import minetweaker.item.WeightedItemStack;
import minetweaker.item.IItemStack;


################
### Removals ###
################


# Remove Zoocraft seeds from grass loot
val rSeed = [
    <ZoocraftDiscoveries:basil_seed>,
    <ZoocraftDiscoveries:bay_seed>,
    <ZoocraftDiscoveries:chive_seed>,
    <ZoocraftDiscoveries:coriander_seed>,
    <ZoocraftDiscoveries:dill_seed>,
    <ZoocraftDiscoveries:lemongrass_seed>,
    <ZoocraftDiscoveries:mint_seed>,
    <ZoocraftDiscoveries:oregano_seed>,
    <ZoocraftDiscoveries:parsley_seed>,
    <ZoocraftDiscoveries:rosemary_seed>,
    <ZoocraftDiscoveries:saffron_seed>,
    <ZoocraftDiscoveries:sage_seed>,
    <ZoocraftDiscoveries:tarragon_seed>,
    <ZoocraftDiscoveries:thyme_seed>
] as IItemStack[];

for i, item in rSeed {
	vanilla.seeds.removeSeed(item);
}



# Begin by extracting items that should not be in chests


# Loot items to remove

val rItem = [
	<fossil:bioFossil>,
	<minecraft:saddle>,
	#<minecraft:golden_horse_armor>,
	#<minecraft:iron_horse_armor>,
	#<minecraft:diamond_horse_armor>,
	<CrystalWing:crystalwing.crystalWingBurned>,
	<fossil:record_bones>,
	<minecraft:record_13>,
	<minecraft:record_cat>,
	<minecraft:diamond_shovel>,
	<minecraft:melon_seeds>,
	<minecraft:pumpkin_seeds>,
	<BiomesOPlenty:misc:1>,
	<BiomesOPlenty:plants:5>,
	<BiomesOPlenty:flowers:3>,
	<BiomesOPlenty:flowers:2>,
] as IItemStack[];


# Corresponding chest type from which to remove the loot item

val chesttype = [
	"bonusChest",
	"dungeonChest",
	#"dungeonChest",
	#"dungeonChest",
	#"dungeonChest",
	"dungeonChest",
	"dungeonChest",
	"dungeonChest",
	"dungeonChest",
	"dungeonChest",
	"mineshaftCorridor",
	"mineshaftCorridor",
	"mineshaftCorridor",
	"mineshaftCorridor",
	"strongholdCorridor",
	"strongholdCorridor",
] as string[];

for i, item in rItem {
	vanilla.loot.removeChestLoot(chesttype[i], item);
}








###################
### Bonus chest ###
###################


# Listing of all the weighted items to appear in a chest

val wItem_bonus = [
	<Mariculture:guide:0>.weight(100),
	<TConstruct:manualBook:0>.weight(100),
	<SpiceOfLife:bookfoodjournal:0>.weight(100),
	<cookingbook:recipebook:0>.weight(100),
	<minecraft:wooden_sword>.weight(1),
	<minecraft:stone_sword>.weight(1),
	<minecraft:wooden_hoe>.weight(1),
	<minecraft:bread>.weight(10),
	<minecraft:apple>.weight(10),
	<minecraft:baked_potato>.weight(5),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_bonus = [
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 3],
	[1, 5],
	[1, 3],
] as int[][];

for i, MinMax in itemBounds_bonus {
	vanilla.loot.addChestLoot("bonusChest", wItem_bonus[i], MinMax[0], MinMax[1]);
}








#####################
### Dungeon chest ###
#####################



# Listing of all the weighted items to appear in a chest

val wItem_dungeon = [
	<CrystalWing:crystalwing.crystalWingBurned>.weight(1),
	#<MSM3:crystal>.weight(8),
	<minecraft:iron_sword>.weight(7),
	<minecraft:chainmail_boots>.weight(7),
	<minecraft:chainmail_helmet>.weight(7),
	<minecraft:iron_boots>.weight(7),
	<minecraft:iron_helmet>.weight(7),
	<minecraft:chainmail_leggings>.weight(7),
	<minecraft:chainmail_chestplate>.weight(7),
	<Metallurgy:copper.sword>.weight(6),
	<Metallurgy:metallurgy.copper.boots>.weight(6),
	<Metallurgy:metallurgy.copper.helmet>.weight(6),
	<Metallurgy:metallurgy.copper.leggings>.weight(6),
	<Metallurgy:prometheum.sword>.weight(5),
	<Metallurgy:metallurgy.prometheum.boots>.weight(5),
	<Metallurgy:silver.sword>.weight(4),
	<Metallurgy:metallurgy.silver.boots>.weight(4),
	#<MSM3:glacial>.weight(3),
	#<MSM3:dawnStar>.weight(3),
	#<MSM3:vampiric>.weight(3),
	<Metallurgy:deep.iron.sword>.weight(2),
	<Metallurgy:metallurgy.deep.iron.boots>.weight(2),
	#<MSM3:aether>.weight(1),
	<minecraft:golden_sword>.weight(1),
	#<MSM3:gladiolus>.weight(1),
	<witchery:silversword>.weight(1),
	<Metallurgy:astral.silver.sword>.weight(1),
	<Metallurgy:oureclase.sword>.weight(1),
	<Metallurgy:carmot.sword>.weight(1),
	<Metallurgy:mithril.sword>.weight(1),
	<Metallurgy:platinum.sword>.weight(1),
	<Metallurgy:orichalcum.sword>.weight(1),
	#<MSM3:draconic>.weight(1),
	<fossil:record_bones>.weight(3),
	<minecraft:record_13>.weight(4),
	<minecraft:record_cat>.weight(1),
	<minecraft:record_blocks>.weight(1),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(1),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(3),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(3),
	<minecraft:record_11>.weight(3),
	<minecraft:record_wait>.weight(1),
	<BiomesOPlenty:record_wanderer>.weight(1),
	<LostBooks:randomBook>.weight(8),
	<LostBooks:randomBook>.weight(8),
	<LostBooks:randomBook>.weight(8),
	<LostBooks:randomBook>.weight(8),
	<ThermalFoundation:material:67>.weight(1),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_dungeon = [
	[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
] as int[][];

for i, MinMax in itemBounds_dungeon {
	vanilla.loot.addChestLoot("dungeonChest", wItem_dungeon[i], MinMax[0], MinMax[1]);
}






################################
### Village Blacksmith chest ###
################################




# Listing of all the weighted items to appear in a chest

val wItem_blacksmith = [
	<minecraft:iron_sword>.weight(2),
	<minecraft:iron_hoe>.weight(1),
	<minecraft:chainmail_boots>.weight(1),
	<minecraft:chainmail_helmet>.weight(1),
	<minecraft:iron_boots>.weight(1),
	<minecraft:iron_helmet>.weight(1),
	<minecraft:chainmail_leggings>.weight(1),
	<minecraft:chainmail_chestplate>.weight(1),
	<minecraft:iron_horse_armor>.weight(1),
	<minecraft:iron_leggings>.weight(1),
	<minecraft:iron_chestplate>.weight(1),
	<Metallurgy:copper.sword>.weight(1),
	<Metallurgy:copper.hoe>.weight(1),
	<Metallurgy:metallurgy.copper.boots>.weight(1),
	<Metallurgy:metallurgy.copper.helmet>.weight(1),
	<Metallurgy:metallurgy.copper.leggings>.weight(1),
	<Metallurgy:prometheum.sword>.weight(1),
	<Metallurgy:prometheum.hoe>.weight(1),
	<Metallurgy:silver.sword>.weight(1),
	<Metallurgy:silver.hoe>.weight(1),
	#<MSM3:glacial>.weight(5),
	#<MSM3:dawnStar>.weight(5),
	#<MSM3:vampiric>.weight(4),
	<Metallurgy:deep.iron.sword>.weight(1),
	<Metallurgy:deep.iron.hoe>.weight(1),
	#<MSM3:aether>.weight(3),
	#<MSM3:gladiolus>.weight(2),
	<witchery:silversword>.weight(2),
	<Metallurgy:astral.silver.sword>.weight(1),
	<Metallurgy:oureclase.sword>.weight(1),
	<Metallurgy:carmot.sword>.weight(1),
	<Metallurgy:mithril.sword>.weight(1),
	<Metallurgy:platinum.sword>.weight(1),
	#<MSM3:draconic>.weight(1),
	<fossil:record_bones>.weight(1),
	<minecraft:record_13>.weight(1),
	<minecraft:record_cat>.weight(2),
	<minecraft:record_blocks>.weight(2),
	<minecraft:record_chirp>.weight(2),
	<minecraft:record_far>.weight(1),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(2),
	<minecraft:record_stal>.weight(3),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(3),
	<minecraft:record_11>.weight(1),
	<minecraft:record_wait>.weight(3),
	<BiomesOPlenty:record_wanderer>.weight(2),
	<minecraft:arrow>.weight(6),
	<minecraft:bucket>.weight(3),
	<minecraft:name_tag>.weight(5),
	<minecraft:shears>.weight(4),
	<CarpentersBlocks:itemCarpentersHammer>.weight(1),
	<cfm:ItemHammer>.weight(1),
	<CarpentersBlocks:itemCarpentersChisel>.weight(1),
	<chisel:chisel>.weight(1),
	<TConstruct:materials:19>.weight(1),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<ThermalFoundation:material:67>.weight(3),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_blacksmith = [
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[3, 10],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 8],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 3],
] as int[][];

for i, MinMax in itemBounds_blacksmith {
	vanilla.loot.addChestLoot("villageBlacksmith", wItem_blacksmith[i], MinMax[0], MinMax[1]);
}







############################
### Desert Pyramid chest ###
############################



# Listing of all the weighted items to appear in a chest

val wItem_desertPyramid = [
	<Metallurgy:prometheum.sword>.weight(1),
	<Metallurgy:prometheum.hoe>.weight(1),
	<Metallurgy:metallurgy.prometheum.boots>.weight(1),
	<Metallurgy:metallurgy.prometheum.helmet>.weight(1),
	<Metallurgy:metallurgy.prometheum.leggings>.weight(1),
	<Metallurgy:metallurgy.prometheum.chestplate>.weight(1),
	<Metallurgy:silver.sword>.weight(2),
	<Metallurgy:silver.hoe>.weight(2),
	<Metallurgy:metallurgy.silver.boots>.weight(2),
	<Metallurgy:metallurgy.silver.helmet>.weight(2),
	<Metallurgy:metallurgy.silver.leggings>.weight(2),
	<Metallurgy:metallurgy.silver.chestplate>.weight(2),
	#<MSM3:glacial>.weight(9),
	#<MSM3:dawnStar>.weight(9),
	#<MSM3:vampiric>.weight(8),
	<Metallurgy:deep.iron.sword>.weight(3),
	<Metallurgy:deep.iron.hoe>.weight(3),
	<Metallurgy:metallurgy.deep.iron.boots>.weight(3),
	#<MSM3:aether>.weight(8),
	#<MSM3:gladiolus>.weight(4),
	<witchery:silversword>.weight(4),
	<Metallurgy:astral.silver.sword>.weight(5),
	<Metallurgy:astral.silver.hoe>.weight(5),
	<Metallurgy:oureclase.sword>.weight(6),
	<Metallurgy:oureclase.hoe>.weight(6),
	<Metallurgy:carmot.sword>.weight(7),
	<Metallurgy:carmot.hoe>.weight(7),
	<Metallurgy:mithril.sword>.weight(7),
	<Metallurgy:mithril.hoe>.weight(7),
	<Metallurgy:platinum.sword>.weight(6),
	<Metallurgy:platinum.hoe>.weight(6),
	<Metallurgy:orichalcum.sword>.weight(5),
	#<MSM3:draconic>.weight(4),
	#<MSM3:ender>.weight(2),
	<fossil:record_bones>.weight(2),
	<minecraft:record_13>.weight(1),
	<minecraft:record_cat>.weight(3),
	<minecraft:record_blocks>.weight(3),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(1),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(1),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(3),
	<minecraft:record_11>.weight(1),
	<minecraft:record_wait>.weight(3),
	<BiomesOPlenty:record_wanderer>.weight(3),
	<LostBooks:randomBook>.weight(15),
	<LostBooks:randomBook>.weight(15),
	<LostBooks:randomBook>.weight(15),
	<Metallurgy:prometheum.ingot>.weight(1),
	<Metallurgy:silver.ingot>.weight(2),
	<Metallurgy:deep.iron.ingot>.weight(3),
	<minecraft:gold_ingot>.weight(4),
	<Metallurgy:astral.silver.ingot>.weight(5),
	<BiomesOPlenty:gems:1>.weight(5),
	<BiomesOPlenty:gems:2>.weight(5),
	<BiomesOPlenty:gems:3>.weight(5),
	<BiomesOPlenty:gems:4>.weight(5),
	<BiomesOPlenty:gems:5>.weight(5),
	<BiomesOPlenty:gems:6>.weight(5),
	<minecraft:redstone>.weight(3),
	<minecraft:dye:4>.weight(3),
	<minecraft:emerald>.weight(2),
	<minecraft:diamond>.weight(1),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_desertPyramid = [
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 7],
	[1, 5],
	[1, 3],
	[1, 1],
	[1, 4],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
] as int[][];

for i, MinMax in itemBounds_desertPyramid {
	vanilla.loot.addChestLoot("pyramidDesertyChest", wItem_desertPyramid[i], MinMax[0], MinMax[1]);
}






############################
### Jungle Pyramid chest ###
############################



# Listing of all the weighted items to appear in a chest

val wItem_junglePyramid = [
	<Metallurgy:prometheum.sword>.weight(2),
	<Metallurgy:prometheum.hoe>.weight(2),
	<Metallurgy:metallurgy.prometheum.boots>.weight(2),
	<Metallurgy:metallurgy.prometheum.helmet>.weight(2),
	<Metallurgy:metallurgy.prometheum.leggings>.weight(2),
	<Metallurgy:metallurgy.prometheum.chestplate>.weight(2),
	<Metallurgy:silver.sword>.weight(3),
	<Metallurgy:silver.hoe>.weight(3),
	<Metallurgy:metallurgy.silver.boots>.weight(3),
	<Metallurgy:metallurgy.silver.helmet>.weight(3),
	<Metallurgy:metallurgy.silver.leggings>.weight(3),
	<Metallurgy:metallurgy.silver.chestplate>.weight(3),
	#<MSM3:glacial>.weight(9),
	#<MSM3:dawnStar>.weight(9),
	#<MSM3:vampiric>.weight(8),
	<Metallurgy:deep.iron.sword>.weight(4),
	<Metallurgy:deep.iron.hoe>.weight(4),
	<Metallurgy:metallurgy.deep.iron.boots>.weight(4),
	#<MSM3:aether>.weight(8),
	#<MSM3:gladiolus>.weight(4),
	<witchery:silversword>.weight(4),
	<Metallurgy:astral.silver.sword>.weight(6),
	<Metallurgy:astral.silver.hoe>.weight(6),
	<Metallurgy:oureclase.sword>.weight(7),
	<Metallurgy:oureclase.hoe>.weight(7),
	<Metallurgy:carmot.sword>.weight(7),
	<Metallurgy:carmot.hoe>.weight(7),
	<Metallurgy:mithril.sword>.weight(6),
	<Metallurgy:mithril.hoe>.weight(6),
	<Metallurgy:platinum.sword>.weight(5),
	<Metallurgy:platinum.hoe>.weight(5),
	<Metallurgy:orichalcum.sword>.weight(4),
	#<MSM3:draconic>.weight(2),
	#<MSM3:ender>.weight(1),
	<fossil:record_bones>.weight(2),
	<minecraft:record_13>.weight(1),
	<minecraft:record_cat>.weight(3),
	<minecraft:record_blocks>.weight(2),
	<minecraft:record_chirp>.weight(3),
	<minecraft:record_far>.weight(2),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(1),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(2),
	<minecraft:record_ward>.weight(1),
	<minecraft:record_11>.weight(2),
	<minecraft:record_wait>.weight(2),
	<BiomesOPlenty:record_wanderer>.weight(2),
	<LostBooks:randomBook>.weight(5),
	<LostBooks:randomBook>.weight(5),
	<ThermalFoundation:material:67>.weight(5),
	<Metallurgy:prometheum.ingot>.weight(1),
	<Metallurgy:silver.ingot>.weight(2),
	<Metallurgy:deep.iron.ingot>.weight(3),
	<minecraft:gold_ingot>.weight(4),
	<BiomesOPlenty:gems:2>.weight(5),
	<BiomesOPlenty:gems:3>.weight(5),
	<BiomesOPlenty:gems:4>.weight(5),
	<BiomesOPlenty:gems:5>.weight(5),
	<BiomesOPlenty:gems:6>.weight(5),
	<BiomesOPlenty:gems:7>.weight(5),
	<minecraft:redstone>.weight(3),
	<minecraft:dye:4>.weight(3),
	<minecraft:emerald>.weight(2),
	<minecraft:diamond>.weight(1),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_junglePyramid = [
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 5],
	[1, 7],
	[1, 5],
	[1, 3],
	[1, 1],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
] as int[][];

for i, MinMax in itemBounds_junglePyramid {
	vanilla.loot.addChestLoot("pyramidJungleChest", wItem_junglePyramid[i], MinMax[0], MinMax[1]);
}






################################
### Mineshaft Corridor chest ###
################################



# Listing of all the weighted items to appear in a chest

val wItem_mineshaft = [
	<fossil:record_bones>.weight(3),
	<minecraft:record_13>.weight(4),
	<minecraft:record_cat>.weight(1),
	<minecraft:record_blocks>.weight(2),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(1),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(1),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(4),
	<minecraft:record_11>.weight(3),
	<minecraft:record_wait>.weight(1),
	<BiomesOPlenty:record_wanderer>.weight(1),
	<minecraft:tnt>.weight(15),
	<minecraft:minecart>.weight(1),
	<minecraft:torch>.weight(1),
	<LostBooks:randomBook>.weight(3),
	<minecraft:coal:0>.weight(19),
	<minecraft:iron_ingot>.weight(7),
	<minecraft:redstone>.weight(6),
	<Metallurgy:prometheum.ingot>.weight(5),
	<Metallurgy:zinc.ingot>.weight(5),
	<Metallurgy:deep.iron.ingot>.weight(3),
	<Metallurgy:manganese.ingot>.weight(3),
	<Metallurgy:infuscolium.ingot>.weight(3),
	<Metallurgy:utility.item:0>.weight(2),
	<Metallurgy:utility.item:1>.weight(2),
	<Metallurgy:utility.item:2>.weight(2),
	<Metallurgy:utility.item:3>.weight(2),
	<Metallurgy:utility.item:4>.weight(2),
	<Metallurgy:utility.item:5>.weight(2),
	<minecraft:gold_ingot>.weight(2),
	<Metallurgy:astral.silver.ingot>.weight(2),
	<Metallurgy:oureclase.ingot>.weight(2),
	<Metallurgy:carmot.ingot>.weight(2),
	<Metallurgy:mithril.ingot>.weight(2),
	<Metallurgy:platinum.ingot>.weight(2),
	<Metallurgy:orichalcum.ingot>.weight(1),
	<minecraft:dye:4>.weight(1),
	<Metallurgy:rubracium.ingot>.weight(1),
	<minecraft:diamond>.weight(1),
	<minecraft:emerald>.weight(1),
	<ThermalFoundation:material:67>.weight(1),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_mineshaft = [
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 2],
	[1, 1],
	[2, 12],
	[1, 1],
	[1, 5],
	[1, 7],
	[2, 10],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 5],
	[1, 5],
	[1, 5],
	[1, 5],
	[1, 5],
	[1, 5],
	[1, 2],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[4, 8],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 2],
] as int[][];

for i, MinMax in itemBounds_mineshaft {
	vanilla.loot.addChestLoot("mineshaftCorridor", wItem_mineshaft[i], MinMax[0], MinMax[1]);
}





################################
### Stronghold Library chest ###
################################



# Listing of all the weighted items to appear in a chest

val wItem_strongholdLibrary = [
	<fossil:record_bones>.weight(1),
	<minecraft:record_13>.weight(1),
	<minecraft:record_cat>.weight(3),
	<minecraft:record_blocks>.weight(1),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(2),
	<minecraft:record_mall>.weight(5),
	<minecraft:record_mellohi>.weight(4),
	<minecraft:record_stal>.weight(2),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(1),
	<minecraft:record_11>.weight(1),
	<minecraft:record_wait>.weight(1),
	<BiomesOPlenty:record_wanderer>.weight(1),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
	<LostBooks:randomBook>.weight(20),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_strongholdLibrary = [
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
] as int[][];

for i, MinMax in itemBounds_strongholdLibrary {
	vanilla.loot.addChestLoot("strongholdLibrary", wItem_strongholdLibrary[i], MinMax[0], MinMax[1]);
}







#################################
### Stronghold Crossing chest ###
#################################



# Listing of all the weighted items to appear in a chest

val wItem_strongholdCrossing = [
	#<MSM3:vampiric>.weight(1),
	<fossil:record_bones>.weight(3),
	<minecraft:record_13>.weight(3),
	<minecraft:record_cat>.weight(1),
	<minecraft:record_blocks>.weight(1),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(1),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(3),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(4),
	<minecraft:record_11>.weight(3),
	<minecraft:record_wait>.weight(1),
	<BiomesOPlenty:record_wanderer>.weight(1),
	<LostBooks:randomBook>.weight(10),
	<LostBooks:randomBook>.weight(10),
	<LostBooks:randomBook>.weight(10),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_strongholdCrossing = [
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
] as int[][];

for i, MinMax in itemBounds_strongholdCrossing {
	vanilla.loot.addChestLoot("strongholdCrossing", wItem_strongholdCrossing[i], MinMax[0], MinMax[1]);
}





#################################
### Stronghold Corridor chest ###
#################################



# Listing of all the weighted items to appear in a chest

val wItem_strongholdCorridor = [
	#<MSM3:vampiric>.weight(12),
	<Metallurgy:eximite.sword>.weight(2),
	<Metallurgy:eximite.hoe>.weight(2),
	<Metallurgy:metallurgy.eximite.boots>.weight(1),
	<Metallurgy:metallurgy.eximite.helmet>.weight(1),
	<Metallurgy:metallurgy.eximite.leggings>.weight(1),
	<Metallurgy:metallurgy.eximite.chestplate>.weight(1),
	<Metallurgy:deep.iron.sword>.weight(2),
	<Metallurgy:deep.iron.hoe>.weight(2),
	<Metallurgy:metallurgy.deep.iron.boots>.weight(2),
	<Metallurgy:metallurgy.deep.iron.helmet>.weight(2),
	<Metallurgy:metallurgy.deep.iron.leggings>.weight(2),
	<Metallurgy:metallurgy.deep.iron.chestplate>.weight(2),
	#<MSM3:aether>.weight(8),
	<minecraft:golden_sword>.weight(3),
	#<MSM3:gladiolus>.weight(7),
	<witchery:silversword>.weight(6),
	<Metallurgy:astral.silver.sword>.weight(4),
	<Metallurgy:astral.silver.hoe>.weight(4),
	<Metallurgy:metallurgy.astral.silver.boots>.weight(4),
	<Metallurgy:oureclase.sword>.weight(5),
	<Metallurgy:oureclase.hoe>.weight(5),
	<Metallurgy:metallurgy.oureclase.boots>.weight(5),
	<Metallurgy:carmot.sword>.weight(7),
	<Metallurgy:carmot.hoe>.weight(7),
	<Metallurgy:mithril.sword>.weight(6),
	<Metallurgy:mithril.hoe>.weight(6),
	<Metallurgy:platinum.sword>.weight(5),
	<Metallurgy:platinum.hoe>.weight(5),
	<Metallurgy:orichalcum.sword>.weight(4),
	<Metallurgy:orichalcum.hoe>.weight(4),
	#<MSM3:draconic>.weight(6),
	#<MSM3:ender>.weight(1),
	<fossil:record_bones>.weight(3),
	<minecraft:record_13>.weight(5),
	<minecraft:record_cat>.weight(1),
	<minecraft:record_blocks>.weight(1),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(1),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(1),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(4),
	<minecraft:record_11>.weight(3),
	<minecraft:record_wait>.weight(1),
	<BiomesOPlenty:record_wanderer>.weight(1),
	<LostBooks:randomBook>.weight(5),
	<LostBooks:randomBook>.weight(5),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_strongholdCorridor = [
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
] as int[][];

for i, MinMax in itemBounds_strongholdCorridor {
	vanilla.loot.addChestLoot("strongholdCorridor", wItem_strongholdCorridor[i], MinMax[0], MinMax[1]);
}






##########################
### Wizard Tower chest ###
##########################



# Listing of all the weighted items to appear in a chest

val wItem_wizardTower = [
	<fossil:record_bones>.weight(1),
	<minecraft:record_13>.weight(1),
	<minecraft:record_cat>.weight(1),
	<minecraft:record_blocks>.weight(1),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(2),
	<minecraft:record_mall>.weight(1),
	<minecraft:record_mellohi>.weight(1),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(2),
	<minecraft:record_11>.weight(1),
	<minecraft:record_wait>.weight(1),
	<BiomesOPlenty:record_wanderer>.weight(3),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<LostBooks:randomBook>.weight(40),
	<Metallurgy:utility.item:0>.weight(7),
	<Metallurgy:utility.item:1>.weight(7),
	<Metallurgy:utility.item:2>.weight(7),
	<Metallurgy:utility.item:3>.weight(7),
	<Metallurgy:utility.item:4>.weight(7),
	<Metallurgy:utility.item:5>.weight(7),
	<BiomesOPlenty:gems:2>.weight(5),
	<BiomesOPlenty:gems:3>.weight(5),
	<BiomesOPlenty:gems:4>.weight(5),
	<BiomesOPlenty:gems:5>.weight(5),
	<BiomesOPlenty:gems:6>.weight(5),
	<BiomesOPlenty:gems:7>.weight(5),
	<minecraft:redstone>.weight(3),
	<minecraft:dye:4>.weight(3),
	<minecraft:emerald>.weight(2),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_wizardTower = [
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
	[1, 2],
] as int[][];

for i, MinMax in itemBounds_wizardTower {
	vanilla.loot.addChestLoot("A_WIZARD_DID_IT", wItem_wizardTower[i], MinMax[0], MinMax[1]);
}






#########################
### Ocean Floor chest ###
#########################



# Listing of all the weighted items to appear in a chest

val wItem_oceanFloor = [
	#<MSM3:glacial>.weight(14),
	#<MSM3:dawnStar>.weight(14),
	#<MSM3:vampiric>.weight(11),
	<Metallurgy:deep.iron.sword>.weight(1),
	<Metallurgy:deep.iron.hoe>.weight(1),
	<Metallurgy:metallurgy.deep.iron.boots>.weight(1),
	<Metallurgy:metallurgy.deep.iron.helmet>.weight(1),
	<Metallurgy:metallurgy.deep.iron.leggings>.weight(1),
	<Metallurgy:metallurgy.deep.iron.chestplate>.weight(1),
	#<MSM3:aether>.weight(7),
	<minecraft:golden_sword>.weight(1),
	#<MSM3:gladiolus>.weight(6),
	<witchery:silversword>.weight(6),
	<Metallurgy:astral.silver.sword>.weight(2),
	<Metallurgy:astral.silver.hoe>.weight(2),
	<Metallurgy:oureclase.sword>.weight(3),
	<Metallurgy:oureclase.hoe>.weight(3),
	<Metallurgy:carmot.sword>.weight(4),
	<Metallurgy:carmot.hoe>.weight(4),
	<Metallurgy:mithril.sword>.weight(5),
	<Metallurgy:mithril.hoe>.weight(5),
	<Metallurgy:platinum.sword>.weight(4),
	<Metallurgy:platinum.hoe>.weight(4),
	<Metallurgy:orichalcum.sword>.weight(3),
	<Metallurgy:orichalcum.hoe>.weight(3),
	#<MSM3:draconic>.weight(3),
	#<MSM3:ender>.weight(3),
	<fossil:record_bones>.weight(3),
	<minecraft:record_13>.weight(3),
	<minecraft:record_cat>.weight(1),
	<minecraft:record_blocks>.weight(1),
	<minecraft:record_chirp>.weight(1),
	<minecraft:record_far>.weight(1),
	<minecraft:record_mall>.weight(3),
	<minecraft:record_mellohi>.weight(4),
	<minecraft:record_stal>.weight(1),
	<minecraft:record_strad>.weight(1),
	<minecraft:record_ward>.weight(3),
	<minecraft:record_11>.weight(1),
	<minecraft:record_wait>.weight(1),
	<BiomesOPlenty:record_wanderer>.weight(1),
	<Artifacts:artifact>.weight(10),
	<Artifacts:artifact>.weight(10),
	<Artifacts:artifact>.weight(10),
	<Artifacts:artifact>.weight(10),
] as WeightedItemStack[];


# Corresponding minimum and maximum number of such items that can appear per slot

val itemBounds_oceanFloor = [
	#[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	#[1, 1],
	#[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
	[1, 1],
] as int[][];

for i, MinMax in itemBounds_oceanFloor {
	vanilla.loot.addChestLoot("oceanFloorChest", wItem_oceanFloor[i], MinMax[0], MinMax[1]);
}



