import minetweaker.item.IItemStack;

####################
### Name changes ###
####################

### CONSOLIDATE ALL GALAXYSPACE RENAMES HERE BECAUSE THINGS CHANGE TOO MUCH ###
# Galaxy Space thermal cloth needs a distinguishing name
<GalaxySpace:item.ThermalClothT2:0>.displayName = "Self-regulating Thermal Cloth";

# Aluminium
<GalaxySpace:europablocks:5>.displayName="Bauxite";
<GalaxySpace:marsoresblocks:5>.displayName="Gibbsite";
<GalaxySpace:barnardacores:9>.displayName="Boehmite";

# Coal
<GalaxySpace:enceladusblocks:2>.displayName="Anthracite";
<GalaxySpace:marsoresblocks:2>.displayName="Anthracite";
<GalaxySpace:proximabblocks:8>.displayName="Anthracite";
<GalaxySpace:barnardacores:0>.displayName="Coal Deposit";

# Cobalt
<GalaxySpace:barnardacores:11>.displayName="Cobaltite";

# Copper
<GalaxySpace:ioblocks:3>.displayName="Copper Deposit";
<GalaxySpace:proximabblocks:7>.displayName="Djurleite";
<GalaxySpace:barnardacores:7>.displayName="Chalcopyrite";

# Dolomite
<GalaxySpace:ceresblocks:2>.displayName="Dolomite Geode";
<GalaxySpace:mirandablocks:4>.displayName="Dolomite Geode";

# Emerald
<GalaxySpace:europablocks:3>.displayName="Beryl";
<GalaxySpace:proximabblocks:10>.displayName="Beryl";

# Gold
<GalaxySpace:marsoresblocks:1>.displayName="Calaverite";
<GalaxySpace:proximabblocks:5>.displayName="Petzite";
<GalaxySpace:barnardacores:2>.displayName="Gold Deposit";
<GalaxySpace:barnardaeblocks:3>.displayName="Calaverite";

# Iron
<GalaxySpace:mercuryblocks:3>.displayName="Goethite";
<GalaxySpace:mirandablocks:3>.displayName="Siderite";
<GalaxySpace:barnardacores:1>.displayName="Wustite";
<GalaxySpace:barnardaeblocks:2>.displayName="Wustite";
<GalaxySpace:ores:0>.displayName="Wustite"; # This spawns on the moon as Cobalt Ore, due to a bug

# Lapis
<GalaxySpace:barnardacores:4>.displayName="Lazurite";

# Magnesium
<GalaxySpace:ganymedeblocks:2>.displayName="Brucite";
<GalaxySpace:mercuryblocks:5>.displayName="Brucite";

# Meteoric Iron
<GalaxySpace:ceresblocks:3>.displayName="Kamacite";

# Nickel
<GalaxySpace:ores:1>.displayName="Pentlandite";
<GalaxySpace:mercuryblocks:4>.displayName="Pyrrhotite";
<GalaxySpace:barnardacores:12>.displayName="Pecoraite";

# Quartz
<GalaxySpace:barnardacores:10>.displayName="Quartz Ore";

# Sapphire
<GalaxySpace:item.BasicItems:6>.displayName="Lunar Sapphire";
<GalaxySpace:ores:2>.displayName="Lunar Corundum";

# Silicon
<GalaxySpace:europablocks:4>.displayName="Ferrosilicon";
<GalaxySpace:marsoresblocks:4>.displayName="Ferrosilicon";
<GalaxySpace:proximabblocks:9>.displayName="Ferrosilicon";
<GalaxySpace:barnardacores:6>.displayName="Ferrosilicon";

# Sulfur
<GalaxySpace:venusblocks:2>.displayName="Sulfur Deposit";
<GalaxySpace:ioblocks:4>.displayName="Sulfur Deposit";

# Tin
<GalaxySpace:proximabblocks:6>.displayName="Cassiterite";
<GalaxySpace:barnardacores:8>.displayName="Cassiterite";

# Titanium
<GalaxySpace:ganymedeblocks:3>.displayName="Leucoxene";

# Unknown Crystal
<GalaxySpace:enceladuscrystal>.displayName="Unknown Crystal";

# Uranium
<GalaxySpace:tritonblocks:5>.displayName="Pitchblende";
<GalaxySpace:ores:3>.displayName="Pitchblende";



### Ore dictionary adjustments
<ore:oreRutile>.add(<GalaxySpace:ganymedeblocks:3>);
<ore:oreTitanium>.remove(<GalaxySpace:ganymedeblocks:3>);
<ore:oreImpureTitanium>.remove(<GalaxySpace:ganymedeblocks:3>);


### Spelling corrections
<witchery:witchhand>.displayName = "Witch's Hand";
<harvestcraft:grapefruitjuiceItem>.displayName = "Grapefruit Juice";


# Limestone
<chisel:limestone>.displayName = "Continental Limestone";
<chisel:limestone_stairs.0>.displayName = "Continental Limestone Stairs";
<chisel:limestone_stairs.1>.displayName = "Continental Limestone Stairs";
<chisel:limestone_stairs.2>.displayName = "Continental Limestone Stairs";
<chisel:limestone_stairs.3>.displayName = "Continental Limestone Stairs";
<chisel:limestone_stairs.4>.displayName = "Continental Limestone Stairs";
<chisel:limestone_stairs.5>.displayName = "Continental Limestone Stairs";
<chisel:limestone_stairs.6>.displayName = "Continental Limestone Stairs";
<chisel:limestone_stairs.7>.displayName = "Continental Limestone Stairs";



# Base game

<minecraft:stone_stairs>.displayName = "Cobblestone Stairs";
<minecraft:monster_egg:0>.displayName = "Stone";
<minecraft:monster_egg:1>.displayName = "Cobblestone";
<minecraft:monster_egg:2>.displayName = "Stone Bricks";
<minecraft:monster_egg:3>.displayName = "Mossy Stone Bricks";
<minecraft:monster_egg:4>.displayName = "Cracked Stone Bricks";
<minecraft:monster_egg:5>.displayName = "Chiseled Stone Bricks";
<minecraft:monster_egg:0>.addTooltip(format.yellow(format.italic("Silverfish egg")));
<minecraft:monster_egg:1>.addTooltip(format.yellow(format.italic("Silverfish egg")));
<minecraft:monster_egg:2>.addTooltip(format.yellow(format.italic("Silverfish egg")));
<minecraft:monster_egg:3>.addTooltip(format.yellow(format.italic("Silverfish egg")));
<minecraft:monster_egg:4>.addTooltip(format.yellow(format.italic("Silverfish egg")));
<minecraft:monster_egg:5>.addTooltip(format.yellow(format.italic("Silverfish egg")));
# Added in to counter MSM
#<minecraft:bone>.displayName = "Bone";


# Voltz Engine
# Because 1/4 and 1/8 pieces share a name
<voltzengine:veSheetMetal:3>.displayName = "Sheet Metal Piece";


# JAFFA: rename "milkshake" to "frappe"
<jaffa:StrawberryMilkshake>.displayName = "Strawberry Frappe";
<jaffa:BananaMilkshake>.displayName = "Banana Frappe";
<jaffa:ChocolateMilkshake>.displayName = "Chocolate Frappe";
<jaffa:VanillaMilkshake>.displayName = "Vanilla Frappe";


# Et Futurum: rename "Bark" to "Wood"
<etfuturum:bark:0>.displayName = "Oak Wood";
<etfuturum:bark:1>.displayName = "Spruce Wood";
<etfuturum:bark:2>.displayName = "Birch Wood";
<etfuturum:bark:3>.displayName = "Jungle Wood";
<etfuturum:bark:4>.displayName = "Acacia Wood";
<etfuturum:bark:5>.displayName = "Dark Oak Wood";
# Rename "Boat" to "Rowboat"
<etfuturum:oak_boat>.displayName = "Oak Rowboat";
<etfuturum:spruce_boat>.displayName = "Spruce Rowboat";
<etfuturum:birch_boat>.displayName = "Birch Rowboat";
<etfuturum:jungle_boat>.displayName = "Jungle Rowboat";
<etfuturum:acacia_boat>.displayName = "Acacia Rowboat";
<etfuturum:dark_oak_boat>.displayName = "Dark Oak Rowboat";


# Weee! Flowers/seed names
<weeeflowers:White Flower Seed>.displayName = "White Rose Seed";
<weeeflowers:Flower:1>.displayName = "Wild Poppies";
<weeeflowers:Orange Flower Seed>.displayName = "Wild Poppy Seed";
<weeeflowers:Magenta Flower Seed>.displayName = "Magenta Wildflower Seed";
<weeeflowers:Light Blue Flower Seed>.displayName = "Blue Chrysanthemum Seed";
<weeeflowers:Yellow Flower Seed>.displayName = "Dandelion Seed";
<weeeflowers:Flower:4>.displayName = "Light Green Shrub";
<weeeflowers:Lime Flower Seed>.displayName = "Light Green Shrub Seed";
<weeeflowers:Flower:5>.displayName = "Pink Daisies";
<weeeflowers:Pink Flower Seed>.displayName = "Pink Daisy Seed";
<weeeflowers:Light Grey Flower Seed>.displayName = "Wild Parsley Seed";
<weeeflowers:Flower:6>.displayName = "Gray Peonies";
<weeeflowers:Dark Grey Flower Seed>.displayName = "Gray Peony Seed";
<weeeflowers:Cyan Flower Seed>.displayName = "Cyan Wildflower Seed";
<weeeflowers:Purple Flower Seed>.displayName = "Purple Violet Seed";
<weeeflowers:Blue Flower Seed>.displayName = "Blue Hydrangea Seed";
<weeeflowers:Flower:11>.displayName = "Brown Shrub";
<weeeflowers:Brown Flower Seed>.displayName = "Brown Shrub Seed";
<weeeflowers:Flower:12>.displayName = "Dark Green Shrub";
<weeeflowers:Green Flower Seed>.displayName = "Dark Green Shrub Seed";
<minecraft:red_flower>.displayName = "Red Poppy";
<weeeflowers:Red Flower Seed>.displayName = "Red Poppy Seed";
<weeeflowers:Black Flower Seed>.displayName = "Black Rose Seed";


# Harvestcraft mortar-and-pestle flour:
<harvestcraft:flourItem>.displayName = "All-Purpose Flour";

# Rename Chisel concretes
<chisel:concrete:0>.displayName = "Concrete Road";


### Food/wood subtypes renamed ###

# Natura fences don't list wood type
<Natura:Natura.fence:0>.displayName = "Natura Wood Fence";


# Wood to Oak

# Garden Trees
<GardenTrees:sapling:0>.displayName = "Red Pine Sapling";
<GardenTrees:sapling:1>.displayName = "Swamp Oak Sapling";

# Pears
<BiomesOPlenty:fruitBop:3>.displayName = "Bartlett Pear";
<BiomesOPlenty:food:12>.displayName = "Bartlett Pear";
<harvestcraft:pamPear>.displayName = "Williams Pear";
<harvestcraft:pampearSapling>.displayName = "Williams Pear Sapling";
<harvestcraft:pearItem>.displayName = "Williams Pear";

# Peaches
<harvestcraft:pamPeach>.displayName = "Nectarine";
<harvestcraft:pampeachSapling>.displayName = "Nectarine Sapling";
<harvestcraft:peachItem>.displayName = "Nectarine";

# Darkwood
<Natura:planks:11>.displayName = "Nether Darkwood Planks";
<Natura:florasapling:6>.displayName = "Nether Darkwood Sapling";
<Natura:Dark Tree:0>.displayName = "Nether Darkwood";
<Natura:Dark Leaves:0>.displayName = "Nether Darkwood Leaves";
<Natura:Dark Leaves:1>.displayName = "Nether Darkwood Leaves";
<Natura:Dark Leaves:2>.displayName = "Nether Darkwood Leaves";
<Natura:plankSlab2:3>.displayName = "Nether Darkwood Slab";
<Natura:stair.darkwood>.displayName = "Nether Darkwood Stairs";
<Natura:pressureplate.darkwood>.displayName = "Nether Darkwood Pressure Plate";
<Natura:trapdoor.darkwood>.displayName = "Nether Darkwood Trapdoor";
<Natura:button.darkwood>.displayName = "Nether Darkwood Button";
#<Natura:natura.kama.darkwood>.displayName = "Nether Darkwood Kama";
#<Natura:natura.bow.darkwood>.displayName = "Nether Darkwood Bow";
<woodendoors:naturadoor_darkwood>.displayName = "Nether Darkwood Door";
<TwilightForest:tile.TFLog:3>.displayName = "Twilight Darkwood";
<TwilightForest:tile.TFSapling:3>.displayName = "Twilight Darkwood Sapling";
<TwilightForest:tile.DarkLeaves:0>.displayName = "Twilight Darkwood Leaves";
<BiomesOPlenty:saplings:4>.displayName = "Umbran Sapling";
<BiomesOPlenty:logs1:2>.displayName = "Umbran Wood";
<BiomesOPlenty:planks:2>.displayName = "Umbran Planks";
<BiomesOPlenty:darkStairs>.displayName = "Umbran Stairs";


# Willow
<BiomesOPlenty:willow:0>.displayName = "Willow Vines";
<BiomesOPlenty:logs3:1>.displayName = "Weeping Willow Wood";
<BiomesOPlenty:colorizedSaplings:4>.displayName = "Weeping Willow Sapling";
<BiomesOPlenty:planks:9>.displayName = "Weeping Willow Planks";
<BiomesOPlenty:woodenSingleSlab2:1>.displayName = "Weeping Willow Slab";
<BiomesOPlenty:woodenDoubleSlab2:1>.displayName = "Weeping Willow Slab";
<BiomesOPlenty:willowStairs>.displayName = "Weeping Willow Stairs";
<BiomesOPlenty:colorizedLeaves2:0>.displayName = "Weeping Willow Leaves";
<Natura:planks:10>.displayName = "Babylon Willow Planks";
<Natura:floraleavesnocolor:3>.displayName = "Babylon Willow Leaves";
<Natura:willow:0>.displayName = "Babylon Willow Wood";
<Natura:Rare Sapling:4>.displayName = "Babylon Willow Sapling";
<Natura:plankSlab2:2>.displayName = "Babylon Willow Slab";
<Natura:stair.willow>.displayName = "Babylon Willow Stairs";
<Natura:pressureplate.willow>.displayName = "Babylon Willow Pressure Plate";
<Natura:trapdoor.willow>.displayName = "Babylon Willow Trapdoor";
<Natura:button.willow>.displayName = "Babylon Willow Button";
<Natura:fenceGate.willow>.displayName = "Babylon Willow Fence Gate";

# Maple
<BiomesOPlenty:saplings:11>.displayName = "Red Maple Sapling";
<BiomesOPlenty:leaves3:2>.displayName = "Red Maple Leaves";
<MorePlanet:mp_wood_half_slab>.displayName = "Fronos Maple Wood Slab";
<MorePlanet:fronos_log:1>.displayName = "Fronos Maple Wood";
<MorePlanet:fronos_wooden_planks:1>.displayName = "Fronos Maple Wood Planks";
<MorePlanet:fronos_leaves2:0>.displayName = "Red Fronos Maple Leaves";
<MorePlanet:fronos_leaves2:1>.displayName = "Yellow Fronos Maple Leaves";
<MorePlanet:fronos_leaves2:2>.displayName = "Purple Fronos Maple Leaves";
<MorePlanet:red_maple_wood_stairs>.displayName = "Fronos Maple Wood Stairs";
<MorePlanet:fronos_fence:1>.displayName = "Fronos Maple Fence";
<MorePlanet:red_maple_fence_gate>.displayName = "Fronos Maple Fence Gate";
<MorePlanet:fronos_sapling:1>.displayName = "Fronos Red Maple Sapling";
<MorePlanet:fronos_sapling:2>.displayName = "Fronos Yellow Maple Sapling";
<MorePlanet:fronos_sapling:3>.displayName = "Fronos Purple Maple Sapling";
<MorePlanet:maple_ivy:0>.displayName = "Fronos Maple Ivy";
<MorePlanet:red_maple_door>.displayName = "Fronos Maple Door";
<MorePlanet:red_maple_door>.displayName = "Fronos Maple Door";
<Natura:planks:6>.displayName = "Sycamore Maple Planks";
<Natura:Rare Tree:0>.displayName = "Sycamore Maple Wood";
<Natura:Rare Leaves:0>.displayName = "Sycamore Maple Leaves";
<Natura:Rare Sapling:0>.displayName = "Sycamore Maple Sapling";
<Natura:plankSlab1:6>.displayName = "Sycamore Maple Slab";
<Natura:stair.maple>.displayName = "Sycamore Maple Stairs";
<Natura:pressureplate.maple>.displayName = "Sycamore Maple Pressure Plate";
<Natura:trapdoor.maple>.displayName = "Sycamore Maple Trapdoor";
<Natura:button.maple>.displayName = "Sycamore Maple Button";
<Natura:fenceGate.maple>.displayName = "Sycamore Maple Fence Gate";
<woodendoors:naturadoor_maple>.displayName = "Sycamore Maple Door";
<harvestcraft:pamMaple>.displayName = "Sugar Maple Wood";
<harvestcraft:pammapleSapling>.displayName = "Sugar Maple Sapling";

# Redwood
<BiomesOPlenty:logs3:0>.displayName = "Coastal Redwood";
<BiomesOPlenty:colorizedSaplings:3>.displayName = "Coastal Redwood Sapling";
<BiomesOPlenty:planks:8>.displayName = "Coastal Redwood Planks";
<BiomesOPlenty:woodenSingleSlab2:0>.displayName = "Coastal Redwood Slab";
<BiomesOPlenty:woodenDoubleSlab2:0>.displayName = "Coastal Redwood Slab";
<BiomesOPlenty:redwoodStairs:0>.displayName = "Coastal Redwood Stairs";
<BiomesOPlenty:colorizedLeaves1:3>.displayName = "Coastal Redwood Leaves";

<Natura:redwood:0>.displayName = "Giant Redwood Bark";
<Natura:redwood:1>.displayName = "Giant Redwood";
<Natura:redwood:2>.displayName = "Giant Redwood Root";
<Natura:planks:3>.displayName = "Giant Redwood Planks";
<Natura:floraleaves:0>.displayName = "Giant Redwood Leaves";
<Natura:florasapling:0>.displayName = "Giant Redwood Sapling";
<Natura:door.redwood>.displayName = "Giant Redwood Door";
<Natura:door.redwoodbark>.displayName = "Giant Redwood Bark Door";
<Natura:plankSlab1:3>.displayName = "Giant Redwood Slab";
<Natura:stair.redwood>.displayName = "Giant Redwood Stairs";
<Natura:pressureplate.redwood>.displayName = "Giant Redwood Pressure Plate";
<Natura:trapdoor.redwood>.displayName = "Giant Redwood Trapdoor";
<Natura:button.redwood>.displayName = "Giant Redwood Button";
<Natura:fenceGate.redwood>.displayName = "Giant Redwood Fence Gate";
<Natura:redwoodDoorItem:0>.displayName = "Giant Redwood Door";
<Natura:redwoodDoorItem:6>.displayName = "Giant Redwood Bark Door";


# Bamboo
<BiomesOPlenty:bamboo>.displayName = "Bambusea Bamboo";
<BiomesOPlenty:leaves1:1>.displayName = "Bambusea Bamboo Leaves";
<BiomesOPlenty:saplings:2>.displayName = "Bambusea Bamboo Sapling";
<BiomesOPlenty:planks:10>.displayName = "Bambusea Bamboo Thatching";
<doorsoplenty:door_bamboo>.displayName = "Bambusea Bamboo Door";
<Growthcraft|Bamboo:grc.bambooBlock>.displayName = "Arundinaria Bamboo Planks";
<Growthcraft|Bamboo:grc.bambooShoot>.displayName = "Arundinaria Bamboo Shoot";
<Growthcraft|Bamboo:grc.bambooStalk>.displayName = "Arundinaria Bamboo";
<Growthcraft|Bamboo:grc.bambooLeaves>.displayName = "Arundinaria Bamboo Leaves";
<Growthcraft|Bamboo:grc.bambooFence>.displayName = "Arundinaria Bamboo Fence";
<Growthcraft|Bamboo:grc.bambooWall>.displayName = "Arundinaria Bamboo Wall";
<Growthcraft|Bamboo:grc.bambooStairs>.displayName = "Arundinaria Bamboo Stairs";
<Growthcraft|Bamboo:grc.bambooSingleSlab>.displayName = "Arundinaria Bamboo Slab";
<Growthcraft|Bamboo:grc.bambooDoubleSlab>.displayName = "Arundinaria Bamboo Slab";
<Growthcraft|Bamboo:grc.bambooFenceGate>.displayName = "Arundinaria Bamboo Fence Gate";
<Growthcraft|Bamboo:grc.bambooScaffold>.displayName = "Arundinaria Bamboo Scaffold";
<Growthcraft|Bamboo:grc.bambooDoorItem>.displayName = "Arundinaria Bamboo Door";
<Growthcraft|Bamboo:grc.bamboo>.displayName = "Arundinaria Bamboo";
<Growthcraft|Bamboo:grc.bambooShootFood>.displayName = "Arundinaria Bamboo Shoot";
<harvestcraft:bambooshootItem>.displayName = "Olyrea Bamboo Shoot";
<harvestcraft:bambooshootseedItem>.displayName = "Olyrea Bamboo Shoot Seed";


# Persimmon
<BiomesOPlenty:fruitBop:1>.displayName = "Asian Persimmon";
<BiomesOPlenty:persimmonLeaves>.displayName = "Asian Persimmon Leaves";
<BiomesOPlenty:food:8>.displayName = "Asian Persimmon";
<harvestcraft:pamPersimmon>.displayName = "Date-Plum Persimmon";
<harvestcraft:pampersimmonSapling>.displayName = "Date-Plum Persimmon Sapling";
<harvestcraft:persimmonItem>.displayName = "Date-Plum Persimmon";

# Blueberry
<Natura:berry:1>.displayName = "Highbush Blueberry";
<harvestcraft:blueberryItem>.displayName = "Lowbush Blueberry";

# Blackberry
<Natura:berry:2>.displayName = "Highbush Blackberry";
#<harvestcraft:pamblackberryCrop>.displayName = "Dewberry Crop";
#<harvestcraft:blackberryItem>.displayName = "Dewberry";
#<harvestcraft:blackberryseedItem>.displayName = "Dewberry Seed";

# Strawberry
<MorePlanet:fronos_food:0>.displayName = "Fronos Strawberry";
<MorePlanet:fruits_juice:0>.displayName = "Fronos Strawberry Juice";
<ore:listAllfruit>.add(<MorePlanet:fronos_food:0>);
<ore:cropStrawberry>.add(<MorePlanet:fronos_food:0>);
<ore:listAllberry>.add(<MorePlanet:fronos_food:0>);

# Raspberry
<Natura:BerryBush:12>.displayName = "American Raspberry Bush";
<Natura:berry:0>.displayName = "American Raspberry";
<harvestcraft:pamraspberryCrop>.displayName = "European Raspberry Crop";
<harvestcraft:raspberryItem>.displayName = "European Raspberry";
<harvestcraft:raspberryseedItem>.displayName = "European Raspberry Seed";

# Garlic
<harvestcraft:garlicItem>.displayName = "Softneck Garlic";
<harvestcraft:garlicseedItem>.displayName = "Softneck Garlic Seed";
<witchery:garlic>.displayName = "Hardneck Garlic";

# Cotton
<Natura:barleyFood:3>.displayName = "Levant Cotton";
<Natura:barley.seed:1>.displayName = "Levant Cotton Seed";
<Natura:cottonBag>.displayName = "Levant Cotton Seed Bag";
<harvestcraft:pamcottonCrop>.displayName = "Upland Cotton Crop";
<harvestcraft:cottonItem>.displayName = "Upland Cotton";
<harvestcraft:cottonseedItem>.displayName = "Upland Cotton Seed";

# Grape
<Growthcraft|Grapes:grc.grapes:0>.displayName = "Wine Grapes";
<Growthcraft|Grapes:grc.grapes:1>.displayName = "White Wine Grapes";
<Growthcraft|Grapes:grc.grapes:2>.displayName = "Red Wine Grapes";
<Growthcraft|Grapes:grc.grapeSeeds>.displayName = "Wine Grape Seeds";
<harvestcraft:pamgrapeCrop>.displayName = "Table Grape Crop";
<harvestcraft:grapeItem>.displayName = "Table Grapes";
<harvestcraft:grapeseedItem>.displayName = "Table Grape Seed";

# Barley
<Natura:barleyFood:0>.displayName = "Naked Barley";
#<Natura:barleyFood:1>.displayName = "Levant Cotton";
<Natura:barley.seed>.displayName = "Naked Barley Seeds";
<Natura:barleyBag>.displayName = "Naked Barley Seed Bag";
<harvestcraft:pambarleyCrop>.displayName = "Wild Barley Crop";
<harvestcraft:barleyItem>.displayName = "Wild Barley";
<harvestcraft:barleyseedItem>.displayName = "Wild Barley Seed";


# Mekanism compressor ingots
<Mekanism:Ingot:0>.displayName = "Obsidian-Fused Osmium Ingot";
<Mekanism:Ingot:3>.displayName = "Glowstone-Fused Osmium Ingot";


# Statues hammer
<statues:statues.marteau>.displayName = "Sculpting Hammer";

# Openblock sponge
#<OpenBlocks:sponge>.displayName = "Thirsty Sponge";
#<OpenBlocks:spongeonastick>.displayName = "Sponge on a Stick";

# Minecraft sponge
<minecraft:sponge>.displayName = "Inert Sponge";
<minecraft:sponge>.addTooltip("Craft this into a functional sponge!");

# Rename unknown dusts

val unkdust_a = [
	<Mariculture:materials:6>, # Electrum, Lead with Sulfur imurity
	<Mariculture:materials:7>, # Copper, Silver, Tin, Iron
	<Mariculture:materials:8>, # Copper, Lead, Iron with Sulfur imurity
	<Mariculture:materials:9>, # Tin, Cobalt, Iron, Nickel, Gold, Silver with Sulfur imurity
	<Mariculture:materials:10>, # Gold, Silver, Electrum
	<Mariculture:materials:11>, # Aluminium, Tin, Copper, Iron
] as IItemStack[];

for dust in unkdust_a {
	dust.displayName = "Unknown Metallic Dust";
}


# Rename Mekanism "alloy" to "lattice"
<Mekanism:EnrichedAlloy>.displayName = "Infused Lattice";
<Mekanism:ReinforcedAlloy>.displayName = "Reinforced Lattice";
<Mekanism:AtomicAlloy>.displayName = "Atomic Lattice";

# Rename Mekanism "Compressed" to "Refined"
<Mekanism:CompressedCarbon>.displayName = "Refined Carbon";
<Mekanism:CompressedRedstone>.displayName = "Refined Redstone";
<Mekanism:CompressedDiamond>.displayName = "Refined Diamond";
<Mekanism:CompressedObsidian>.displayName = "Refined Obsidian";


# Framing Saw to regular ol' Saw
<BiblioCraft:item.FramingSaw>.displayName = "Saw";

# Moon turf is regolith
<GalacticraftCore:tile.moonBlock:5>.displayName = "Lunar Regolith";

# Change Diamond pick name so that it sounds more like a part than a tool
# <minecraft:diamond_pickaxe>.displayName = "Diamond Mining Component";


# Change Harvestcraft candles and wax
<harvestcraft:waxItem>.displayName = "Candle Wax";
<GardenStuff:candle>.displayName = "Garden Lantern Candle";


# New jerky names
<TConstruct:jerky:2>.displayName = "Pork Jerky";
<TConstruct:jerky:3>.displayName = "Lamb Jerky";
<TConstruct:jerky:5>.displayName = "Zombie Jerky";

# Sesame Seeds are called Sesame Seeds Seed. Durr?
<harvestcraft:sesameseedsseedItem>.displayName = "Sesame Seed";

# Call MC seeds "wheat seeds" instead, durr
<minecraft:wheat_seeds>.displayName = "Wheat Seeds";

# Rename Metallurgy Crusher to Pulverizer
<Metallurgy:crusher>.displayName = "Ore Crusher";

# Rename Kitchen Mod knife
#<kitchen:knife>.displayName = "Kitchen Knife";

# Rename citrus jellies to marmalades
<harvestcraft:lemonjellyItem>.displayName = "Lemon Marmalade";
<harvestcraft:lemonjellysandwichItem>.displayName = "Lemon Marmalade Sandwich";
<harvestcraft:limejellyItem>.displayName = "Lime Marmalade";
<harvestcraft:limejellysandwichItem>.displayName = "Lime Marmalade Sandwich";
<harvestcraft:orangejellyItem>.displayName = "Orange Marmalade";
<harvestcraft:orangejellysandwichItem>.displayName = "Orange Marmalade Sandwich";
<harvestcraft:grapefruitjellyItem>.displayName = "Grapefruit Marmalade";
<harvestcraft:grapefruitjellysandwichItem>.displayName = "Grapefruit Marmalade Sandwich";



# Make harvestcraft salt be "rock salt"
<harvestcraft:saltItem>.displayName = "Rock salt";
# Change jerkys to be "salted jerky"
<harvestcraft:zombiejerkyItem>.displayName = "Salted Zombie Jerky";
<harvestcraft:beefjerkyItem>.displayName = "Salted Beef Jerky";




###########################
### Rename various ores ###
###########################

# Zirconium, which comes from Zircon


# Aluminium is Boehmite (Earth), Bauxite (Sea), Diaspore (Moon), Gibbsite (Asteroid)

val Bauxite = [
	<Mariculture:rocks:2>,
] as IItemStack[];
for entry in Bauxite {entry.displayName="Bauxite";}

val Boehmite = [
	<TConstruct:SearedBrick:5>,
	<MorePlanet:fronos_block:4>,
] as IItemStack[];
for entry in Boehmite {entry.displayName="Boehmite";}
<TConstruct:GravelOre:4>.displayName = "Boehmite Gravel";

val Diaspore = [
	<GalacticraftCore:tile.gcBlockCore:7>,
	<MorePlanet:diona_block:9>,
	<MorePlanet:mercury_block:6>,
] as IItemStack[];
for entry in Diaspore {entry.displayName="Diaspore";}

val Gibbsite = [
	<GalacticraftMars:tile.asteroidsBlock:3>,
	<MorePlanet:dark_asteroid_block:3>,
] as IItemStack[];
for entry in Gibbsite {entry.displayName="Gibbsite";}



# Amber
#<BiomesOPlenty:gemOre:14>.displayName="Corundum";


# Bitumen is in sediment
<Metallurgy:utility.ore:4>.displayName = "Bituminous Sediment";


# Coal is in deposits (bioligically active) or in Anthracite (inert)

val Anthracite = [
	<MorePlanet:venus_block:8>,
] as IItemStack[];
for entry in Anthracite {entry.displayName="Anthracite";}

val CoalDeposit = [
	<minecraft:coal_ore>,
	<MorePlanet:nibiru_block:7>,
	<MorePlanet:fronos_block:3>,
] as IItemStack[];
for entry in CoalDeposit {entry.displayName="Coal Deposit";}



# Cobalt is in cobaltite

val Cobaltite = [
	<TConstruct:SearedBrick:1>,
] as IItemStack[];
for entry in Cobaltite {entry.displayName="Cobaltite";}
<TConstruct:GravelOre:5>.displayName = "Cobaltite Gravel";



# Copper Ore is Chalcopyrite (Earth), Brochantite (poor Earth ore)
# Cuprite (Moon), Bornite (Mars), Deposit (Io)

val Bornite = [
	<GalacticraftMars:tile.mars:0>,
	<MorePlanet:polongnius_block:4>,
	<MorePlanet:kapteyn-b_block:7>,
	<MorePlanet:phobos_block:5>,	
] as IItemStack[];
for entry in Bornite {entry.displayName="Bornite";}

val Brochantite = [
	<Railcraft:ore:9>,
] as IItemStack[];
for entry in Brochantite {entry.displayName="Brochantite";}

val Chalcopyrite = [
	<Metallurgy:base.ore:0>,
	<GalacticraftCore:tile.gcBlockCore:5>,
	<Mekanism:OreBlock:1>,
	<TConstruct:SearedBrick:3>,
	<ThermalFoundation:Ore:0>,
] as IItemStack[];
for entry in Chalcopyrite {entry.displayName="Chalcopyrite";}

val CopperDeposit = [
	<MorePlanet:koentus_block:5>,
	<MorePlanet:mercury_block:5>,
	<MorePlanet:deimos_block:5>,
] as IItemStack[];
for entry in CopperDeposit {entry.displayName="Copper Deposit";}

val Cuprite = [
	<GalacticraftCore:tile.moonBlock:0>,
	<MorePlanet:diona_block:7>,
	<MorePlanet:fronos_block:6>,
	<MorePlanet:venus_block:7>,
] as IItemStack[];
for entry in Cuprite {entry.displayName="Cuprite";}


# Diamond Ore is the same
<Railcraft:ore:2>.displayName="Diamond Ore";


# Emerald is in beryl

val Beryl = [
	<minecraft:emerald_ore>,
	<Railcraft:ore:3>,
	<MorePlanet:fronos_block1:2>,
	<MorePlanet:dark_asteroid_block:9>,
] as IItemStack[];
for entry in Beryl {entry.displayName="Beryl";}


# Fossils are in sediments
<fossil:fossil>.displayName="Fossil Sediment";


# Gold is in deposits (Earth), Calaverite (Barnarda E)
val Calaverite = [
	<MorePlanet:venus_block:10>,
] as IItemStack[];
for entry in Calaverite {entry.displayName="Calaverite";}

val GoldDeposit = [
	<minecraft:gold_ore>,
	<MorePlanet:fronos_block1:0>,
] as IItemStack[];
for entry in GoldDeposit {entry.displayName="Gold Deposit";}
<Railcraft:ore:8>.displayName="Poor Gold Deposit";



# Iron is hematite (Earth). Moon iron is in the form of wustite.
# Magnetite (Mars, Asteroids) Goethite (Mercury), Siderite (Miranda), Wustite (Barnarda E)

val Goethite = [
	<MorePlanet:fronos_block:2>,
	<MorePlanet:pluto_block:6>,
] as IItemStack[];
for entry in Goethite {entry.displayName="Goethite";}

val Hematite = [
	<minecraft:iron_ore>,
] as IItemStack[];
for entry in Hematite {entry.displayName="Hematite";}
<TConstruct:GravelOre:0>.displayName="Hematite Gravel";
<Railcraft:ore:7>.displayName="Poor Hematite";

val Magnetite = [
	<GalacticraftMars:tile.mars:3>,
	<GalacticraftMars:tile.asteroidsBlock:5>,
	<MorePlanet:polongnius_block:6>,
	<MorePlanet:mercury_block:7>,
	<MorePlanet:deimos_block:6>,
] as IItemStack[];
for entry in Magnetite {entry.displayName="Magnetite";}

val Siderite = [
	<MorePlanet:phobos_block:6>,
] as IItemStack[];
for entry in Siderite {entry.displayName="Siderite";}

val Wustite = [
	<MorePlanet:venus_block:9>,
	<MorePlanet:dark_asteroid_block:5>,
] as IItemStack[];
for entry in Wustite {entry.displayName="Wustite";}


# Neodymium from "Frozen Iron"
<MorePlanet:kapteyn-b_block:5>.displayName="Monazite";
<MorePlanet:pluto_block:5>.displayName="Bastnasite";
<MorePlanet:kapteyn-b_block:12>.displayName="Neodymium Block";
<MorePlanet:kapteyn-b_item:0>.displayName="Neodymium Ingot";
<MorePlanet:kapteyn-b_item:2>.displayName="Compressed Neodymium";
<MorePlanet:kapteyn-b_item:4>.displayName="Neodymium Stick";
<MorePlanet:frozen_iron_helmet:0>.displayName="Neodymium Helmet";
<MorePlanet:frozen_iron_chestplate:0>.displayName="Neodymium Chestplate";
<MorePlanet:frozen_iron_leggings:0>.displayName="Neodymium Leggings";
<MorePlanet:frozen_iron_boots:0>.displayName="Neodymium Boots";
<MorePlanet:breathable_frozen_iron_helmet:0>.displayName="Breathable Neodymium Helmet";
<MorePlanet:frozen_iron_pickaxe:0>.displayName="Neodymium Pickaxe";
<MorePlanet:frozen_iron_axe:0>.displayName="Neodymium Axe";
<MorePlanet:frozen_iron_hoe:0>.displayName="Neodymium Hoe";
<MorePlanet:frozen_iron_spade:0>.displayName="Neodymium Shovel";
<MorePlanet:frozen_iron_sword:0>.displayName="Neodymium Sword";


# Iridium is
<MorePlanet:fronos_block:10>.displayName="Iridium deposit";



# Lapis is in lazurite

val Lazurite = [
	<minecraft:lapis_ore>,
	<Railcraft:ore:4>,
	<MorePlanet:fronos_block:7>,
	<MorePlanet:dark_asteroid_block:10>,
] as IItemStack[];
for entry in Lazurite {entry.displayName="Lazurite";}


# Lead is Galena (Earth), Anglesite (poor Earth ore), Cerussite (Mercury)

val Anglesite = [
	<Railcraft:ore:11>,
] as IItemStack[];
for entry in Anglesite {entry.displayName="Anglesite";}

val Cerussite = [
	<MorePlanet:venus_block:5>,
] as IItemStack[];
for entry in Cerussite {entry.displayName="Cerussite";}

val Galena = [
	<ThermalFoundation:Ore:3>,
] as IItemStack[];
for entry in Galena {entry.displayName="Galena";}


# Magnesium is in Brucite (Earth) and Dolomite (Ganymede)

val Brucite = [
	<Metallurgy:utility.ore:3>,
] as IItemStack[];
for entry in Brucite {entry.displayName="Brucite";}




# Manganese is Pyrolusite

val Pyrolusite = [
	<Metallurgy:base.ore:2>,
] as IItemStack[];
for entry in Pyrolusite {entry.displayName="Pyrolusite";}


# Meteoric Iron is Kamacite (Ceres)



# Polongius variant is cheese like

<MorePlanet:polongnius_block:10>.displayName = "Solid Polongnius Meteoric Curd";
<MorePlanet:polongnius_item:2>.displayName = "Raw Polongnius Meteoric Curd";
<MorePlanet:polongnius_item:4>.displayName = "Polongnius Meteoric Curd Ingot";
<MorePlanet:polongnius_item:6>.displayName = "Compressed Polongnius Meteoric Curd";
<MorePlanet:polongnius_item:8>.displayName = "Polongnius Meteoric Curd Stick";
<MorePlanet:polongnius_meteor_helmet>.displayName = "Polongnius Meteoric Curd Helmet";
<MorePlanet:polongnius_meteor_chestplate>.displayName = "Polongnius Meteoric Curd Chestplate";
<MorePlanet:polongnius_meteor_leggings>.displayName = "Polongnius Meteoric Curd Leggings";
<MorePlanet:polongnius_meteor_boots>.displayName = "Polongnius Meteoric Curd Boots";
<MorePlanet:breathable_polongnius_meteor_helmet>.displayName = "Breathable Polongnius Meteoric Curd Helmet";
<MorePlanet:polongnius_meteor_pickaxe>.displayName = "Polongnius Meteoric Curd Pickaxe";
<MorePlanet:polongnius_meteor_axe>.displayName = "Polongnius Meteoric Curd Axe";
<MorePlanet:polongnius_meteor_hoe>.displayName = "Polongnius Meteoric Curd Hoe";
<MorePlanet:polongnius_meteor_spade>.displayName = "Polongnius Meteoric Curd Shovel";
<MorePlanet:polongnius_meteor_sword>.displayName = "Polongnius Meteoric Curd Sword";


# Nickel comes from Pentlandite (Earth) or Pecoraite (Mercury)

val Pentlandite = [
	<ThermalFoundation:Ore:4>,
	<GalaxySpace:ores:1>,
] as IItemStack[];
for entry in Pentlandite {entry.displayName="Pentlandite";}


# Osmium is in native form

val OsmiumDeposit = [
	<Mekanism:OreBlock:0>,
] as IItemStack[];
for entry in OsmiumDeposit {entry.displayName="Osmium Deposit";}


# Palladium

val PalladiumDeposit = [
	<MorePlanet:polongnius_block:7>,
] as IItemStack[];
for entry in PalladiumDeposit {entry.displayName="Palladium Deposit";}


# Peridot

val Olivine = [
	<BiomesOPlenty:gemOre:4>,
] as IItemStack[];
for entry in Olivine {entry.displayName="Olivine";}


# Phosphorus is in phosphorite



# Platinum is in native form (Earth) or Sperrylite (Proteus)

val PlatinumDeposit = [
	<Metallurgy:precious.ore:2>,
	<ThermalFoundation:Ore:5>
] as IItemStack[];
for entry in PlatinumDeposit {entry.displayName="Platinum Deposit";}


# Quartz Ore is the same


# Ruby
val RedCorundum = [
	<BiomesOPlenty:gemOre:2>,
] as IItemStack[];
for entry in RedCorundum {entry.displayName="Red Corundum";}


# Saltpeter


# Sapphire

val BlueCorundum = [
	<BiomesOPlenty:gemOre:12>,
] as IItemStack[];
for entry in BlueCorundum {entry.displayName="Blue Corundum";}


# Silicon is taken from Ferrosilicon

val Ferrosilicon = [
	<GalacticraftCore:tile.gcBlockCore:8>,
	<MorePlanet:diona_block:8>,
	<MorePlanet:fronos_block1:3>,
	<MorePlanet:dark_asteroid_block:7>,
] as IItemStack[];
for entry in Ferrosilicon {entry.displayName="Ferrosilicon";}



# Silver is Acanthite

val Acanthite = [
	<Metallurgy:precious.ore:1>,
	<ThermalFoundation:Ore:2>, # This was taken care of in the mod file
] as IItemStack[];
for entry in Acanthite {entry.displayName="Acanthite";}

# But Thermal Foundation's silver can't be deactivated entirely for some reason.


# Sulfur

val SulfurDeposit = [
	<Metallurgy:utility.ore:0>,
	<Railcraft:ore:0>,
	<MorePlanet:sirius_block:4>,
	<MorePlanet:venus_block:4>,
	<MorePlanet:io_block:4>,
] as IItemStack[];
for entry in SulfurDeposit {entry.displayName="Sulfur Deposit";}


# Tanzanite


# Tin is Cassiterite pretty much EVERYWHERE.

val Cassiterite = [
	<Metallurgy:base.ore:1>,
	<GalacticraftCore:tile.moonBlock:1>,
	<GalacticraftMars:tile.mars:1>,
	<GalacticraftCore:tile.gcBlockCore:6>,
	<Mekanism:OreBlock:2>,
	<TConstruct:SearedBrick:4>,
	<MorePlanet:diona_block:6>,
	<MorePlanet:polongnius_block:5>,
	<MorePlanet:koentus_block:4>,
	<MorePlanet:fronos_block:5>,
	<MorePlanet:kapteyn-b_block:4>,
	<MorePlanet:mercury_block:4>,
	<MorePlanet:venus_block:6>,
	<MorePlanet:phobos_block:4>,
	<MorePlanet:deimos_block:4>,
	<ThermalFoundation:Ore:1>,
] as IItemStack[];
for entry in Cassiterite {entry.displayName="Cassiterite";}
<TConstruct:GravelOre:3>.displayName="Cassiterite Gravel";
<Railcraft:ore:10>.displayName="Poor Cassiterite";




# Titanium is in rutile (Earth), Ilmenite (Mars), Leucoxene (Ganymede)

val Rutile = [
	<Mariculture:rocks:3>,
] as IItemStack[];
for entry in Rutile {entry.displayName="Rutile";}

val Ilmenite = [
	<GalacticraftMars:tile.asteroidsBlock:4>,
	<MorePlanet:dark_asteroid_block:4>,
] as IItemStack[];
for entry in Ilmenite {entry.displayName="Ilmenite";}

<ore:oreRutile>.add(<GalacticraftMars:tile.asteroidsBlock:4>);
<ore:oreRutile>.add(<MorePlanet:dark_asteroid_block:4>);
<ore:oreTitanium>.remove(<GalacticraftMars:tile.asteroidsBlock:4>);
<ore:oreImpureTitanium>.remove(<GalacticraftMars:tile.asteroidsBlock:4>);


# Topaz


# Tungsten is Wolframite (Io), and Scheelite (Proteus)


# Uranium is in uraninite

val Uraninite = [
	<BigReactors:YelloriteOre>,
	<MorePlanet:kapteyn-b_block>,
] as IItemStack[];
for entry in Uraninite {entry.displayName="Uraninite";}
<aobd:crushedYellorium>.displayName="Crushed Uraninite";
<aobd:clumpYellorium>.displayName="Uranium Clump";
<aobd:crystalYellorium>.displayName="Uranium Crystal";
<aobd:shardYellorium>.displayName="Uranium Shard";
<aobd:dustDirtyYellorium>.displayName="Dirty Yellowcake";
<aobd:bottle_aobdyellorium>.displayName="Molten Uranium Bottle";
<aobd:nuggetYellorium>.displayName="Uranium Nugget";


# Zinc is Sphalerite

val Sphalerite = [
	<Metallurgy:precious.ore:0>,
] as IItemStack[];
for entry in Sphalerite {entry.displayName="Sphalerite";}



# Change TE Crescent Hammer to wrench
#<ThermalExpansion:wrench>.displayName = "Crescent Wrench";

