# Custom recipes required to access the Potion Core potions.
# There is no brewing stand modification available for MineTweaker,
# so all of these are manual crafting recipes. Bummer.


#############################
### Ingredients ###
#############################



### Potion bases ###

val bottleEmpty = <minecraft:glass_bottle>;

val bottleWater = <minecraft:potion:0>;
val bottleWater_dirty = <enviromine:badWaterBottle>;
val bottleWater_salt = <enviromine:saltWaterBottle>;
val bottleWater_cold = <enviromine:coldWaterBottle>;

val potionAwkward = <minecraft:potion:16>;
val potionThick = <minecraft:potion:32>;
val potionMundane_64 = <minecraft:potion:64>;
val potionMundane_8192 = <minecraft:potion:8192>;
# An oredict entry so that both mundane types are interchangeable
val potionMundane_ore = <ore:potionMundane>;
potionMundane_ore.add(potionMundane_64);
potionMundane_ore.add(potionMundane_8192);

val bottleExperience = <minecraft:experience_bottle>;
val bottleVoid = <Mariculture:fluids:0>;
val bottleSteam = <Railcraft:fluid.steam.bottle>;



### Basic incredients ###

val redstone = <minecraft:redstone>; # For extendival redstone = <minecraft:redstone>; # For extending potions
val glowstone_dust = <minecraft:glowstone_dust>; # For extendival redstone = <minecraft:redstone>; # For potent potions
val gunpowder = <minecraft:gunpowder>; # For making splash potions
val blaze_powder = <minecraft:blaze_powder>;



### Characteristic ingredients ###

val slimeball = <minecraft:slime_ball>;
val chorusfruit = <etfuturum:chorus_fruit>;
val endereye = <minecraft:ender_eye>;
val crystalwing = <CrystalWing:crystalwing.crystalWing>;
val pomegranate = <ore:cropPomegranate>;
val pearl_mar = <Mariculture:pearls:*>;
val cactus_mc = <minecraft:cactus>;
val ginger_ore = <ore:cropGinger>;
val milk_ore = <ore:listAllmilk>;
val cobweb_mc = <minecraft:web>;
val potatoPoison_mc = <minecraft:poisonous_potato>;
val mushroomRed_mc = <minecraft:red_mushroom>;
val saltAll_ore = <ore:saltAll>;
saltAll_ore.addAll(<ore:dustSalt>);
saltAll_ore.addAll(<ore:foodSalt>);
saltAll_ore.addAll(<ore:itemSalt>);
val feather_mc = <minecraft:feather>;
val appleGolden_mc = <minecraft:golden_apple>;
val blaze_rod = <minecraft:blaze_rod>;
val anvil_pristine = <minecraft:anvil:0>;
val anvil_cracked = <minecraft:anvil:1>;
val anvil_damaged = <minecraft:anvil:2>;
val enderEye_mc = <minecraft:ender_eye>;
val clayBall_mc = <minecraft:clay_ball>;
val soulSand_mc = <minecraft:soul_sand>;



##########################
### Potioncore recipes ###
##########################


# Note: irrespective of potion enchantments, all potions of the same "type" are identical for
# use in recipes. For example, you can't make potionLove + gunpowder = potionLove_splash without it also
# affecting potionRecoil, provided that they both used Awkward Potion as their base.
# This means that every potion here is a crafting endpoint, and is never transitional.



### Love ###

# Mariculture pearls take a bit to find, but they are farmable. Breeding most animals using the potion
# is unnecessary, but mod creatures and vanilla horses in particular may be difficult to breed.

val potionLove = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 53 as byte, Amplifier: 0 as byte}]});
val potionLove_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 53 as byte, Amplifier: 0 as byte}]});

recipes.addShapeless(
	potionLove,
	[potionAwkward, pearl_mar]
	);
recipes.addShapeless(
	potionLove_splash,
	[potionAwkward, pearl_mar, gunpowder]
	);



### Recoil ###

# The attacker takes some damage back. This shouldn't be too easy to make, so I require a blaze powder.

# Potion of Recoil I 3:00
val potionRecoil = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 55 as byte, Amplifier: 0 as byte}]});
# Potion of Recoil I 8:00
val potionRecoil_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 55 as byte, Amplifier: 0 as byte}]});
# Potion of Recoil II 1:30
val potionRecoil_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1800, Id: 55 as byte, Amplifier: 1 as byte}]});
# Splash Potion of Recoil 2:15
val potionRecoil_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 55 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Recoil 6:00
val potionRecoil_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 55 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Recoil II 1:07
val potionRecoil_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1340, Id: 55 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(
	potionRecoil,
	[potionAwkward, blaze_powder, cactus_mc]
	);
recipes.addShapeless(
	potionRecoil_extended,
	[potionAwkward, blaze_powder, cactus_mc, redstone]
	);
recipes.addShapeless(
	potionRecoil_potent,
	[potionAwkward, blaze_powder, cactus_mc, glowstone_dust]
	);
recipes.addShapeless(
	potionRecoil_splash,
	[potionAwkward, blaze_powder, cactus_mc, gunpowder]
	);
recipes.addShapeless(
	potionRecoil_splash_extended,
	[potionAwkward, blaze_powder, cactus_mc, redstone, gunpowder]
	);
recipes.addShapeless(
	potionRecoil_splash_potent,
	[potionAwkward, blaze_powder, cactus_mc, glowstone_dust, gunpowder]
	);



### Curing ###

# Healing all negative status effects WITHOUT canceling positive ones is a notable abililty.
# So this one requires blaze powder and a couple ingredients.

# Potion of Curing
val potionCuring = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 48 as byte, Amplifier: 0 as byte}]});
val potionCuring_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 48 as byte, Amplifier: 0 as byte}]});

recipes.addShapeless(
	potionCuring,
	[potionMundane_ore, blaze_powder, milk_ore, ginger_ore]
	);
recipes.addShapeless(
	potionCuring_splash,
	[potionMundane_ore, blaze_powder, gunpowder, milk_ore, ginger_ore]
	);



### Climbing ###

# Climbing is a strong ability but is precarious. You need to obtain cobweb, which can only be found
# already spawned, and which requires silk touch.

# Potion of Climbing 3:00
val potionClimbing = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 47 as byte, Amplifier: 0 as byte}]});
# Potion of Climbing 8:00
val potionClimbing_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 47 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Climbing 2:15
val potionClimbing_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 47 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Climbing 6:00
val potionClimbing_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 47 as byte, Amplifier: 0 as byte}]});

recipes.addShapeless(
	potionClimbing,
	[potionAwkward, cobweb_mc]
	);
recipes.addShapeless(
	potionClimbing_extended,
	[potionAwkward, cobweb_mc, redstone]
	);
recipes.addShapeless(
	potionClimbing_splash,
	[potionAwkward, cobweb_mc, gunpowder]
	);
recipes.addShapeless(
	potionClimbing_splash_extended,
	[potionAwkward, cobweb_mc, redstone, gunpowder]
	);



### Perplexity ###

# This potion will SERIOUSLY mess up player opponent. It doesn't seem to have an effect on mobs.
# Since the effect is so catastrophic to a player, this one is costly. It requires somewhat tough-
# to-find mushroom, and a difficult-to-obtain experience bottle.

# Potion of Perplexity 3:00
val potionPerplexity = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 54 as byte, Amplifier: 0 as byte}]});
# Potion of Perplexity 8:00
val potionPerplexity_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 54 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Perplexity 2:15
val potionPerplexity_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 54 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Perplexity 6:00
val potionPerplexity_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 54 as byte, Amplifier: 0 as byte}]});

recipes.addShapeless(
	potionPerplexity,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), mushroomRed_mc]
	);
recipes.addShapeless(
	potionPerplexity_extended,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), mushroomRed_mc, redstone]
	);
recipes.addShapeless(
	potionPerplexity_splash,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), mushroomRed_mc, gunpowder]
	);
recipes.addShapeless(
	potionPerplexity_splash_extended,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), mushroomRed_mc, redstone, gunpowder]
	);



### Corrosion ###

# Possibly the most powerful potion. It eats away at a player's hard-earned equipment: worn and held in hand.
# Even if you lose the battle, the player has to disrobe or else lose a ton of durability.
# I made this one a bit pricey.

# Potion of Corrosion 3:00
val potionCorrosion = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 56 as byte, Amplifier: 0 as byte}]});
# Potion of Corrosion 8:00
val potionCorrosion_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 56 as byte, Amplifier: 0 as byte}]});
# Potion of Corrosion II 1:30
val potionCorrosion_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1800, Id: 56 as byte, Amplifier: 1 as byte}]});
# Splash Potion of Corrosion 2:15
val potionCorrosion_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 56 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Corrosion 6:00
val potionCorrosion_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 56 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Corrosion II 1:07
val potionCorrosion_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1340, Id: 56 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(
	potionCorrosion,
	[potionMundane_ore, bottleExperience.giveBack(bottleEmpty), blaze_powder, saltAll_ore]
	);
recipes.addShapeless(
	potionCorrosion_extended,
	[potionMundane_ore, bottleExperience.giveBack(bottleEmpty), blaze_powder, saltAll_ore, redstone]
	);
recipes.addShapeless(
	potionCorrosion_potent,
	[potionMundane_ore, bottleExperience.giveBack(bottleEmpty), blaze_powder, saltAll_ore, glowstone_dust]
	);
recipes.addShapeless(
	potionCorrosion_splash,
	[potionMundane_ore, bottleExperience.giveBack(bottleEmpty), blaze_powder, saltAll_ore, gunpowder]
	);
recipes.addShapeless(
	potionCorrosion_splash_extended,
	[potionMundane_ore, bottleExperience.giveBack(bottleEmpty), blaze_powder, saltAll_ore, redstone, gunpowder]
	);
recipes.addShapeless(
	potionCorrosion_splash_potent,
	[potionMundane_ore, bottleExperience.giveBack(bottleEmpty), blaze_powder, saltAll_ore, glowstone_dust, gunpowder]
	);



### Vulnerability ###

# Finally, a use for poison potatoes!
# They are rare enough that you have to work a bit to make these.

# Potion of Vulnerability 3:00
val potionVulnerability = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 61 as byte, Amplifier: 0 as byte}]});
# Potion of Vulnerability 8:00
val potionVulnerability_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 61 as byte, Amplifier: 0 as byte}]});
# Potion of Vulnerability II 1:30
val potionVulnerability_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1800, Id: 61 as byte, Amplifier: 1 as byte}]});
# Splash Potion of Vulnerability 2:15
val potionVulnerability_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 61 as byte, Amplifier: 0 as byte}]});
# Potion of Vulnerability 6:00
val potionVulnerability_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 61 as byte, Amplifier: 0 as byte}]});
# Potion of Vulnerability II 1:07
val potionVulnerability_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1340, Id: 61 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(
	potionVulnerability,
	[potionAwkward, potatoPoison_mc]
	);
recipes.addShapeless(
	potionVulnerability_extended,
	[potionAwkward, potatoPoison_mc, redstone]
	);
recipes.addShapeless(
	potionVulnerability_potent,
	[potionAwkward, potatoPoison_mc, glowstone_dust]
	);
recipes.addShapeless(
	potionVulnerability_splash,
	[potionAwkward, potatoPoison_mc, gunpowder]
	);
recipes.addShapeless(
	potionVulnerability_splash_extended,
	[potionAwkward, potatoPoison_mc, redstone, gunpowder]
	);
recipes.addShapeless(
	potionVulnerability_splash_potent,
	[potionAwkward, potatoPoison_mc, glowstone_dust, gunpowder]
	);
	


### Slowfall ###

# Very cheap, because you have NO control over your motion when falling,
# And you still suffer fall damage on Level 1.

# Potion of Slowfall 3:00
val potionSlowfall = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 57 as byte, Amplifier: 0 as byte}]});
# Potion of Slowfall 8:00
val potionSlowfall_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 57 as byte, Amplifier: 0 as byte}]});
# Potion of Slowfall II 1:30
val potionSlowfall_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1800, Id: 57 as byte, Amplifier: 1 as byte}]});
# Splash Potion of Slowfall 2:15
val potionSlowfall_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 57 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Slowfall 6:00
val potionSlowfall_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 57 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Slowfall II 1:07
val potionSlowfall_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1340, Id: 57 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(
	potionSlowfall,
	[potionAwkward, feather_mc]
	);
recipes.addShapeless(
	potionSlowfall_extended,
	[potionAwkward, feather_mc, redstone]
	);
recipes.addShapeless(
	potionSlowfall_potent,
	[potionAwkward, feather_mc, glowstone_dust]
	);
recipes.addShapeless(
	potionSlowfall_splash,
	[potionAwkward, feather_mc, gunpowder]
	);
recipes.addShapeless(
	potionSlowfall_splash_extended,
	[potionAwkward, feather_mc, redstone, gunpowder]
	);
recipes.addShapeless(
	potionSlowfall_splash_potent,
	[potionAwkward, feather_mc, glowstone_dust, gunpowder]
	);



### Levitation ###

# Hot air rises.
# Medium cost, because vertical movement is extremely useful, but you have only very slight control,
# and a precarious fall could be fatal.

# Potion of Levitation 0:30
val potionLevitation = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 600, Id: 52 as byte, Amplifier: 0 as byte}]});
# Potion of Levitation 2:00
val potionLevitation_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2400, Id: 52 as byte, Amplifier: 0 as byte}]});
# Potion of Levitation II 0:20
val potionLevitation_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 400, Id: 52 as byte, Amplifier: 1 as byte}]});
# Splash Potion of Levitation 0:25
val potionLevitation_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 500, Id: 52 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Levitation 1:00
val potionLevitation_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1200, Id: 52 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Levitation II 0:15
val potionLevitation_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 300, Id: 52 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(
	potionLevitation,
	[potionAwkward, blaze_rod]
	);
recipes.addShapeless(
	potionLevitation_extended,
	[potionAwkward, blaze_rod, redstone]
	);
recipes.addShapeless(
	potionLevitation_potent,
	[potionAwkward, blaze_rod, glowstone_dust]
	);
recipes.addShapeless(
	potionLevitation_splash,
	[potionAwkward, blaze_rod, gunpowder]
	);
recipes.addShapeless(
	potionLevitation_splash_extended,
	[potionAwkward, blaze_rod, redstone, gunpowder]
	);
recipes.addShapeless(
	potionLevitation_splash_potent,
	[potionAwkward, blaze_rod, glowstone_dust, gunpowder]
	);



### Inversion ###

# In the right circumstances this potion is amazing. So it's going to cost you.

# Potion of Inversion
val potionInversion = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 51 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Inversion
val potionInversion_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 51 as byte, Amplifier: 0 as byte}]});

recipes.addShapeless(
	potionInversion,
	[potionAwkward, appleGolden_mc]
	);
recipes.addShapeless(
	potionInversion_splash,
	[potionAwkward, appleGolden_mc, gunpowder]
	);



### High Step ###

# This potion is great if you have no other way to high-step. At the cost of a single slime ball,
# its price is on par with the swiftness potion.

# Potion of High Step 3:00
val potionHighStep = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 60 as byte, Amplifier: 0 as byte}]});
# Potion of High Step 8:00
val potionHighStep_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 60 as byte, Amplifier: 0 as byte}]});
# Potion of High Step II 1:30
val potionHighStep_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1800, Id: 60 as byte, Amplifier: 1 as byte}]});
# Splash Potion of High Step 2:15
val potionHighStep_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 60 as byte, Amplifier: 0 as byte}]});
# Splash Potion of High Step 6:00
val potionHighStep_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 60 as byte, Amplifier: 0 as byte}]});
# Splash Potion of High Step II 2:15
val potionHighStep_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1340, Id: 60 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(
	potionHighStep,
	[potionAwkward, slimeball]
	);
recipes.addShapeless(
	potionHighStep_extended,
	[potionAwkward, slimeball, redstone]
	);
recipes.addShapeless(
	potionHighStep_potent,
	[potionAwkward, slimeball, glowstone_dust]
	);
recipes.addShapeless(
	potionHighStep_splash,
	[potionAwkward, slimeball, gunpowder]
	);
recipes.addShapeless(
	potionHighStep_splash_extended,
	[potionAwkward, slimeball, redstone, gunpowder]
	);
recipes.addShapeless(
	potionHighStep_splash_potent,
	[potionAwkward, slimeball, glowstone_dust, gunpowder]
	);



### Weight ###

# This potion can be very useful against both players and mobs! So I made it costly.
# You need to use an anvil as part of the cost, but instead of consuming the whole anvil,
# it gets damaged. Only when it's Very Damaged will it be consumed on potion use.
# As a result, I had to register three copies of each recipe.

# Potion of Weight 3:00
val potionWeight = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 62 as byte, Amplifier: 0 as byte}]});
# Potion of Weight 8:00
val potionWeight_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 62 as byte, Amplifier: 0 as byte}]});
# Potion of Weight II 1:30
val potionWeight_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1800, Id: 62 as byte, Amplifier: 1 as byte}]});
# Splash Potion of Weight 2:15
val potionWeight_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 62 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Weight 6:00
val potionWeight_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 62 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Weight II 1:07
val potionWeight_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1340, Id: 62 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(potionWeight, [potionThick, blaze_powder, anvil_pristine.transformReplace(anvil_cracked)]);
recipes.addShapeless(potionWeight, [potionThick, blaze_powder, anvil_cracked.transformReplace(anvil_damaged)]);
recipes.addShapeless(potionWeight, [potionThick, blaze_powder, anvil_damaged]);

recipes.addShapeless(potionWeight_extended, [potionThick, blaze_powder, anvil_pristine.transformReplace(anvil_cracked), redstone]);
recipes.addShapeless(potionWeight_extended, [potionThick, blaze_powder, anvil_cracked.transformReplace(anvil_damaged), redstone]);
recipes.addShapeless(potionWeight_extended, [potionThick, blaze_powder, anvil_damaged, redstone]);

recipes.addShapeless(potionWeight_potent, [potionThick, blaze_powder, anvil_pristine.transformReplace(anvil_cracked), glowstone_dust]);
recipes.addShapeless(potionWeight_potent, [potionThick, blaze_powder, anvil_cracked.transformReplace(anvil_damaged), glowstone_dust]);
recipes.addShapeless(potionWeight_potent, [potionThick, blaze_powder, anvil_damaged, glowstone_dust]);

recipes.addShapeless(potionWeight_splash, [potionThick, blaze_powder, anvil_pristine.transformReplace(anvil_cracked), gunpowder]);
recipes.addShapeless(potionWeight_splash, [potionThick, blaze_powder, anvil_cracked.transformReplace(anvil_damaged), gunpowder]);
recipes.addShapeless(potionWeight_splash, [potionThick, blaze_powder, anvil_damaged, gunpowder]);

recipes.addShapeless(potionWeight_splash_extended, [potionThick, blaze_powder, anvil_pristine.transformReplace(anvil_cracked), redstone, gunpowder]);
recipes.addShapeless(potionWeight_splash_extended, [potionThick, blaze_powder, anvil_cracked.transformReplace(anvil_damaged), redstone, gunpowder]);
recipes.addShapeless(potionWeight_splash_extended, [potionThick, blaze_powder, anvil_damaged, redstone, gunpowder]);

recipes.addShapeless(potionWeight_splash_potent, [potionThick, blaze_powder, anvil_pristine.transformReplace(anvil_cracked), glowstone_dust, gunpowder]);
recipes.addShapeless(potionWeight_splash_potent, [potionThick, blaze_powder, anvil_cracked.transformReplace(anvil_damaged), glowstone_dust, gunpowder]);
recipes.addShapeless(potionWeight_splash_potent, [potionThick, blaze_powder, anvil_damaged, glowstone_dust, gunpowder]);



### Dispel ###

# Removing positive statuses from your opponent can be pretty great under the right circumstances,
# so an ender eye seems like a fair price.

# Potion of Dispel
val potionDispel = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 49 as byte, Amplifier: 0 as byte}]});
val potionDispel_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1, Id: 49 as byte, Amplifier: 0 as byte}]});

recipes.addShapeless(
	potionDispel,
	[potionMundane_ore, enderEye_mc]
	);
recipes.addShapeless(
	potionDispel_splash,
	[potionMundane_ore, enderEye_mc, gunpowder]
	);



### Antidote ###

# Very cheap: a clay ball. Poison is more of a minor annoyance than a serious threat.
# And this potion is only useful if you ANTICIPATE being poisoned.
# Inspired by tapirs eating clay in order to neutralize poison.

# Antidote 3:00
val potionAntidote = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 46 as byte, Amplifier: 0 as byte}]});
# Antidote 8:00
val potionAntidote_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 46 as byte, Amplifier: 0 as byte}]});
# Splash Antidote 2:15
val potionAntidote_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 46 as byte, Amplifier: 0 as byte}]});
# Splash Antidote 6:00
val potionAntidote_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 46 as byte, Amplifier: 0 as byte}]});

recipes.addShapeless(
	potionAntidote,
	[potionThick, clayBall_mc]
	);
recipes.addShapeless(
	potionAntidote_extended,
	[potionThick, clayBall_mc, redstone]
	);
recipes.addShapeless(
	potionAntidote_splash,
	[potionThick, clayBall_mc, gunpowder]
	);
recipes.addShapeless(
	potionAntidote_splash_extended,
	[potionThick, clayBall_mc, redstone, gunpowder]
	);



### Spinning ###

# This is another one that will be a massive annoyance to your opponent.
# It appears to affect mobs, but they don't really care.
# Because it's such a dreadful effect, even if you win the battle, I made it expensive.

# Potion of Spinning 3:00
val potionSpinning = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 3600, Id: 59 as byte, Amplifier: 0 as byte}]});
# Potion of Spinning 8:00
val potionSpinning_extended = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 9600, Id: 59 as byte, Amplifier: 0 as byte}]});
# Potion of Spinning II 1:30
val potionSpinning_potent = <potioncore:custom_potion>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1800, Id: 59 as byte, Amplifier: 1 as byte}]});
# Splash Potion of Spinning 2:15
val potionSpinning_splash = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 2700, Id: 59 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Spinning 6:00
val potionSpinning_splash_extended = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 7200, Id: 59 as byte, Amplifier: 0 as byte}]});
# Splash Potion of Spinning II 1:07
val potionSpinning_splash_potent = <potioncore:custom_potion:16384>.withTag({CustomPotionEffects: [{Ambient: 0 as byte, Duration: 1340, Id: 59 as byte, Amplifier: 1 as byte}]});

recipes.addShapeless(
	potionSpinning,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), blaze_powder, soulSand_mc]
	);
recipes.addShapeless(
	potionSpinning_extended,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), blaze_powder, soulSand_mc, redstone]
	);
recipes.addShapeless(
	potionSpinning_potent,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), blaze_powder, soulSand_mc, glowstone_dust]
	);
recipes.addShapeless(
	potionSpinning_splash,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), blaze_powder, soulSand_mc, gunpowder]
	);
recipes.addShapeless(
	potionSpinning_splash_extended,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), blaze_powder, soulSand_mc, redstone, gunpowder]
	);
recipes.addShapeless(
	potionSpinning_splash_potent,
	[potionAwkward, bottleExperience.giveBack(bottleEmpty), blaze_powder, soulSand_mc, glowstone_dust, gunpowder]
	);