import minetweaker.item.IItemStack;
import minetweaker.item.IIngredient;


#### Item key ###
# Osmium ingot: <Mekanism:Ingot:1>


### Item values ###

# Minecraft
val itemString = <minecraft:string>;
val anvil_mc_any = <minecraft:anvil:*>;
val compass_mc = <minecraft:compass>;
val bottleGlass_mc = <minecraft:glass_bottle>;
val redstone_mc = <minecraft:redstone>;
val diamond_mc = <minecraft:diamond>;
val slimeball_mc = <minecraft:slime_ball>;
val torchRedstone_mc = <minecraft:redstone_torch>;
val blockPiston_mc = <minecraft:piston>;
val flint_mc = <minecraft:flint>;
val lapis_mc = <minecraft:dye:4>;
val flintsteel_mc = <minecraft:flint_and_steel>;
val paper_mc = <minecraft:paper>;
val seedwt_mc = <minecraft:wheat_seeds>;
val ingotFe_mc = <minecraft:iron_ingot>;
val oreFe_mc = <minecraft:iron_ore>;

### OreDict

val blockStone_ore = <ore:stone>;
val stickWood_ore = <ore:stickWood>;
val planksWood_ore = <ore:plankWood>;
val blockSponge_ore = <ore:sponge>;
val pillarQuartz_ore = <ore:blockQuartzPillar>;
val blockGlass_ore = <ore:glass>;
val logWood_ore = <ore:logWood>;
val slabWood_ore = <ore:slabWood>;
val fenceWood_ore = <ore:fenceWood>;
val fenceGateWood_ore = <ore:fenceGateWood>;

# Ores
val oreFe_ore = <ore:oreIron>;
val oreRutile_ore = <ore:oreRutile>;
val oreCu_ore = <ore:oreCopper>;
val oreCo_ore = <ore:oreCobalt>;

# Ingots
val ingotFe_ore = <ore:ingotIron>;
val ingotAu_ore = <ore:ingotGold>;
val ingotCu_ore = <ore:ingotCopper>;
val ingotBronze_ore = <ore:ingotBronze>;
val ingotSteel_ore = <ore:ingotSteel>;
val ingotObsidian_ore = <ore:ingotObsidian>;
val ingotAl_ore = <ore:ingotAluminium>;
val ingotTi_ore = <ore:ingotTitanium>;
val ingotCo_ore = <ore:ingotCobalt>;

# Blocks
val blockSteel_ore = <ore:blockSteel>;
val blockCu_ore = <ore:blockCopper>;

# Nuggets
val nuggetFe_ore = <ore:nuggetIron>;
val nuggetAu_ore = <ore:nuggetGold>;
val nuggetCu_ore = <ore:nuggetCopper>;

# Dust
val dustCu_ore = <ore:dustCopper>;
val dustCo_ore = <ore:dustCobalt>;
val dustFe_ore = <ore:dustIron>;

# Dirty Dust
val dirtyDustCo_ore = <ore:dustDirtyCobalt>;
val dirtyDustFe_ore = <ore:dustDirtyIron>;

# Clump
val clumpCo_ore = <ore:clumpCobalt>;
val clumpFe_ore = <ore:clumpIron>;

# Shard
val shardCo_ore = <ore:shardCobalt>;
val shardFe_ore = <ore:shardIron>;

# Crystal
val crystalCo_ore = <ore:crystalCobalt>;
val crystalFe_ore = <ore:crystalIron>;

# Rods
val rodStone_ore = <ore:rodStone>;
val rodFe_ore = <ore:rodIron>;

# Plates
val plateSteel_ore = <ore:plateSteel>;

# Dyes
val dyeWhite_ore = <ore:dyeWhite>;     # 0
val dyeOrange_ore = <ore:dyeOrange>;    # 1
val dyeMagenta_ore = <ore:dyeMagenta>;   # 2
val dyeLightBlue_ore = <ore:dyeLightBlue>; # 3
val dyeYellow_ore = <ore:dyeYellow>;    # 4
val dyeLime_ore = <ore:dyeLime>;      # 5
val dyePink_ore = <ore:dyePink>;      # 6
val dyeGray_ore = <ore:dyeGray>;      # 7
val dyeLightGray_ore = <ore:dyeLightGray>; # 8
val dyeCyan_ore = <ore:dyeCyan>;      # 9
val dyePurple_ore = <ore:dyePurple>;    # 10
val dyeBlue_ore = <ore:dyeBlue>;      # 11
val dyeBrown_ore = <ore:dyeBrown>;     # 12
val dyeGreen_ore = <ore:dyeGreen>;     # 13
val dyeRed_ore = <ore:dyeRed>;       # 14
val dyeBlack_ore = <ore:dyeBlack>;      # 15

# Foods
val muttonRaw_ore = <ore:foodMuttonraw>;
val muttonCooked_ore = <ore:foodMuttoncooked>;
val eggFried = <ore:foodFriedegg>;
val cropPotato_ore = <ore:cropPotato>;
val cropCotton_ore = <ore:cropCotton>;
val cropBarley_ore = <ore:cropBarley>;

# Feathers
val feather_ore = <ore:feather>;

# Liquids
val water_liq = <liquid:water>;
val moltenCopper_liq = <liquid:copper.molten>;
val moltenIron_liq = <liquid:iron.molten>;
val moltenRutile_liq = <liquid:rutile.molten>;

# Gases
val gasOxygen = <gas:oxygen>;
val gasHydrogen = <gas:hydrogen>;
val gasWater = <gas:water>;
val gasHCl = <gas:hydrogenchloride>;
val gaslOs = <gas:liquidOsmium>;
val gasEthene = <gas:ethene>;
val gasNa = <gas:sodium>;
val gasD = <gas:deuterium>;
val gasT = <gas:tritium>;

# Big Reactors
val ingotYellorium_br = <BigReactors:BRIngot:0>;
val ingotCyanite_br = <BigReactors:BRIngot:1>;
val blockCyanite_br = <BigReactors:BRMetalBlock:1>;
val blockLudicrite_br = <BigReactors:BRMetalBlock:4>;

# Biomes o' Plenty
val gemAmethyst_bop = <BiomesOPlenty:gems:0>;
val gemRuby_bop = <BiomesOPlenty:gems:1>;
val gemPeridot_bop = <BiomesOPlenty:gems:2>;
val gemTopaz_bop = <BiomesOPlenty:gems:3>;
val gemTanzanite_bop = <BiomesOPlenty:gems:4>;
val gemMalachite_bop = <BiomesOPlenty:gems:5>;
val gemSapphire_bop = <BiomesOPlenty:gems:6>;
val gemAmber_bop = <BiomesOPlenty:gems:7>;

# Eggy Goodness
val goldegg_eg = <EggyGoodness:emeraldGoldenEgg>;

# Fossils
val gemScarab = <fossil:scarabGem>;

# Galacticraft and modules
val canvas_gc = <GalacticraftCore:item.canvas>;
val heavyplating_gc = <GalacticraftCore:item.heavyPlating>;
val wireAl_gc = <GalacticraftCore:tile.aluminumWire:0>;
val ingotCo_gs = <GalaxySpace:item.Ingots:0>;
val oreCo_gs = <GalaxySpace:ores:0>;

# Growthcraft
val rope_grce = <Growthcraft:grc.rope>;
val planks_bamboo_gc = <Growthcraft|Bamboo:grc.bambooBlock>;

# Mariculture
#val voltz_sheet_metal_hammer = <voltzengine:veSheetMetalTools>.withTag({toolType: "hammer"});
val sheet_of_Al = <Mariculture:crafting:7>;
val sheet_of_Au = <Mariculture:crafting:13>;
val sheet_of_Ti = <Mariculture:crafting:17>;
val wd_cons_blk = <Mariculture:woods>; # Wooden Construction Block

# Mekanism
val circuit_basic = <Mekanism:ControlCircuit:0>;
val circuit_advanced = <Mekanism:ControlCircuit:1>;
val circuit_elite = <Mekanism:ControlCircuit:2>;
val circuit_ultimate = <Mekanism:ControlCircuit:3>;
val alloy_reinforced = <Mekanism:ReinforcedAlloy>;
val alloy_enriched = <Mekanism:EnrichedAlloy>;
val alloy_atomic = <Mekanism:AtomicAlloy>;
val plastic_pellet = <Mekanism:Polyethene:0>;
val plastic_rod = <Mekanism:Polyethene:1>;
val plastic_sheet = <Mekanism:Polyethene:2>;
val plaStick = <Mekanism:Polyethene:3>;
val dustIron_mk = <Mekanism:Dust:0>;
val dirtyDustIron_mk = <Mekanism:DirtyDust:0>;
val clumpIron_mk = <Mekanism:Clump:0>;
val shardIron_mk = <Mekanism:Shard:0>;
val crystalIron_mk = <Mekanism:Crystal:0>;

# Voltz Engine
#val circuitBasic_ve = <voltzengine:veCircuits:0>;
#val circuitAdvanced_ve = <voltzengine:veCircuits:1>;
#val circuitElite_ve = <voltzengine:veCircuits:2>;

# Zoocraft Discoveries
val pantile_zcd = <ZoocraftDiscoveries:clay_pantile:*>;

# Copper Ingots
val ingotCopper_gc = <GalacticraftCore:item.basicItem:3>;
val ingotCopper_mc = <Mariculture:materials:4>;
val ingotCopper_mk = <Mekanism:Ingot:5>;
val ingotCopper_mt = <Metallurgy:copper.ingot>;
val ingotCopper_rc = <Railcraft:ingot:1>;
val ingotCopper_tf = <ThermalFoundation:material:64>;
val ingotCopper_ef = <etfuturum:copper_ingot>;
#val ingotCopper_ve = <voltzengine:veIngot:1>;
val ingotCopper_tc = <TConstruct:materials:9>;

# Copper Blocks
val blockCopper_gc = <GalacticraftCore:tile.gcBlockCore:9>;
val blockCopper_mk = <Mekanism:BasicBlock:12>;
val blockCopper_mt = <Metallurgy:base.block>;
val blockCopper_tf = <ThermalFoundation:Storage>;
val blockCopper_mc = <Mariculture:metals>;
val blockCopper_rc = <Railcraft:cube:9>;
val blockCopper_tc = <TConstruct:MetalBlock:3>;
val blockCopper_ef = <etfuturum:copper_block>;
val blockWaxedCopper_ef = <etfuturum:copper_block:8>;


# === OreDict modifications ===

# Basalt, Gabbro, Volcanic Stone
<ore:stoneBasalt>.remove(<ganyssurface:basalt:0>);
<ore:stoneBasaltPolished>.remove(<ganyssurface:basalt:1>);
<ore:stoneBasalt>.remove(<fossil:volcanicRock>);
<ore:stoneBasaltBricks>.remove(<fossil:volcanicBrick>);
<ore:stoneGabbro>.add(<ganyssurface:basalt:0>);
<ore:stoneGabbro>.add(<ganyssurface:basalt:1>);
<ore:stoneVolcanicRock>.add(<fossil:volcanicRock>);
<ore:stoneVolcanicRockBricks>.add(<fossil:volcanicBrick>);

val stoneBasaltTypes = [
	<netherlicious:Basalt:0>,
	<netherlicious:Basalt:1>
	] as IItemStack[];
for oredictval in stoneBasaltTypes {
	<ore:stoneBasalt>.add(oredictval);
}
val stoneBasaltBricksTypes = [
	<netherlicious:BasaltBricks:0>,
	<netherlicious:BasaltBricks:1>,
	<netherlicious:BasaltBricks:2>,
	<netherlicious:BasaltBricks:3>,
	<netherlicious:BasaltBricks:4>,
	<netherlicious:BasaltBricks:5>,
	<netherlicious:BasaltBricks:6>,
	<netherlicious:BasaltBricks:7>
	] as IItemStack[];
for oredictval in stoneBasaltBricksTypes {
	<ore:stoneBasaltBricks>.add(oredictval);
}

<ore:cropMint>.add(<ZoocraftDiscoveries:herb:6>);

# There is no entry for fences??
val woodFenceTypes = [
	<minecraft:fence:0>,
	<Growthcraft|Bamboo:grc.bambooFence:0>,
	<MorePlanet:nibiru_fence:0>,
	<MorePlanet:nibiru_fence:1>,
	<MorePlanet:crystal_fence:0>,
	<MorePlanet:fronos_fence:0>,
	<MorePlanet:fronos_fence:1>,
	<MorePlanet:europa_fence:0>,
	<MorePlanet:alien_fence:0>,
	<Natura:Natura.fence:0>,
	<Natura:Natura.fence:1>,
	<Natura:Natura.fence:2>,
	<Natura:Natura.fence:3>,
	<Natura:Natura.fence:4>,
	<Natura:Natura.fence:5>,
	<Natura:Natura.fence:6>,
	<Natura:Natura.fence:7>,
	<Natura:Natura.fence:8>,
	<Natura:Natura.fence:9>,
	<Natura:Natura.fence:10>,
	<Natura:Natura.fence:11>,
	<Natura:Natura.fence:12>,
	<ganyssurface:fence_1:0>,
	<ganyssurface:fence_2:0>,
	<ganyssurface:fence_3:0>,
	<ganyssurface:fence_4:0>,
	<ganyssurface:fence_5:0>,
	<netherlicious:FoxfireFence:0>,
	<netherlicious:CrimsonFence:0>,
	<netherlicious:WarpedFence:0>,
	<woodstuff:fence_tile.planks_4:0>,
	<woodstuff:fence_tile.planks_3:0>,
	<woodstuff:fence_tile.planks_6:0>,
	<woodstuff:fence_tile.planks_5:0>,
	<woodstuff:fence_tile.planks_0:0>,
	<woodstuff:fence_tile.planks_2:0>,
	<woodstuff:fence_tile.planks_1:0>,
	<woodstuff:fence_tile.planks_8:0>,
	<woodstuff:fence_tile.planks_7:0>,
	<woodstuff:fence_tile.planks_9:0>,
	<woodstuff:fence_mariculture.tile.woods_1:0>,
	<woodstuff:fence_tile.planks_10:0>,
	<woodstuff:fence_tile.planks_11:0>,
	<woodstuff:fence_tile.planks_12:0>,
	<woodstuff:fence_tile.planks_13:0>,
	<woodstuff:fence_tile.planks_14:0>,
	<woodstuff:fence_tile.spookyLog_0:0>,
	<woodstuff:fence_tile.palaeoraphePlanks_0:0>,
	<woodstuff:fence_tile.witchery.witchwood_0:0>,
	<woodstuff:fence_tile.witchery.witchwood_1:0>,
	<woodstuff:fence_tile.witchery.witchwood_2:0>,
	<woodstuff:fence_tile.TFTowerStone_0:0>,
	<woodstuff:fence_tile.logs3_3:0>,
	<woodstuff:fence_tile.logs3_2:0>,
	<woodstuff:fence_tile.BarnardaCBlocks_4:0>
	] as IItemStack[];
	
for fenceVal in woodFenceTypes {
	fenceWood_ore.add(fenceVal);
}


# Fence Gates
val woodFenceGateTypes = [
	<minecraft:fence_gate>,
	<CarpentersBlocks:blockCarpentersGate>,
	<Growthcraft|Bamboo:grc.bambooFenceGate>,
	<MorePlanet:ancient_dark_fence_gate>,
	<MorePlanet:orange_fence_gate>,
	<MorePlanet:crystal_fence_gate>,
	<MorePlanet:coconut_fence_gate>,
	<MorePlanet:red_maple_fence_gate>,
	<MorePlanet:europa_fence_gate>,
	<MorePlanet:alien_fence_gate>,
	<Natura:fenceGate.eucalyptus>,
	<Natura:fenceGate.sakura>,
	<Natura:fenceGate.ghostwood>,
	<Natura:fenceGate.redwood>,
	<Natura:fenceGate.bloodwood>,
	<Natura:fenceGate.hopseed>,
	<Natura:fenceGate.maple>,
	<Natura:fenceGate.amaranth>,
	<Natura:fenceGate.silverbell>,
	<Natura:fenceGate.tiger>,
	<Natura:fenceGate.willow>,
	<Natura:fenceGate.darkwood>,
	<Natura:fenceGate.fusewood>,
	<ganyssurface:fence_gate_1>,
	<ganyssurface:fence_gate_2>,
	<ganyssurface:fence_gate_3>,
	<ganyssurface:fence_gate_4>,
	<ganyssurface:fence_gate_5>,
	<netherlicious:crimsonFenceGate>,
	<netherlicious:foxfireFenceGate>,
	<netherlicious:warpedFenceGate>,
	<woodstuff:fence_gate_tile.palaeoraphePlanks_0>,
	<woodstuff:fence_gate_tile.witchery.witchwood_0>,
	<woodstuff:fence_gate_tile.witchery.witchwood_1>,
	<woodstuff:fence_gate_tile.witchery.witchwood_2>,
	<woodstuff:fence_gate_tile.BarnardaCBlocks_4>,
	<woodstuff:fence_gate_tile.TFTowerStone_0>,
	<woodstuff:fence_gate_tile.spookyLog_0>,
	<woodstuff:fence_gate_mariculture.tile.woods_1>,
	<woodstuff:fence_gate_tile.planks_9>,
	<woodstuff:fence_gate_tile.planks_3>,
	<woodstuff:fence_gate_tile.planks_4>,
	<woodstuff:fence_gate_tile.planks_1>,
	<woodstuff:fence_gate_tile.planks_2>,
	<woodstuff:fence_gate_tile.planks_7>,
	<woodstuff:fence_gate_tile.planks_8>,
	<woodstuff:fence_gate_tile.planks_5>,
	<woodstuff:fence_gate_tile.planks_6>,
	<woodstuff:fence_gate_tile.planks_14>,
	<woodstuff:fence_gate_tile.planks_12>,
	<woodstuff:fence_gate_tile.planks_0>,
	<woodstuff:fence_gate_tile.planks_13>,
	<woodstuff:fence_gate_tile.planks_10>,
	<woodstuff:fence_gate_tile.planks_11>,
	<woodstuff:fence_gate_tile.logs3_3>
	] as IItemStack[];
	
for fenceGateVal in woodFenceGateTypes {
	fenceGateWood_ore.add(fenceGateVal);
}


# MoCreatures stuff courtesy of Jonathan
<ore:treeLeaves>.add(<MoCreatures:MoCLeaves:0>);
<ore:treeLeaves>.add(<MoCreatures:MoCLeaves:1>);
logWood_ore.add(<MoCreatures:MoCLog:0>);
logWood_ore.add(<MoCreatures:MoCLog:1>);
planksWood_ore.add(<MoCreatures:MoCWoodPlank:0>);
planksWood_ore.add(<MoCreatures:MoCWoodPlank:1>);
<ore:record>.add(<MoCreatures:recordshuffle>);
<ore:foodOmelet>.add(<MoCreatures:omelet>);
<ore:foodTurtleraw>.add(<MoCreatures:turtleraw>);
<ore:foodTurtlesoup>.add(<MoCreatures:turtlesoup>);
val rawOstrich = <MoCreatures:ostrichraw>;
<ore:foodOstrichraw>.add(rawOstrich);
<ore:listAllostrichraw>.add(rawOstrich);
<ore:listAllmeatraw>.add(rawOstrich);
val cookedOstrich= <MoCreatures:ostrichcooked>;
<ore:foodOstrichcooked>.add(cookedOstrich);
<ore:listAllostrichcooked>.add(cookedOstrich);
<ore:listAllmeatcooked>.add(cookedOstrich);
val rawTurkey = <MoCreatures:turkeyraw>;
<ore:foodTurkeyraw>.add(rawTurkey);
<ore:listAllturkeyraw>.add(rawTurkey);
<ore:listAllmeatraw>.add(rawTurkey);
val cookedTurkey = <MoCreatures:turkeycooked>;
<ore:foodTurkeycooked>.add(cookedTurkey);
<ore:listAllturkeycooked>.add(cookedTurkey);
<ore:listAllmeatcooked>.add(cookedTurkey);
<ore:foodRatraw>.add(<MoCreatures:ratraw>);
<ore:foodRatcooked>.add(<MoCreatures:ratcooked>);
<ore:foodRatburger>.add(<MoCreatures:ratburger>);
<ore:foodCrabraw>.add(<MoCreatures:crabraw>);
<ore:foodCrabcooked>.add(<MoCreatures:crabcooked>);


# === Meats ===

# Alligator
<ore:listAllmeatraw>.add(<awakeningmeat:alligator_raw>);
<ore:listAllalligatorraw>.add(<awakeningmeat:alligator_raw>);
<ore:foodAlligatorraw>.add(<awakeningmeat:alligator_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:alligator_cooked>);
<ore:listAllalligatorcooked>.add(<awakeningmeat:alligator_cooked>);
<ore:foodAlligatorcooked>.add(<awakeningmeat:alligator_cooked>);
# Bat
<ore:listAllmeatraw>.add(<awakeningmeat:bat_raw>);
<ore:listAllbatraw>.add(<awakeningmeat:bat_raw>);
<ore:foodBatraw>.add(<awakeningmeat:bat_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:bat_cooked>);
<ore:listAllbatcooked>.add(<awakeningmeat:bat_cooked>);
<ore:foodBatcooked>.add(<awakeningmeat:bat_cooked>);
# Bird
<ore:listAllmeatraw>.add(<awakeningmeat:bird_raw>);
<ore:listAllbirdraw>.add(<awakeningmeat:bird_raw>);
<ore:foodBirdraw>.add(<awakeningmeat:bird_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:bird_cooked>);
<ore:listAllbirdcooked>.add(<awakeningmeat:bird_cooked>);
<ore:foodBirdcooked>.add(<awakeningmeat:bird_cooked>);
# Bison
<ore:listAllmeatraw>.add(<wildmobsmod:bison_meat>);
<ore:listAllbisonraw>.add(<wildmobsmod:bison_meat>);
<ore:foodBisonraw>.add(<wildmobsmod:bison_meat>);
<ore:listAllmeatcooked>.add(<wildmobsmod:cooked_bison_meat>);
<ore:listAllbisoncooked>.add(<wildmobsmod:cooked_bison_meat>);
<ore:foodBisoncooked>.add(<wildmobsmod:cooked_bison_meat>);
# Bushmeat
<ore:listAllmeatraw>.add(<awakeningmeat:bushmeat_raw>);
<ore:listAllbushmeatraw>.add(<awakeningmeat:bushmeat_raw>);
<ore:foodBushmeatraw>.add(<awakeningmeat:bushmeat_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:bushmeat_cooked>);
<ore:listAllbushmeatcooked>.add(<awakeningmeat:bushmeat_cooked>);
<ore:foodBushmeatcooked>.add(<awakeningmeat:bushmeat_cooked>);
# Calamari
<ore:listAllfishraw>.add(<wildmobsmod:calamari>);
<ore:foodCalamariraw>.add(<wildmobsmod:calamari>);
<ore:listAllfishcooked>.add(<wildmobsmod:cooked_calamari>);
<ore:foodCalamaricooked>.add(<wildmobsmod:cooked_calamari>);
# Camel
<ore:listAllmeatraw>.add(<awakeningmeat:camel_raw>);
<ore:listAllcamelraw>.add(<awakeningmeat:camel_raw>);
<ore:foodCamelraw>.add(<awakeningmeat:camel_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:camel_cooked>);
<ore:listAllcamelcooked>.add(<awakeningmeat:camel_cooked>);
<ore:foodCamelcooked>.add(<awakeningmeat:camel_cooked>);
# Chevon
<ore:listAllmeatraw>.add(<wildmobsmod:chevon>);
<ore:listAllchevonraw>.add(<wildmobsmod:chevon>);
<ore:foodChevonraw>.add(<wildmobsmod:chevon>);
<ore:listAllmeatcooked>.add(<wildmobsmod:cooked_chevon>);
<ore:listAllchevoncooked>.add(<wildmobsmod:cooked_chevon>);
<ore:foodChevoncooked>.add(<wildmobsmod:cooked_chevon>);
# Clownfish
<ore:listAllfishcooked>.add(<awakeningmeat:clownfish_cooked>);
<ore:foodClownfishcooked>.add(<awakeningmeat:clownfish_cooked>);
# Dragon
<ore:listAllmeatraw>.add(<awakeningmeat:dragon_raw>);
<ore:listAlldragonraw>.add(<awakeningmeat:dragon_raw>);
<ore:foodDragonraw>.add(<awakeningmeat:dragon_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:dragon_cooked>);
<ore:listAlldragoncooked>.add(<awakeningmeat:dragon_cooked>);
<ore:foodDragoncooked>.add(<awakeningmeat:dragon_cooked>);
# Duck
<ore:listAllmeatraw>.add(<awakeningmeat:duck_raw>);
<ore:listAllduckraw>.add(<awakeningmeat:duck_raw>);
<ore:foodDuckraw>.add(<awakeningmeat:duck_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:duck_cooked>);
<ore:listAllduckcooked>.add(<awakeningmeat:duck_cooked>);
<ore:foodDuckcooked>.add(<awakeningmeat:duck_cooked>);
# Elephant
<ore:listAllmeatraw>.add(<awakeningmeat:elephant_raw>);
<ore:listAllelephantraw>.add(<awakeningmeat:elephant_raw>);
<ore:foodElephantraw>.add(<awakeningmeat:elephant_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:elephant_cooked>);
<ore:listAllelephantcooked>.add(<awakeningmeat:elephant_cooked>);
<ore:foodElephantcooked>.add(<awakeningmeat:elephant_cooked>);
# Goose
<ore:listAllmeatraw>.add(<wildmobsmod:goose>);
<ore:listAllgooseraw>.add(<wildmobsmod:goose>);
<ore:foodGooseraw>.add(<wildmobsmod:goose>);
<ore:listAllmeatcooked>.add(<wildmobsmod:cooked_goose>);
<ore:listAllgoosecooked>.add(<wildmobsmod:cooked_goose>);
<ore:foodGoosecooked>.add(<wildmobsmod:cooked_goose>);
# Mouse
<ore:listAllmeatraw>.add(<wildmobsmod:mouse>);
<ore:listAllmouseraw>.add(<wildmobsmod:mouse>);
<ore:foodMouseraw>.add(<wildmobsmod:mouse>);
<ore:listAllmeatcooked>.add(<wildmobsmod:cooked_mouse>);
<ore:listAllmousecooked>.add(<wildmobsmod:cooked_mouse>);
<ore:foodMousecooked>.add(<wildmobsmod:cooked_mouse>);
# Ostrich
<ore:listAllmeatraw>.add(<awakeningmeat:ostrich_raw>);
<ore:listAllostrichraw>.add(<awakeningmeat:ostrich_raw>);
<ore:foodOstrichraw>.add(<awakeningmeat:ostrich_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:ostrich_cooked>);
<ore:listAllostrichcooked>.add(<awakeningmeat:ostrich_cooked>);
<ore:foodOstrichcooked>.add(<awakeningmeat:ostrich_cooked>);
# Psittaco
<ore:listAllmeatraw>.add(<ZoocraftDiscoveries:psittaco_meat_raw>);
<ore:foodBisonraw>.add(<ZoocraftDiscoveries:psittaco_meat_raw>);
<ore:listAllmeatcooked>.add(<ZoocraftDiscoveries:psittaco_meat_cooked>);
<ore:foodBisoncooked>.add(<ZoocraftDiscoveries:psittaco_meat_cooked>);
# Pufferfish
<ore:listAllfishcooked>.add(<awakeningmeat:pufferfish_cooked>);
<ore:foodPufferfishcooked>.add(<awakeningmeat:pufferfish_cooked>);
# Sandworm
<ore:listAllmeatraw>.add(<awakeningmeat:sandworm_raw>);
<ore:listAllsandwormraw>.add(<awakeningmeat:sandworm_raw>);
<ore:foodSandwormraw>.add(<awakeningmeat:sandworm_raw>);
<ore:listAllmeatcooked>.add(<awakeningmeat:sandworm_cooked>);
<ore:listAllsandwormcooked>.add(<awakeningmeat:sandworm_cooked>);
<ore:foodSandwormcooked>.add(<awakeningmeat:sandworm_cooked>);
# Venison
<ore:listAllmeatraw>.add(<TwilightForest:item.venisonRaw>);
<ore:listAllvenisonraw>.add(<TwilightForest:item.venisonRaw>);
<ore:foodVenisonraw>.add(<TwilightForest:item.venisonRaw>);
<ore:listAllmeatcooked>.add(<TwilightForest:item.venisonCooked>);
<ore:listAllvenisoncooked>.add(<TwilightForest:item.venisonCooked>);
<ore:foodVenisoncooked>.add(<TwilightForest:item.venisonCooked>);
<ore:listAllmeatraw>.add(<wildmobsmod:venison>);
<ore:listAllvenisonraw>.add(<wildmobsmod:venison>);
<ore:foodVenisonraw>.add(<wildmobsmod:venison>);
<ore:listAllmeatcooked>.add(<wildmobsmod:cooked_venison>);
<ore:listAllvenisoncooked>.add(<wildmobsmod:cooked_venison>);
<ore:foodVenisoncooked>.add(<wildmobsmod:cooked_venison>);


# Add stripped logs to logWood
<ore:logWood>.add(<etfuturum:log_stripped>);
<ore:logWood>.add(<etfuturum:log2_stripped>);
<ore:logWood>.add(<etfuturum:wood_stripped>);
<ore:logWood>.add(<etfuturum:wood2_stripped>);

# Add HEE Falling Obsidian to Obsidian
<ore:obsidian>.add(<HardcoreEnderExpansion:obsidian_end>);

# Add certain things as poison yeast for making growthcraft drinks
<ore:yeastPoison>.add(<BiomesOPlenty:jarFilled:1>);
<ore:yeastPoison>.add(<swampmobs:poisongland>);
#<ore:yeastPoison>.add(<icbmclassic:icbmCPoisonPowder>);
<ore:yeastPoison>.add(<swampmobs:poisongland>);

# Add JAFFA's kale
<ore:listAllveggie>.add(<jaffa:Kale>);
<ore:cropKale>.add(<jaffa:Kale>);
<ore:listAllgreenveggie>.add(<jaffa:Kale>);

# Add Mariculture Kelp to Harvestcraft seaweed
<ore:listAllveggie>.add(<Mariculture:plant_static:1>);
<ore:cropSeaweed>.add(<Mariculture:plant_static:1>);
<ore:listAllgreenveggie>.add(<Mariculture:plant_static:1>);

# Add Obsidion ingots to registry
ingotObsidian_ore.add(<Mekanism:Ingot:0>);
ingotObsidian_ore.add(<TConstruct:materials:18>);

# Raw lamb oredict entry
#muttonRaw_ore.add(<ganyssurface:mutton_raw>);
muttonRaw_ore.add(<harvestcraft:muttonrawItem>);
muttonRaw_ore.add(<witchery:ingredient:158>);
#muttonCooked_ore.add(<ganyssurface:mutton_cooked>);
muttonCooked_ore.add(<harvestcraft:muttoncookedItem>);
muttonCooked_ore.add(<witchery:ingredient:159>);

# Add Eggy Goodness eggs to the ore dictionary
eggFried.add(<EggyGoodness:friedEgg>);
eggFried.add(<EggyGoodness:friedDoubleYolkEgg>);

# Make beets and beetroot intercompatible
<ore:cropBeet>.add(<ganyssurface:beetroot>);
<ore:listAllveggie>.add(<ganyssurface:beetroot>);
<ore:cropBeetroot>.add(<harvestcraft:beetItem>);

# Sponge oredict entry
blockSponge_ore.add(<minecraft:sponge:*>);
blockSponge_ore.add(<VillageNames:sponge:*>);
oreRutile_ore.add(<GalacticraftMars:tile.asteroidsBlock:4>);
oreRutile_ore.add(<GalaxySpace:ganymedeblocks:3>);

# Bed oredict entry
val itemBed_ore = <ore:itemBed>;

val bedTypes = [
	<minecraft:bed>,
	<CarpentersBlocks:itemCarpentersBed>,
	<bettervanilla:bettervanilla_colored_bed:0>,
	<bettervanilla:bettervanilla_colored_bed:1>,
	<bettervanilla:bettervanilla_colored_bed:2>,
	<bettervanilla:bettervanilla_colored_bed:3>,
	<bettervanilla:bettervanilla_colored_bed:4>,
	<bettervanilla:bettervanilla_colored_bed:5>,
	<bettervanilla:bettervanilla_colored_bed:6>,
	<bettervanilla:bettervanilla_colored_bed:7>,
	<bettervanilla:bettervanilla_colored_bed:8>,
	<bettervanilla:bettervanilla_colored_bed:9>,
	<bettervanilla:bettervanilla_colored_bed:10>,
	<bettervanilla:bettervanilla_colored_bed:11>,
	<bettervanilla:bettervanilla_colored_bed:12>,
	<bettervanilla:bettervanilla_colored_bed:13>,
	<bettervanilla:bettervanilla_colored_bed:14>,
	<bettervanilla:bettervanilla_colored_bed:15>
	] as IItemStack[];
	
for bedval in bedTypes {
	itemBed_ore.add(bedval);
}

### Organized lists

# OreDict
val oreDyes = [
    dyeWhite_ore,     # 0
	dyeOrange_ore,    # 1
	dyeMagenta_ore,   # 2
	dyeLightBlue_ore, # 3
	dyeYellow_ore,    # 4
	dyeLime_ore,      # 5
	dyePink_ore,      # 6
	dyeGray_ore,      # 7
	dyeLightGray_ore, # 8
	dyeCyan_ore,      # 9
	dyePurple_ore,    # 10
	dyeBlue_ore,      # 11
	dyeBrown_ore,     # 12
	dyeGreen_ore,     # 13
	dyeRed_ore,       # 14
	dyeBlack_ore      # 15
    ] as IIngredient[];






################
### Removals ###
################

# Remove Doritos recipe
recipes.remove(<jaffa:Doritos>);

# Remove Gabbro and Bountiful stone crafting recipes because they don't make geological sense
recipes.remove(<ganyssurface:basalt>);
recipes.remove(<chisel:granite>);
recipes.remove(<chisel:diorite>);
recipes.remove(<chisel:andesite>);

# Remove Walleye to cooked cod
furnace.remove(<minecraft:cooked_fished>, <harvestcraft:walleyerawItem>);

# Remove bucket from smeltery so you can't get fast iron by making a bucket from something other than iron
mods.tconstruct.Smeltery.removeMelting(<minecraft:bucket>);

# Remove substrate-multiplying PRC recipe
mods.mekanism.Reaction.removeRecipe(<Mekanism:Substrate>, gasOxygen, <Mekanism:Substrate>, water_liq, gasEthene);

# Remove "present" chisel group
mods.chisel.Groups.removeGroup("present");

# Remove specialty glass types
mods.chisel.Groups.removeGroup("glass");
mods.chisel.Groups.addGroup("glass");

val chiselGlassTypes = [
	<minecraft:glass>,
	<chisel:glass:1>,
	<chisel:glass:2>,
	<chisel:glass:3>,
	<chisel:glass:4>,
	<chisel:glass:5>,
	<chisel:glass:6>,
	<chisel:glass:7>,
	<chisel:glass:8>,
	<chisel:glass:9>,
	<chisel:glass:10>,
	<chisel:glass:11>,
	<chisel:glass:12>,
	<chisel:glass:13>,
	<chisel:glass:14>,
	<chisel:glass:15>,
	<chisel:glass2:0>
	] as IItemStack[];
	
for cglassval in chiselGlassTypes {
	mods.chisel.Groups.addVariation("glass", cglassval);
}



val generalRecipesToRemove = [
	
	# Non-diamond, non-gold swords
	<minecraft:iron_sword>,
	<minecraft:wooden_sword>,
	<minecraft:stone_sword>,
	<BiomesOPlenty:swordMud>,
	<BiomesOPlenty:swordAmethyst>,
	<GalacticraftMars:item.titanium_sword>,
	<GalacticraftMars:item.deshSword>,
#	<Natura:natura.sword.ghostwood>,
#	<Natura:natura.sword.bloodwood>,
#	<Natura:natura.sword.ghostwood>,
#	<Natura:natura.sword.darkwood>,
#	<Natura:natura.sword.fusewood>,
	#<Natura:natura.sword.netherquartz>,
	<TwilightForest:item.ironwoodSword>,
	<TwilightForest:item.fierySword>,
	<TwilightForest:item.steeleafSword>,
	<TwilightForest:item.knightlySword>,
	
	# Remove tools invalidated by Iguana Tinker Tweaks
	<BiomesOPlenty:shovelMud>,
	<BiomesOPlenty:pickaxeMud>,
	<BiomesOPlenty:axeMud>,
	<BiomesOPlenty:shovelAmethyst>,
	<BiomesOPlenty:pickaxeAmethyst>,
	<BiomesOPlenty:axeAmethyst>,
#	<Natura:natura.pickaxe.ghostwood>,
#	<Natura:natura.shovel.ghostwood>,
#	<Natura:natura.axe.ghostwood>,
#	<Natura:natura.pickaxe.bloodwood>,
#	<Natura:natura.shovel.bloodwood>,
#	<Natura:natura.axe.bloodwood>,
#	<Natura:natura.pickaxe.darkwood>,
#	<Natura:natura.shovel.darkwood>,
#	<Natura:natura.axe.darkwood>,
#	<Natura:natura.pickaxe.fusewood>,
#	<Natura:natura.shovel.fusewood>,
#	<Natura:natura.axe.fusewood>,
	#<Natura:natura.pickaxe.netherquartz>,
	#<Natura:natura.shovel.netherquartz>,
	#<Natura:natura.axe.netherquartz>,
	
	# Remove vanilla tools
	<minecraft:iron_shovel>,
	<minecraft:iron_pickaxe>,
	<minecraft:iron_axe>,
	<minecraft:wooden_shovel>,
	<minecraft:wooden_pickaxe>,
	<minecraft:wooden_axe>,
	<minecraft:stone_shovel>,
	<minecraft:stone_pickaxe>,
	<minecraft:stone_axe>,
	<minecraft:diamond_shovel>,
	<minecraft:diamond_axe>,
	<minecraft:golden_shovel>,
	<minecraft:golden_pickaxe>,
	<minecraft:golden_axe>,
	
	# Natura
	#<Natura:NetherFurnace>,
	
	# Remove name tag
	<minecraft:name_tag>,
	
	# Gotta remove Cyanite Reprocessor because it crashes with AsieLib
	<BigReactors:BRDevice:0>,
	
	# Mud junk lel
	<BiomesOPlenty:hoeMud>,
	<BiomesOPlenty:helmetMud>,
	<BiomesOPlenty:chestplateMud>,
	<BiomesOPlenty:leggingsMud>,
	<BiomesOPlenty:bootsMud>,
	# BoP scythes
	<BiomesOPlenty:scytheWood>,
	<BiomesOPlenty:scytheStone>,
	<BiomesOPlenty:scytheIron>,
	<BiomesOPlenty:scytheGold>,
	<BiomesOPlenty:scytheDiamond>,
	<BiomesOPlenty:scytheMud>,
	<BiomesOPlenty:scytheAmethyst>,
	
	<chisel:cloudinabottle>,

	<cfm:ItemStereo>, # Stereo
	<cfm:ItemSuperSoapyWater>, # Super soapy water
	
	<EggyGoodness:eggnog>, # Harvestcraft's egg nog is better
	
	<enviromine:camelPack>, # Camel packs are stupid
	
	# Remove Esky and Freezer because we're not doing food spoilage
	<enviromine:esky>,
	<enviromine:freezer>,
	
	# Gany's surface stuff
	<ganyssurface:horsalyser>,

	<Growthcraft|Fishtrap:grc.fishTrap>, # Growthcraft fish traps are OP
	
	# Two Harvestcraft items that are buggy
	<harvestcraft:garammasalaItem>,
	<harvestcraft:market>, # Harvestcraft market
	
	# Jaffa foods
	<jaffa:CreamCan>,
	
	# Heavy-duty tools
	<GalacticraftCore:item.steel_pickaxe>,
	<GalacticraftCore:item.steel_axe>,
	<GalacticraftCore:item.steel_shovel>,
	<GalacticraftCore:item.steel_sword>,
	# Remove titanium pickaxe, axe, shovel
	<GalacticraftMars:item.titanium_axe>,
	<GalacticraftMars:item.titanium_pickaxe>,
	<GalacticraftMars:item.titanium_shovel>,
	
	# Galaxy Space plasma gear
	<GalaxySpace:item.plasmasword>,
	<GalaxySpace:item.plasmapickaxe>,
	<GalaxySpace:item.plasmaaxe>,
	<GalaxySpace:item.plasmashovel>,
	<GalaxySpace:item.plasmahoe>,
	
	<GalaxySpace:item.cobalt_axe>,
	<GalaxySpace:item.cobalt_leg>,
	<GalaxySpace:item.cobalt_boots>,
	<GalaxySpace:item.cobalt_sword>,
	<GalaxySpace:item.cobalt_hoe>,
	<GalaxySpace:item.cobalt_helmet>,
	<GalaxySpace:item.cobalt_pickaxe>,
	<GalaxySpace:item.cobalt_shovel>,
	<GalaxySpace:item.cobalt_plate>,
	<GalaxySpace:item.JetPack:*>,
	
	# Remove GalaxySpace's Modification Table so that there's no incentive to make a Space Suit
	<GalaxySpace:modificationtable>,
	
	
	<Mariculture:machines_single:1>, # Mariculture Auto-dictionary

	### Mekanism factories are OP.
	
	# Installers (upgrade each machine to a "factory")
	<Mekanism:FactoryInstaller:0>,
	<Mekanism:FactoryInstaller:1>,
	<Mekanism:FactoryInstaller:2>,
	<Mekanism:FactoryInstaller:3>,
	
	#<Mekanism:MachineBlock:5>, # Basic factories
	#<Mekanism:MachineBlock:6>, # Advanced factories
	#<Mekanism:MachineBlock:7>, # Elite factories
	
	<Mekanism:Flamethrower:*>, # Flamethrower
	<Mekanism:PortableTeleporter:*>, # Portable Teleporter
	#<Mekanism:MachineBlock:4>, # Digital Miner
	<Mekanism:AtomicDisassembler:*>, # Atomic Disassembler
	<Mekanism:ElectricBow:*>, # Electric Bow
	<Mekanism:FreeRunners:*>, # Free Runners
	<MekanismGenerators:Generator:6>, # Mekanism Wind Turbine
	<Mekanism:Jetpack>,
	<Mekanism:ArmoredJetpack>,
	
	# Remove Mekanism diving gear because it doesn't render with Smart Moving
	<Mekanism:GasMask>,
	<Mekanism:ScubaTank>,
	
	
	#<Metallurgy:base.dust:4>,
	#<Metallurgy:base.dust:5>,
	#<Metallurgy:base.dust:6>,
	#<Metallurgy:base.dust:7>,
	<Metallurgy:ender.dust:2>,
	<Metallurgy:fantasy.dust:3>,
	<Metallurgy:fantasy.dust:9>,
	<Metallurgy:fantasy.dust:10>,
	<Metallurgy:nether.dust:10>,
	<Metallurgy:nether.dust:11>,
	#<Metallurgy:precious.dust:3>,
	#<Metallurgy:precious.dust:4>,
	#<TConstruct:materials:41>,
	#<TConstruct:materials:42>,
	
	# Remove Zhark fishbowl
	<MoCreatures:bowlempty>,
	<MoCreatures:bowlwater>,
	<MoCreatures:bowlfish1>,
	<MoCreatures:bowlfish2>,
	<MoCreatures:bowlfish3>,
	<MoCreatures:bowlfish4>,
	<MoCreatures:bowlfish5>,
	<MoCreatures:bowlfish6>,
	<MoCreatures:bowlfish7>,
	<MoCreatures:bowlfish8>,
	<MoCreatures:bowlfish9>,
	<MoCreatures:bowlfish10>,
	# Stuff related to kitties
	<MoCreatures:woolball>,
	<MoCreatures:kittybed>,
	<MoCreatures:kittylitter>,
	<MoCreatures:petfood>,
	
	<mffs:moduleDisintegration>, # Disintegration module is too OP

	# MorePlanets Uranium tools
	<MorePlanet:breathable_uranium_helmet>,
	<MorePlanet:uranium_pickaxe>,
	<MorePlanet:uranium_axe>,
	<MorePlanet:uranium_hoe>,
	<MorePlanet:uranium_spade>,
	<MorePlanet:uranium_sword>,
	<MorePlanet:kapteyn-b_block:13>,
	<MorePlanet:kapteyn-b_item:1>,
	<MorePlanet:kapteyn-b_item:3>,
	<MorePlanet:jetpack>,
	
	# Cheap Tinkers gear
	<TConstruct:travelGoggles>,
	<TConstruct:travelVest>,
	<TConstruct:travelWings>,
	<TConstruct:travelBoots>,
	# Wooden armor
	<TConstruct:helmetWood>,
	<TConstruct:chestplateWood>,
	<TConstruct:leggingsWood>,
	<TConstruct:bootsWood>,
	# Remove Tinkers Construct Moss ball
	<TConstruct:materials:6>,
	
	# Remove Weather Machine so you don't accidentally--or purposefully--create tornadoes
	#<weather2:WeatherMachine>,
	
	# Glider wing
	<OpenBlocks:generic:0>,
	
	# Zoocraft Discoveries particle blocks
	<ZoocraftDiscoveries:particle_block:*>,
	
] as IItemStack[];


for recipe in generalRecipesToRemove {
	recipes.remove(recipe);
}




# Don't make silicon with crusher
mods.mekanism.Crusher.removeRecipe(<GalacticraftCore:item.basicItem:2>);

# Don't crush flint into gunpowder
mods.mekanism.Crusher.removeRecipe(<minecraft:gunpowder>);



# Remove cotton recipe from candleberry
recipes.removeShapeless(<harvestcraft:cottonItem>, [<harvestcraft:candleberryItem>, <harvestcraft:candleberryItem>]);

# Gany's Nether Soul Glass because there is a conflict with Natura's
furnace.remove(<ganysnether:soulGlass>, <minecraft:soul_sand>);

# Fossils cooked egg
#furnace.remove(<fossil:cooked_egg>, <minecraft:egg>);



mods.tconstruct.Casting.removeBasinRecipe(<MorePlanet:kapteyn-b_block:13>);


# Remove ability to convert dusts to rutile
mods.metallurgy.Crusher.removeRecipe(<Mariculture:materials:5>);


### I'd like to remove the Mekanism ore multiplication for (most) Metallurgy minerals.


## Remove from Chemical Dissolution Chamber (5) down through Purifiction Chamber (3):

val mk_remove_3to5_array = [
	[<ore:oreYellorium>, <gas:Yellorium>, <ore:shardYellorium>, <ore:clumpYellorium>],
	[<ore:oreUranium>, <gas:Uranium>, <ore:shardUranium>, <ore:clumpUranium>],
	[<ore:oreGold>, <gas:Gold>, <ore:shardGold>, <ore:clumpGold>],
	[<ore:oreRubracium>, <gas:Rubracium>, <ore:shardRubracium>, <ore:clumpRubracium>],
	[oreRutile_ore,<gas:Rutile>, <ore:shardRutile>, <ore:clumpRutile> ],
	[<ore:oreAdamantine>, <gas:Adamantine>, <ore:shardAdamantine>, <ore:clumpAdamantine>],
	[<ore:oreAtlarus>, <gas:Atlarus>, <ore:shardAtlarus>, <ore:clumpAtlarus>],
	[<ore:oreArdite>, <gas:Ardite>, <ore:shardArdite>, <ore:clumpArdite>],
	[oreCo_ore, <gas:Cobalt>, shardCo_ore, clumpCo_ore],
	[<ore:oreEximite>, <gas:Eximite>, <ore:shardEximite>, <ore:clumpEximite>],
	[<ore:oreMeutoite>, <gas:Meutoite>, <ore:shardMeutoite>, <ore:clumpMeutoite>],
] as IIngredient[][];

for entry in mk_remove_3to5_array {
	mods.mekanism.chemical.Dissolution.removeRecipe(entry[1], entry[0]);
	mods.mekanism.chemical.Injection.removeRecipe(entry[2], entry[0], gasHCl);
	mods.mekanism.Purification.removeRecipe(entry[3], entry[0], gasOxygen);
}


## Remove from Chemical Dissolution Chamber (5) down through Chemical Injection Chamber (4):

val mk_remove_4to5_array = [
	[<ore:oreIgnatius>, <gas:Ignatius>, <ore:shardIgnatius>],
	[<ore:oreShadowIron>, <gas:ShadowIron>, <ore:shardShadowIron>],
	[<ore:oreMidasium>, <gas:Midasium>, <ore:shardMidasium>],
	[<ore:oreVyroxeres>, <gas:Vyroxeres>, <ore:shardVyroxeres>],
	[<ore:oreLemurite>, <gas:Lemurite>, <ore:shardLemurite>],
	[<ore:oreOrichalcum>, <gas:Orichalcum>, <ore:shardOrichalcum>],
	[<ore:oreCeruclase>, <gas:Ceruclase>, <ore:shardCeruclase>],
	[<ore:oreKalendrite>, <gas:Kalendrite>, <ore:shardKalendrite>],
	[<ore:oreAlduorite>, <gas:Alduorite>, <ore:shardAlduorite>],
	[<ore:oreCarmot>, <gas:Carmot>, <ore:shardCarmot>],
	[<ore:oreMithril>, <gas:Mithril>, <ore:shardMithril>],
	[<ore:oreVulcanite>, <gas:Vulcanite>, <ore:shardVulcanite>],
	[<ore:oreSanguinite>, <gas:Sanguinite>, <ore:shardSanguinite>],
] as IIngredient[][];

for entry in mk_remove_4to5_array {
	mods.mekanism.chemical.Dissolution.removeRecipe(entry[1], entry[0]);
	mods.mekanism.chemical.Injection.removeRecipe(entry[2], entry[0], gasHCl);
}


## Remove from Chemical Dissolution Chamber (5):

val mk_5array = [
	[<ore:oreDeepIron>, <gas:DeepIron>],
	[<ore:oreOureclase>, <gas:Oureclase>],
	[<ore:oreAstralSilver>, <gas:AstralSilver>],
	[<ore:orePlatinum>, <gas:Platinum>],
	[<ore:oreInfuscolium>, <gas:Infuscolium>],
	[<ore:oreNickel>, <gas:Nickel>],
] as IIngredient[][];

for entry in mk_5array {
	mods.mekanism.chemical.Dissolution.removeRecipe(entry[1], entry[0]);
}


# Remove Rutile dust coral rock recipe
mods.metallurgy.Crusher.removeRecipe(<Mariculture:rocks:0>);








# Remove wood-looking obsidian variation from chisel
mods.chisel.Groups.removeVariation(<chisel:obsidian:15>);

# Remove MorePlanets variations from chisel
mods.chisel.Groups.removeGroup("cobblestone"); 
mods.chisel.Groups.addGroup("cobblestone"); 


val cobblestonechiselvariations = [
	
	<minecraft:cobblestone>,
	<chisel:cobblestone:1>,
	<chisel:cobblestone:2>,
	<chisel:cobblestone:3>,
	<chisel:cobblestone:4>,
	<chisel:cobblestone:5>,
	<chisel:cobblestone:6>,
	<chisel:cobblestone:7>,
	<chisel:cobblestone:8>,
	<chisel:cobblestone:9>,
	<chisel:cobblestone:10>,
	<chisel:cobblestone:11>,
	<chisel:cobblestone:12>,
	<chisel:cobblestone:13>,
	<chisel:cobblestone:14>,
	<chisel:cobblestone:15>,

] as IItemStack[];


for cobblestone in cobblestonechiselvariations {
	mods.chisel.Groups.addVariation("cobblestone", cobblestone);
}




# Prevent player from crafting snails into fish (lol?)
recipes.removeShapeless(<minecraft:fish>, [<harvestcraft:snailrawItem>]);



mods.tconstruct.Modifiers.remove("Moss");


# Remove Zhark omelet recipe
furnace.remove(<MoCreatures:omelet>);




###############
### Changes ###
###############


# === Nerf the GalaxySpace cobalt ore because it exists only due to a bug ===

# Remove the ore and ingot from the oredict
oreCo_ore.remove(oreCo_gs);
ingotCo_ore.remove(ingotCo_gs);
# Re-add Wustite to iron oredict
oreFe_ore.add(oreCo_gs);

# Remove GS cobalt ingot from furnace
furnace.remove(ingotCo_gs, oreCo_ore);

# Vanilla Furnace
furnace.remove(ingotCo_gs, oreCo_gs);
furnace.addRecipe(ingotFe_mc, oreCo_gs);

# Mariculture
mods.mariculture.Crucible.removeRecipe(oreCo_gs);
mods.mariculture.Crucible.addRecipe(1538, oreCo_gs, <liquid:iron.molten> * 288);

# Mekanism
mods.mekanism.Enrichment.removeRecipe(oreCo_gs, dustCo_ore);
mods.mekanism.Enrichment.addRecipe(oreCo_gs, dustIron_mk*2);

#mods.mekanism.Purification.removeRecipe(clumpCo_ore, oreCo_gs, <gas:oxygen>);
mods.mekanism.Purification.addRecipe(oreCo_gs, <gas:oxygen>, clumpIron_mk*3);

#mods.mekanism.chemical.Injection.removeRecipe(shardCo_ore, oreCo_gs, <gas:hydrogenchloride>);
mods.mekanism.chemical.Injection.addRecipe(oreCo_gs, <gas:hydrogenChloride>, shardIron_mk*4);

#mods.mekanism.chemical.Dissolution.removeRecipe(<gas:Cobalt>, oreCo_gs);
mods.mekanism.chemical.Dissolution.addRecipe(oreCo_gs, <gas:Iron>);

# Tinkers Construct
mods.tconstruct.Smeltery.removeMelting(oreCo_gs);
mods.tconstruct.Smeltery.addMelting(oreCo_gs, <liquid:iron.molten> * 244, 600, oreFe_mc);

# Metallurgy
mods.metallurgy.Crusher.removeRecipe(oreCo_gs);
mods.metallurgy.Crusher.addRecipe(oreCo_gs, <ThermalFoundation:material:0>*2);

# Railcraft
mods.railcraft.RockCrusher.removeRecipe(oreCo_gs);
mods.railcraft.RockCrusher.addRecipe(oreCo_gs, false, false, [<aobd:crushedIron>*2], [1.0]);


# Re-add fence and basic fence gate recipes so that you can craft certain woodstuff gates
recipes.remove(<minecraft:fence_gate>);
recipes.addShaped(<minecraft:fence_gate>, [[stickWood_ore,planksWood_ore,stickWood_ore],[stickWood_ore,planksWood_ore,stickWood_ore]]);

### Disable triplicate door crafting ###

# Iron door
recipes.remove(<minecraft:iron_door>*3);
recipes.addShaped(<minecraft:iron_door>, [[ingotFe_ore,ingotFe_ore],[ingotFe_ore,ingotFe_ore],[ingotFe_ore,ingotFe_ore]]);

# Specific doors
val doorMatrix = [
	# More Planets
    [<MorePlanet:ancient_dark_door>, <MorePlanet:nibiru_planks:0>], # Ancient Dark
	[<MorePlanet:orange_door>, <MorePlanet:nibiru_planks:1>], # Orange
	[<MorePlanet:crystal_door>, <MorePlanet:crystal_planks:0>], # Crystal wooden
	[<MorePlanet:coconut_door>, <MorePlanet:fronos_wooden_planks:0>], # Coconut Wood
	[<MorePlanet:red_maple_door>, <MorePlanet:fronos_wooden_planks:1>], # Fronos Maple
	[<MorePlanet:europa_door>, <MorePlanet:europa_planks:0>], # Europa Wood
    # Doors o' Plenty (BoP)
	[<doorsoplenty:door_bamboo>, <BiomesOPlenty:planks:10>], # Bambusea Bamboo
	[<doorsoplenty:door_cherry>, <BiomesOPlenty:planks:1>], # Cherry Wood
	[<doorsoplenty:door_pine>, <BiomesOPlenty:planks:11>], # Pine
	[<doorsoplenty:door_dark>, <BiomesOPlenty:planks:2>], # Dark
	[<doorsoplenty:door_ethereal>, <BiomesOPlenty:planks:4>], # Ethereal
	[<doorsoplenty:door_fir>, <BiomesOPlenty:planks:3>], # Fir
	[<doorsoplenty:door_hellbark>, <BiomesOPlenty:planks:12>], # Hellbark
	[<doorsoplenty:door_jacaranda>, <BiomesOPlenty:planks:13>], # Jacaranda
	[<doorsoplenty:door_magic>, <BiomesOPlenty:planks:5>], # Magic
	[<doorsoplenty:door_mahogany>, <BiomesOPlenty:planks:14>], # Mahogany
	[<doorsoplenty:door_mangrove>, <BiomesOPlenty:planks:6>], # Mangrove
	[<doorsoplenty:door_palm>, <BiomesOPlenty:planks:7>], # Palm
	[<doorsoplenty:door_redwood>, <BiomesOPlenty:planks:8>], # Coastal Redwood
	[<doorsoplenty:door_sacred>, <BiomesOPlenty:planks:0>], # Sacred
	[<doorsoplenty:door_willow>, <BiomesOPlenty:planks:9>], # Weeping Willow
    # Gany's Surface
	[<ganyssurface:door_spruce>, <minecraft:planks:1>], # Spruce
	[<ganyssurface:door_birch>, <minecraft:planks:2>], # Birch
	[<ganyssurface:door_jungle>, <minecraft:planks:3>], # Jungle
	[<ganyssurface:door_acacia>, <minecraft:planks:4>], # Acacia
	[<ganyssurface:door_dark_oak>, <minecraft:planks:5>], # Dark Oak
    # Netherlicious
	[<netherlicious:door_crimson>, <netherlicious:Planks:0>], # Crimson
	[<netherlicious:door_warped>, <netherlicious:Planks:1>], # Warped
	[<netherlicious:door_foxfire>, <netherlicious:Planks:2>], # Foxfire
    # Natura
    [<woodendoors:naturadoor_maple>, <Natura:planks:6>], # Sycamore Maple
    [<woodendoors:naturadoor_silverbell>, <Natura:planks:7>], # Silverbell
    [<woodendoors:naturadoor_tiger>, <Natura:planks:9>], # Tigerwood
    [<woodendoors:naturadoor_darkwood>, <Natura:planks:11>], # Nether Darkwood
    [<woodendoors:naturadoor_fusewood>, <Natura:planks:12>], # Fusewood
    # Ancient Doors
    [<woodendoors:ancientdoor_acemus>, <dendrology:wood0:0>], # Acemus
    [<woodendoors:ancientdoor_cedrum>, <dendrology:wood0:1>], # Cedrum
    [<woodendoors:ancientdoor_cerasu>, <dendrology:wood0:2>], # Cerasu
    [<woodendoors:ancientdoor_delnas>, <dendrology:wood0:3>], # Delnas
    [<woodendoors:ancientdoor_ewcaly>, <dendrology:wood0:4>], # Ewcaly
    [<woodendoors:ancientdoor_hekur>, <dendrology:wood0:5>], # Hekur
    [<woodendoors:ancientdoor_kiparis>, <dendrology:wood0:6>], # Kiparis
    [<woodendoors:ancientdoor_kulist>, <dendrology:wood0:7>], # Kulist
    [<woodendoors:ancientdoor_lata>, <dendrology:wood0:8>], # Lata
    [<woodendoors:ancientdoor_nucis>, <dendrology:wood0:9>], # Nucis
    [<woodendoors:ancientdoor_porffor>, <dendrology:wood0:10>], # Porffor
    [<woodendoors:ancientdoor_salyx>, <dendrology:wood0:11>], # Salyx
    [<woodendoors:ancientdoor_tuopa>, <dendrology:wood0:12>], # Tuopa
    
    ] as IItemStack[][];

for ingredient in doorMatrix
{
	recipes.remove(ingredient[0]);
	recipes.addShaped(ingredient[0], [[ingredient[1],ingredient[1]],[ingredient[1],ingredient[1]],[ingredient[1],ingredient[1]]]);
}


# Remove and re-add generic door to allow the above to work
recipes.remove(<minecraft:wooden_door>);
recipes.addShaped(<minecraft:wooden_door>, [[planksWood_ore,planksWood_ore],[planksWood_ore,planksWood_ore],[planksWood_ore,planksWood_ore]]);


# Gotta re-enable Lunarin iron blocks so that they don't intercept iron doors
recipes.remove(<VillageNames:lunarinIronBlock>);
recipes.addShapeless(<VillageNames:lunarinIronBlock>, [ingotFe_ore, ingotFe_ore, ingotFe_ore, ingotFe_ore, ingotFe_ore, ingotFe_ore]);

# Use oredict feathers
recipes.remove(<CrystalWing:crystalwing.crystalWing>);
recipes.addShaped(<CrystalWing:crystalwing.crystalWing>, [[ingotAu_ore,ingotAu_ore,ingotAu_ore],[<minecraft:ender_pearl>,feather_ore,feather_ore]]);

# Shore up Basalt and Gabbro chisel groups and oredicts

mods.chisel.Groups.addGroup("basalt");
val chiselBasaltTypes = [
	<netherlicious:Basalt>,
	<netherlicious:BasaltBricks>
	] as IItemStack[];
for cvariation in chiselBasaltTypes {
	#mods.chisel.Groups.addVariation("basalt", cvariation);
}

mods.chisel.Groups.addGroup("gabbro");
val chiselGabbroTypes = [
	<ganyssurface:basalt:0>,
	<ganyssurface:basalt:1>
	] as IItemStack[];
for cvariation in chiselGabbroTypes {
	mods.chisel.Groups.addVariation("gabbro", cvariation);
}

mods.chisel.Groups.addGroup("volcanicrock");
val chiselVolcanicRockTypes = [
	<fossil:volcanicRock>,
	<fossil:volcanicBrick>
	] as IItemStack[];
for cvariation in chiselVolcanicRockTypes {
	mods.chisel.Groups.addVariation("volcanicrock", cvariation);
}


### === Copper ===

## Remove crafting into non-EFR ingots

# Shaped
recipes.removeShaped(ingotCopper_gc*9, [[blockCu_ore]]);
val copperIngotShaped = [
	ingotCopper_mc,
	ingotCopper_mt,
	ingotCopper_rc,
	#ingotCopper_ve,
] as IIngredient[];
for i, entry in copperIngotShaped
{
	recipes.removeShaped(entry, [[nuggetCu_ore,nuggetCu_ore,nuggetCu_ore],[nuggetCu_ore,nuggetCu_ore,nuggetCu_ore],[nuggetCu_ore,nuggetCu_ore,nuggetCu_ore]]);
}

# Shapeless
recipes.removeShapeless(ingotCopper_mc*9, [blockCu_ore]);
recipes.removeShapeless(ingotCopper_tf, [nuggetCu_ore,nuggetCu_ore,nuggetCu_ore,nuggetCu_ore,nuggetCu_ore,nuggetCu_ore,nuggetCu_ore,nuggetCu_ore,nuggetCu_ore]);
recipes.removeShapeless(ingotCopper_tf*9, [blockCu_ore]);

# Smelting
val copperIngotSmelting = [
	ingotCopper_gc,
	ingotCopper_mc,
	ingotCopper_mk,
	ingotCopper_mt,
	ingotCopper_rc,
	ingotCopper_tf,
] as IIngredient[];
for i, entry in copperIngotSmelting
{
	furnace.remove(entry);
}

# Casting
mods.mariculture.Casting.removeIngotRecipe(ingotCopper_rc);
mods.tconstruct.Casting.removeTableRecipe(ingotCopper_tc);

## Add crafting into EFR ingots

# Shapeless
recipes.addShapeless(ingotCopper_ef*9, [<ore:blockCopper>]);
recipes.addShaped(ingotCopper_ef, [[nuggetCu_ore,nuggetCu_ore,nuggetCu_ore],[nuggetCu_ore,nuggetCu_ore,nuggetCu_ore],[nuggetCu_ore,nuggetCu_ore,nuggetCu_ore]]);

# Smelting
val smeltsIntoCopperIngot = [
	oreCu_ore,
	dustCu_ore,
#	<voltzengine:veDustImpure:1>,
	<ore:crushedCopper>,
	<ore:rubbleCopper>,
] as IIngredient[];
for i, entry in smeltsIntoCopperIngot {furnace.addRecipe(ingotCopper_ef, entry, 0.5);}
furnace.addRecipe(ingotCopper_ef*3, <GalacticraftCore:item.canister:1>, 0.5);

# Casting
mods.tconstruct.Casting.addTableRecipe(ingotCopper_ef, moltenCopper_liq * 144, <TConstruct:metalPattern>, false, 20);
mods.mariculture.Casting.addIngotRecipe(moltenCopper_liq * 144, ingotCopper_ef);

## Remove crafting into non-EFR blocks

# Shaped
val copperBlockShaped = [
	blockCopper_mt,
	blockCopper_mc,
	blockCopper_rc,
	blockCopper_tc,
	blockCopper_ef, # To remove the recipe from the panel
] as IIngredient[];
for i, entry in copperBlockShaped
{
	recipes.removeShaped(entry, [[ingotCu_ore,ingotCu_ore,ingotCu_ore],[ingotCu_ore,ingotCu_ore,ingotCu_ore],[ingotCu_ore,ingotCu_ore,ingotCu_ore]]);
}

# Shapeless
val copperBlockShapeless = [
	blockCopper_gc,
	blockCopper_tf,
] as IIngredient[];
for i, entry in copperBlockShapeless
{
	recipes.removeShapeless(entry, [ingotCu_ore,ingotCu_ore,ingotCu_ore,ingotCu_ore,ingotCu_ore,ingotCu_ore,ingotCu_ore,ingotCu_ore,ingotCu_ore]);
}

# Shaped
recipes.addShaped(blockCopper_ef, [[ingotCu_ore,ingotCu_ore,ingotCu_ore],[ingotCu_ore,ingotCu_ore,ingotCu_ore],[ingotCu_ore,ingotCu_ore,ingotCu_ore]]);

# Casting
mods.mariculture.Casting.removeBlockRecipe(blockCopper_rc);
mods.tconstruct.Casting.removeBasinRecipe(blockCopper_tc);

## Add crafting into EFR blocks

# Casting
mods.tconstruct.Casting.addBasinRecipe(blockCopper_ef, moltenCopper_liq * 1296, null, false, 20);
mods.mariculture.Casting.addBlockRecipe(moltenCopper_liq * 1296, blockCopper_ef);

# Harvestcraft Mint foods require actual mint

recipes.remove(<harvestcraft:mintchocolatechipicemcreamItem>);
recipes.addShapeless(<harvestcraft:mintchocolatechipicemcreamItem>,
 [<ore:toolMixingbowl>, <ore:listAllicecream>, <ore:cropMint>, <ore:foodChocolatebar>]);

recipes.remove(<harvestcraft:peppermintItem>);
recipes.addShapeless(<harvestcraft:peppermintItem>,
 [<ore:toolSaucepan>, <ore:cropMint>, <ore:listAllsugar>]);

recipes.remove(<harvestcraft:lambwithmintsauceItem>);
recipes.addShapeless(<harvestcraft:lambwithmintsauceItem>,
 [<ore:toolBakeware>, <ore:listAllmuttonraw>, <ore:cropMint>, <ore:foodVinegar>, <ore:listAllsugar>]);

# Use oredict dye for staining pantiles
recipes.remove(<ZoocraftDiscoveries:clay_pantile_dyed:*>);

val zoocraftStainedPantiles = [
    <ZoocraftDiscoveries:clay_pantile_dyed:0>,
    <ZoocraftDiscoveries:clay_pantile_dyed:1>,
    <ZoocraftDiscoveries:clay_pantile_dyed:2>,
    <ZoocraftDiscoveries:clay_pantile_dyed:3>,
    <ZoocraftDiscoveries:clay_pantile_dyed:4>,
    <ZoocraftDiscoveries:clay_pantile_dyed:5>,
    <ZoocraftDiscoveries:clay_pantile_dyed:6>,
    <ZoocraftDiscoveries:clay_pantile_dyed:7>,
    <ZoocraftDiscoveries:clay_pantile_dyed:8>,
    <ZoocraftDiscoveries:clay_pantile_dyed:9>,
    <ZoocraftDiscoveries:clay_pantile_dyed:10>,
    <ZoocraftDiscoveries:clay_pantile_dyed:11>,
    <ZoocraftDiscoveries:clay_pantile_dyed:12>,
    <ZoocraftDiscoveries:clay_pantile_dyed:13>,
    <ZoocraftDiscoveries:clay_pantile_dyed:14>,
    <ZoocraftDiscoveries:clay_pantile_dyed:15>
    ] as IItemStack[];

for i, ptile in zoocraftStainedPantiles {
	
	recipes.addShaped(
		ptile,
		[
		[pantile_zcd,pantile_zcd,pantile_zcd],
		[pantile_zcd, oreDyes[i], pantile_zcd],
		[pantile_zcd,pantile_zcd,pantile_zcd]
		]
		);
	
	recipes.addShapeless(
		ptile,
		[<ZoocraftDiscoveries:clay_pantile:*>, oreDyes[i]]
		);
	
		recipes.addShapeless(
		ptile,
		[<ZoocraftDiscoveries:clay_pantile_dyed:*>, oreDyes[i]]
		);
}


# Cookie Bush from fronos saplings
<ore:fronosSapling>.add(<MorePlanet:fronos_sapling:0>);
<ore:fronosSapling>.add(<MorePlanet:fronos_sapling:1>);
<ore:fronosSapling>.add(<MorePlanet:fronos_sapling:2>);
<ore:fronosSapling>.add(<MorePlanet:fronos_sapling:3>);
recipes.remove(<ZoocraftDiscoveries:cookie_bush>);
recipes.addShaped(<ZoocraftDiscoveries:cookie_bush>,
 [[<minecraft:cookie>, <minecraft:cookie>, <minecraft:cookie>],
 [<minecraft:cookie>, <ore:fronosSapling>, <minecraft:cookie>],
  [<minecraft:cookie>, <minecraft:cookie>, <minecraft:cookie>]]);


# Change Mariculture Wooden Construction Block to use oredict fences
recipes.remove(wd_cons_blk);
recipes.addShaped(wd_cons_blk,
	[
	[logWood_ore,fenceWood_ore,logWood_ore],
	[fenceWood_ore,null,fenceWood_ore],
	[logWood_ore, fenceWood_ore, logWood_ore]
	]);


# Change Mariculture Sawmill to require a saw rather than an axe
recipes.remove(<Mariculture:machines_single:2>);
recipes.addShaped(<Mariculture:machines_single:2>,
	[
	[null,<BiblioCraft:item.FramingSaw>,null],
	[slabWood_ore,logWood_ore,slabWood_ore],
	[ingotCu_ore, wd_cons_blk, ingotCu_ore]
	]);


# Change Gany's Surface lantern to use the ore dictionary
#recipes.remove(<ganyssurface:lantern>);
#recipes.addShapeless(<ganyssurface:lantern>, [<ore:blockGlass>, <minecraft:torch>]);


# Vanilla beds cost three generic wool
recipes.removeShaped(<minecraft:bed>,
	[
	[<fossil:analyzerActive>,<fossil:analyzerActive>,<fossil:analyzerActive>],
	[<fossil:palaeoraphePlanks>,<fossil:palaeoraphePlanks>,<fossil:palaeoraphePlanks>]
	]);
recipes.addShaped(<minecraft:bed>,
	[
	[<ore:blockCloth>,<ore:blockCloth>,<ore:blockCloth>],
	[planksWood_ore, planksWood_ore, planksWood_ore]
	]);

# Change string to be three cotton to two string
recipes.removeShaped(itemString, [[cropCotton_ore, cropCotton_ore, cropCotton_ore]]);
recipes.addShapeless(itemString*2, [cropCotton_ore, cropCotton_ore, cropCotton_ore]);

# Change cotton-to-wool to cost six
recipes.removeShapeless(<minecraft:wool>, [cropCotton_ore]);
recipes.addShapeless(<minecraft:wool>, [cropCotton_ore,cropCotton_ore,cropCotton_ore,cropCotton_ore,cropCotton_ore,cropCotton_ore]);

# Improve salt and aluminum entries
<ore:dustSalt>.addAll(<ore:foodSalt>);
<ore:itemSalt>.mirror(<ore:dustSalt>);
<ore:ingotAluminium>.addAll(<ore:ingotAluminum>);


# Change Mariculture sheet metal recipes because the anvil is messed up

# Aluminium
#mods.mariculture.Anvil.removeRecipe(<Mariculture:crafting:7>);
#recipes.addShapeless(sheet_of_Al, [ingotAl_ore, voltz_sheet_metal_hammer.transformDamage()]);

# Gold
#mods.mariculture.Anvil.removeRecipe(<Mariculture:crafting:13>);
#recipes.addShapeless(sheet_of_Au, [ingotAu_ore, voltz_sheet_metal_hammer.transformDamage()]);

# Titanium
#mods.mariculture.Anvil.removeRecipe(<Mariculture:crafting:17>);
#recipes.addShapeless(sheet_of_Ti, [ingotTi_ore, voltz_sheet_metal_hammer.transformDamage()]);



# Change More Planets sulfur battery to use oredict sulfur
recipes.remove(<MorePlanet:sulfur_battery:*>);
recipes.addShaped(<MorePlanet:sulfur_battery:100>,
	[[null,<GalacticraftCore:item.basicItem:7>,null],
	[<GalacticraftCore:item.basicItem:7>,redstone_mc,<GalacticraftCore:item.basicItem:7>],
	[<GalacticraftCore:item.basicItem:7>,<ore:dustSulfur>,<GalacticraftCore:item.basicItem:7>]]);


# Allow GC parachutes to use any dye
recipes.remove(<GalacticraftCore:item.parachute:*>);
recipes.addShaped(
	<GalacticraftCore:item.parachute:0>,
	[
	[canvas_gc,canvas_gc,canvas_gc],
	[itemString, null, itemString],
	[null, itemString, null]
	]
	);

val galactricraftParachuteColors = [
    <GalacticraftCore:item.parachute:0>,
	<GalacticraftCore:item.parachute:15>,
	<GalacticraftCore:item.parachute:3>,
	<GalacticraftCore:item.parachute:5>,
	<GalacticraftCore:item.parachute:12>,
	<GalacticraftCore:item.parachute:11>,
	<GalacticraftCore:item.parachute:7>,
	<GalacticraftCore:item.parachute:13>,
	<GalacticraftCore:item.parachute:8>,
	<GalacticraftCore:item.parachute:2>,
	<GalacticraftCore:item.parachute:1>,
	<GalacticraftCore:item.parachute:6>,
	<GalacticraftCore:item.parachute:10>,
	<GalacticraftCore:item.parachute:14>,
	<GalacticraftCore:item.parachute:9>,
	<GalacticraftCore:item.parachute:4>
    ] as IItemStack[];

for i, gcpar in galactricraftParachuteColors {
	
	recipes.addShaped(
		gcpar,
		[
		[canvas_gc,canvas_gc,canvas_gc],
		[itemString, oreDyes[i], itemString],
		[null, itemString, null]
		]
		);
	
	recipes.addShapeless(
		gcpar,
		[<GalacticraftCore:item.parachute:*>, oreDyes[i]]
		);
}





# Change Heavy-Duty armor to require HD plates rather than just steel
recipes.remove(<GalacticraftCore:item.steel_helmet>);
recipes.addShaped(<GalacticraftCore:item.steel_helmet>,
	[
	[heavyplating_gc,heavyplating_gc,heavyplating_gc],
	[heavyplating_gc,null,heavyplating_gc]
	]);
recipes.remove(<GalacticraftCore:item.steel_chestplate>);
recipes.addShaped(<GalacticraftCore:item.steel_chestplate>,
	[
	[heavyplating_gc,null,heavyplating_gc],
	[heavyplating_gc,heavyplating_gc,heavyplating_gc],
	[heavyplating_gc,heavyplating_gc,heavyplating_gc]
	]);
recipes.remove(<GalacticraftCore:item.steel_leggings>);
recipes.addShaped(<GalacticraftCore:item.steel_leggings>,
	[
	[heavyplating_gc,heavyplating_gc,heavyplating_gc],
	[heavyplating_gc,null,heavyplating_gc],
	[heavyplating_gc,null,heavyplating_gc]
	]);
recipes.remove(<GalacticraftCore:item.steel_boots>);
recipes.addShaped(<GalacticraftCore:item.steel_boots>,
	[
	[heavyplating_gc,null,heavyplating_gc],
	[heavyplating_gc,null,heavyplating_gc]
	]);




# Iron door and trapdoor need to be fixed in the
# Mariculture crucible furnace
mods.mariculture.Crucible.removeRecipe(<minecraft:iron_door>);
mods.mariculture.Crucible.addRecipe(1538, <minecraft:iron_door>, moltenIron_liq * 288, null, 0);
mods.mariculture.Crucible.addRecipe(1538, <etfuturum:iron_trapdoor>, moltenIron_liq * 576, null, 0);




### Allow recipes for both cooked and smoked salmon
# Now you can cook salmon into cooked salmon,
# And then hang cooked salmon on a drying rack
# to make smoked salmon
furnace.remove(<Mariculture:food:2>);
mods.tconstruct.Drying.addRecipe(<minecraft:cooked_fished:1>, <Mariculture:food:2>, 12000);



# Make Crayfish computer more complicated to build
recipes.remove(<cfm:ItemComputer>);
recipes.addShaped(<cfm:ItemComputer>,
	[
	[<OpenComputers:item:8>,<OpenComputers:screen1>,null],
	[<OpenComputers:keyboard>,<OpenComputers:case1>,<OpenComputers:item:44>],
	[<OpenComputers:item:5>,<OpenComputers:item:29>,<OpenComputers:item:1>]
	]);
recipes.addShaped(<cfm:ItemComputer>,
	[
	[<OpenComputers:item:8>,<OpenComputers:screen1>,<OpenComputers:item:113>],
	[<OpenComputers:keyboard>,<OpenComputers:case1>,<OpenComputers:item:11>],
	[<OpenComputers:item:5>,<OpenComputers:item:29>,<OpenComputers:item:1>]
	]);

	

# Remove the black concrete from the chisel group, make it require bitumen.
mods.chisel.Groups.removeVariation(<chisel:concrete:10>);
recipes.addShapeless(<chisel:concrete:10>*8, [<Metallurgy:utility.item:4>,<minecraft:sand>,<minecraft:sand>,<minecraft:sand>,<minecraft:sand>,<minecraft:gravel>,<minecraft:gravel>,<minecraft:gravel>,<minecraft:gravel>]);

# Change OpenBlocks squeege to use sponges and not slime
val spongeAny = [
    <minecraft:sponge:*>, 
    <VillageNames:sponge:*>
	] as IItemStack[];
recipes.remove(<OpenBlocks:squeegee>);
recipes.addShaped(<OpenBlocks:squeegee>,
	[[<ore:sponge>, <ore:sponge>, <ore:sponge>],
	[null, stickWood_ore, null],
	[null, stickWood_ore, null]]);


# Change GalaxySpace items that require cobalt to now require Manganese
recipes.remove(<GalaxySpace:item.BasicItems:3>);
recipes.addShaped(<GalaxySpace:item.BasicItems:3>,
	[[<GalacticraftCore:tile.aluminumWire:1>, redstone_mc, <GalacticraftCore:tile.aluminumWire:1>],
	[ingotSteel_ore, <GalacticraftMars:item.null:6>, ingotSteel_ore],
	[plateSteel_ore, plateSteel_ore, plateSteel_ore]]);

recipes.remove(<GalaxySpace:recycler>);
recipes.addShaped(<GalaxySpace:recycler>,
	[[ingotSteel_ore, <GalaxySpace:fluidtank>, ingotSteel_ore],
	[<GalaxySpace:item.BasicItems>, <GalaxySpace:machineframes:0>, <GalaxySpace:item.BasicItems>],
	[<GalacticraftCore:tile.aluminumWire:1>, <GalacticraftCore:tile.machineTiered:4>, <GalacticraftCore:tile.aluminumWire:1>]]);

recipes.remove(<GalaxySpace:item.ThermalClothT2:0>);
recipes.addShaped(<GalaxySpace:item.ThermalClothT2:0>*4,
	[[<minecraft:wool>, redstone_mc, <minecraft:wool>],
	[redstone_mc, <GalaxySpace:item.BasicItems:6>, redstone_mc],
	[<minecraft:wool>, redstone_mc, <minecraft:wool>]]);


# Now, I can't modify compressor recipes. But (a lot of) cobalt plates are required.
# My solution to this is to make use of the osmium compressor.
# I'm also going to change the plate name here so that it can make sense given what we're going to feed it.
<GalaxySpace:item.CompressedPlates:0>.displayName = "Compressed Ferromagnetic Alloy";
<GalaxySpace:decometalsblock:0>.displayName = "Ferromagnetic Decoration Block";
mods.mekanism.Compressor.addRecipe(<GalaxySpace:item.CompressedPlates:2>, gaslOs, <GalaxySpace:item.CompressedPlates:0>);
mods.mekanism.Compressor.addRecipe(<GalacticraftCore:item.basicItem:11>, gaslOs, <GalaxySpace:item.CompressedPlates:0>);

# Railcraft quarried stone should act more like regular stone
furnace.remove(<Railcraft:brick.quarried:2>, <Railcraft:brick.quarried:5>);
furnace.addRecipe(<Railcraft:cube:7>, <Railcraft:brick.quarried:5>, 0.5);
mods.chisel.Groups.removeVariation(<Railcraft:brick.quarried:5>);
mods.chisel.Groups.addVariation("RCQuarriedBlock", <Railcraft:cube:7>);


# Change recipe to make soap
recipes.remove(<cfm:ItemSoap>);
#InputStack, InputFluid, InputGas, OutputStack, OutputGas, InputRF, Time in Ticks
mods.mekanism.Reaction.addRecipe(<harvestcraft:oliveoilItem>, water_liq*10, gasNa*100, <cfm:ItemSoap>, gasHydrogen*50, 1, 100);



# Gany's colorized quartz has a "white" variant that is not identical to default quartz.
recipes.remove(<ganysnether:colouredQuartzBlock:15>);
recipes.remove(<ganysnether:colouredChiselledQuartzBlock:15>);
recipes.remove(<ganysnether:whiteQuartzStairs:15>);
recipes.remove(<ganysnether:colouredQuartzPillar3:3>);
recipes.removeShaped(<minecraft:quartz_block:0>, [[<ore:blockQuartz>]]);
recipes.removeShaped(<minecraft:quartz_block:1>, [[<ore:blockQuartzChiselled>]]);
recipes.removeShaped(<minecraft:quartz_block:2>, [[null,null,null],[null,<ore:blockQuartzPillar>,null],[null,null,null]]);

# Add dye-to-white blocks

### Add chisel categories for colored quartz ###



val ganyquartzmatrix = [

	[<ganysnether:colouredQuartzBlock:0>, <ganysnether:colouredChiselledQuartzBlock:0>, <ganysnether:colouredQuartzPillar0:0>],
    [<ganysnether:colouredQuartzBlock:1>, <ganysnether:colouredChiselledQuartzBlock:1>, <ganysnether:colouredQuartzPillar0:1>],
    [<ganysnether:colouredQuartzBlock:2>, <ganysnether:colouredChiselledQuartzBlock:2>, <ganysnether:colouredQuartzPillar0:2>],
    [<ganysnether:colouredQuartzBlock:3>, <ganysnether:colouredChiselledQuartzBlock:3>, <ganysnether:colouredQuartzPillar0:3>],
    [<ganysnether:colouredQuartzBlock:4>, <ganysnether:colouredChiselledQuartzBlock:4>, <ganysnether:colouredQuartzPillar1:0>],
    [<ganysnether:colouredQuartzBlock:5>, <ganysnether:colouredChiselledQuartzBlock:5>, <ganysnether:colouredQuartzPillar1:1>],
    [<ganysnether:colouredQuartzBlock:6>, <ganysnether:colouredChiselledQuartzBlock:6>, <ganysnether:colouredQuartzPillar1:2>],
    [<ganysnether:colouredQuartzBlock:7>, <ganysnether:colouredChiselledQuartzBlock:7>, <ganysnether:colouredQuartzPillar1:3>],
    [<ganysnether:colouredQuartzBlock:8>, <ganysnether:colouredChiselledQuartzBlock:8>, <ganysnether:colouredQuartzPillar2:0>],
    [<ganysnether:colouredQuartzBlock:9>, <ganysnether:colouredChiselledQuartzBlock:9>, <ganysnether:colouredQuartzPillar2:1>],
    [<ganysnether:colouredQuartzBlock:10>, <ganysnether:colouredChiselledQuartzBlock:10>, <ganysnether:colouredQuartzPillar2:2>],
    [<ganysnether:colouredQuartzBlock:11>, <ganysnether:colouredChiselledQuartzBlock:11>, <ganysnether:colouredQuartzPillar2:3>],
    [<ganysnether:colouredQuartzBlock:12>, <ganysnether:colouredChiselledQuartzBlock:12>, <ganysnether:colouredQuartzPillar3:0>],
    [<ganysnether:colouredQuartzBlock:13>, <ganysnether:colouredChiselledQuartzBlock:13>, <ganysnether:colouredQuartzPillar3:1>],
    [<ganysnether:colouredQuartzBlock:14>, <ganysnether:colouredChiselledQuartzBlock:14>, <ganysnether:colouredQuartzPillar3:2>],
    [<ganysnether:colouredQuartzBlock:15>, <ganysnether:colouredChiselledQuartzBlock:15>, <ganysnether:colouredQuartzPillar3:3>],
	
    ] as IItemStack[][];

val ganyquartzcategory = [

	"quartzBlockBlack",
	"quartzBlockRed",
	"quartzBlockGreen",
	"quartzBlockBrown",
	"quartzBlockBlue",
	"quartzBlockPurple",
	"quartzBlockCyan",
	"quartzBlockLightGray",
	"quartzBlockGray",
	"quartzBlockPink",
	"quartzBlockLime",
	"quartzBlockYellow",
	"quartzBlockLightBlue",
	"quartzBlockMagenta",
	"quartzBlockOrange",
	"quartzBlockWhite",
	
] as string[];

for i, entry in ganyquartzcategory {
	mods.chisel.Groups.addGroup(entry);
	mods.chisel.Groups.addVariation(entry, ganyquartzmatrix[i][0]);
	mods.chisel.Groups.addVariation(entry, ganyquartzmatrix[i][1]);
	mods.chisel.Groups.addVariation(entry, ganyquartzmatrix[i][2]);
}

recipes.addShaped(<minecraft:quartz_block:2>*8,
	[[pillarQuartz_ore, pillarQuartz_ore, pillarQuartz_ore],
	[pillarQuartz_ore, dyeWhite_ore, pillarQuartz_ore],
	[pillarQuartz_ore, pillarQuartz_ore, pillarQuartz_ore]]);




# Change Mariculture vat to wrought iron
recipes.remove(<Mariculture:machines_multi_rendered:3>);
recipes.addShaped(<Mariculture:machines_multi_rendered:3>,
	[[<GardenStuff:wrought_iron_ingot>, null, <GardenStuff:wrought_iron_ingot>],
	[<GardenStuff:wrought_iron_ingot>, null, <GardenStuff:wrought_iron_ingot>],
	[<GardenStuff:wrought_iron_ingot>, <GardenStuff:wrought_iron_ingot>, <GardenStuff:wrought_iron_ingot>]]);


# OpenBlocks canvas should produce 1 and not 8:
recipes.remove(<OpenBlocks:canvas>);
recipes.addShaped(<OpenBlocks:canvas>,
	[[paper_mc, paper_mc, paper_mc],
	[paper_mc, planksWood_ore, paper_mc],
	[paper_mc, paper_mc, paper_mc]]);

# Make BiblioCraft clipboard accept any wood and ink
recipes.remove(<BiblioCraft:item.BiblioClipboard>);
recipes.addShaped(<BiblioCraft:item.BiblioClipboard>,
	[[<ore:dyeBlack>, null, <minecraft:feather>],
	[paper_mc, paper_mc, paper_mc],
	[null, <minecraft:wooden_pressure_plate>, null]]);

# Make statues palette accept generic ingredients and a slab
recipes.remove(<statues:statues.item.palette>);
recipes.addShaped(<statues:statues.item.palette>,
	[[<ore:dyeYellow>, <ore:dyeBlue>, <ore:dyeWhite>],
	[<ore:dyeRed>, <minecraft:wooden_pressure_plate>, <ore:dyeBlack>]]);

# Remove Chisel purpur and substitute EtFuturm's
recipes.remove(<chisel:purpur:0>);
mods.chisel.Groups.removeVariation(<chisel:purpur:0>);
mods.chisel.Groups.removeVariation(<chisel:purpur:1>);
mods.chisel.Groups.addVariation("purpur", <etfuturum:purpur_block>);
mods.chisel.Groups.addVariation("purpur", <etfuturum:purpur_pillar>);


# Voltz circuits use Mekanism-like improvement
#recipes.remove(circuitAdvanced_ve);
#recipes.addShaped(circuitAdvanced_ve,
#	[[alloy_enriched,circuitBasic_ve,alloy_enriched]]);
#recipes.remove(circuitElite_ve);
#recipes.addShaped(circuitElite_ve,
#	[[alloy_reinforced,circuitAdvanced_ve,alloy_reinforced]]);


# Change pam weee flowers to make dye instead of odd dye items

val pamweeeflowersmatrix = [
	
	[<minecraft:dye:15>, <weeeflowers:Flower:0>, <BiomesOPlenty:misc:8>, <ganyssurface:dye:14>], # White roses
	[<minecraft:dye:0>, <weeeflowers:Flower:13>, <BiomesOPlenty:misc:9>, <ganyssurface:dye:0>], # Black Roses
	[lapis_mc, <weeeflowers:Flower:10>, <BiomesOPlenty:misc:5>, <ganyssurface:dye:0>], # Blue Hydrangeas
	[<minecraft:dye:3>, <weeeflowers:Flower:11>, <BiomesOPlenty:misc:6>, <ganyssurface:dye:3>], # Dying Shrub
	[<minecraft:dye:2>, <weeeflowers:Flower:12>, <BiomesOPlenty:misc:7>, <ganyssurface:dye:2>], # Green Shrub
	
    ] as IItemStack[][];

for entry in pamweeeflowersmatrix {

	recipes.removeShapeless(entry[0]*8, [entry[1], bottleGlass_mc, redstone_mc]);
	recipes.addShapeless(entry[2]*8, [entry[1], bottleGlass_mc, redstone_mc]);
	recipes.removeShapeless(entry[0], [entry[1]]);
	recipes.addShapeless(entry[2], [entry[1]]);
	recipes.removeShapeless(entry[0]*9, [entry[3]]);
	recipes.addShapeless(entry[2]*9, [entry[3]]);
	
}



# Gany's Surface oak fences don't work with growthcraft
# So I'm making sure they and the gates are "vanilla" style
recipes.remove(<ganyssurface:fence_0>);
recipes.addShaped(<minecraft:fence>*3,
	[[<minecraft:planks>,stickWood_ore,<minecraft:planks>],
	[<minecraft:planks>,stickWood_ore,<minecraft:planks>]]);

### ICBM

# Condensed Explosives should not give you three. Come on man.
#recipes.remove(<icbmclassic:icbmCExplosive:0>);
#recipes.addShaped(<icbmclassic:icbmCExplosive:0>,
#	[[null,<Mekanism:BasicBlock:8>,null],
#	[<minecraft:tnt>,<minecraft:repeater>,<minecraft:tnt>]]);

# Nuclear bomb should require an ultimate control circuit and some Uranium
#recipes.remove(<icbmclassic:icbmCExplosive:15>);
#recipes.addShaped(<icbmclassic:icbmCExplosive:15>,
#	[[<icbmclassic:icbmCExplosive:13>,<icbmclassic:icbmCExplosive:13>,<icbmclassic:icbmCExplosive:13>],
#	[<BigReactors:BRReactorPart:2>,<BigReactors:BRReactorPart:2>,<BigReactors:BRReactorPart:2>],
#	[circuit_advanced,circuit_advanced,circuit_advanced]]);

# Antimatter should require more than one Nuclear and 8 Nether Star
#recipes.remove(<icbmclassic:icbmCExplosive:22>);
#recipes.addShaped(<icbmclassic:icbmCExplosive:22>,
#	[[blockLudicrite_br,<icbmclassic:icbmCExplosive:15>,blockLudicrite_br],
#	[<icbmclassic:icbmCExplosive:15>,circuit_elite,<icbmclassic:icbmCExplosive:15>],
#	[blockLudicrite_br,<icbmclassic:icbmCExplosive:15>,blockLudicrite_br]]);

# Red matter...
#recipes.remove(<icbmclassic:icbmCExplosive:23>);
#recipes.addShaped(<icbmclassic:icbmCExplosive:23>,
#	[[circuit_ultimate,<icbmclassic:icbmCExplosive:22>,circuit_ultimate],
#	[<icbmclassic:icbmCExplosive:22>,<minecraft:nether_star>,<icbmclassic:icbmCExplosive:22>],
#	[circuit_ultimate,<icbmclassic:icbmCExplosive:22>,circuit_ultimate]]);


# Change Ludicrite block such that you can only get two ingots if you don't use a star.
recipes.removeShaped(blockLudicrite_br,
	[[<BigReactors:BRIngot:3>,<minecraft:blaze_rod>,<BigReactors:BRIngot:3>],
	[<ThermalFoundation:Storage:12>,null,<ThermalFoundation:Storage:12>],
	[<BigReactors:BRIngot:3>,<minecraft:blaze_rod>,<BigReactors:BRIngot:3>]]);


# Change More Planets' Uranium gear
furnace.remove(<MorePlanet:kapteyn-b_item:1>);
furnace.addRecipe(ingotYellorium_br, <MorePlanet:kapteyn-b_block:6>, 0.5);
<ore:oreUranium>.add(<MorePlanet:kapteyn-b_block:6>);

recipes.remove(<MorePlanet:uranium_battery:100>);
recipes.addShaped(<MorePlanet:uranium_battery:100>,
	[[null,<MorePlanet:kapteyn-b_item:2>,null],
	[<MorePlanet:kapteyn-b_item:2>,redstone_mc,<MorePlanet:kapteyn-b_item:2>],
	[<MorePlanet:kapteyn-b_item:2>,ingotYellorium_br,<MorePlanet:kapteyn-b_item:2>]]);

recipes.remove(<MorePlanet:laser_charge:3>);
recipes.addShaped(<MorePlanet:laser_charge:3>*12,
	[[null,ingotYellorium_br],
	[ingotFe_mc,null]]);



# Grappling Hook
recipes.remove(<GalacticraftMars:item.grapple>);
recipes.addShaped(<GalacticraftMars:item.grapple>,
	[[null,null,rope_grce],
	[<GalacticraftMars:item.null:1>,<GalacticraftCore:item.meteoricIronIngot:1>,null],
	[<GalacticraftMars:item.null:1>,<GalacticraftMars:item.null:1>,null]]);


### Openblocks recipe


# Golden Eye
#recipes.remove(<OpenBlocks:goldenEye:100>);
#recipes.addShaped(<OpenBlocks:goldenEye:0>,
#	[[<minecraft:gold_block>,<minecraft:ender_eye>,<minecraft:gold_block>],
#	[<minecraft:ender_eye>,<BiomesOPlenty:biomeFinder>,<minecraft:ender_eye>],
#	[<minecraft:gold_block>,<minecraft:ender_eye>,<minecraft:gold_block>]]);

# Map memory module
recipes.remove(<OpenBlocks:generic:7>);
recipes.addShaped(<OpenBlocks:generic:7>,
	[[alloy_enriched,<OpenComputers:item:32>,nuggetAu_ore]]);

# Map controller module
recipes.remove(<OpenBlocks:generic:6>);
recipes.addShaped(<OpenBlocks:generic:6>,
	[[nuggetAu_ore,<OpenComputers:item:32>,nuggetAu_ore],
	[<OpenComputers:item:32>,circuit_advanced,<OpenComputers:item:32>],
	[nuggetAu_ore,<OpenComputers:item:32>,nuggetAu_ore]]);

# Sprinkler
recipes.remove(<OpenBlocks:sprinkler>);
recipes.addShaped(<OpenBlocks:sprinkler>,
	[[null,<minecraft:iron_bars>,null],
	[<ore:ingotAluminumBrass>,<Mekanism:PartTransmitter:4>,<ore:ingotAluminumBrass>],
	[null,<minecraft:repeater>,null]]);

# Height map projector
recipes.remove(<OpenBlocks:projector>);
recipes.addShaped(<OpenBlocks:projector>,
	[[null,<OpenComputers:hologram1>,null],
	[<minecraft:stone_slab:0>,redstone_mc,<minecraft:stone_slab:0>]]);

# Building guide
recipes.remove(<OpenBlocks:guide>);
recipes.addShaped(<OpenBlocks:guide>,
	[[blockGlass_ore,blockGlass_ore,blockGlass_ore],
	[blockGlass_ore,<OpenComputers:hologram1>,blockGlass_ore],
	[blockGlass_ore,redstone_mc,blockGlass_ore]]);

# Enhanced Building guide
recipes.remove(<OpenBlocks:builder_guide>);
recipes.addShaped(<OpenBlocks:builder_guide>,
	[[blockGlass_ore,blockGlass_ore,blockGlass_ore],
	[blockGlass_ore,<OpenComputers:hologram2>,blockGlass_ore],
	[blockGlass_ore,redstone_mc,blockGlass_ore]]);


# Change raw circuit board (OpenComputers)

recipes.remove(<OpenComputers:item:30>);
recipes.addShapeless(<OpenComputers:item:30>, [nuggetAu_ore, <ore:dyeGreen>, <GalacticraftCore:item.basicItem:2>]);
# Change Mariculture silicon carbide
recipes.remove(<Mariculture:crafting:10>);
recipes.addShaped(<Mariculture:crafting:10>,
	[[null,<ore:sand>,null],
	[<minecraft:coal:0>,<GalacticraftCore:item.basicItem:2>,<minecraft:coal:0>],
	[null,<ore:sand>,null]]);


### Change GalaxySpace metal blocks to a chisel subtype

mods.chisel.Groups.addGroup("magnesiumblock"); 
mods.chisel.Groups.addVariation("magnesiumblock", <Mariculture:metals:3>);
mods.chisel.Groups.addVariation("magnesiumblock", <Metallurgy:utility.block:3>);

mods.chisel.Groups.addGroup("mithrilblock"); 
mods.chisel.Groups.addVariation("mithrilblock", <Metallurgy:fantasy.block:7>);
mods.chisel.Groups.addVariation("mithrilblock", <ThermalFoundation:Storage:6>);

mods.chisel.Groups.addGroup("platinumblock"); 
mods.chisel.Groups.addVariation("platinumblock", <Metallurgy:precious.block:2>);
mods.chisel.Groups.addVariation("platinumblock", <ThermalFoundation:Storage:5>);


# Make Ilmenite and Leucoxene give back IMPURE TITANIUM
mods.mariculture.Crucible.addRecipe(1662, <GalacticraftMars:tile.asteroidsBlock:4>, moltenRutile_liq * 288, <GalacticraftMars:tile.asteroidsBlock:0>, 2);
mods.mariculture.Crucible.addRecipe(1662, <GalaxySpace:ganymedeblocks:3>, moltenRutile_liq * 288, <GalaxySpace:ganymedeblocks:1>, 2);
furnace.remove(<GalacticraftMars:item.itemBasicAsteroids:5>);
furnace.addRecipe(<Mariculture:materials:3>, <GalacticraftMars:tile.asteroidsBlock:4>, 0.5);
furnace.addRecipe(<Mariculture:materials:3>, <GalaxySpace:ganymedeblocks:3>, 0.5);
furnace.addRecipe(<Mariculture:materials:3>, <GalacticraftMars:item.itemBasicAsteroids:4>, 0.5);
mods.mekanism.Enrichment.addRecipe(<GalacticraftMars:tile.asteroidsBlock:4>, <aobd:dustRutile>*2);
mods.mekanism.Enrichment.addRecipe(<GalaxySpace:ganymedeblocks:3>, <aobd:dustRutile>*2);


# Growthcraft rope should be harder to make
recipes.remove(rope_grce);
recipes.addShapeless(rope_grce, [itemString,itemString,itemString]);


# Change all the Garden Trees posts to no longer require an axe.

recipes.remove(<GardenTrees:thin_log:*>);
recipes.remove(<GardenTrees:thin_log_fence:*>);

# Logs / Posts / Post fences
val gardentreesmatrix = [
	
	[<minecraft:log:0>, <GardenTrees:thin_log:0>, <GardenTrees:thin_log_fence:0>], # Oak
	[<minecraft:log:1>, <GardenTrees:thin_log:1>, <GardenTrees:thin_log_fence:1>], # Spruce
	[<minecraft:log:2>, <GardenTrees:thin_log:2>, <GardenTrees:thin_log_fence:2>], # Birch
	[<minecraft:log:3>, <GardenTrees:thin_log:3>, <GardenTrees:thin_log_fence:3>], # Jungle
	[<minecraft:log2:0>, <GardenTrees:thin_log:4>, <GardenTrees:thin_log_fence:4>], # Acacia
	[<minecraft:log2:1>, <GardenTrees:thin_log:5>, <GardenTrees:thin_log_fence:5>], # Dark Oak
	
	#[<Natura:tree:0>, <GardenTrees:thin_log:249>, <GardenTrees:thin_log_fence:249>], # Eucalyptus
	#[<Natura:redwood:0>, <GardenTrees:thin_log:250>, <GardenTrees:thin_log_fence:250>], # Redwood Bark
	#[<Natura:bloodwood:15>, <GardenTrees:thin_log:61863>, <GardenTrees:thin_log_fence:61863>], # Bloodwood
	#[<BiomesOPlenty:logs4:2>, <GardenTrees:thin_log:8749>, <GardenTrees:thin_log_fence:8749>], # Jacaranda
	#[<Natura:willow:0>, <GardenTrees:thin_log:409>, <GardenTrees:thin_log_fence:409>], # Babylon Willow
	#[<Natura:tree:2>, <GardenTrees:thin_log:8441>, <GardenTrees:thin_log_fence:8441>], # Ghostwood
	#[<BiomesOPlenty:logs4:0>, <GardenTrees:thin_log:557>, <GardenTrees:thin_log_fence:557>], # Pine
	#[<Natura:Dark Tree:1>, <GardenTrees:thin_log:4522>, <GardenTrees:thin_log_fence:4522>], # Fusewood
	#[<Natura:Rare Tree:1>, <GardenTrees:thin_log:4540>, <GardenTrees:thin_log_fence:4540>], # Silverbell
	#[<BiomesOPlenty:logs1:1>, <GardenTrees:thin_log:4650>, <GardenTrees:thin_log_fence:4650>], # Cherry
	#[<BiomesOPlenty:logs2:1>, <GardenTrees:thin_log:4651>, <GardenTrees:thin_log_fence:4651>], # Magic
	#[<BiomesOPlenty:logs3:1>, <GardenTrees:thin_log:4652>, <GardenTrees:thin_log_fence:4652>], # Weeping willow
	#[<Natura:Rare Tree:3>, <GardenTrees:thin_log:12732>, <GardenTrees:thin_log_fence:12732>], # Tiger
	#[<BiomesOPlenty:logs2:3>, <GardenTrees:thin_log:12843>, <GardenTrees:thin_log_fence:12843>], # Palm
	#[<BiomesOPlenty:logs3:3>, <GardenTrees:thin_log:12844>, <GardenTrees:thin_log_fence:12844>], # Giant Flower Stem
	#[<BiomesOPlenty:logs1:3>, <GardenTrees:thin_log:12842>, <GardenTrees:thin_log_fence:12842>], # Fir
	#[<BiomesOPlenty:logs4:3>, <GardenTrees:thin_log:12845>, <GardenTrees:thin_log_fence:12845>], # Mahogany
	#[<Natura:tree:1>, <GardenTrees:thin_log:4345>, <GardenTrees:thin_log_fence:4345>], # Sakura
	#[<Natura:redwood:1>, <GardenTrees:thin_log:4346>, <GardenTrees:thin_log_fence:4346>], # Giant Redwood
	#[<BiomesOPlenty:logs4:1>, <GardenTrees:thin_log:4653>, <GardenTrees:thin_log_fence:4653>], # Hellbark
	#[<Natura:Dark Tree:0>, <GardenTrees:thin_log:426>, <GardenTrees:thin_log_fence:426>], # Darkwood
	#[<Natura:tree:3>, <GardenTrees:thin_log:12537>, <GardenTrees:thin_log_fence:12537>], # Hopseed
	#[<BiomesOPlenty:logs1:0>, <GardenTrees:thin_log:554>, <GardenTrees:thin_log_fence:554>], # Sacred Oak
	#[<BiomesOPlenty:logs3:0>, <GardenTrees:thin_log:556>, <GardenTrees:thin_log_fence:556>], # Redwood Wood
	#[<Natura:Rare Tree:0>, <GardenTrees:thin_log:444>, <GardenTrees:thin_log_fence:444>], # Sycamore Maple
	#[<BiomesOPlenty:logs3:2>, <GardenTrees:thin_log:8748>, <GardenTrees:thin_log_fence:8748>], # Dead
	#[<BiomesOPlenty:logs2:2>, <GardenTrees:thin_log:8747>, <GardenTrees:thin_log_fence:8747>], # Mangrove
	#[<BiomesOPlenty:logs1:2>, <GardenTrees:thin_log:8746>, <GardenTrees:thin_log_fence:8746>], # Umbran
	#[<Natura:Rare Tree:2>, <GardenTrees:thin_log:8636>, <GardenTrees:thin_log_fence:8636>], # Amaranth
	#[<BiomesOPlenty:logs2:0>, <GardenTrees:thin_log:555>, <GardenTrees:thin_log_fence:555>], # Ethereal
	
	# Witchery and Twilight Forest trees seem to botch up their syncs.
	# They probably have a dynamic registry.
	#[<TwilightForest:tile.TFMagicLog:3>, <GardenTrees:thin_log:12990>, <GardenTrees:thin_log_fence:12990>], # Sortingwood
	#[<TwilightForest:tile.TFLog:0>, <GardenTrees:thin_log:686>, <GardenTrees:thin_log_fence:686>], # Twilight Oak
	#[<TwilightForest:tile.TFMagicLog:1>, <GardenTrees:thin_log:4798>, <GardenTrees:thin_log_fence:4798>], # Transwood
	#[<TwilightForest:tile.TFLog:2>, <GardenTrees:thin_log:8878>, <GardenTrees:thin_log_fence:8878>], # Mangrove
	#[<witchery:witchlog:1>, <GardenTrees:thin_log:6749>, <GardenTrees:thin_log_fence:6749>], # Alder
	#[<TwilightForest:tile.TFLog:1>, <GardenTrees:thin_log:4782>, <GardenTrees:thin_log_fence:4782>], # Canopy
	#[<witchery:witchlog:2>, <GardenTrees:thin_log:10845>, <GardenTrees:thin_log_fence:10845>], # Hawthorn
	#[<TwilightForest:tile.TFMagicLog:2>, <GardenTrees:thin_log:8894>, <GardenTrees:thin_log_fence:8894>], # Minewood
	#[<TwilightForest:tile.TFLog:3>, <GardenTrees:thin_log:12974>, <GardenTrees:thin_log_fence:12974>], # Twilight Darkwood
	#[<witchery:witchlog:0>, <GardenTrees:thin_log:2653>, <GardenTrees:thin_log_fence:2653>], # Rowan
	#[<TwilightForest:tile.TFMagicLog:0>, <GardenTrees:thin_log:702>, <GardenTrees:thin_log_fence:702>], # Timewood
	
] as IItemStack[][];

# This for-loop actually makes the recipes
for i, entry in gardentreesmatrix {
    
    #recipes.addShaped(entry[1]*4, [ [<BiblioCraft:item.FramingSaw>], [entry[0]] ]);
	recipes.addShaped(entry[1]*4, [[<BiblioCraft:item.FramingSaw>], [entry[0]]] );
    recipes.addShaped(entry[2]*2, [ [entry[1], rope_grce, entry[1] ]	]);
	# Make posts into full logs
	recipes.addShaped(entry[0], [ [entry[1], entry[1]], [entry[1], entry[1]] ]);	
}



recipes.addShaped(<minecraft:diamond_pickaxe>,
 [[diamond_mc, diamond_mc, diamond_mc],
  [null, stickWood_ore, null],
  [null, stickWood_ore, null]]);

### I tried to remove the diamond pick and replace it with the diamond scythe, but
### the elevator bottom stopped working. I'm instead going to just re-name the diamond pick.


# Change Undercutter cart to not require diamond shovel
recipes.remove(<Railcraft:cart.undercutter>);
recipes.addShaped(<Railcraft:cart.undercutter>,
 [[<minecraft:dye:11>, <minecraft:redstone_lamp>, <minecraft:dye:11>],
  [blockPiston_mc, blockSteel_ore, blockPiston_mc],
  [diamond_mc, <minecraft:minecart>, diamond_mc]]);

  # Change Scarab tools to not require nullified base tools
recipes.remove(<fossil:scarabAxe>);
recipes.addShaped(<fossil:scarabAxe>,
 [[ingotAu_ore, ingotAu_ore],
  [ingotAu_ore, gemScarab],
  [null, stickWood_ore]]);
recipes.addShaped(<fossil:scarabAxe>,
 [[diamond_mc, diamond_mc],
  [diamond_mc, gemScarab],
  [null, stickWood_ore]]);

recipes.remove(<fossil:scarabPickAxe>);
recipes.addShaped(<fossil:scarabPickAxe>,
 [[ingotAu_ore, ingotAu_ore, ingotAu_ore],
  [null, gemScarab, null],
  [null, stickWood_ore, null]]);
recipes.addShaped(<fossil:scarabPickAxe>,
 [[diamond_mc, diamond_mc, diamond_mc],
  [null, gemScarab, null],
  [null, stickWood_ore, null]]);

recipes.remove(<fossil:scarabShovel>);
recipes.addShaped(<fossil:scarabShovel>,
 [[ingotAu_ore],
  [gemScarab],
  [stickWood_ore]]);
recipes.addShaped(<fossil:scarabShovel>,
 [[diamond_mc],
  [gemScarab],
  [stickWood_ore]]);





# Try to make the growthcraft mead bucket work
//recipes.remove(<Growthcraft|Bees:grc.honeyMead_bucket>);
recipes.addShapeless(<Growthcraft|Bees:grc.honeyMeadBucket.0>, [<minecraft:water_bucket>, <minecraft:bucket>, <Growthcraft|Bees:grc.honeyJar>]);


# Pam's Fresh Milk should give back one instead of four.
recipes.remove(<harvestcraft:freshmilkItem>);
recipes.addShapeless(<harvestcraft:freshmilkItem>, [<minecraft:milk_bucket>]);

# Change laboratory block recipe
recipes.remove(<chisel:laboratoryblock:0>);
recipes.addShaped(<chisel:laboratoryblock:0>*5,
 [[blockStone_ore, ingotFe_ore, blockStone_ore],
  [ingotFe_ore, <ore:dyeWhite>, ingotFe_ore],
  [blockStone_ore, ingotFe_ore, blockStone_ore]]);

# Change technical block to give 6 instead of whatever
recipes.remove(<chisel:technical:0>);
recipes.addShaped(<chisel:technical:0>*6,
 [[blockStone_ore, ingotFe_ore, blockStone_ore],
  [ingotFe_ore, blockStone_ore, ingotFe_ore],
  [blockStone_ore, ingotFe_ore, blockStone_ore]]);

# Change warning sign block to give 8 instead of 4
recipes.remove(<chisel:warningSign:0>);
recipes.addShaped(<chisel:warningSign:0>*8,
 [[blockStone_ore, blockStone_ore, blockStone_ore],
  [blockStone_ore, <minecraft:sign>, blockStone_ore],
  [blockStone_ore, blockStone_ore, blockStone_ore]]);

# Change paper wall to give 1 block instead of 4
recipes.remove(<chisel:paperwall_block:0>);
recipes.addShaped(<chisel:paperwall_block:0>,
 [[<chisel:paperwall>, <chisel:paperwall>, <chisel:paperwall>],
  [<chisel:paperwall>, stickWood_ore, <chisel:paperwall>],
  [<chisel:paperwall>, <chisel:paperwall>, <chisel:paperwall>]]);

# Change Hex Plating so you get 9 instead of 8
#recipes.remove(<chisel:hexPlating:0>);
#recipes.addShaped(<chisel:hexPlating:0>*9,
# [[blockStone_ore, blockStone_ore, blockStone_ore],
#  [blockStone_ore, <minecraft:coal_block>, blockStone_ore],
#  [blockStone_ore, blockStone_ore, blockStone_ore]]);

# Change Chisel Rebellious blocks so that you get five instead of 32.
recipes.remove(<chisel:rebel:0>);
recipes.addShaped(<chisel:rebel:0>*5,
 [[blockStone_ore, ingotFe_ore, blockStone_ore],
  [ingotFe_ore, nuggetAu_ore, ingotFe_ore],
  [blockStone_ore, ingotFe_ore, blockStone_ore]]);


# Fix the microblocks saws so that they work

val hacksawmatrix = [

	<ForgeMicroblock:sawStone>,
	<ForgeMicroblock:sawIron>,
	<ForgeMicroblock:sawDiamond>,
	<IguanaTweaksTConstruct:sawArdite>,
	<IguanaTweaksTConstruct:sawCobalt>,
	<IguanaTweaksTConstruct:sawManyullyn>,
	
] as IItemStack[];


val hacksawpiecesmatrix = [

	[flint_mc, rodStone_ore],
	[ingotFe_ore, rodFe_ore],
	[diamond_mc, rodFe_ore],
	[<ore:rodArdite>, rodFe_ore],
	[<ore:rodCobalt>, rodFe_ore],
	[<ore:rodManyullyn>, rodFe_ore],
	
] as IIngredient[][];


for i, entry in hacksawpiecesmatrix {
	
	recipes.remove(hacksawmatrix[i]);
	
	recipes.addShaped(
		hacksawmatrix[i],
			[[entry[1], entry[1], entry[1]],
			[stickWood_ore, entry[0], entry[1]]]
		);
  
}


# Change jerky recipes to take four times as long

val jerkytoremove = [
	
	<TConstruct:jerky:0>,
	<TConstruct:jerky:1>,
	<TConstruct:jerky:2>,
	#<TConstruct:jerky:3>,
	<TConstruct:jerky:4>,
	<TConstruct:jerky:5>,
	<TConstruct:jerky:7>,
	
] as IItemStack[];

for defjerk in jerkytoremove {
	mods.tconstruct.Drying.removeRecipe(defjerk);
}

val jerkymatrix = [
	
	[<minecraft:beef>, <TConstruct:jerky:0>],
	[<minecraft:chicken>, <TConstruct:jerky:1>],
	[<minecraft:porkchop>, <TConstruct:jerky:2>],
	[<harvestcraft:muttonrawItem>, <TConstruct:jerky:3>],
	[<etfuturum:mutton_raw>, <TConstruct:jerky:3>],
	[<minecraft:fish:0>, <TConstruct:jerky:4>], # cod
	[<minecraft:fish:1>, <TConstruct:jerky:4>], # salmon
	[<minecraft:fish:2>, <TConstruct:jerky:4>], # clownfish
	[<TConstruct:strangeFood:1>, <TConstruct:jerky:7>],
	[<Mariculture:plant_growable:1>, <Mariculture:plant_static:1>], # Kelp
	
] as IItemStack[][];

for entry in jerkymatrix {
	
	mods.tconstruct.Drying.addRecipe(entry[0], entry[1], 12000);
	
}

mods.tconstruct.Drying.addRecipe(<minecraft:rotten_flesh>, <TConstruct:jerky:5>, 18000); # monster


# Make it cost two wheat and a mortar/pestle to make wheat flour
recipes.remove(<Natura:barleyFood:2>);
recipes.addShapeless(<Natura:barleyFood:2>, [<minecraft:wheat>, <minecraft:wheat>, <harvestcraft:mortarandpestleItem>.transformReplace(<harvestcraft:mortarandpestleItem>)]);

# Add barley flour recipe
recipes.remove(<Natura:barleyFood:1>);
recipes.addShapeless(<Natura:barleyFood:1>, [cropBarley_ore, cropBarley_ore, <harvestcraft:mortarandpestleItem>.transformReplace(<harvestcraft:mortarandpestleItem>)]);



# Hand craft harvestcraft salt into mekanism salt and vice-versa
recipes.addShapeless(<harvestcraft:saltItem>, [<Mekanism:Salt>]);
recipes.addShapeless(<Mekanism:Salt>, [<harvestcraft:saltItem>]);


# Change medallion to be more expensive
recipes.remove(<MoCreatures:medallion>);
recipes.addShaped(<MoCreatures:medallion>,
 [[<minecraft:leather>, null, <minecraft:leather>],
  [<minecraft:gold_ingot>, diamond_mc, <minecraft:gold_ingot>],
  [null, <minecraft:gold_ingot>, null]]);


# Change Archimedes floater
recipes.remove(<ArchimedesShipsPlus:floater>);
recipes.addShaped(<ArchimedesShipsPlus:floater>,
 [[<minecraft:slime_ball>, planksWood_ore,slimeball_mc],
  [planksWood_ore, null, planksWood_ore],
  [<minecraft:slime_ball>, planksWood_ore,slimeball_mc]]);


# Change Archimedes balloons
val thermalcloth = <GalacticraftMars:item.itemBasicAsteroids:7>;
recipes.remove(<ArchimedesShipsPlus:balloon:*>);
recipes.addShaped(<ArchimedesShipsPlus:balloon:0>,
 [[itemString, thermalcloth, itemString],
  [thermalcloth, <minecraft:blaze_powder>, thermalcloth],
  [itemString, thermalcloth, itemString]]);

# Dyed versions


val archimedesballoons = [
	<ArchimedesShipsPlus:balloon:0>,
	<ArchimedesShipsPlus:balloon:1>,
	<ArchimedesShipsPlus:balloon:2>,
	<ArchimedesShipsPlus:balloon:3>,
	<ArchimedesShipsPlus:balloon:4>,
	<ArchimedesShipsPlus:balloon:5>,
	<ArchimedesShipsPlus:balloon:6>,
	<ArchimedesShipsPlus:balloon:7>,
	<ArchimedesShipsPlus:balloon:8>,
	<ArchimedesShipsPlus:balloon:9>,
	<ArchimedesShipsPlus:balloon:10>,
	<ArchimedesShipsPlus:balloon:11>,
	<ArchimedesShipsPlus:balloon:12>,
	<ArchimedesShipsPlus:balloon:13>,
	<ArchimedesShipsPlus:balloon:14>,
	<ArchimedesShipsPlus:balloon:15>,
	] as IItemStack[];
	
for i, balloon in archimedesballoons {
	recipes.addShapeless(balloon, [<ArchimedesShipsPlus:balloon:*>, oreDyes[i]]);
}




# Remove Cyanite-from-sand crafting
recipes.remove(ingotCyanite_br);
# Re-add 9 cyanite from block
recipes.addShapeless(ingotCyanite_br*9, [blockCyanite_br]);


# Change Zhark fishbowls
recipes.addShaped(<MoCreatures:bowlempty>,
 [[<minecraft:glass_pane>, null, <minecraft:glass_pane>],
  [<minecraft:glass_pane>, null, <minecraft:glass_pane>],
  [<minecraft:glass_pane>, <minecraft:glass_pane>, <minecraft:glass_pane>]]);


# Replace EF boat recipes because wooden shovels are no longer available
val ef_boats = [
	<etfuturum:oak_boat>,
	<etfuturum:spruce_boat>,
	<etfuturum:birch_boat>,
	<etfuturum:jungle_boat>,
	<etfuturum:acacia_boat>,
	<etfuturum:dark_oak_boat>,
	] as IItemStack[];
val wood_planks = [
	<minecraft:planks:0>,
	<minecraft:planks:1>,
	<minecraft:planks:2>,
	<minecraft:planks:3>,
	<minecraft:planks:4>,
	<minecraft:planks:5>,
	] as IItemStack[];
for i, boat in ef_boats {
	recipes.remove(boat);
	recipes.addShaped(boat,
	 [[wood_planks[i], <minecraft:stick>, wood_planks[i]],
	  [wood_planks[i], wood_planks[i], wood_planks[i]]]);
	recipes.addShaped(boat,
	 [[wood_planks[i], <minecraft:boat>, wood_planks[i]],
	  [wood_planks[i], wood_planks[i], wood_planks[i]]]);
}


# Make Speed Boat more expensive
recipes.remove(<Mariculture:boat_speed>);
recipes.addShaped(<Mariculture:boat_speed>,
 [[<minecraft:glass_pane>, null, <Mariculture:turbine_aluminum>],
  [sheet_of_Al, sheet_of_Al, sheet_of_Al]]);


# Mekanism solar panels require lapis
recipes.remove(<MekanismGenerators:SolarPanel>);
recipes.addShaped(<MekanismGenerators:SolarPanel>,
 [[<minecraft:glass_pane>, <minecraft:glass_pane>, <minecraft:glass_pane>],
  [redstone_mc, lapis_mc, redstone_mc],
  [<Mekanism:Ingot:1>, circuit_basic, <Mekanism:Ingot:1>]]);



# Teleportation core requires Ender Pearl instead of Diamond
recipes.remove(<Mekanism:TeleportationCore>);
recipes.addShaped(<Mekanism:TeleportationCore>,
 [[diamond_mc, alloy_atomic, diamond_mc],
  [<minecraft:gold_ingot>, <minecraft:ender_pearl>, <minecraft:gold_ingot>],
  [diamond_mc, alloy_atomic, diamond_mc]]);

# Teleporter requires ultimate circuit
recipes.remove(<Mekanism:MachineBlock:11>);
recipes.addShaped(<Mekanism:MachineBlock:11>,
 [[circuit_ultimate, <Mekanism:BasicBlock:8>, circuit_ultimate],
  [<Mekanism:BasicBlock:8>, <Mekanism:TeleportationCore>, <Mekanism:BasicBlock:8>],
  [circuit_ultimate, <Mekanism:BasicBlock:8>, circuit_ultimate]]);


# Remove the Palaeoraphe plank jukebox
recipes.remove(<minecraft:jukebox>);
recipes.addShaped(<minecraft:jukebox>,
 [[planksWood_ore, planksWood_ore, planksWood_ore],
  [planksWood_ore, diamond_mc, planksWood_ore],
  [planksWood_ore, planksWood_ore, planksWood_ore]]);
  
  
### Change Weather block devices ###

#recipes.remove(<weather2:WeatherForecast>);
#recipes.addShaped(<weather2:WeatherForecast>,
# [[null, <GalacticraftCore:tile.viewScreen>, null],
#  [circuit_elite, compass_mc, circuit_elite]]);

#recipes.remove(<weather2:TornadoSensor>);
#recipes.addShaped(<weather2:TornadoSensor>,
# [[null, <Mekanism:BasicBlock:8>, null],
#  [circuit_advanced, compass_mc, circuit_advanced]]);

#recipes.remove(<weather2:TornadoSiren>);
#recipes.addShaped(<weather2:TornadoSiren>,
# [[<cfm:ItemFireAlarm>],
#  [<weather2:TornadoSensor>]]);

#recipes.remove(<weather2:WeatherDeflector>);
#recipes.addShaped(<weather2:WeatherDeflector>,
# [[ingotSteel_ore, circuit_ultimate, ingotSteel_ore],
#  [circuit_ultimate, compass_mc, circuit_ultimate],
#  [ingotSteel_ore, circuit_ultimate, ingotSteel_ore]]);




# Flint and Steel now can use steel.
recipes.addShapeless(flintsteel_mc, [ingotSteel_ore, flint_mc]);


# Name tag
recipes.addShapeless(<minecraft:name_tag>, [itemString, <ore:slimeball>, sheet_of_Al, paper_mc]);


# Make Robit quite a bit more expensive
recipes.remove(<Mekanism:Robit:*>);
recipes.addShaped(<Mekanism:Robit>,
 [[<Mekanism:EnergyTablet:*>, <OpenComputers:item:14>, <Mekanism:MachineBlock:13>],
  [<Mekanism:EnergyTablet:*>, alloy_atomic, <GalacticraftCore:tile.machineTiered:4>],
  [<Mekanism:Ingot:0>, <Mekanism:Ingot:0>, anvil_mc_any]]);






#################
### Additions ###
#################


# Get salt from salt water bottle
# EnviroMine's salt water bottle needs to specify an empty bottle return. Growthcraft's does not.
recipes.addShapeless(<harvestcraft:saltItem>, [<harvestcraft:potItem>, <enviromine:saltWaterBottle>.giveBack(<minecraft:glass_bottle>)]);
recipes.addShapeless(<harvestcraft:saltItem>, [<harvestcraft:potItem>, <Growthcraft:grccore.BottleFluidSaltWater>]);


# Two beetroots craft into two beetroot seeds
recipes.remove(<harvestcraft:beetItem>);
recipes.addShaped(<ganyssurface:beetrootSeeds>, [[<ganyssurface:beetroot>, <ganyssurface:beetroot>]]);


# Add to Endergized Smelter (1) up through Chemical Dissolution Chamber (5)
# Gotta do this with specific items because you can't use oredict entries, ffs

# Energized Smelter
mods.mekanism.Smelter.addRecipe(<Mariculture:rocks:2>, <TConstruct:materials:11>);
# Enrichment Chamber
#mods.mekanism.Enrichment.addRecipe(<Mariculture:rocks:2>, <TConstruct:materials:40>*2);
# Purification Chamber
mods.mekanism.Purification.addRecipe(<Mariculture:rocks:2>, <gas:oxygen>, <aobd:clumpAluminium>*3);
# Chemical Injection Chamber
mods.mekanism.chemical.Injection.addRecipe(<Mariculture:rocks:2>, <gas:hydrogenChloride>, <aobd:shardAluminium>*4);
# Chemical Dissolution Chamber
mods.mekanism.chemical.Dissolution.addRecipe(<Mariculture:rocks:2>, <gas:Aluminium>*1000);


# Smelt aluminum ore into aluminum
furnace.addRecipe(<Mariculture:materials:0>, <ore:oreAluminum>);
furnace.addRecipe(<Mariculture:materials:0>, <ore:oreAluminium>);


# Add ability to craft beetroot into beetroot seeds
recipes.addShapeless(<ganyssurface:beetrootSeeds>, [<ganyssurface:beetroot>]);


# Add raw abyssal stone to chisel group
mods.chisel.Groups.addVariation("RCAbyssalBlock", <Railcraft:cube:6>);


# Register Deepslate to its own chisel entry
mods.chisel.Groups.addGroup("deepslate"); 

val deepslate_block = [

	<etfuturum:deepslate>,
	<etfuturum:cobbled_deepslate>,
	<etfuturum:polished_deepslate>,
	<etfuturum:deepslate_bricks:0>,
	<etfuturum:deepslate_bricks:1>,
	<etfuturum:deepslate_bricks:2>,
	<etfuturum:deepslate_bricks:3>,
	<etfuturum:deepslate_bricks:4>
	
] as IItemStack[];

for entry in deepslate_block {
	mods.chisel.Groups.addVariation("deepslate", entry);
}


# Rhino leather into regular leather
recipes.addShapeless(<minecraft:leather>*2, [<ZoocraftDiscoveries:rhino_leather>]);


# Armadillo blocks
mods.chisel.Groups.addGroup("armadilloshellblock"); 
mods.chisel.Groups.addVariation("armadilloshellblock", <wildmobsmod:armadilloShellBlock>);
mods.chisel.Groups.addVariation("armadilloshellblock", <wildmobsmod:armadilloShellBlockCracked>);
mods.chisel.Groups.addVariation("armadilloshellblock", <wildmobsmod:armadilloShellBlockPatterned>);


# Thick bone into four bonemeal
recipes.addShapeless(<minecraft:dye:15>*4, [<wildmobsmod:thick_bone>]);


# Craft oredict bed into vanilla bed
recipes.addShapeless(<minecraft:bed>, [itemBed_ore]);


# Make Concrete Powder from enriching Concrete

val concrete_in = [

	[<VillageNames:concrete:0>, <VillageNames:concretePowder:0>],
	[<VillageNames:concrete:1>, <VillageNames:concretePowder:1>],
	[<VillageNames:concrete:2>, <VillageNames:concretePowder:2>],
	[<VillageNames:concrete:3>, <VillageNames:concretePowder:3>],
	[<VillageNames:concrete:4>, <VillageNames:concretePowder:4>],
	[<VillageNames:concrete:5>, <VillageNames:concretePowder:5>],
	[<VillageNames:concrete:6>, <VillageNames:concretePowder:6>],
	[<VillageNames:concrete:7>, <VillageNames:concretePowder:7>],
	[<VillageNames:concrete:8>, <VillageNames:concretePowder:8>],
	[<VillageNames:concrete:9>, <VillageNames:concretePowder:9>],
	[<VillageNames:concrete:10>, <VillageNames:concretePowder:10>],
	[<VillageNames:concrete:11>, <VillageNames:concretePowder:11>],
	[<VillageNames:concrete:12>, <VillageNames:concretePowder:12>],
	[<VillageNames:concrete:13>, <VillageNames:concretePowder:13>],
	[<VillageNames:concrete:14>, <VillageNames:concretePowder:14>],
	[<VillageNames:concrete:15>, <VillageNames:concretePowder:15>]
	
] as IItemStack[][];

for entry in concrete_in {
	mods.mekanism.Enrichment.addRecipe(entry[0], entry[1]);
}


# Add Kale stuff
recipes.addShapeless(<jaffa:kaleSeed>, [<ore:cropKale>]);


# Craft Spectral Moss via end stone
recipes.addShaped(<BiomesOPlenty:bopGrass:0>,
 [[seedwt_mc, seedwt_mc, seedwt_mc],
  [seedwt_mc, <minecraft:end_stone>, seedwt_mc],
  [seedwt_mc, seedwt_mc, seedwt_mc]]);


# Make BoP algae craftable into lime dye
recipes.addShapeless(<minecraft:dye:10>, [<BiomesOPlenty:coral2:8>]);
mods.mariculture.Anvil.removeRecipe(<minecraft:red_flower>);



# Add More Planets sulfur to the ore dictionary
<ore:dustSulfur>.add(<MorePlanet:sirius-b_item:2>);
<ore:ingotSulfur>.add(<MorePlanet:sirius-b_item:3>);


# Add recipe for Plutonium
#InputStack, InputFluid, InputGas, OutputStack, OutputGas, InputRF, Time in Ticks
mods.mekanism.Reaction.addRecipe(ingotCyanite_br*2, water_liq*1000, gasD*2952, <BigReactors:BRIngot:3>, gasWater*1000, 1000, 1000);


# Add recipe for Repulsive Explosives
#recipes.addShaped(<icbmclassic:icbmCExplosive:6>,
#	[[<icbmclassic:icbmCExplosive:0>],
#	[<icbmclassic:icbmCExplosive:0>]]);

	
# Allow inter-conversion between Mariculture and Mekanism plastic sheets
furnace.addRecipe(<Mariculture:crafting:5>, plastic_sheet);
mods.mekanism.Enrichment.addRecipe(<Mariculture:crafting:5>, plastic_sheet);
#recipes.addShapeless(plastic_sheet, [<Mariculture:crafting:5>]);
#recipes.addShapeless(<Mariculture:crafting:5>, [plastic_sheet]);


# Craft generic meta bone into ordinary bone
recipes.addShapeless(<minecraft:bone:0>, [<minecraft:bone:*>]);


# Allow player to craft variant obsidian snakestone blocks into the basic type
recipes.addShapeless(<chisel:obsidian_snakestone:1>, [<chisel:obsidian_snakestone:*>]);



# Add single-dye wool recipes

val singledyewoolmatrix = [
	<minecraft:wool:0>,
	<minecraft:wool:1>,
	<minecraft:wool:2>,
	<minecraft:wool:3>,
	<minecraft:wool:4>,
	<minecraft:wool:5>,
	<minecraft:wool:6>,
	<minecraft:wool:7>,
	<minecraft:wool:8>,
	<minecraft:wool:9>,
	<minecraft:wool:10>,
	<minecraft:wool:11>,
	<minecraft:wool:12>,
	<minecraft:wool:13>,
	<minecraft:wool:14>,
	<minecraft:wool:15>,
] as IItemStack[];

for i, wool in singledyewoolmatrix {
	recipes.addShapeless(wool, [oreDyes[i],<minecraft:wool:*>]);
}



# Touch up berry/grain lists

val berrylist = [
	<BiomesOPlenty:food:0>,
	<Natura:berry:0>, # Raspberry
	<Natura:berry:1>, # Blueberry
	<Natura:berry:2>, # Blackberry
	<Natura:berry:3>, # Maloberry
	<Natura:berry.nether:0>, # Blightberry
	<Natura:berry.nether:1>, # Duskberry
	<Natura:berry.nether:2>, # skyberry
	<Natura:berry.nether:3>, # Stingberry
] as IItemStack[];

for berry in berrylist {
	
	<ore:listAllfruit>.add(berry);
	<ore:listAllberry>.add(berry);
	<ore:foodFruit>.add(berry);
	
}

<ore:cropRaspberry>.add(<Natura:berry:0>);
<ore:cropBlueberry>.add(<Natura:berry:1>);
<ore:cropBlackberry>.add(<Natura:berry:2>);
<ore:cropMaloberry>.add(<Natura:berry:3>);
<ore:cropBlightberry>.add(<Natura:berry.nether:0>);
<ore:cropDuskberry>.add(<Natura:berry.nether:1>);
<ore:cropSkyberry>.add(<Natura:berry.nether:2>);
<ore:cropStingberry>.add(<Natura:berry.nether:3>);

<ore:listAllfruit>.add(<minecraft:melon>);
<ore:listAllgrain>.add(<Growthcraft|Rice:grc.rice>);
<ore:listAllgrain>.add(<Natura:barleyFood:0>);
<ore:cropBarley>.add(<Natura:barleyFood:0>);
<ore:flourEqualswheat>.add(<Natura:barleyFood:1>);
<ore:flourEqualswheat>.add(<Natura:barleyFood:2>);
<ore:flourEqualswheat>.add(<ganysnether:flour>);
<ore:dustWheat>.add(<Natura:barleyFood:1>);
<ore:dustWheat>.add(<Natura:barleyFood:2>);
<ore:foodFlour>.add(<Natura:barleyFood:1>);
<ore:foodFlour>.add(<Natura:barleyFood:2>);
<ore:foodFlour>.add(<ganysnether:flour>);


# Add 1.13 recipe for packed ice
recipes.addShapeless(<minecraft:packed_ice>, [<minecraft:ice>,<minecraft:ice>,<minecraft:ice>,<minecraft:ice>,<minecraft:ice>,<minecraft:ice>,<minecraft:ice>,<minecraft:ice>,<minecraft:ice>]);


# Add bloodwood to sawmill
# Not necessary since Jonathan's Natura branch takes care of this
#mods.mekanism.Sawmill.addRecipe(<Natura:bloodwood>, <Natura:planks:4> * 6, <Mekanism:Sawdust> * 1, 1.00);


### Mekanism plastic barriers don't have recipes besides white!

val plasticfencematrix = [
	
	[<Mekanism:PlasticFence:0>, <Mekanism:PlasticBlock:0>],
	[<Mekanism:PlasticFence:1>, <Mekanism:PlasticBlock:1>],
	[<Mekanism:PlasticFence:2>, <Mekanism:PlasticBlock:2>],
	[<Mekanism:PlasticFence:3>, <Mekanism:PlasticBlock:3>],
	[<Mekanism:PlasticFence:4>, <Mekanism:PlasticBlock:4>],
	[<Mekanism:PlasticFence:5>, <Mekanism:PlasticBlock:5>],
	[<Mekanism:PlasticFence:6>, <Mekanism:PlasticBlock:6>],
	[<Mekanism:PlasticFence:7>, <Mekanism:PlasticBlock:7>],
	[<Mekanism:PlasticFence:8>, <Mekanism:PlasticBlock:8>],
	[<Mekanism:PlasticFence:9>, <Mekanism:PlasticBlock:9>],
	[<Mekanism:PlasticFence:10>, <Mekanism:PlasticBlock:10>],
	[<Mekanism:PlasticFence:11>, <Mekanism:PlasticBlock:11>],
	[<Mekanism:PlasticFence:12>, <Mekanism:PlasticBlock:12>],
	[<Mekanism:PlasticFence:13>, <Mekanism:PlasticBlock:13>],
	[<Mekanism:PlasticFence:14>, <Mekanism:PlasticBlock:14>],
	[<Mekanism:PlasticFence:15>, <Mekanism:PlasticBlock:15>],
	
] as IItemStack [][];

for i, entry in plasticfencematrix {

	recipes.addShaped(entry[0]*3,
		[[entry[1], plaStick, entry[1]],
		 [entry[1], plaStick, entry[1]]]);
	recipes.addShapeless(entry[0]*3, [<Mekanism:PlasticFence:*>,<Mekanism:PlasticFence:*>,<Mekanism:PlasticFence:*>, oreDyes[15-i]]);

}



### Re-add Ancient Staff recipe
recipes.addShaped(<BiomesOPlenty:ancientStaff:0>,
	[
	[<BiomesOPlenty:ancientStaff:3>],
	[<BiomesOPlenty:ancientStaff:2>],
	[<BiomesOPlenty:ancientStaff:1>]
	]);
recipes.addShapeless(<BiomesOPlenty:ancientStaff:0>, [<BiomesOPlenty:ancientStaff:4>, <minecraft:nether_star>]);
	
recipes.addShaped(<BiomesOPlenty:ancientStaff:1>,
	[
	[<minecraft:end_stone>, gemSapphire_bop, <minecraft:end_stone>],
	[<minecraft:end_stone>,gemTanzanite_bop, <minecraft:end_stone>],
	[null,<minecraft:end_stone>,null]
	]);

recipes.addShaped(<BiomesOPlenty:ancientStaff:2>,
	[
	[<minecraft:end_stone>, gemPeridot_bop, <minecraft:end_stone>],
	[<minecraft:end_stone>,<minecraft:end_stone>, <minecraft:end_stone>],
	[<minecraft:end_stone>,gemMalachite_bop,<minecraft:end_stone>]
	]);

recipes.addShaped(<BiomesOPlenty:ancientStaff:3>,
	[
	[null, <minecraft:nether_star>, null],
	[<minecraft:end_stone>,gemRuby_bop, <minecraft:end_stone>],
	[<minecraft:end_stone>,gemTopaz_bop,<minecraft:end_stone>]
	]);

# Craft red/black wax into red/black candles
recipes.addShapeless(<harvestcraft:pamcandleDeco15>*4,[<Growthcraft|Bees:grcbees.BeesWax:1>,itemString]);
recipes.addShapeless(<harvestcraft:pamcandleDeco16>*4,[<Growthcraft|Bees:grcbees.BeesWax:2>,itemString]);


# Craft Harvestcraft maple logs into Natura maple logs
recipes.addShapeless(<Natura:Rare Tree:0>, [<harvestcraft:pamMaple>]);


# Allow Gysahl to be crushed into bio fuel
mods.mekanism.Crusher.addRecipe(<chococraft:Gysahl_Seeds>, <Mekanism:BioFuel>*1);


# Add foods to cooking oil types
recipes.addShapeless(<harvestcraft:oliveoilItem>, [<harvestcraft:juicerItem>,<ore:cropAvocado>]);
#recipes.addShapeless(<harvestcraft:oliveoilItem>, [<harvestcraft:juicerItem>,<ore:cropCoconut>]); #Conflicts with coconut oil
#mods.mekanism.Crusher.addRecipe(<harvestcraft:coconutItem>, <harvestcraft:oliveoilItem>);
mods.mekanism.Enrichment.addRecipe(<harvestcraft:coconutItem>, <harvestcraft:oliveoilItem>);
recipes.addShapeless(<harvestcraft:oliveoilItem>, [<harvestcraft:juicerItem>,<ore:cropSesameseeds>]);
recipes.addShapeless(<harvestcraft:oliveoilItem>, [<harvestcraft:juicerItem>,<BiomesOPlenty:colorizedSaplings:2>]);



# Make Fossils glass types their own chisel category
mods.chisel.Groups.addGroup("fossilglass"); 
mods.chisel.Groups.addVariation("fossilglass", <fossil:strongGlass>);
mods.chisel.Groups.addVariation("fossilglass", <fossil:ancientGlass>);


# Change Chisel Al blocks to TC
val Alblock_a = [
	<chisel:aluminumblock:0>,
	<chisel:aluminumblock:1>,
	<chisel:aluminumblock:2>,
	<chisel:aluminumblock:3>,
	<chisel:aluminumblock:4>,
	<chisel:aluminumblock:5>,
] as IItemStack[];

for outAlblock in Alblock_a {
	recipes.addShapeless(<TConstruct:MetalBlock:6>, [outAlblock]);
}


# Add wrought iron to metallurgic infuser
mods.mekanism.Infuser.addRecipe("CARBON", 10, ingotFe_mc, <GardenStuff:wrought_iron_ingot>);


# Add Railcraft brick variations to Nether Brick

val netherbrick_rc = [
	<Railcraft:brick.nether:1>,
	<Railcraft:brick.nether:2>,
	<Railcraft:brick.nether:3>,
	<Railcraft:brick.nether:4>,
] as IItemStack[];

for nbrick in netherbrick_rc {
	mods.chisel.Groups.addVariation("nether_brick", nbrick);
}


# Slimy sapling because I've deactivated islands
recipes.addShapeless(<TConstruct:slime.sapling>, [<TConstruct:CraftedSoil:2>, <BiomesOPlenty:saplings:3>]);


### Turn hardened dirt into regular dirt

val dirtin_cic = [
	<BiomesOPlenty:driedDirt>,
	<BiomesOPlenty:newBopDirt:0>,
	<BiomesOPlenty:newBopDirt:1>,
	<BiomesOPlenty:newBopDirt:2>,
	<BiomesOPlenty:newBopDirt:3>,
	<BiomesOPlenty:newBopDirt:4>,
	<BiomesOPlenty:newBopDirt:5>,
	<BiomesOPlenty:hardDirt>,
] as IItemStack[];

val dirtour_cic = [
	<minecraft:dirt>,
	<minecraft:dirt>,
	<etfuturum:coarse_dirt>,
	<minecraft:dirt>,
	<etfuturum:coarse_dirt>,
	<minecraft:dirt>,
	<etfuturum:coarse_dirt>,
	<etfuturum:coarse_dirt>,
] as IItemStack[];

for i, entry in dirtour_cic {
	mods.mekanism.chemical.Injection.addRecipe(dirtin_cic[i], gasHCl, entry);
}


### There's no lapis-block-to-lapis recipe for some reason
recipes.addShapeless(lapis_mc*9, [<minecraft:lapis_block>]);


### Add weather anemometer
#recipes.addShaped(<weather2:Anemometer>,
#	[
#	[null, ingotFe_mc, null],
#	[ingotFe_mc, ingotFe_mc, ingotFe_mc],
#	[redstone_mc, ingotFe_mc, redstone_mc]
#	]);


### Add light gray concrete powder recipe because it's funny
recipes.addShapeless(<VillageNames:concretePowder:8>*9,
	[<VillageNames:concretePowder:0>,<VillageNames:concretePowder:0>,<VillageNames:concretePowder:0>,
	<VillageNames:concretePowder:1>,
	<VillageNames:concretePowder:5>,
	<VillageNames:concretePowder:7>,
	<VillageNames:concretePowder:9>,
	<VillageNames:concretePowder:10>,
	<VillageNames:concretePowder:15>,
	]);


### Add recipe for Prismarine shard
#mods.mekanism.chemical.Injection.addRecipe(<minecraft:sand>*4, gasWater, <VillageNames:prismarine_shard>);

### Add recipe to turn prismarine shard into crystal
#mods.mekanism.Infuser.addRecipe("REDSTONE", 10, <VillageNames:prismarine_shard>, <VillageNames:prismarine_crystals>);


### Make Elytra recipe

#backlytra:elytra
#HardcoreEnderExpansion:essence
#fossil:scarabGem
#etfuturum:end_rod
#TConstruct:travelWings
#recipes.addShaped(<backlytra:elytra>,
#	[
#	[<HardcoreEnderExpansion:essence>, <CrystalWing:crystalwing.crystalWing>, <HardcoreEnderExpansion:essence>],
#	[<HardcoreEnderExpansion:essence>,<etfuturum:end_rod>, <HardcoreEnderExpansion:essence>]
#	]);


# Re-add vanilla shovels so you can plant rice
recipes.addShaped(<minecraft:iron_shovel>, [[ingotFe_mc],[stickWood_ore],[stickWood_ore]]);
recipes.addShaped(<minecraft:golden_shovel>, [[<minecraft:gold_ingot>],[stickWood_ore],[stickWood_ore]]);
#recipes.addShaped(<minecraft:diamond_shovel>, [[diamond_mc],[stickWood_ore],[stickWood_ore]]);

# Make green dye from yellow and cyan
recipes.removeShapeless(<minecraft:dye:2>*2, [<minecraft:dye:11>,lapis_mc]);
recipes.addShapeless(<BiomesOPlenty:misc:7>*2, [<ore:dyeYellow>,<ore:dyeCyan>]);

# Make red dye from magenta and yellow
recipes.addShapeless(<Mariculture:materials:31>*2, [<ore:dyeMagenta>,<ore:dyeYellow>]);

# Make blue dye from cyan and magenta
recipes.addShapeless(<BiomesOPlenty:misc:5>*2, [<ore:dyeCyan>,<ore:dyeMagenta>]);

# Make black dye from all three
recipes.addShapeless(<minecraft:dye:8>*3, [<ore:dyeCyan>,<ore:dyeMagenta>,<ore:dyeYellow>]);


# Add Voltz screwdriver because you need it for MFFS
recipes.addShaped(<voltzengine:ve.screwdriver>,
 [[null, ingotSteel_ore],
  [stickWood_ore, null]]);


# Add pine nuts to the oredict
<ore:listAllnut>.add(<ganyssurface:pineNuts>);

# Mirror grape and grapes
<ore:cropGrape>.addAll(<ore:cropGrapes>);
<ore:cropGrapes>.mirror(<ore:cropGrape>); 

# Recipe for green heart and canister
recipes.addShaped(<TConstruct:heartCanister:5>,
 [[goldegg_eg, goldegg_eg, goldegg_eg],
  [goldegg_eg, <TConstruct:heartCanister:3>, goldegg_eg],
  [goldegg_eg, goldegg_eg, goldegg_eg]]);
recipes.addShapeless(<TConstruct:heartCanister:6>, [<TConstruct:heartCanister:2>, 	<TConstruct:heartCanister:4>, <minecraft:nether_star>, <TConstruct:heartCanister:5>]);


# Re-add diamond sword
recipes.addShaped(<minecraft:diamond_sword>,
 [[diamond_mc],
  [diamond_mc],
  [stickWood_ore]]);

# Allow BoP pinecones to make pine nuts
recipes.addShapeless(<ganyssurface:pineNuts>, [<BiomesOPlenty:misc:13>]);


# Allow Chemical Injection Chamber usage for Railcraft poor ores

val orein_a = [
	<Railcraft:ore:7>,
	#<Railcraft:ore:8>,
	<Railcraft:ore:9>,
	<Railcraft:ore:10>,
	<Railcraft:ore:11>,
] as IItemStack[];

val shardout_a = [
	<Mekanism:Shard:0>,
	#<Mekanism:Shard:1>,
	<Mekanism:Shard:3>,
	<Mekanism:Shard:4>,
	<Mekanism:Shard:6>,
] as IItemStack[];

for i, entry in shardout_a {
	mods.mekanism.chemical.Injection.addRecipe(orein_a[i], gasHCl, entry);
}


# Crush cracked sand into hardened sand into sand
//mods.mekanism.Crusher.addRecipe(<ExtrabiomesXL:terrain_blocks2>, <BiomesOPlenty:hardSand>);
mods.mekanism.Crusher.addRecipe(<BiomesOPlenty:hardSand>, <minecraft:sand:1>);


# Square up the Mekanism crusher

mods.mekanism.Crusher.removeRecipe(<Mekanism:BioFuel>*2, <minecraft:wheat_seeds>);
mods.mekanism.Crusher.removeRecipe(<Mekanism:BioFuel>*2, <minecraft:pumpkin_seeds>);
mods.mekanism.Crusher.removeRecipe(<Mekanism:BioFuel>*2, <minecraft:melon_seeds>);

val crusherin_a = [
	# Big Reactors
	ingotYellorium_br,
	ingotCyanite_br,
	<BigReactors:BRIngot:2>,
	<BigReactors:BRIngot:3>,
	<BigReactors:BRIngot:8>,
	# HEE
	<HardcoreEnderExpansion:endium_ingot>,
	# Metallurgy
	<Metallurgy:manganese.ingot>,
	<Metallurgy:bronze.ingot>,
	<Metallurgy:hepatizon.ingot>,
	<Metallurgy:damascus.steel.ingot>,
	<Metallurgy:angmallen.ingot>,
	#<Metallurgy:steel.ingot>,
	<Metallurgy:eximite.ingot>,
	<Metallurgy:meutoite.ingot>,
	<Metallurgy:desichalkos.ingot>,
	<Metallurgy:prometheum.ingot>,
	<Metallurgy:deep.iron.ingot>,
	<Metallurgy:infuscolium.ingot>,
	<Metallurgy:black.steel.ingot>,
	<Metallurgy:oureclase.ingot>,
	<Metallurgy:astral.silver.ingot>,
	<Metallurgy:carmot.ingot>,
	<Metallurgy:mithril.ingot>,
	<Metallurgy:rubracium.ingot>,
	<Metallurgy:quicksilver.ingot>,
	<Metallurgy:haderoth.ingot>,
	<Metallurgy:orichalcum.ingot>,
	<Metallurgy:celenegil.ingot>,
	<Metallurgy:adamantine.ingot>,
	<Metallurgy:atlarus.ingot>,
	<Metallurgy:tartarite.ingot>,
	<Metallurgy:ignatius.ingot>,
	<Metallurgy:shadow.iron.ingot>,
	<Metallurgy:lemurite.ingot>,
	<Metallurgy:midasium.ingot>,
	<Metallurgy:vyroxeres.ingot>,
	<Metallurgy:ceruclase.ingot>,
	<Metallurgy:alduorite.ingot>,
	<Metallurgy:kalendrite.ingot>,
	<Metallurgy:vulcanite.ingot>,
	<Metallurgy:sanguinite.ingot>,
	<Metallurgy:shadow.steel.ingot>,
	<Metallurgy:inolashite.ingot>,
	<Metallurgy:amordrine.ingot>,
	<Metallurgy:zinc.ingot>,
	#<Metallurgy:silver.ingot>,
	<Metallurgy:platinum.ingot>,
	<Metallurgy:brass.ingot>,
	<Metallurgy:electrum.ingot>,
	# Thermal Foundation
	<ThermalFoundation:material:69>,
	<ThermalFoundation:material:70>,
	<ThermalFoundation:material:73>,
	# Voltz Engine
#	<voltzengine:veIngot:18>,
#	<voltzengine:veIngot:3>,
	<minecraft:wheat_seeds>,
	<minecraft:pumpkin_seeds>,
	<minecraft:melon_seeds>,
	<BiomesOPlenty:turnipSeeds>,
	<GardenTrees:candelilla_seeds>,
	<Growthcraft|Grapes:grc.grapeSeeds>,
	<Growthcraft|Hops:grc.hopSeeds>,
	<Growthcraft|Milk:grcmilk.SeedThistle>,
	<Mariculture:crafting:21>,
	<MorePlanet:fronos_food:10>,
	<MorePlanet:strawberry_seed>,
	<MorePlanet:golden_seeds>,
	<Natura:barley.seed:*>,
	<Natura:saguaro.fruit>,
	<fossil:seed:*>,
	<ganyssurface:beetrootSeeds>,
	<harvestcraft:sunflowerseedsItem>,
	<harvestcraft:mustardseedsItem>,
	<harvestcraft:sesameseedsItem>,
	<harvestcraft:blackberryseedItem>,
	<harvestcraft:blueberryseedItem>,
	<harvestcraft:candleberryseedItem>,
	<harvestcraft:raspberryseedItem>,
	<harvestcraft:strawberryseedItem>,
	<harvestcraft:grapeseedItem>,
	<harvestcraft:cactusfruitseedItem>,
	<harvestcraft:asparagusseedItem>,
	<harvestcraft:barleyseedItem>,
	<harvestcraft:oatsseedItem>,
	<harvestcraft:ryeseedItem>,
	<harvestcraft:cornseedItem>,
	<harvestcraft:bambooshootseedItem>,
	<harvestcraft:cantaloupeseedItem>,
	<harvestcraft:cucumberseedItem>,
	<harvestcraft:wintersquashseedItem>,
	<harvestcraft:zucchiniseedItem>,
	<harvestcraft:beetseedItem>,
	<harvestcraft:onionseedItem>,
	<harvestcraft:parsnipseedItem>,
	<harvestcraft:peanutseedItem>,
	<harvestcraft:radishseedItem>,
	<harvestcraft:rutabagaseedItem>,
	<harvestcraft:sweetpotatoseedItem>,
	<harvestcraft:turnipseedItem>,
	<harvestcraft:rhubarbseedItem>,
	<harvestcraft:celeryseedItem>,
	<harvestcraft:garlicseedItem>,
	<harvestcraft:gingerseedItem>,
	<harvestcraft:spiceleafseedItem>,
	<harvestcraft:teaseedItem>,
	<harvestcraft:coffeeseedItem>,
	<harvestcraft:mustardseedItem>,
	<harvestcraft:broccoliseedItem>,
	<harvestcraft:cauliflowerseedItem>,
	<harvestcraft:leekseedItem>,
	<harvestcraft:lettuceseedItem>,
	<harvestcraft:scallionseedItem>,
	<harvestcraft:artichokeseedItem>,
	<harvestcraft:brusselsproutseedItem>,
	<harvestcraft:cabbageseedItem>,
	<harvestcraft:spinachseedItem>,
	<harvestcraft:beanseedItem>,
	<harvestcraft:soybeanseedItem>,
	<harvestcraft:bellpepperseedItem>,
	<harvestcraft:chilipepperseedItem>,
	<harvestcraft:eggplantseedItem>,
	<harvestcraft:okraseedItem>,
	<harvestcraft:peasseedItem>,
	<harvestcraft:tomatoseedItem>,
	<harvestcraft:cottonseedItem>,
	<harvestcraft:pineappleseedItem>,
	<harvestcraft:curryleafseedItem>,
	<harvestcraft:sesameseedsseedItem>,
	<harvestcraft:kiwiseedItem>,
	<harvestcraft:cranberryseedItem>,
	<harvestcraft:riceseedItem>,
	<harvestcraft:seaweedseedItem>,
	<harvestcraft:waterchestnutseedItem>,
	<jaffa:kaleSeed>,
	<weeeflowers:White Flower Seed>,
	<weeeflowers:Orange Flower Seed>,
	<weeeflowers:Magenta Flower Seed>,
	<weeeflowers:Light Blue Flower Seed>,
	<weeeflowers:Yellow Flower Seed>,
	<weeeflowers:Lime Flower Seed>,
	<weeeflowers:Pink Flower Seed>,
	<weeeflowers:Light Grey Flower Seed>,
	<weeeflowers:Dark Grey Flower Seed>,
	<weeeflowers:Cyan Flower Seed>,
	<weeeflowers:Purple Flower Seed>,
	<weeeflowers:Blue Flower Seed>,
	<weeeflowers:Brown Flower Seed>,
	<weeeflowers:Green Flower Seed>,
	<weeeflowers:Red Flower Seed>,
	<weeeflowers:Black Flower Seed>,
	<witchery:ingredient:70>,
	<witchery:seedsbelladonna>,
	<witchery:seedsmandrake>,
	<witchery:seedsartichoke>,
	<witchery:seedssnowbell>,
	<witchery:seedswormwood>,
	<witchery:seedswolfsbane>,
	<Growthcraft|Rice:grc.rice>,
	<harvestcraft:riceItem>,
	<GardenTrees:sapling:*>,
	<harvestcraft:pamappleSapling>,
	<harvestcraft:pamalmondSapling>,
	<harvestcraft:pamapricotSapling>,
	<harvestcraft:pamavocadoSapling>,
	<harvestcraft:pambananaSapling>,
	<harvestcraft:pamcashewSapling>,
	<harvestcraft:pamcherrySapling>,
	<harvestcraft:pamchestnutSapling>,
	<harvestcraft:pamcinnamonSapling>,
	<harvestcraft:pamcoconutSapling>,
	<harvestcraft:pamdateSapling>,
	<harvestcraft:pamdragonfruitSapling>,
	<harvestcraft:pamdurianSapling>,
	<harvestcraft:pamfigSapling>,
	<harvestcraft:pamgrapefruitSapling>,
	<harvestcraft:pamlemonSapling>,
	<harvestcraft:pamlimeSapling>,
	<harvestcraft:pammapleSapling>,
	<harvestcraft:pammangoSapling>,
	<harvestcraft:pamnutmegSapling>,
	<harvestcraft:pamoliveSapling>,
	<harvestcraft:pamorangeSapling>,
	<harvestcraft:pampapayaSapling>,
	<harvestcraft:pampeachSapling>,
	<harvestcraft:pampearSapling>,
	<harvestcraft:pampecanSapling>,
	<harvestcraft:pampeppercornSapling>,
	<harvestcraft:pampersimmonSapling>,
	<harvestcraft:pampistachioSapling>,
	<harvestcraft:pamplumSapling>,
	<harvestcraft:pampomegranateSapling>,
	<harvestcraft:pamstarfruitSapling>,
	<harvestcraft:pamvanillabeanSapling>,
	<harvestcraft:pamwalnutSapling>,
	<harvestcraft:pamgooseberrySapling>,
] as IItemStack[];


val crusherout_a = [
	
	# Big Reactors
	<BigReactors:BRIngot:4>,
	<BigReactors:BRIngot:5>,
	<BigReactors:BRIngot:6>,
	<BigReactors:BRIngot:7>,
	<BigReactors:BRIngot:9>,
	# HEE
	<aobd:dustHeeEndium>,
	# Metallurgy
	<Metallurgy:base.dust:2>,
	<Metallurgy:base.dust:3>,
	<Metallurgy:base.dust:4>,
	<Metallurgy:base.dust:5>,
	<Metallurgy:base.dust:6>,
	#<Metallurgy:base.dust:7>,
	<Metallurgy:ender.dust:0>,
	<Metallurgy:ender.dust:1>,
	<Metallurgy:ender.dust:2>,
	<Metallurgy:fantasy.dust:0>,
	<Metallurgy:fantasy.dust:1>,
	<Metallurgy:fantasy.dust:2>,
	<Metallurgy:fantasy.dust:3>,
	<Metallurgy:fantasy.dust:4>,
	<Metallurgy:fantasy.dust:5>,
	<Metallurgy:fantasy.dust:6>,
	<Metallurgy:fantasy.dust:7>,
	<Metallurgy:fantasy.dust:8>,
	<Metallurgy:fantasy.dust:9>,
	<Metallurgy:fantasy.dust:10>,
	<Metallurgy:fantasy.dust:11>,
	<Metallurgy:fantasy.dust:12>,
	<Metallurgy:fantasy.dust:13>,
	<Metallurgy:fantasy.dust:14>,
	<Metallurgy:fantasy.dust:15>,
	<Metallurgy:nether.dust:0>,
	<Metallurgy:nether.dust:1>,
	<Metallurgy:nether.dust:2>,
	<Metallurgy:nether.dust:3>,
	<Metallurgy:nether.dust:4>,
	<Metallurgy:nether.dust:5>,
	<Metallurgy:nether.dust:6>,
	<Metallurgy:nether.dust:7>,
	<Metallurgy:nether.dust:8>,
	<Metallurgy:nether.dust:9>,
	<Metallurgy:nether.dust:10>,
	<Metallurgy:nether.dust:11>,
	<Metallurgy:nether.dust:12>,
	<Metallurgy:precious.dust:0>,
	#<Metallurgy:precious.dust:1>,
	<Metallurgy:precious.dust:2>,
	<Metallurgy:precious.dust:3>,
	<Metallurgy:precious.dust:4>,
	# Thermal Foundation
	<ThermalFoundation:material:37>,
	<ThermalFoundation:material:38>,
	<ThermalFoundation:material:41>,
	# Voltz Engine
#	<voltzengine:veDust:18>,
#	<voltzengine:veDust:3>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
	<Mekanism:BioFuel>*2,
] as IItemStack[];

for i, entry in crusherout_a {
	mods.mekanism.Crusher.addRecipe(crusherin_a[i], entry);
}



# Change seeds to refine to one bio fuel,




# Mass furnace additions

val furnacein = [

	[<witchery:ingredient:18>, <GardenTrees:sapling:*>],
	[<witchery:ingredient:18>, <harvestcraft:pamappleSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamalmondSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamapricotSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamavocadoSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pambananaSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamcashewSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamcherrySapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamchestnutSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamcinnamonSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamcoconutSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamdateSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamdragonfruitSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamdurianSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamfigSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamgrapefruitSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamlemonSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamlimeSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pammapleSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pammangoSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamnutmegSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamoliveSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamorangeSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampapayaSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampaperbarkSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampeachSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampearSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampecanSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampeppercornSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampersimmonSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampistachioSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamplumSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pampomegranateSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamstarfruitSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamvanillabeanSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamwalnutSapling>],
	[<witchery:ingredient:18>, <harvestcraft:pamgooseberrySapling>],
	[<minecraft:sand:0>, <BiomesOPlenty:mud:1>],
	
] as IItemStack[][];

for entry in furnacein {
	furnace.addRecipe(entry[0], entry[1]);
}



# Add new ways to make Egg Sandwich
recipes.addShapeless(<EggyGoodness:eggSandwich>, [<EggyGoodness:friedEgg>, <minecraft:bread>]);
recipes.addShapeless(<EggyGoodness:eggSandwich>, [<EggyGoodness:friedDoubleYolkEgg>, <minecraft:bread>]);


# Add crafting recipes for chainmail
# First remove Iron Nugget recipes, hurf
#recipes.remove(<Mariculture:materials:33>);
#recipes.remove(<TConstruct:materials:19>);
#recipes.remove(<ThermalFoundation:material:8>);


recipes.remove(<minecraft:chainmail_helmet>);
recipes.addShaped(<minecraft:chainmail_helmet>,
 [[ingotFe_ore, ingotFe_ore, ingotFe_ore],
  [nuggetFe_ore, null, nuggetFe_ore]]);

recipes.remove(<minecraft:chainmail_chestplate>);
recipes.addShaped(<minecraft:chainmail_chestplate>,
 [[ingotFe_ore, null, ingotFe_ore],
  [nuggetFe_ore, nuggetFe_ore, nuggetFe_ore],
  [ingotFe_ore, ingotFe_ore, ingotFe_ore]]);

recipes.remove(<minecraft:chainmail_leggings>);
recipes.addShaped(<minecraft:chainmail_leggings>,
 [[ingotFe_ore, ingotFe_ore, ingotFe_ore],
  [nuggetFe_ore, null, nuggetFe_ore],
  [ingotFe_ore, null, ingotFe_ore]]);

recipes.remove(<minecraft:chainmail_boots>);
recipes.addShaped(<minecraft:chainmail_boots>,
 [[nuggetFe_ore, null, nuggetFe_ore],
  [ingotFe_ore, null, ingotFe_ore]]);





#############
### Fixes ###
#############

recipes.remove(<fossil:analyzer>);
recipes.addShaped(<fossil:analyzer>,
 [[ingotFe_ore, <fossil:relicScrap>, ingotFe_ore],
  [ingotFe_ore, <fossil:bioFossil>, ingotFe_ore]]);


  
