/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.handlers;

import com.ayutaki.chinjufumod.config.CMConfigCore_new;
import com.ayutaki.chinjufumod.worldgen.biomegen.BiomeIchoh;
import com.ayutaki.chinjufumod.worldgen.biomegen.BiomeKaede;
import com.ayutaki.chinjufumod.worldgen.biomegen.BiomeSakura;
import com.ayutaki.chinjufumod.worldgen.biomegen.ModBiomeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeHandler {
    public static final List<ModBiomeEntry> biomeEntryList = new ArrayList<ModBiomeEntry>();
    public static final BiomeSakura BIOME_SAKURA = new BiomeSakura();
    public static final BiomeKaede BIOME_KAEDE = new BiomeKaede();
    public static final BiomeIchoh BIOME_ICHOH = new BiomeIchoh();

    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        if (CMConfigCore_new.sakuraBiomeRegister) {
            event.getRegistry().register((IForgeRegistryEntry)BIOME_SAKURA);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_SAKURA, CMConfigCore_new.sakuraBiomeChance));
            BiomeManager.addSpawnBiome((Biome)BIOME_SAKURA);
        }
        if (!CMConfigCore_new.sakuraBiomeRegister) {
            // empty if block
        }
        if (CMConfigCore_new.kaedeBiomeRegister) {
            event.getRegistry().register((IForgeRegistryEntry)BIOME_KAEDE);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_KAEDE, CMConfigCore_new.kaedeBiomeChance));
            BiomeManager.addSpawnBiome((Biome)BIOME_KAEDE);
        }
        if (!CMConfigCore_new.kaedeBiomeRegister) {
            // empty if block
        }
        if (CMConfigCore_new.ichohBiomeRegister) {
            event.getRegistry().register((IForgeRegistryEntry)BIOME_ICHOH);
            BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)BIOME_ICHOH, CMConfigCore_new.ichohBiomeChance));
            BiomeManager.addSpawnBiome((Biome)BIOME_ICHOH);
        }
        if (!CMConfigCore_new.ichohBiomeRegister) {
            // empty if block
        }
    }

    private static void registerBiome(RegistryEvent.Register<Biome> event, ModBiomeBase biome, BiomeManager.BiomeType type, int weight, BiomeDictionary.Type ... biomeDictTypes) {
        event.getRegistry().register((IForgeRegistryEntry)biome);
        for (BiomeDictionary.Type biomeDictType : biomeDictTypes) {
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{biomeDictType});
        }
        biomeEntryList.add(new ModBiomeEntry(biome, type, weight));
    }

    public static class ModBiomeEntry {
        private final int weight;
        private final Biome biome;
        private final BiomeManager.BiomeType type;
        private final BiomeManager.BiomeEntry entry;

        private ModBiomeEntry(ModBiomeBase biome, BiomeManager.BiomeType type, int weight) {
            this.type = type;
            this.biome = biome;
            this.weight = weight;
            this.entry = new BiomeManager.BiomeEntry((Biome)biome, weight);
        }

        public ModBiomeBase getBiome() {
            return (ModBiomeBase)this.biome;
        }

        public BiomeManager.BiomeEntry getEntry() {
            return this.entry;
        }

        public BiomeManager.BiomeType getType() {
            return this.type;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

