/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.init.blocks;

import com.ayutaki.chinjufumod.init.ChinjufuModTabs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BaseRoof
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool COR = PropertyBool.func_177716_a((String)"cor");
    public static final PropertyEnum<SlabHalf> HALF = PropertyEnum.func_177709_a((String)"half", SlabHalf.class);
    protected static final AxisAlignedBB BOTTOM_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);

    protected BaseRoof(String unlocalizedName) {
        super(Material.field_151585_k);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("chinjufumod", unlocalizedName));
        this.func_149647_a(ChinjufuModTabs.tab_seasonal);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149713_g(2);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)COR, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)((Object)SlabHalf.BOTTOM)));
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P();
        if (facing.func_176740_k().func_176722_c()) {
            iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)COR, (Comparable)Boolean.valueOf(false));
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)((Object)(hitY > 0.5f ? SlabHalf.TOP : SlabHalf.BOTTOM)));
        } else {
            iblockstate = iblockstate.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)COR, (Comparable)Boolean.valueOf(false));
            iblockstate = iblockstate.func_177226_a(HALF, (Comparable)((Object)(facing == EnumFacing.UP ? SlabHalf.BOTTOM : SlabHalf.TOP)));
        }
        return iblockstate;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected static EnumFacing getFacing(int meta) {
        switch (meta & 3) {
            case 0: {
                return EnumFacing.NORTH;
            }
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.EAST;
    }

    protected static int getMetaForFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 0;
            }
            case SOUTH: {
                return 1;
            }
            case WEST: {
                return 2;
            }
        }
        return 3;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)BaseRoof.getFacing(meta)).func_177226_a((IProperty)COR, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a(HALF, (Comparable)((Object)((meta & 8) == 0 ? SlabHalf.BOTTOM : SlabHalf.TOP)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= BaseRoof.getMetaForFacing((EnumFacing)state.func_177229_b((IProperty)FACING));
        if (((Boolean)state.func_177229_b((IProperty)COR)).booleanValue()) {
            i |= 4;
        }
        if (state.func_177229_b(HALF) == SlabHalf.TOP) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COR, FACING, HALF});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return (face == EnumFacing.UP && state.func_177229_b(HALF) == SlabHalf.TOP || face == EnumFacing.DOWN && state.func_177229_b(HALF) == SlabHalf.BOTTOM) && (Boolean)state.func_177229_b((IProperty)COR) == false ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        AxisAlignedBB axisalignedbb = state.func_177229_b(HALF) == SlabHalf.TOP ? TOP_AABB : BOTTOM_AABB;
        return axisalignedbb;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(HALF) == SlabHalf.TOP;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        int meta = stack.func_77960_j();
        tooltip.add(I18n.func_135052_a((String)"tips.block_tabakusa_roof.name", (Object[])new Object[]{meta}));
    }

    public static enum SlabHalf implements IStringSerializable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private SlabHalf(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

