/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.init.chairs;

import com.ayutaki.chinjufumod.base.CollisionHelper;
import com.ayutaki.chinjufumod.base.SittableUtil;
import com.ayutaki.chinjufumod.entity.EntitySittableBlock;
import com.ayutaki.chinjufumod.handlers.SoundsHandler;
import com.ayutaki.chinjufumod.init.chairs.item.Chair_Items;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockAdmiralChair
extends Block {
    public static final String ID = "block_admiralchair";
    public static final PropertyInteger STAGE_1_2 = PropertyInteger.func_177719_a((String)"stage", (int)1, (int)2);
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    private static final AxisAlignedBB CHAIR_BASE = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.5625, 0.9);
    private static final AxisAlignedBB CHAIR_BACKREST_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.0, 0.5625, 0.0, 0.1, 2.0, 1.0);
    private static final AxisAlignedBB CHAIR_BACKREST_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.5625, 0.0, 0.1, 2.0, 1.0);
    private static final AxisAlignedBB CHAIR_BACKREST_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.0, 0.5625, 0.0, 0.1, 2.0, 1.0);
    private static final AxisAlignedBB CHAIR_BACKREST_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.5625, 0.0, 0.1, 2.0, 1.0);

    public BlockAdmiralChair() {
        super(Material.field_151575_d);
        this.setRegistryName(new ResourceLocation("chinjufumod", ID));
        this.func_149663_c(ID);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149713_g(1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)STAGE_1_2, (Comparable)Integer.valueOf(1)));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (SittableUtil.sitOnBlock(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), playerIn, 0.34375)) {
            worldIn.func_175666_e(pos, (Block)this);
            worldIn.func_184133_a(null, pos, SoundsHandler.SIT_CHAIR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= (Integer)state.func_177229_b((IProperty)STAGE_1_2) - 1 << 2;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)STAGE_1_2, (Comparable)Integer.valueOf(1 + (meta >> 2)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, STAGE_1_2});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return SittableUtil.isSomeoneSitting(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) ? 1 : 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean p_185477_7_) {
        if (!(entityIn instanceof EntitySittableBlock)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            switch (facing) {
                case SOUTH: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_SOUTH);
                    break;
                }
                case EAST: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_EAST);
                    break;
                }
                case WEST: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_WEST);
                    break;
                }
                default: {
                    Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BACKREST_NORTH);
                }
            }
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CHAIR_BASE);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos) && worldIn.func_175623_d(pos.func_177984_a());
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canSilkHarvest(World world, EntityPlayer player, int x, int y, int z, int metadata) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        int i = (Integer)state.func_177229_b((IProperty)STAGE_1_2);
        if (i == 1) {
            stack.add(new ItemStack((Item)Chair_Items.ADMIRALCHAIR, 1, 1));
        }
        if (i == 2) {
            stack.add(new ItemStack((Item)Chair_Items.ADMIRALCHAIR, 1, 2));
        }
        return stack;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int i = (Integer)state.func_177229_b((IProperty)STAGE_1_2);
        if (i == 2) {
            return new ItemStack((Item)Chair_Items.ADMIRALCHAIR, 1, 2);
        }
        return new ItemStack((Item)Chair_Items.ADMIRALCHAIR, 1, 1);
    }
}

