/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.init.crops;

import com.ayutaki.chinjufumod.base.BaseFacingSapo;
import com.ayutaki.chinjufumod.base.CollisionHelper;
import com.ayutaki.chinjufumod.init.crops.item.Crops_Items;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSeedsBox
extends BaseFacingSapo {
    public static final String ID = "block_seedsbox";
    private static final AxisAlignedBB BOUNDING_BOX_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.375, 0.0, 0.25, 0.625, 0.5, 0.75);
    private static final AxisAlignedBB BOUNDING_BOX_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.375, 0.0, 0.25, 0.625, 0.5, 0.75);
    private static final AxisAlignedBB BOUNDING_BOX_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.375, 0.0, 0.25, 0.625, 0.5, 0.75);
    private static final AxisAlignedBB BOUNDING_BOX_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.375, 0.0, 0.25, 0.625, 0.5, 0.75);
    private static final AxisAlignedBB[] BOUNDING_BOX = new AxisAlignedBB[]{BOUNDING_BOX_SOUTH, BOUNDING_BOX_WEST, BOUNDING_BOX_NORTH, BOUNDING_BOX_EAST};

    public BlockSeedsBox() {
        super(Material.field_151577_b);
        this.setRegistryName(new ResourceLocation("chinjufumod", ID));
        this.func_149663_c(ID);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.5f);
        this.func_149752_b(1.0f);
        this.func_149713_g(1);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return BOUNDING_BOX[facing.func_176736_b()];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    protected int getSaplingDropChance(IBlockState state) {
        return 10;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.getSaplingDropChance(state);
        if (fortune > 0 && (chance -= 11 << fortune) < 11) {
            chance = 11;
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_CABBAGE, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_SOY, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_SPINACH, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_TOMATO, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_CORN, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_ONION, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_RICE, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.SEEDS_HAKUSAI, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.CHANOKI, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.BUDOUNOKI, 1, this.func_180651_a(state)));
        }
        if (rand.nextInt(chance) == 0) {
            stack.add(new ItemStack((Item)Crops_Items.MIKAN, 1, this.func_180651_a(state)));
        }
        return stack;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

