/*
 * Decompiled with CFR 0.152.
 */
package com.ayutaki.chinjufumod.init.items.kansaiki.material;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MaterialDefinition {
    private final String prefix;
    private final ItemStack repairMaterial;
    private final Item.ToolMaterial material;
    private final List<Item> materialBasedItems;

    public MaterialDefinition(String prefix, Item.ToolMaterial material) {
        this(prefix, material, material.getRepairItemStack());
    }

    public MaterialDefinition(String prefix, Item.ToolMaterial material, ItemStack repairMaterial) {
        this.prefix = prefix;
        this.material = material;
        this.repairMaterial = repairMaterial;
        this.materialBasedItems = new LinkedList<Item>();
    }

    public void addItem(Item item) {
        this.materialBasedItems.add(item);
    }

    public float getDamageVsEntity() {
        return this.material.func_78000_c();
    }

    public float getEfficiencyOnProperMaterial() {
        return this.material.func_77998_b();
    }

    public int getEnchantability() {
        return this.material.func_77995_e();
    }

    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    public final List<Item> getMaterialBasedItems() {
        return this.materialBasedItems;
    }

    public int getMaxUses() {
        return this.material.func_77997_a();
    }

    public final String getPrefix() {
        return this.prefix;
    }

    public String getPrefixedName(String baseName) {
        return this.prefix + "_" + baseName;
    }

    public ItemStack getRepairMaterial() {
        return this.repairMaterial;
    }

    public void onEntityHit(Entity target) {
    }
}

