/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone;

import com.google.common.base.Predicate;
import com.google.common.reflect.Reflection;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Logger;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.magic.IProtectedEntity;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.ProtectedEntityStorage;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.capability.TBCapabilityStorage;
import ovh.corail.tombstone.compatibility.CompatibilityBloodMagic;
import ovh.corail.tombstone.compatibility.CompatibilityCosmeticArmor;
import ovh.corail.tombstone.compatibility.CompatibilityFirstAid;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.compatibility.CompatibilityOpenBlocks;
import ovh.corail.tombstone.compatibility.CompatibilityThaumcraft;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.TombstoneDataFixer;
import ovh.corail.tombstone.loot.AsGiftFunction;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.loot.KnowledgeRewardFunction;
import ovh.corail.tombstone.loot.PreciseEnchantFunction;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.proxy.IProxy;
import ovh.corail.tombstone.registry.ModStats;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

@Mod(modid="tombstone", name="Corail Tombstone", version="4.5.3", acceptedMinecraftVersions="[1.12.2,1.13)", dependencies="required-after:forge@[14.23.5.2838,);before:erebus;before:enderio;before:forgeessentials;before:quark;before:advanced-fishing", updateJSON="https://raw.githubusercontent.com/Corail31/tombstone_lite/master/update.json")
public class ModTombstone {
    @Mod.Instance(value="tombstone")
    public static ModTombstone instance;
    public static Logger LOGGER;
    @SidedProxy(clientSide="ovh.corail.tombstone.proxy.ClientProxy", serverSide="ovh.corail.tombstone.proxy.ServerProxy")
    public static IProxy PROXY;
    public static final EnumEnchantmentType typeTombstoneAll;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        TombstoneAPIProps.COOLDOWN_HANDLER = CooldownHandler.INSTANCE;
        Reflection.initialize((Class[])new Class[]{PacketHandler.class, ModStats.class, ModTriggers.class, ModTabs.class});
        CapabilityManager.INSTANCE.register(ITBCapability.class, (Capability.IStorage)new TBCapabilityStorage(), TBCapabilityDefault::new);
        CapabilityManager.INSTANCE.register(ISoulConsumer.class, TBSoulConsumerProvider.NULL_STORAGE, TBSoulConsumerProvider::getDefault);
        CapabilityManager.INSTANCE.register(IProtectedEntity.class, (Capability.IStorage)new ProtectedEntityStorage(), ProtectedEntityImpl::new);
        PacketHandler.init();
        SoundHandler.registerSounds();
        GameRegistry.registerTileEntity(TileEntityDecorativeGrave.class, (String)"tombstone:writable_grave");
        GameRegistry.registerTileEntity(TileEntityPlayerGrave.class, (String)"tombstone:tombstone");
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new DelayedNBTFunction.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new PreciseEnchantFunction.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new KnowledgeRewardFunction.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new AsGiftFunction.Serializer());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Helper.registerOreDicts();
        PROXY.init(event);
        TombstoneDataFixer.init();
        if (SupportMods.BLOOD_MAGIC.isLoaded()) {
            LOGGER.warn("Enabling the patch for Blood Magic (preventing the sacrificial dagger from killing a player twice, causing them to lose their inventory), you won't see this message again if you update your Blood Magic version.");
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityBloodMagic.instance);
        }
        if (SupportMods.THAUMCRAFT.isLoaded() && ConfigTombstone.compatibilities.allowThaumcraftVisValues) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityThaumcraft.instance);
        }
        if (SupportMods.TOP.isLoaded()) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"ovh.corail.tombstone.compatibility.IntegrationTOP");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void onServerStarted(FMLServerStartingEvent event) {
        TimeHelper.init();
        ConfigTombstone.updateServerDatas();
        if (ConfigTombstone.player_death.handlePlayerDeath && CompatibilityGraveStone.instance.isNightKosh()) {
            CompatibilityGraveStone.instance.disable();
        }
        if (SupportMods.OPENBLOCKS.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityOpenBlocks.instance);
        }
        if (SupportMods.COSMETIC_ARMOR.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityCosmeticArmor.instance);
        }
        if (SupportMods.FIRST_AID.isLoaded()) {
            MinecraftForge.EVENT_BUS.register((Object)CompatibilityFirstAid.instance);
        }
        Helper.initCommands(event);
        TameableType.init();
    }

    @Mod.EventHandler
    public void onServerStoppingEvent(FMLServerStoppedEvent event) {
        CallbackHandler.flushTasks();
        PlayerPreference.clear();
        CooldownHandler.INSTANCE.clear();
    }

    static {
        typeTombstoneAll = Helper.addEnchantmentType("typeTombstoneAll", (Predicate<Item>)((Predicate)p -> p != null && (p.func_77639_j() == 1 || p.func_77619_b() > 0)), EnumEnchantmentType.ALL);
    }
}

