/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import ovh.corail.tombstone.api.capability.Perk;

public interface ITBCapability
extends INBTSerializable<NBTTagCompound> {
    public long getKnowledge();

    public ITBCapability setKnowledge(long var1);

    default public void reward(EntityPlayerMP player, int knowledge, int alignment) {
    }

    @Deprecated
    default public ITBCapability addKnowledgeAndSync(EntityPlayerMP player, long points) {
        this.reward(player, (int)points, 0);
        return this;
    }

    default public void loseKnowledge(EntityPlayerMP player, int points) {
    }

    @Deprecated
    default public ITBCapability removeKnowledgeAndSync(EntityPlayerMP player, long points) {
        this.loseKnowledge(player, (int)points);
        return this;
    }

    public long getKnowledgeForLevel(int var1);

    public long getKnowledgeToReachNextLevel(int var1);

    public int getUsedPerkPoints(EntityPlayer var1);

    public int getTotalPerkPoints();

    public Map<Perk, Integer> getPerks();

    public ITBCapability setPerks(Map<Perk, Integer> var1);

    public ITBCapability setPerk(Perk var1, int var2);

    public boolean removePerk(Perk var1);

    public int getPerkLevel(EntityPlayer var1, Perk var2);

    public int getPerkLevelWithBonus(EntityPlayer var1, @Nullable Perk var2);

    public boolean canResetPerks(EntityPlayer var1);

    public boolean resetPerks(EntityPlayerMP var1);

    public ITBCapability copyCapability(ITBCapability var1);

    public ITBCapability syncAll(EntityPlayerMP var1);

    public int getAlignmentValue();

    public int getAlignmentMinValue();

    public int getAlignmentMaxValue();

    public int getAlignmentLevel();

    public ITBCapability setAlignment(int var1);

    @Deprecated
    default public ITBCapability addAlignmentAndSync(EntityPlayerMP player, int value) {
        this.reward(player, 0, value);
        return this;
    }

    public ITBCapability onAlignmentLevelChange(int var1, int var2);
}

