/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityDecorativeGrave;

public class BlockDecorativeGrave
extends BlockGraveBase {
    public BlockDecorativeGrave(GraveModel graveModel) {
        super("decorative_" + graveModel.func_176610_l(), graveModel);
        this.setHarvestLevel("shovel", 0);
    }

    @Nullable
    public TileEntityDecorativeGrave getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityDecorativeGrave ? (TileEntityDecorativeGrave)tile : null;
    }

    public TileEntityDecorativeGrave createTileEntity(World world, IBlockState state) {
        return new TileEntityDecorativeGrave();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ConfigTombstone.decorativeGrave.isUnbreakableDecorativeGrave() ? -1.0f : this.field_149782_v;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return !ConfigTombstone.decorativeGrave.isUnbreakableDecorativeGrave();
    }

    public String func_149739_a() {
        return "tombstone.grave." + this.name.replace("decorative_", "");
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals("pickaxe") || type.equals("shovel");
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSpade) && !(stack.func_77973_b() instanceof ItemPickaxe)) {
            return super.canHarvestBlock(world, pos, player);
        }
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ISoulConsumer soulConsumer;
        if (!EntityHelper.isValidPlayer(playerIn)) {
            return false;
        }
        ItemStack stack = playerIn.func_184614_ca();
        if (hand != EnumHand.MAIN_HAND || stack.func_190926_b()) {
            return false;
        }
        if (playerIn.field_70170_p.field_72995_K) {
            return !EntityHelper.hasGlobalItemCooldown(playerIn, stack);
        }
        EntityPlayerMP serverPlayer = (EntityPlayerMP)playerIn;
        boolean isSoulReceptacle = stack.func_77973_b() == ModItems.soul_receptacle;
        ISoulConsumer iSoulConsumer = soulConsumer = isSoulReceptacle ? null : (ISoulConsumer)stack.getCapability(TBSoulConsumerProvider.CAP_SOUL_CONSUMER, null);
        if (!isSoulReceptacle && soulConsumer == null) {
            return super.func_180639_a(world, pos, state, (EntityPlayer)serverPlayer, hand, facing, hitX, hitY, hitZ);
        }
        if (!EntityHelper.hasGlobalItemCooldown((EntityPlayer)serverPlayer, stack)) {
            if (isSoulReceptacle) {
                EntityHelper.setGlobalItemCooldown((EntityPlayer)serverPlayer, stack, 10);
                if (((Boolean)state.func_177229_b((IProperty)HAS_SOUL)).booleanValue()) {
                    LangKey.MESSAGE_FREE_SOUL_FAILED.sendWarnMessage((ICommandSender)serverPlayer, new Object[0]);
                    return super.func_180639_a(world, pos, state, (EntityPlayer)serverPlayer, hand, facing, hitX, hitY, hitZ);
                }
                world.func_72942_c((Entity)new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockGraveBase.HAS_SOUL, (Comparable)Boolean.valueOf(true)), 3);
                LangKey.MESSAGE_FREE_SOUL_SUCCESS.sendSpecialMessage((ICommandSender)serverPlayer, new Object[0]);
                if (!serverPlayer.func_184812_l_()) {
                    serverPlayer.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
                Optional.ofNullable(serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(serverPlayer, 10, ConfigTombstone.alignment.pointsFreeSoulReceptacle));
                ModTriggers.FREE_SOUL.trigger(serverPlayer);
                return true;
            }
            if (soulConsumer.isEnchanted(stack)) {
                LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.sendWarnMessage((ICommandSender)serverPlayer, new Object[0]);
            } else if (((Boolean)state.func_177229_b((IProperty)HAS_SOUL)).booleanValue()) {
                if (soulConsumer.canEnchant(world, pos, (EntityPlayer)serverPlayer, stack)) {
                    int consumed;
                    TileEntityDecorativeGrave tile = this.getTileEntity((IBlockAccess)world, pos);
                    if (tile != null && (consumed = soulConsumer.setEnchant(world, pos, serverPlayer, stack, tile.hasStrongSoul())) > 0) {
                        if (tile.hasStrongSoul() && consumed == 1) {
                            ModTriggers.KNOWLEDGE_WASTED.trigger(serverPlayer);
                        }
                        IBlockState newState = state;
                        if (!tile.hasStrongSoul() || consumed > 1) {
                            newState = state.func_177226_a((IProperty)BlockGraveBase.HAS_SOUL, (Comparable)Boolean.valueOf(false));
                            world.func_180501_a(pos, newState, 3);
                        }
                        tile.removeStrongSoul();
                        tile.resetCheckSoul();
                        tile.func_70296_d();
                        world.func_184138_a(pos, state, newState, 3);
                        SoundHandler.playSoundAllAround("magic_use01", world, serverPlayer.func_180425_c());
                        serverPlayer.func_145747_a(soulConsumer.getEnchantSuccessMessage((EntityPlayer)serverPlayer).func_150255_a(StyleType.MESSAGE_SPECIAL));
                        ModTriggers.CONSUME_SOUL.trigger(serverPlayer);
                        Optional.ofNullable(serverPlayer.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(serverPlayer, soulConsumer.getKnowledge(), 0));
                    } else {
                        serverPlayer.func_145747_a(soulConsumer.getEnchantFailedMessage((EntityPlayer)serverPlayer).func_150255_a(StyleType.COLOR_OFF));
                    }
                } else {
                    LangKey.MESSAGE_ENCHANT_ITEM_NOT_ALLOWED.sendWarnMessage((ICommandSender)serverPlayer, new Object[0]);
                }
            } else {
                LangKey.MESSAGE_ENCHANT_ITEM_NO_SOUL.sendWarnMessage((ICommandSender)serverPlayer, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown((EntityPlayer)serverPlayer, stack, 10);
        }
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        ISoulConsumer soulConsumer;
        ItemStack stack;
        if (entity.func_70093_af() && !entity.field_70128_L && TimeHelper.atInterval(entity.field_70173_aa, 20) && EntityHelper.isValidPlayer(entity) && !(stack = ((EntityPlayer)entity).func_184614_ca()).func_190926_b() && (soulConsumer = (ISoulConsumer)stack.getCapability(TBSoulConsumerProvider.CAP_SOUL_CONSUMER, null)) != null) {
            soulConsumer.onSneakGrave(world, pos, (EntityPlayer)entity, stack);
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
        TileEntityDecorativeGrave tile = this.getTileEntity(world, pos);
        if (tile != null && !tile.getOwnerName().isEmpty()) {
            EngravableHelper.setEngravedName(stack, tile.getOwnerName());
        }
        drops.add((Object)stack);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        Helper.removeNoEvent(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityDecorativeGrave tile;
        String engraved_name = EngravableHelper.getEngravedName(stack);
        if (!engraved_name.isEmpty() && (tile = this.getTileEntity((IBlockAccess)world, pos)) != null) {
            tile.setOwner(engraved_name, TimeHelper.systemTime());
        }
    }
}

