/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class BlockGrave
extends BlockGraveBase {
    public BlockGrave(GraveModel graveModel) {
        super(graveModel.func_176610_l(), graveModel);
        this.func_149647_a(null);
        this.func_149722_s();
        this.func_149715_a(0.7f);
    }

    @Nullable
    public TileEntityPlayerGrave getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityPlayerGrave ? (TileEntityPlayerGrave)tile : null;
    }

    public TileEntityPlayerGrave createTileEntity(World world, IBlockState state) {
        return new TileEntityPlayerGrave();
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return -1.0f;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityPlayerGrave oldTile;
        IBlockState newState;
        if (!worldIn.field_72995_K && !Helper.isAllowedForRemoval(worldIn, pos) && !ModBlocks.isPlayerGrave((newState = worldIn.func_180495_p(pos)).func_177230_c()) && ModBlocks.isPlayerGrave(state.func_177230_c()) && (oldTile = this.getTileEntity((IBlockAccess)worldIn, pos)) != null) {
            CallbackHandler.addCallback(0, () -> {
                NBTTagCompound oldNbt = oldTile.func_189515_b(new NBTTagCompound());
                Helper.placeNoEvent(worldIn, pos, state);
                TileEntity newTile = worldIn.func_175625_s(pos);
                if (newTile != null) {
                    newTile.func_145839_a(oldNbt);
                    newTile.func_70296_d();
                    worldIn.func_184138_a(pos, newState, state, 3);
                }
            });
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public String func_149739_a() {
        return "tombstone.grave." + this.name;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (player.func_184812_l_()) {
            world.func_180498_a(player, 2001, pos, BlockGrave.func_176210_f((IBlockState)state));
            if (!world.field_72995_K) {
                Helper.removeNoEvent(world, pos);
            }
            return true;
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            return this.activatePlayerGrave(world, pos, state, (EntityPlayerMP)player);
        }
        return true;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EntityPlayerMP player;
        if (!world.field_72995_K && entity.func_70093_af() && !entity.field_70128_L && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && PlayerPreference.get(entity.func_110124_au()).activateGraveBySneaking() && this.activatePlayerGrave(world, pos, state, player = (EntityPlayerMP)entity)) {
            ModTriggers.SNEAK_GRAVE.trigger(player);
        }
    }

    private boolean activatePlayerGrave(World world, BlockPos pos, IBlockState state, EntityPlayerMP player) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityPlayerGrave tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile == null || tile.countTicks < 30 || !player.func_70089_S()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory((EntityPlayer)player, new Location(pos, world));
        boolean isOwner = tile.isOwner((EntityPlayer)player);
        if (!hasKey && isOwner) {
            ModTriggers.EASY_OPENING.trigger(player);
        }
        if (hasKey || isOwner) {
            tile.giveInventory(player);
            if (world.func_72912_H().func_176130_y() != EnumDifficulty.PEACEFUL && ConfigTombstone.player_death.chanceMobOnGraveRecovery > 0 && Helper.getRandom(1, 100) <= ConfigTombstone.player_death.chanceMobOnGraveRecovery) {
                IntStream.range(0, Helper.getRandom(1, 3)).forEach(i -> Helper.spawnRandomMob((WorldServer)world, pos));
            }
        } else if (!tile.getNeedAccess()) {
            ModTriggers.TOMB_RAIDING.trigger(player);
            Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 0, ConfigTombstone.alignment.pointsPlunderPlayerGrave));
            LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage((ICommandSender)player, new Object[0]);
        } else {
            LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.sendWarnMessage((ICommandSender)player, new Object[0]);
        }
        return true;
    }

    public ItemStack asDecorativeStack(IBlockState state) {
        Item item;
        ResourceLocation registryName = this.getRegistryName();
        if (registryName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName.func_110624_b(), "decorative_" + registryName.func_110623_a()))) != null && item != Items.field_190931_a) {
            return new ItemStack(item, 1, this.func_180651_a(state));
        }
        return ItemStack.field_190927_a;
    }
}

