/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ovh.corail.tombstone.api.magic.ILocation;
import ovh.corail.tombstone.api.magic.IProtectedEntity;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncProtectionMessage;

public class ProtectedEntityImpl
implements IProtectedEntity {
    private boolean active = false;
    private final Function<EntityLivingBase, Location> defaultSafeLocation = entity -> new Location(entity.func_180425_c().func_177982_a(Helper.getRandom(-50, 50), 0, Helper.getRandom(-50, 50)), entity.field_70170_p);
    private final Function<EntityLivingBase, Optional<Location>> safeLocation;
    private static final String ACTIVE = "active";

    public ProtectedEntityImpl() {
        this.safeLocation = entity -> Optional.empty();
    }

    public ProtectedEntityImpl(Function<EntityLivingBase, Optional<Location>> safeLocation) {
        this.safeLocation = safeLocation;
    }

    @Override
    public void apply(EntityLivingBase entity, boolean active) {
        this.active = active;
        if (!entity.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new SyncProtectionMessage(entity.func_145782_y(), active), (Entity)entity);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ILocation getSafeLocation(EntityLivingBase entity) {
        return this.safeLocation.apply(entity).orElse(this.defaultSafeLocation.apply(entity));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a(ACTIVE, this.active);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b(ACTIVE, 1)) {
            this.active = nbt.func_74767_n(ACTIVE);
        }
    }
}

