/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;
import ovh.corail.tombstone.perk.PerkRegistry;
import ovh.corail.tombstone.registry.ModTriggers;

public class TBCapabilityDefault
implements ITBCapability {
    protected long knowledge = 0L;
    protected int alignment = 0;
    protected int alignmentLevel = 0;
    private final Map<Perk, Integer> perks = new ConcurrentHashMap<Perk, Integer>();

    @Override
    public long getKnowledge() {
        return this.knowledge;
    }

    @Override
    public ITBCapability setKnowledge(long points) {
        this.knowledge = Math.max(0L, points);
        return this;
    }

    @Override
    public void reward(EntityPlayerMP player, int knowledge, int alignment) {
        if (EntityHelper.isValidServerPlayer((Entity)player)) {
            if (knowledge > 0) {
                int newPerkPoints;
                int earnedPerkPoints;
                int oldPerkPoints = this.getTotalPerkPoints();
                this.knowledge += (long)knowledge;
                boolean canDisplay = PlayerPreference.get(player.func_110124_au()).displayKnowledgeMessage();
                if (canDisplay) {
                    LangKey.MESSAGE_EARN_KNOWLEDGE.sendMagicMessage((ICommandSender)player, LangKey.MESSAGE_YOUR_KNOWLEDGE.getTranslation(new Object[0]), knowledge);
                }
                if ((earnedPerkPoints = (newPerkPoints = this.getTotalPerkPoints()) - oldPerkPoints) > 0) {
                    if (canDisplay) {
                        LangKey.MESSAGE_ACCESS_GUI.sendSpecialMessage((ICommandSender)player, earnedPerkPoints, LangKey.MESSAGE_HERE.createComponentCommand("/tbgui", new Object[0]));
                    }
                    if (oldPerkPoints == 0) {
                        ModTriggers.FIRST_KNOWLEDGE.trigger(player);
                    }
                    if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                        ModTriggers.MASTERY_1.trigger(player);
                    }
                }
            }
            if (alignment != 0) {
                int oldAlignment = this.alignmentLevel;
                if (alignment > 0 && this.alignmentLevel < 0 || alignment < 0 && this.alignmentLevel > 0) {
                    alignment *= 2;
                }
                this.setAlignment(this.alignment + alignment);
                if (oldAlignment != this.alignmentLevel) {
                    this.onAlignmentLevelChange(oldAlignment, this.alignmentLevel);
                }
            }
            if (knowledge > 0 && alignment != 0) {
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE_AND_ALIGNMENT, this.knowledge, this.alignment), player);
            } else if (knowledge > 0) {
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
            } else if (alignment != 0) {
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALIGNMENT, this.alignment), player);
            }
        }
    }

    @Override
    public void loseKnowledge(EntityPlayerMP player, int points) {
        if (EntityHelper.isValidServerPlayer((Entity)player)) {
            int oldPerkPoints = this.getTotalPerkPoints();
            this.setKnowledge(this.knowledge - (long)points);
            int lostPerkPoints = oldPerkPoints - this.getTotalPerkPoints();
            if (lostPerkPoints > 0) {
                Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey(), (EntityPlayer)player)) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
            } else {
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.KNOWLEDGE, this.knowledge), player);
            }
            if (PlayerPreference.get(player.func_110124_au()).displayKnowledgeMessage()) {
                LangKey.MESSAGE_LOSE_KNOWLEDGE.sendMagicMessage((ICommandSender)player, LangKey.MESSAGE_YOUR_KNOWLEDGE.getTranslation(new Object[0]), points);
            }
        }
    }

    @Override
    public long getKnowledgeForLevel(int level) {
        return level <= 0 ? 0L : (long)(level * level + 1);
    }

    @Override
    public long getKnowledgeToReachNextLevel(int level) {
        return this.getKnowledgeForLevel(level + 1) - this.getKnowledgeForLevel(level);
    }

    @Override
    public int getUsedPerkPoints(EntityPlayer player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = this.perks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += entry.getKey().getCost(i);
            }
        }
        return perkPoints;
    }

    @Override
    public int getTotalPerkPoints() {
        return (int)MathHelper.func_76129_c((float)(this.knowledge - 1L));
    }

    @Override
    public Map<Perk, Integer> getPerks() {
        return this.perks;
    }

    @Override
    public ITBCapability setPerks(Map<Perk, Integer> perks) {
        this.perks.clear();
        for (Map.Entry<Perk, Integer> entry : perks.entrySet()) {
            this.setPerk(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ITBCapability setPerk(Perk perk, int level) {
        this.perks.put(perk, level);
        return this;
    }

    @Override
    public boolean removePerk(Perk perk) {
        return this.perks.remove(perk) != null;
    }

    @Override
    public int getPerkLevel(EntityPlayer player, Perk perk) {
        return perk.isDisabled(player) ? 0 : this.perks.getOrDefault(perk, 0);
    }

    @Override
    public int getPerkLevelWithBonus(EntityPlayer player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(this.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    @Override
    public boolean canResetPerks(EntityPlayer player) {
        return CooldownHandler.INSTANCE.noCooldown(player, CooldownType.RESET_PERKS) && this.perks.entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled(player));
    }

    @Override
    public boolean resetPerks(EntityPlayerMP player) {
        if (!player.field_70170_p.field_72995_K && this.canResetPerks((EntityPlayer)player)) {
            this.setPerks(new HashMap<Perk, Integer>());
            CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.RESET_PERKS);
            this.syncAll(player);
            return true;
        }
        return false;
    }

    @Override
    public ITBCapability copyCapability(ITBCapability otherTBCapability) {
        this.deserializeNBT((NBTTagCompound)otherTBCapability.serializeNBT());
        return this;
    }

    @Override
    public ITBCapability syncAll(EntityPlayerMP player) {
        if (EntityHelper.isValidServerPlayer((Entity)player)) {
            PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALL, this.knowledge, this.alignment, this.perks), player);
        }
        return this;
    }

    @Override
    public int getAlignmentValue() {
        return this.alignment;
    }

    @Override
    public int getAlignmentMinValue() {
        return -500;
    }

    @Override
    public int getAlignmentMaxValue() {
        return 500;
    }

    @Override
    public int getAlignmentLevel() {
        if (this.alignment <= -500) {
            return -4;
        }
        if (this.alignment <= -300) {
            return -3;
        }
        if (this.alignment <= -150) {
            return -2;
        }
        if (this.alignment <= -50) {
            return -1;
        }
        if (this.alignment < 50) {
            return 0;
        }
        if (this.alignment < 150) {
            return 1;
        }
        if (this.alignment < 300) {
            return 2;
        }
        if (this.alignment < 500) {
            return 3;
        }
        return 4;
    }

    @Override
    public ITBCapability setAlignment(int value) {
        this.alignment = MathHelper.func_76125_a((int)value, (int)this.getAlignmentMinValue(), (int)this.getAlignmentMaxValue());
        this.alignmentLevel = this.getAlignmentLevel();
        return this;
    }

    @Override
    public ITBCapability onAlignmentLevelChange(int oldAlignment, int newAlignment) {
        return this;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74772_a("knowledge", this.knowledge);
        nbt.func_74768_a("alignment", this.alignment);
        NBTTagList tagPerks = new NBTTagList();
        this.perks.forEach((perk, value) -> {
            if (perk != null && !perk.isDisabled(null)) {
                NBTTagCompound tagPerk = new NBTTagCompound();
                tagPerk.func_74768_a("id", PerkRegistry.perkRegistry.getID((IForgeRegistryEntry)perk));
                tagPerk.func_74768_a("level", Math.min(perk.getLevelMax(), value));
                tagPerks.func_74742_a((NBTBase)tagPerk);
            }
        });
        nbt.func_74782_a("perks", (NBTBase)tagPerks);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_150297_b("knowledge", 4)) {
            this.knowledge = nbt.func_74763_f("knowledge");
        }
        if (nbt.func_150297_b("alignment", 3)) {
            this.setAlignment(nbt.func_74762_e("alignment"));
        }
        if (nbt.func_150297_b("perks", 9)) {
            NBTTagList tagPerks = nbt.func_150295_c("perks", 10);
            IntStream.range(0, tagPerks.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)tagPerks).func_150305_b(arg_0)).filter(tagPerk -> tagPerk.func_150297_b("id", 3) && tagPerk.func_150297_b("level", 3)).forEach(tagPerk -> {
                Perk perk = (Perk)PerkRegistry.perkRegistry.getValue(tagPerk.func_74762_e("id"));
                if (perk != null && !perk.isDisabled(null)) {
                    this.perks.put(perk, Math.min(perk.getLevelMax(), tagPerk.func_74762_e("level")));
                }
            });
        }
    }
}

