/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.TimeHelper;

public class CommandTBAcceptTeleport
extends TombstoneCommand {
    private static final Set<Ticket> TICKETS = ConcurrentHashMap.newKeySet();

    public String func_71517_b() {
        return "tbacceptteleport";
    }

    @Override
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandTBAcceptTeleport.func_71521_c((ICommandSender)sender);
        EntityPlayerMP target = server.func_184103_al().func_177451_a(UUID.fromString(args[0]));
        if (target == null) {
            throw new CommandException(LangKey.MESSAGE_PLAYER_INVALID.getKey(), new Object[0]);
        }
        boolean valid = false;
        boolean toPlayer = false;
        Iterator<Ticket> it = TICKETS.iterator();
        while (it.hasNext()) {
            Ticket ticket = it.next();
            if (!ticket.playerUUID.equals(player.func_110124_au()) || !ticket.targetUUID.equals(target.func_110124_au()) || ticket.expiredTime < TimeHelper.systemTime()) continue;
            valid = true;
            toPlayer = ticket.toPlayer;
            it.remove();
            break;
        }
        if (!valid) {
            throw new CommandException(LangKey.MESSAGE_NO_TICKET.getKey(), new Object[0]);
        }
        EntityPlayerMP origin = toPlayer ? target : player;
        EntityPlayerMP destination = toPlayer ? player : target;
        Location spawnLoc = new SpawnHelper(destination.func_71121_q(), destination.func_180425_c()).findSafePlace(3, true, true);
        origin = Helper.teleport(origin, spawnLoc.isOrigin() ? new Location((Entity)destination) : spawnLoc);
        LangKey.MESSAGE_TELEPORT_SUCCESS.sendSpecialMessage((ICommandSender)origin, new Object[0]);
        LangKey.MESSAGE_JOIN_YOU.sendSpecialMessage((ICommandSender)destination, origin.func_70005_c_());
    }

    public static void addTicket(EntityPlayer player, EntityPlayer target, int duration) {
        CommandTBAcceptTeleport.addTicket(player, target, duration, true);
    }

    public static void addTicket(EntityPlayer player, EntityPlayer target, int duration, boolean toPlayer) {
        TICKETS.add(new Ticket(player.func_110124_au(), target.func_110124_au(), TimeHelper.systemTime() + TimeUnit.SECONDS.toMillis(duration), toPlayer));
    }

    public static void cleanTickets() {
        if (TICKETS.size() > 0) {
            long systemTime = TimeHelper.systemTime();
            TICKETS.removeIf(p -> ((Ticket)p).expiredTime < systemTime);
        }
    }

    public static class Ticket
    implements Comparable<Ticket> {
        private final UUID playerUUID;
        private final UUID targetUUID;
        private final long expiredTime;
        private final boolean toPlayer;

        Ticket(UUID playerUUID, UUID targetUUID, long expiredTime, boolean toPlayer) {
            this.playerUUID = playerUUID;
            this.targetUUID = targetUUID;
            this.expiredTime = expiredTime;
            this.toPlayer = toPlayer;
        }

        @Override
        public int compareTo(Ticket ticket) {
            int cmp = this.playerUUID.compareTo(ticket.playerUUID);
            if (cmp == 0 && (cmp = this.targetUUID.compareTo(ticket.targetUUID)) == 0) {
                return Long.compare(this.expiredTime, ticket.expiredTime);
            }
            return cmp;
        }
    }
}

