/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCapClientMessage;

public class CommandTBKnowledge
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbknowledge";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2 || args.length > 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = CommandTBKnowledge.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        Action action = Action.getAction(args[1]);
        if (action == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (action) {
            case SHOW: {
                if (args.length == 3) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                this.showKnowledge(sender, player);
                break;
            }
            case SET: {
                int newKnowledge = CommandTBKnowledge.func_175755_a((String)args[2]);
                this.setKnowledge(sender, player, newKnowledge);
                break;
            }
            case GIVE: {
                int amount = CommandTBKnowledge.func_175755_a((String)args[2]);
                this.giveKnowledge(sender, player, amount);
                break;
            }
            case REMOVE: {
                int amount = CommandTBKnowledge.func_175755_a((String)args[2]);
                this.removeKnowledge(sender, player, amount);
                break;
            }
            case RESET_ANKH: {
                this.resetAnkhCooldown(sender, player);
                break;
            }
            case ALIGNMENT: {
                int amount = CommandTBKnowledge.func_175764_a((String)args[2], (int)-4, (int)4);
                this.setAlignment(sender, player, amount);
                break;
            }
        }
    }

    private void setKnowledge(ICommandSender sender, EntityPlayerMP target, long newKnowledge) throws CommandException {
        if (newKnowledge < 0L) {
            throw new CommandException(LangKey.MESSAGE_POSITIVE_INTEGER.getKey(), new Object[0]);
        }
        long oldKnowledge = Optional.ofNullable(target.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).map(ITBCapability::getKnowledge).orElse(0L);
        int adjust = (int)(newKnowledge - oldKnowledge);
        if (adjust >= 0) {
            this.increaseKnowledge(sender, target, adjust);
        } else {
            this.decreaseKnowledge(sender, target, Math.abs(adjust));
        }
    }

    private void giveKnowledge(ICommandSender sender, EntityPlayerMP target, int amount) throws CommandException {
        if (amount <= 0) {
            throw new CommandException(LangKey.MESSAGE_POSITIVE_INTEGER.getKey(), new Object[0]);
        }
        this.increaseKnowledge(sender, target, amount);
    }

    private void removeKnowledge(ICommandSender sender, EntityPlayerMP target, int amount) throws CommandException {
        if (amount <= 0) {
            throw new CommandException(LangKey.MESSAGE_POSITIVE_INTEGER.getKey(), new Object[0]);
        }
        this.decreaseKnowledge(sender, target, amount);
    }

    private void increaseKnowledge(ICommandSender sender, EntityPlayerMP target, int amount) {
        Optional.ofNullable(target.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(target, amount, 0));
        if (!target.equals((Object)sender.func_174793_f()) || !PlayerPreference.get(target.func_110124_au()).displayKnowledgeMessage()) {
            LangKey.MESSAGE_EARN_KNOWLEDGE.sendMessage(sender, LangKey.MESSAGE_PLAYER_KNOWLEDGE.getTranslation(target.func_70005_c_()), amount);
        }
    }

    private void decreaseKnowledge(ICommandSender sender, EntityPlayerMP target, int amount) {
        Optional.ofNullable(target.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.loseKnowledge(target, amount));
        if (!target.equals((Object)sender.func_174793_f()) || !PlayerPreference.get(target.func_110124_au()).displayKnowledgeMessage()) {
            LangKey.MESSAGE_LOSE_KNOWLEDGE.sendMessage(sender, LangKey.MESSAGE_PLAYER_KNOWLEDGE.getTranslation(target.func_70005_c_()), amount);
        }
    }

    private void showKnowledge(ICommandSender sender, EntityPlayerMP target) {
        LangKey.MESSAGE_SHOW_KNOWLEDGE.sendMessage(sender, target.func_70005_c_(), Optional.ofNullable(target.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).map(ITBCapability::getKnowledge).orElse(0L));
    }

    private void resetAnkhCooldown(ICommandSender sender, EntityPlayerMP target) {
        CooldownHandler.INSTANCE.setCooldown(target, CooldownType.NEXT_PRAY, 0);
        LangKey.MESSAGE_RESET_ANKH.sendMessage(sender, target.func_70005_c_());
    }

    private void setAlignment(ICommandSender sender, EntityPlayerMP player, int amount) {
        int alignment = (new int[]{-500, -300, -150, -50, 0, 50, 150, 300, 500})[MathHelper.func_76125_a((int)amount, (int)-4, (int)4) + 4];
        Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.setAlignment(alignment));
        PacketHandler.INSTANCE.sendTo((IMessage)new SyncCapClientMessage(SyncCapClientMessage.SyncType.ALIGNMENT, alignment), player);
        LangKey.MESSAGE_SET_ALIGNMENT.sendMessage(sender, player.func_70005_c_());
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTBKnowledge.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        if (args.length == 2) {
            return CommandTBKnowledge.func_175762_a((String[])args, (Collection)Stream.of(Action.values()).map(Action::asString).collect(Collectors.toList()));
        }
        if (args.length == 3 && Action.getAction(args[1]) == Action.ALIGNMENT) {
            return CommandTBKnowledge.func_175762_a((String[])args, (Collection)IntStream.rangeClosed(-4, 4).mapToObj(String::valueOf).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    static enum Action {
        SHOW,
        SET,
        GIVE,
        REMOVE,
        RESET_ANKH,
        ALIGNMENT;

        private final String name = this.name().toLowerCase(Locale.US);

        public String asString() {
            return this.name;
        }

        @Nullable
        public static Action getAction(String name) {
            return Arrays.stream(Action.values()).filter(p -> p.asString().equals(name)).findFirst().orElse(null);
        }
    }
}

