/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class CommandTBRestoreInventory
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbrestoreinventory";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = args.length == 0 ? CommandTBRestoreInventory.func_71521_c((ICommandSender)sender) : CommandTBRestoreInventory.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        CommandTBRestoreInventory.checkAlive((Entity)player);
        CommandTBRestoreInventory.checkNotSpectator((EntityPlayer)player);
        boolean success = false;
        List<Location> graveLocations = DeathHandler.INSTANCE.getGraveList(player);
        for (Location lastGrave : graveLocations) {
            if (!this.restoreGrave(server, player, lastGrave)) continue;
            success = true;
        }
        if (this.restoreGrave(server, player, ModItems.grave_key.getTombPos(InventoryHelper.findFirstInInventory((EntityPlayer)player, ModItems.grave_key)))) {
            success = true;
        }
        if (!success) {
            throw LangKey.MESSAGE_NO_GRAVE.asCommandException(new Object[0]);
        }
        LangKey.MESSAGE_RECOVER_LOST_ITEMS.sendSpecialMessage((ICommandSender)player, new Object[0]);
        CommandTBRestoreInventory.func_152373_a((ICommandSender)sender, (ICommand)this, (String)LangKey.MESSAGE_OPEN_GRAVE_SUCCESS.getKey(), (Object[])new Object[0]);
    }

    private boolean restoreGrave(MinecraftServer server, EntityPlayerMP player, Location loc) {
        if (!loc.isOrigin() && Helper.isValidDimension(loc.dim)) {
            WorldServer currentWorld = server.func_71218_a(loc.dim);
            TileEntity tile = currentWorld.func_175625_s(loc.getPos());
            if (tile instanceof TileEntityPlayerGrave) {
                ModItems.grave_key.removeKeyForGraveInInventory((EntityPlayer)player, loc);
                ((TileEntityPlayerGrave)tile).giveInventory(player);
                return true;
            }
            DeathHandler.INSTANCE.removeGrave(player, loc);
        }
        return false;
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return args.length == 1 ? CommandTBRestoreInventory.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
    }
}

