/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.VillageSiegeHandler;

public class CommandTBSiege
extends TombstoneCommand {
    public String func_71517_b() {
        return "tbsiege";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        WorldServer world;
        if (!ConfigTombstone.village_siege.handleVillageSiege) {
            throw LangKey.MESSAGE_DISABLED_COMMAND.asCommandException(new Object[0]);
        }
        if (args.length < 1 || args.length > 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        Action action = Action.getAction(args[0]);
        if (action == null) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args.length == 1) {
            world = (WorldServer)sender.func_130014_f_();
        } else {
            int dim = CommandTBSiege.func_175755_a((String)args[1]);
            if (Helper.isValidDimension(dim)) {
                world = DimensionManager.getWorld((int)dim);
                if (world == null) {
                    throw LangKey.MESSAGE_UNLOADED_DIMENSION.asCommandException(new Object[0]);
                }
            } else {
                throw LangKey.MESSAGE_NO_DIMENSION.asCommandException(new Object[0]);
            }
        }
        if (world.func_72912_H().func_176130_y() == EnumDifficulty.PEACEFUL) {
            throw LangKey.MESSAGE_DIFFICULTY_PEACEFUL.asCommandException(new Object[0]);
        }
        if (Stream.of(ConfigTombstone.village_siege.deniedDimensionTypeForSiege).anyMatch(p -> p.equals(world.field_73011_w.func_186058_p().func_186065_b()))) {
            throw LangKey.MESSAGE_DENIED_DIMENSION.asCommandException(new Object[0]);
        }
        if (!(world.field_175740_d instanceof VillageSiegeHandler.CustomVillageSiege)) {
            throw LangKey.MESSAGE_NO_VILLAGE.asCommandException(new Object[0]);
        }
        switch (action) {
            case START: {
                this.startSiege(server, sender, (VillageSiegeHandler.CustomVillageSiege)world.field_175740_d);
                break;
            }
            case STOP: {
                this.stopSiege(server, sender, (VillageSiegeHandler.CustomVillageSiege)world.field_175740_d);
            }
        }
    }

    private void startSiege(MinecraftServer server, ICommandSender sender, VillageSiegeHandler.CustomVillageSiege villageSiege) throws CommandException {
        if (villageSiege.field_75537_a.func_72935_r()) {
            Arrays.stream(server.field_71305_c).forEach(w -> w.func_72877_b(18001L));
        }
        if (!villageSiege.startSiege(100)) {
            throw LangKey.MESSAGE_START_SIEGE_FAILED.asCommandException(new Object[0]);
        }
        LangKey.MESSAGE_START_SIEGE_SUCCESS.sendMessage(sender, new Object[0]);
    }

    private void stopSiege(MinecraftServer server, ICommandSender sender, VillageSiegeHandler.CustomVillageSiege villageSiege) throws CommandException {
        boolean stopped = villageSiege.stopSiege();
        List entities = villageSiege.field_75537_a.func_175644_a(EntityZombie.class, z -> z != null && z.getEntityData().func_74767_n("siege"));
        entities.forEach(e -> {
            e.func_184174_b(false);
            e.func_70106_y();
        });
        if (!stopped && entities.size() == 0) {
            throw LangKey.MESSAGE_STOP_SIEGE_FAILED.asCommandException(new Object[0]);
        }
        LangKey.MESSAGE_STOP_SIEGE_SUCCESS.sendMessage(sender, new Object[0]);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTBSiege.func_175762_a((String[])args, (Collection)Stream.of(Action.values()).map(Action::func_176610_l).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private static enum Action implements IStringSerializable
    {
        START,
        STOP;

        private final String name = this.name().toLowerCase(Locale.US);

        @Nullable
        public static Action getAction(String name) {
            return Arrays.stream(Action.values()).filter(p -> p.func_176610_l().equals(name)).findFirst().orElse(null);
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

