/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;

abstract class TombstoneCommand
extends CommandBase {
    protected static final BiPredicate<MinecraftServer, ICommandSender> SINGLE_PLAYER_OWNER = (server, source) -> {
        if (server.func_71262_S()) return false;
        if (!server.func_71264_H()) return false;
        if (Optional.ofNullable(source.func_174793_f()).filter(EntityPlayerMP.class::isInstance).map(EntityPlayerMP.class::cast).map(EntityPlayer::func_146103_bH).map(profil -> server.func_71214_G().equals(profil.getName())).orElse(false) == false) return false;
        return true;
    };

    TombstoneCommand() {
    }

    public String func_71518_a(ICommandSender sender) {
        return "tombstone.command." + this.func_71517_b() + ".usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return super.func_184882_a(server, sender) || SINGLE_PLAYER_OWNER.test(server, sender);
    }

    static void checkAlive(Entity entity) throws CommandException {
        if (!entity.func_70089_S()) {
            throw new CommandException(LangKey.MESSAGE_DEAD_ENTITY.getKey(), new Object[0]);
        }
    }

    static void checkNotSpectator(Entity entity) throws CommandException {
        if (entity instanceof EntityPlayer) {
            TombstoneCommand.checkNotSpectator((EntityPlayer)entity);
        }
    }

    static void checkNotSpectator(EntityPlayer player) throws CommandException {
        if (EntityHelper.isValidPlayer(player) && player.func_175149_v()) {
            throw new CommandException(LangKey.MESSAGE_PLAYER_SPECTATOR.getKey(), new Object[0]);
        }
    }

    static void checkValidPos(World world, BlockPos pos) throws CommandException {
        if (!Helper.isValidPos(world, pos)) {
            throw new CommandException(LangKey.MESSAGE_INVALID_LOCATION.getKey(), new Object[0]);
        }
    }
}

