/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModTriggers;

public class CompatibilityMinecolonies {
    public static final CompatibilityMinecolonies instance = new CompatibilityMinecolonies();
    private static final List<String> RAIDERS = ImmutableList.of((Object)"barbarian", (Object)"archerbarbarian", (Object)"pirate", (Object)"archerpirate", (Object)"chiefbarbarian", (Object)"chiefpirate");

    private CompatibilityMinecolonies() {
    }

    public boolean isCitizen(@Nullable Entity entity) {
        return SupportMods.MINECOLONIES.isLoaded() && "minecolonies:citizen".equals(EntityHelper.getRegistryString(entity));
    }

    public boolean applyKillResult(EntityPlayerMP player, ResourceLocation typeRL) {
        if (SupportMods.MINECOLONIES.isLoaded() && typeRL != null && typeRL.func_110624_b().equals(SupportMods.MINECOLONIES.func_176610_l())) {
            if (typeRL.func_110623_a().equals("citizen")) {
                Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 0, ConfigTombstone.alignment.pointsKillVillager));
                ModTriggers.KILL_ENOUGH_VILLAGER.trigger(player);
                return true;
            }
            if (RAIDERS.contains(typeRL.func_110623_a())) {
                Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 0, ConfigTombstone.alignment.pointsKillRaider));
                ModTriggers.KILL_ENOUGH_RAIDER.trigger(player);
                return true;
            }
        }
        return false;
    }
}

