/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.ProbeInfo;
import mcjty.theoneprobe.apiimpl.styles.LayoutStyle;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class IntegrationTOP
implements Function<ITheOneProbe, Void> {
    private static final Map<Block, List<IElement>> BLACK_ELEMENTS = new HashMap<Block, List<IElement>>();
    private static final Map<Block, List<IElement>> WHITE_ELEMENTS = new HashMap<Block, List<IElement>>();
    private static boolean FAILED = false;

    private static void setElements(BlockGrave grave, IBlockState state, ProbeInfo probeInfo) {
        int meta = grave.func_180651_a(state);
        List oldElements = probeInfo.getElements();
        List cache = (meta == 1 ? WHITE_ELEMENTS : BLACK_ELEMENTS).get((Object)grave);
        if (cache == null) {
            ItemStack stack = grave.asDecorativeStack(state);
            if (!stack.func_190926_b()) {
                ArrayList toKeep = oldElements.size() == 1 ? new ArrayList() : IntStream.range(1, oldElements.size()).mapToObj(oldElements::get).collect(Collectors.toList());
                oldElements.clear();
                probeInfo.horizontal(new LayoutStyle().alignment(ElementAlignment.ALIGN_TOPLEFT).spacing(2)).item(stack).vertical(new LayoutStyle().alignment(ElementAlignment.ALIGN_TOPLEFT).spacing(2)).itemLabel(stack).text(TextFormatting.BLUE.toString() + TextFormatting.ITALIC + "Corail Tombstone");
                cache = probeInfo.getElements();
                cache.addAll(toKeep);
                (meta == 1 ? WHITE_ELEMENTS : BLACK_ELEMENTS).put(grave, new ArrayList(cache));
            }
        } else {
            oldElements.clear();
            oldElements.addAll(cache);
        }
    }

    @Override
    public Void apply(ITheOneProbe probe) {
        ModTombstone.LOGGER.info("Integration TOP");
        try {
            probe.registerProvider(new IProbeInfoProvider(){

                public String getID() {
                    return "tombstone:top";
                }

                public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, EntityPlayer entityPlayer, World world, IBlockState iBlockState, IProbeHitData iProbeHitData) {
                    if (FAILED || world.field_72995_K) {
                        return;
                    }
                    if (ModBlocks.isPlayerGrave(iBlockState.func_177230_c())) {
                        try {
                            IntegrationTOP.setElements((BlockGrave)iBlockState.func_177230_c(), iBlockState, (ProbeInfo)iProbeInfo);
                            TileEntity tile = world.func_175625_s(iProbeHitData.getPos());
                            if (tile instanceof TileEntityPlayerGrave) {
                                TileEntityPlayerGrave grave = (TileEntityPlayerGrave)tile;
                                iProbeInfo.text(grave.getFormattedInfo());
                                iProbeInfo.text(grave.getFormattedDeathDate());
                            }
                        }
                        catch (Throwable t) {
                            ModTombstone.LOGGER.warn("Compatibility for TheOneProbe has been disabled. Please update this mod to a recent version.");
                            FAILED = true;
                        }
                    }
                }
            });
        }
        catch (Throwable t) {
            ModTombstone.LOGGER.warn("Compatibility for TheOneProbe has been disabled. Please update this mod to a recent version.");
            FAILED = true;
        }
        return null;
    }
}

