/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.List;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

@WailaPlugin
public class IntegrationWaila
implements IWailaPlugin {
    public void register(IWailaRegistrar registrar) {
        try {
            IWailaDataProvider provider = new IWailaDataProvider(){

                @Nonnull
                public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
                    return ModBlocks.isPlayerGrave(accessor.getBlock()) ? ((BlockGrave)accessor.getBlock()).asDecorativeStack(accessor.getBlockState()) : ItemStack.field_190927_a;
                }

                @Nonnull
                public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
                    String translation = TextFormatting.WHITE + accessor.getBlock().func_149732_F();
                    if (tooltip.isEmpty()) {
                        tooltip.add(translation);
                    } else {
                        tooltip.set(0, translation);
                    }
                    return tooltip;
                }

                @Nonnull
                public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
                    if (accessor.getTileEntity() instanceof TileEntityPlayerGrave) {
                        TileEntityPlayerGrave grave = (TileEntityPlayerGrave)accessor.getTileEntity();
                        tooltip.add(grave.getFormattedInfo());
                        tooltip.add(grave.getFormattedDeathDate());
                    }
                    return tooltip;
                }
            };
            registrar.registerStackProvider(provider, BlockGrave.class);
            registrar.registerHeadProvider(provider, BlockGrave.class);
            registrar.registerBodyProvider(provider, BlockGrave.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

