/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.config;

import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.network.CheckConfigMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.network.UpdateServerMessage;

@Mod.EventBusSubscriber(modid="tombstone")
@Config(modid="tombstone", name="tombstone", category="")
public class ConfigTombstone {
    @Config.Name(value="client")
    @Config.LangKey(value="tombstone.config_cat.client")
    @Config.Comment(value={"Personal Options that can be edited even on server"})
    public static CatClient client = new CatClient();
    @Config.Name(value="compatibilities")
    @Config.LangKey(value="tombstone.config_cat.compatibilities")
    @Config.Comment(value={"Allows to enable some features related to others mods"})
    public static CatCompatibilities compatibilities = new CatCompatibilities();
    @Config.Name(value="village_siege")
    @Config.LangKey(value="tombstone.config_cat.village_siege")
    @Config.Comment(value={"Allows to define the conditions for a village siege to begin"})
    public static CatVillageSiege village_siege = new CatVillageSiege();
    @Config.Name(value="enchantments")
    @Config.LangKey(value="tombstone.config_cat.enchantments")
    @Config.Comment(value={"Allows to customize or disable the enchantments"})
    public static CatEnchantments enchantments = new CatEnchantments();
    @Config.Name(value="decorativeGrave")
    @Config.LangKey(value="tombstone.config_cat.decorative_grave")
    @Config.Comment(value={"For settings related to decorative tombs and magic items"})
    public static CatDecorativeGrave decorativeGrave = new CatDecorativeGrave();
    @Config.Name(value="loot")
    @Config.LangKey(value="tombstone.config_cat.loot")
    @Config.Comment(value={"Allows to change the chance to drop some items"})
    public static CatLoot loot = new CatLoot();
    @Config.Name(value="allowedMagicItems")
    @Config.LangKey(value="tombstone.config_cat.allowed_magic_items")
    @Config.Comment(value={"Allows to disable some magic items"})
    public static CatAllowedMagicItems allowedMagicItems = new CatAllowedMagicItems();
    @Config.Name(value="alignment")
    @Config.LangKey(value="tombstone.config_cat.alignment")
    @Config.Comment(value={"Options related to player's alignment"})
    public static CatAlignment alignment = new CatAlignment();
    @Config.Name(value="general")
    @Config.LangKey(value="tombstone.config_cat.general")
    @Config.Comment(value={"Miscellaneous options"})
    public static CatGeneral general = new CatGeneral();
    @Config.Name(value="recovery")
    @Config.LangKey(value="tombstone.config_cat.recovery")
    @Config.Comment(value={"Options related to the command recovery and auto-save of players"})
    public static CatRecovery recovery = new CatRecovery();
    @Config.Name(value="player_death")
    @Config.LangKey(value="tombstone.config_cat.player_death")
    @Config.Comment(value={"Options related to player's death"})
    public static CatPlayerDeath player_death = new CatPlayerDeath();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("tombstone")) {
            ConfigManager.sync((String)"tombstone", (Config.Type)Config.Type.INSTANCE);
            if (CatClient.lastPlayerPreference == null) {
                ConfigTombstone.updatePlayerPreferences();
            } else if (CatClient.lastPlayerPreference.hasChangedFromConfig()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new UpdateServerMessage(ConfigTombstone.updatePlayerPreferences(), false));
            }
            if (Minecraft.func_71410_x().func_71356_B() && Minecraft.func_71410_x().func_71387_A()) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new CheckConfigMessage());
                ConfigTombstone.updateServerDatas();
            }
            event.setResult(Event.Result.DENY);
        }
    }

    public static void updateServerDatas() {
        CatPlayerDeath.serverDecayTime = ConfigTombstone.player_death.decayTime;
        CatGeneral.serverGhostlyShapeDuration = ConfigTombstone.general.ghostlyShapeDuration;
        CatDecorativeGrave.serverTabletMaxUse = ConfigTombstone.decorativeGrave.tabletMaxUse;
        CatDecorativeGrave.serverTabletCooldown = ConfigTombstone.decorativeGrave.tabletCooldown;
        CatDecorativeGrave.serverUnbreakableDecorativeGrave = ConfigTombstone.decorativeGrave.unbreakableDecorativeGrave;
        CatDecorativeGrave.serverCooldownToPray = ConfigTombstone.decorativeGrave.cooldownToPray;
        CatDecorativeGrave.serverCooldownResetperk = ConfigTombstone.decorativeGrave.cooldownResetperk;
        CatEnchantments.serverNerfShadowStepForceSneak = ConfigTombstone.enchantments.nerfShadowStepForceSneak;
        CatEnchantments.serverEnableEnchantmentShadowStep = ConfigTombstone.enchantments.enableEnchantmentShadowStep;
        CatEnchantments.serverEnableEnchantmentSoulbound = ConfigTombstone.enchantments.enableEnchantmentSoulbound;
        CatEnchantments.serverEnableEnchantmentMagicSiphon = ConfigTombstone.enchantments.enableEnchantmentMagicSiphon;
        CatEnchantments.serverEnableEnchantmentPlagueBringer = ConfigTombstone.enchantments.enableEnchantmentPlagueBringer;
        CatEnchantments.serverEnableEnchantmentBlessing = ConfigTombstone.enchantments.enableEnchantmentBlessing;
        CatEnchantments.serverEnableEnchantmentCurseOfBones = ConfigTombstone.enchantments.enableEnchantmentCurseOfBones;
        CatEnchantments.serverSoulboundEnchantingTable = ConfigTombstone.enchantments.soulboundEnchantingTable;
        CatEnchantments.serverShadowStepEnchantingTable = ConfigTombstone.enchantments.shadowStepEnchantingTable;
        CatEnchantments.serverMagicSiphonEnchantingTable = ConfigTombstone.enchantments.magicSiphonEnchantingTable;
        CatEnchantments.serverPlagueBringerEnchantingTable = ConfigTombstone.enchantments.plagueBringerEnchantingTable;
        CatEnchantments.serverBlessingEnchantingTable = ConfigTombstone.enchantments.blessingEnchantingTable;
        CatEnchantments.serverCurseOfBonesEnchantingTable = ConfigTombstone.enchantments.curseOfBonesEnchantingTable;
        CatEnchantments.serverPlagueBringerCombiningMagicSiphon = ConfigTombstone.enchantments.plagueBringerCombiningMagicSiphon;
        CatLoot.serverChanceLootLostTablet = ConfigTombstone.loot.chanceLootLostTablet;
        CatPlayerDeath.serverXpLoss = ConfigTombstone.player_death.xpLoss;
        CatGeneral.serverChanceEnchantedGraveKey = ConfigTombstone.general.chanceEnchantedGraveKey;
        CatGeneral.serverScrollDuration = ConfigTombstone.general.scrollDuration;
        CatGeneral.serverPerkProgressionScale = ConfigTombstone.general.perkProgressionScale;
        CatGeneral.serverScrollOfKnowledgeLoss = ConfigTombstone.general.scrollOfKnowledgeLoss;
        CatEnchantments.serverMaxLevelShadowStep = ConfigTombstone.enchantments.maxLevelShadowStep;
        CatEnchantments.serverMaxLevelMagicSiphon = ConfigTombstone.enchantments.maxLevelMagicSiphon;
        CatEnchantments.serverMaxLevelPlagueBringer = ConfigTombstone.enchantments.maxLevelPlagueBringer;
        CatEnchantments.serverMaxLevelCurseOfBones = ConfigTombstone.enchantments.maxLevelCurseOfBones;
        CatAllowedMagicItems.serverAllowBookOfDisenchantment = ConfigTombstone.allowedMagicItems.allowBookOfDisenchantment;
        CatAllowedMagicItems.serverAllowBookOfRepairing = ConfigTombstone.allowedMagicItems.allowBookOfRepairing;
        CatAllowedMagicItems.serverAllowBookOfMagicImpregnation = ConfigTombstone.allowedMagicItems.allowBookOfMagicImpregnation;
        CatAllowedMagicItems.serverAllowGraveKey = ConfigTombstone.allowedMagicItems.allowGraveKey;
        CatAllowedMagicItems.serverAllowLostTablet = ConfigTombstone.allowedMagicItems.allowLostTablet;
        CatAllowedMagicItems.serverAllowScrollOfKnowledge = ConfigTombstone.allowedMagicItems.allowScrollOfKnowledge;
        CatAllowedMagicItems.serverAllowTabletOfAssistance = ConfigTombstone.allowedMagicItems.allowTabletOfAssistance;
        CatAllowedMagicItems.serverAllowTabletOfRecall = ConfigTombstone.allowedMagicItems.allowTabletOfRecall;
        CatAllowedMagicItems.serverAllowTabletOfHome = ConfigTombstone.allowedMagicItems.allowTabletOfHome;
        CatAllowedMagicItems.serverAllowTabletOfCupidity = ConfigTombstone.allowedMagicItems.allowTabletOfCupidity;
        CatAllowedMagicItems.serverAllowScrollOfPreservation = ConfigTombstone.allowedMagicItems.allowScrollOfPreservation;
        CatAllowedMagicItems.serverAllowScrollOfUnstableIntangibleness = ConfigTombstone.allowedMagicItems.allowScrollOfUnstableIntangibleness;
        CatAllowedMagicItems.serverAllowScrollOfFeatherFall = ConfigTombstone.allowedMagicItems.allowScrollOfFeatherFall;
        CatAllowedMagicItems.serverAllowScrollOfPurification = ConfigTombstone.allowedMagicItems.allowScrollOfPurification;
        CatAllowedMagicItems.serverAllowScrollOfTrueSight = ConfigTombstone.allowedMagicItems.allowScrollOfTrueSight;
        CatAllowedMagicItems.serverAllowScrollOfReach = ConfigTombstone.allowedMagicItems.allowScrollOfReach;
        CatAllowedMagicItems.serverAllowScrollOfLightningResistance = ConfigTombstone.allowedMagicItems.allowScrollOfLightningResistance;
        CatAllowedMagicItems.serverAllowScrollOfFrostResistance = ConfigTombstone.allowedMagicItems.allowScrollOfFrostResistance;
        CatAllowedMagicItems.serverAllowScrollOfAquaticLife = ConfigTombstone.allowedMagicItems.allowScrollOfAquaticLife;
        CatAllowedMagicItems.serverAllowDustOfVanishing = ConfigTombstone.allowedMagicItems.allowDustOfVanishing;
        CatAllowedMagicItems.serverAllowVoodooPoppet = ConfigTombstone.allowedMagicItems.allowVoodooPoppet;
        CatAllowedMagicItems.serverAllowFamiliarReceptacle = ConfigTombstone.allowedMagicItems.allowFamiliarReceptacle;
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleClientPacket(UpdateClientMessage message) {
        CatPlayerDeath.serverDecayTime = message.decayTime;
        CatGeneral.serverGhostlyShapeDuration = message.ghostlyShapeDuration;
        CatDecorativeGrave.serverTabletMaxUse = message.tabletMaxUse;
        CatDecorativeGrave.serverTabletCooldown = message.tabletCooldown;
        CatDecorativeGrave.serverUnbreakableDecorativeGrave = message.unbreakableDecorativeGrave;
        CatDecorativeGrave.serverCooldownToPray = message.cooldownToPray;
        CatDecorativeGrave.serverCooldownResetperk = message.cooldownResetperk;
        CatEnchantments.serverNerfShadowStepForceSneak = message.nerfShadowStepForceSneak;
        CatEnchantments.serverEnableEnchantmentShadowStep = message.enableEnchantmentShadowStep;
        CatEnchantments.serverEnableEnchantmentSoulbound = message.enableEnchantmentSoulbound;
        CatEnchantments.serverEnableEnchantmentMagicSiphon = message.enableEnchantmentMagicSiphon;
        CatEnchantments.serverEnableEnchantmentPlagueBringer = message.enableEnchantmentPlagueBringer;
        CatEnchantments.serverEnableEnchantmentBlessing = message.enableEnchantmentBlessing;
        CatEnchantments.serverEnableEnchantmentCurseOfBones = message.enableEnchantmentCurseOfBones;
        CatEnchantments.serverSoulboundEnchantingTable = message.soulboundEnchantingTable;
        CatEnchantments.serverShadowStepEnchantingTable = message.shadowStepEnchantingTable;
        CatEnchantments.serverMagicSiphonEnchantingTable = message.magicSiphonEnchantingTable;
        CatEnchantments.serverPlagueBringerEnchantingTable = message.plagueBringerEnchantingTable;
        CatEnchantments.serverBlessingEnchantingTable = message.blessingEnchantingTable;
        CatEnchantments.serverCurseOfBonesEnchantingTable = message.curseOfBonesEnchantingTable;
        CatEnchantments.serverPlagueBringerCombiningMagicSiphon = message.plagueBringerCombiningMagicSiphon;
        CatLoot.serverChanceLootLostTablet = message.chanceLootLostTablet;
        CatPlayerDeath.serverXpLoss = message.xpLoss;
        CatGeneral.serverChanceEnchantedGraveKey = message.chanceEnchantedGraveKey;
        CatGeneral.serverScrollDuration = message.scrollDuration;
        CatGeneral.serverPerkProgressionScale = message.perkProgressionScale;
        CatGeneral.serverScrollOfKnowledgeLoss = message.scrollOfKnowledgeLoss;
        CatEnchantments.serverMaxLevelShadowStep = message.maxLevelShadowStep;
        CatEnchantments.serverMaxLevelMagicSiphon = message.maxLevelMagicSiphon;
        CatEnchantments.serverMaxLevelPlagueBringer = message.maxLevelPlagueBringer;
        CatEnchantments.serverMaxLevelCurseOfBones = message.maxLevelCurseOfBones;
        CatAllowedMagicItems.serverAllowBookOfDisenchantment = message.allowBookOfDisenchantment;
        CatAllowedMagicItems.serverAllowBookOfRepairing = message.allowBookOfRepairing;
        CatAllowedMagicItems.serverAllowBookOfMagicImpregnation = message.allowBookOfMagicImpregnation;
        CatAllowedMagicItems.serverAllowGraveKey = message.allowGraveKey;
        CatAllowedMagicItems.serverAllowLostTablet = message.allowLostTablet;
        CatAllowedMagicItems.serverAllowScrollOfKnowledge = message.allowScrollOfKnowledge;
        CatAllowedMagicItems.serverAllowTabletOfAssistance = message.allowTabletOfAssistance;
        CatAllowedMagicItems.serverAllowTabletOfRecall = message.allowTabletOfRecall;
        CatAllowedMagicItems.serverAllowTabletOfHome = message.allowTabletOfHome;
        CatAllowedMagicItems.serverAllowTabletOfCupidity = message.allowTabletOfCupidity;
        CatAllowedMagicItems.serverAllowScrollOfPreservation = message.allowScrollOfPreservation;
        CatAllowedMagicItems.serverAllowScrollOfUnstableIntangibleness = message.allowScrollOfUnstableIntangibleness;
        CatAllowedMagicItems.serverAllowScrollOfFeatherFall = message.allowScrollOfFeatherFall;
        CatAllowedMagicItems.serverAllowScrollOfPurification = message.allowScrollOfPurification;
        CatAllowedMagicItems.serverAllowScrollOfTrueSight = message.allowScrollOfTrueSight;
        CatAllowedMagicItems.serverAllowScrollOfReach = message.allowScrollOfReach;
        CatAllowedMagicItems.serverAllowScrollOfLightningResistance = message.allowScrollOfLightningResistance;
        CatAllowedMagicItems.serverAllowScrollOfFrostResistance = message.allowScrollOfFrostResistance;
        CatAllowedMagicItems.serverAllowScrollOfAquaticLife = message.allowScrollOfAquaticLife;
        CatAllowedMagicItems.serverAllowDustOfVanishing = message.allowDustOfVanishing;
        CatAllowedMagicItems.serverAllowVoodooPoppet = message.allowVoodooPoppet;
        CatAllowedMagicItems.serverAllowFamiliarReceptacle = message.allowFamiliarReceptacle;
    }

    public static PlayerPreference updatePlayerPreferences() {
        CatClient.lastPlayerPreference = PlayerPreference.fromClientConfig();
        return CatClient.lastPlayerPreference;
    }

    public static class CatPlayerDeath {
        @Config.Name(value="handlePlayerDeath")
        @Config.LangKey(value="tombstone.config.handle_player_death")
        @Config.Comment(value={"Whether to handle player death"})
        public boolean handlePlayerDeath = true;
        @Config.Name(value="restoreEffectsOnDeath")
        @Config.LangKey(value="tombstone.config.restore_effects_on_death")
        @Config.Comment(value={"Whether to restore beneficial effects after a player dies"})
        public boolean restoreEffectsOnDeath = false;
        @Config.Name(value="logPlayerGrave")
        @Config.LangKey(value="tombstone.config.log_player_grave")
        @Config.Comment(value={"Whether to log the positions of players' graves"})
        public boolean logPlayerGrave = true;
        @Config.Name(value="xpLoss")
        @Config.LangKey(value="tombstone.config.xp_loss")
        @Config.Comment(value={"Experience loss on death (%) (-1 = disabled)"})
        @Config.RangeInt(min=-1, max=100)
        public int xpLoss = 80;
        static int serverXpLoss = 80;
        @Config.Name(value="decayTime")
        @Config.LangKey(value="tombstone.config.decay_time")
        @Config.Comment(value={"The time in minutes before a Grave's Key isn't required to open a grave (-1 = disabled)"})
        @Config.RangeInt(min=-1)
        public int decayTime = -1;
        static int serverDecayTime = -1;
        @Config.Name(value="pvpUnlockGrave")
        @Config.LangKey(value="tombstone.config.pvp_unlock_grave")
        @Config.Comment(value={"Whether to unlock access to a grave if the player has been killed by another player"})
        public boolean pvpUnlockGrave = true;
        @Config.Name(value="snifferRange")
        @Config.LangKey(value="tombstone.config.sniffer_range")
        @Config.Comment(value={"The radius in which items should be collected when a grave is spawned"})
        @Config.RangeInt(min=1, max=10)
        public int snifferRange = 5;
        @Config.Name(value="noGraveLocation")
        @Config.LangKey(value="tombstone.config.no_grave_location")
        @Config.Comment(value={"Coordinates where graves shouldn't spawn"})
        public String[] noGraveLocation = new String[]{"0, 0, 0, -10000, 20"};
        @Config.Name(value="chanceMobOnGraveRecovery")
        @Config.LangKey(value="tombstone.config.chance_mob_on_grave_recovery")
        @Config.Comment(value={"The chance that creatures appear after the contents of a grave are retrieved"})
        @Config.RangeInt(min=0, max=100)
        public int chanceMobOnGraveRecovery = 0;
        @Config.Name(value="pvpStolenXp")
        @Config.LangKey(value="tombstone.config.pvp_stolen_xp")
        @Config.Comment(value={"Percent of stolen experience by killing a player when PvP mode is enabled"})
        @Config.RangeInt(min=0, max=100)
        public int pvpStolenXp = 30;
        @Config.Name(value="knowledgeLoss")
        @Config.LangKey(value="tombstone.config.knowledge_loss")
        @Config.Comment(value={"Knowledge of Death loss why dying"})
        @Config.RangeInt(min=0, max=500)
        public int knowledgeLoss = 0;
        @Config.Name(value="chanceLossOnDeath")
        @Config.LangKey(value="tombstone.config.chance_loss_on_death")
        @Config.Comment(value={"The chance that some items are lost on death"})
        @Config.RangeInt(min=0, max=100)
        public int chanceLossOnDeath = 0;
        @Config.Name(value="percentLossOnDeath")
        @Config.LangKey(value="tombstone.config.percent_loss_on_death")
        @Config.Comment(value={"The percentage of items that are lost on death"})
        @Config.RangeInt(min=0, max=100)
        public int percentLossOnDeath = 0;
        @Config.Name(value="preventDeathOutsideWorldBorder")
        @Config.LangKey(value="tombstone.config.prevent_death_outside_world_border")
        @Config.Comment(value={"Prevents death outside the borders of the world"})
        public boolean preventDeathOutsideWorldBorder = true;
        @Config.Name(value="preventDeathOutsideBuildHeight")
        @Config.LangKey(value="tombstone.config.prevent_death_outside_build_height")
        @Config.Comment(value={"Prevents death outside the build height"})
        public boolean preventDeathOutsideBuildHeight = false;
        @Config.Name(value="gravesByPassGriefingRules")
        @Config.LangKey(value="tombstone.config.graves_by_pass_griefing_rules")
        @Config.Comment(value={"Whether graves should be allowed to bypass anti-griefing rules"})
        public boolean gravesByPassGriefingRules = true;
        @Config.Name(value="allowToFillExistingGrave")
        @Config.LangKey(value="tombstone.config.allow_to_fill_existing_grave")
        @Config.Comment(value={"Allows to fill an existing grave instead of creating a new one"})
        public boolean allowToFillExistingGrave = true;
        @Config.Name(value="lossOnDeathOnlyForAbandonedGrave")
        @Config.LangKey(value="tombstone.config.loss_on_death_only_for_abandoned_grave")
        @Config.Comment(value={"Only abandoned graves can have losses of items (based on the decay_time)"})
        public boolean lossOnDeathOnlyForAbandonedGrave = true;
        @Config.Name(value="lossOnDeathOnlyForStackableItems")
        @Config.LangKey(value="tombstone.config.loss_on_death_only_for_stackable_items")
        @Config.Comment(value={"Only stackable items can be lost on death"})
        public boolean lossOnDeathOnlyForStackableItems = true;
        @Config.Name(value="nerfGhostlyShapeTeleportWithKey")
        @Config.LangKey(value="tombstone.config.nerf_ghostly_shape_teleport_with_key")
        @Config.Comment(value={"Caps the duration of Ghostly Shape effect to 10 seconds when teleporting with a Grave's Key"})
        public boolean nerfGhostlyShapeTeleportWithKey = true;
        @Config.Name(value="nerfGhostlyShapeEnemyCollision")
        @Config.LangKey(value="tombstone.config.nerf_ghostly_shape_enemy_collision")
        @Config.Comment(value={"Cancel the Ghostly Shape effect when colliding an enemy"})
        public boolean nerfGhostlyShapeEnemyCollision = true;
        @Config.Name(value="nerfGhostlyShapeOpenChest")
        @Config.LangKey(value="tombstone.config.nerf_ghostly_shape_open_chest")
        @Config.Comment(value={"Cancel the Ghostly Shape effect when opening a chest"})
        public boolean nerfGhostlyShapeOpenChest = true;
        @Config.Name(value="nerfGhostlyShapeBreakBlock")
        @Config.LangKey(value="tombstone.config.nerf_ghostly_shape_break_block")
        @Config.Comment(value={"Cancel the Ghostly Shape effect when breaking a block"})
        public boolean nerfGhostlyShapeBreakBlock = true;

        public int getXpLoss() {
            return serverXpLoss;
        }

        public boolean isHandlingPlayerXp() {
            return serverXpLoss > -1;
        }

        public int getDecayTime() {
            return serverDecayTime;
        }
    }

    public static class CatRecovery {
        @Config.Name(value="recoveryPlayerEnable")
        @Config.LangKey(value="tombstone.config.recovery_player_enable")
        @Config.Comment(value={"Enables to backup automatically players"})
        public boolean recoveryPlayerEnable = true;
        @Config.Name(value="recoveryPlayerTimer")
        @Config.LangKey(value="tombstone.config.recovery_player_timer")
        @Config.Comment(value={"Time in minutes between players' backups"})
        @Config.RangeInt(min=5, max=1000)
        public int recoveryPlayerTimer = 19;
        @Config.Name(value="recoveryPlayerMaxSaves")
        @Config.LangKey(value="tombstone.config.recovery_player_max_saves")
        @Config.Comment(value={"Maximum number of backups per player"})
        @Config.RangeInt(min=5, max=100)
        public int recoveryPlayerMaxSaves = 15;
        @Config.Name(value="recoveryFamiliarEnable")
        @Config.LangKey(value="tombstone.config.recovery_familiar_enable")
        @Config.Comment(value={"Enables to backup automatically dead familiars"})
        public boolean recoveryFamiliarEnable = true;
        @Config.Name(value="backupOnDeath")
        @Config.LangKey(value="tombstone.config.backup_on_death")
        @Config.Comment(value={"Backup players on death"})
        public boolean backupOnDeath = false;
    }

    public static class CatGeneral {
        @Config.Name(value="teleportDim")
        @Config.LangKey(value="tombstone.config.teleport_dim")
        @Config.Comment(value={"Allows teleportation to other dimensions"})
        public boolean teleportDim = true;
        @Config.Name(value="unhandledBeneficialEffects")
        @Config.LangKey(value="tombstone.config.unhandled_beneficial_effects")
        @Config.Comment(value={"Beneficial effects that can't used by certain features such as ankh of pray, lollipop, scroll of preservation, alchemy perk and magic siphon enchantment"})
        public String[] unhandledBeneficialEffects = new String[]{"extraalchemy", "astralsorcery:potiontimefreeze", "xreliquary:flight_potion"};
        @Config.Name(value="unhandledHarmfulEffects")
        @Config.LangKey(value="tombstone.config.unhandled_harmful_effects")
        @Config.Comment(value={"Harmful effects that can't used by certain features such as tablet of cupidity and the enchantment plague bringer"})
        public String[] unhandledHarmfulEffects = new String[]{"minecraft:nausea"};
        @Config.Name(value="allowBeyondTheGraveDamage")
        @Config.LangKey(value="tombstone.config.allow_beyond_the_grave_damage")
        @Config.Comment(value={"Allows players to be hurt by special damages related to some items"})
        public boolean allowBeyondTheGraveDamage = true;
        @Config.Name(value="cooldownRequestTeleport")
        @Config.LangKey(value="tombstone.config.cooldown_request_teleport")
        @Config.Comment(value={"Cooldown in minutes to use the command tbrequestteleport (-1 = disabled)"})
        @Config.RangeInt(min=-1, max=1440)
        public int cooldownRequestTeleport = -1;
        @Config.Name(value="cooldownTeleportDeath ")
        @Config.LangKey(value="tombstone.config.cooldown_teleport_death")
        @Config.Comment(value={"Cooldown in minutes to use the command tbteleportdeath (-1 = disabled)"})
        @Config.RangeInt(min=-1, max=1440)
        public int cooldownTeleportDeath = -1;
        @Config.Name(value="cooldownTeleportBind")
        @Config.LangKey(value="tombstone.config.cooldown_teleport_bind")
        @Config.Comment(value={"Cooldown in minutes to use the command tbbind (-1 = disabled)"})
        @Config.RangeInt(min=-1, max=1440)
        public int cooldownTeleportBind = -1;
        @Config.Name(value="ghostlyShapeDuration")
        @Config.LangKey(value="tombstone.config.ghostly_shape_duration")
        @Config.Comment(value={"The duration of the Ghostly Shape effect in seconds"})
        @Config.RangeInt(min=0)
        public int ghostlyShapeDuration = 120;
        static int serverGhostlyShapeDuration = 120;
        @Config.Name(value="chanceEnchantedGraveKey")
        @Config.LangKey(value="tombstone.config.chance_enchanted_grave_key")
        @Config.Comment(value={"The chance that a player receives an already enchanted Grave's Key on death"})
        @Config.RangeInt(min=-1, max=100)
        public int chanceEnchantedGraveKey = 0;
        static int serverChanceEnchantedGraveKey = 0;
        @Config.Name(value="scrollDuration")
        @Config.LangKey(value="tombstone.config.scroll_duration")
        @Config.Comment(value={"Scroll duration"})
        @Config.RangeInt(min=1200, max=120000)
        public int scrollDuration = 12000;
        static int serverScrollDuration = 12000;
        @Config.Name(value="perkProgressionScale")
        @Config.LangKey(value="tombstone.config.perk_progression_scale")
        @Config.Comment(value={"Perk Progression Scale"})
        @Config.RangeInt(min=1, max=5)
        public int perkProgressionScale = 2;
        static int serverPerkProgressionScale = 2;
        @Config.Name(value="scrollOfKnowledgeLoss")
        @Config.LangKey(value="tombstone.config.scroll_of_knowledge_loss")
        @Config.Comment(value={"Scroll of Knowledge Loss"})
        @Config.RangeInt(min=0, max=90)
        public int scrollOfKnowledgeLoss = 0;
        static int serverScrollOfKnowledgeLoss = 0;

        public int getGhostlyShapeDuration() {
            return serverGhostlyShapeDuration;
        }

        public int getChanceEnchantedGraveKey() {
            return serverChanceEnchantedGraveKey;
        }

        public int getScrollDuration() {
            return serverScrollDuration;
        }

        public int getPerkProgressionScale() {
            return serverPerkProgressionScale;
        }

        public int getScrollOfKnowledgeLoss() {
            return serverScrollOfKnowledgeLoss;
        }
    }

    public static class CatAllowedMagicItems {
        @Config.Name(value="allowBookOfDisenchantment")
        @Config.LangKey(value="tombstone.item.book_of_disenchantment.name")
        @Config.Comment(value={"Book of Disenchantment"})
        public boolean allowBookOfDisenchantment = true;
        static boolean serverAllowBookOfDisenchantment = true;
        @Config.Name(value="allowBookOfRepairing")
        @Config.LangKey(value="tombstone.item.book_of_repairing.name")
        @Config.Comment(value={"Book of Repairing"})
        public boolean allowBookOfRepairing = true;
        static boolean serverAllowBookOfRepairing = true;
        @Config.Name(value="allowBookOfMagicImpregnation")
        @Config.LangKey(value="tombstone.item.book_of_magic_impregnation.name")
        @Config.Comment(value={"Book of Magic Impregnation"})
        public boolean allowBookOfMagicImpregnation = true;
        static boolean serverAllowBookOfMagicImpregnation = true;
        @Config.Name(value="allowGraveKey")
        @Config.LangKey(value="tombstone.item.grave_key.name")
        @Config.Comment(value={"Grave's Key"})
        public boolean allowGraveKey = true;
        static boolean serverAllowGraveKey = true;
        @Config.Name(value="allowLostTablet")
        @Config.LangKey(value="tombstone.item.lost_tablet.name")
        @Config.Comment(value={"Lost Tablet"})
        public boolean allowLostTablet = true;
        static boolean serverAllowLostTablet = true;
        @Config.Name(value="allowScrollOfKnowledge")
        @Config.LangKey(value="tombstone.item.scroll_of_knowledge.name")
        @Config.Comment(value={"Scroll of Knowledge"})
        public boolean allowScrollOfKnowledge = true;
        static boolean serverAllowScrollOfKnowledge = true;
        @Config.Name(value="allowTabletOfAssistance")
        @Config.LangKey(value="tombstone.item.tablet_of_assistance.name")
        @Config.Comment(value={"Tablet of Assistance"})
        public boolean allowTabletOfAssistance = true;
        static boolean serverAllowTabletOfAssistance = true;
        @Config.Name(value="allowTabletOfRecall")
        @Config.LangKey(value="tombstone.item.tablet_of_recall.name")
        @Config.Comment(value={"Tablet of Recall"})
        public boolean allowTabletOfRecall = true;
        static boolean serverAllowTabletOfRecall = true;
        @Config.Name(value="allowTabletOfHome")
        @Config.LangKey(value="tombstone.item.tablet_of_home.name")
        @Config.Comment(value={"Tablet of Home"})
        public boolean allowTabletOfHome = true;
        static boolean serverAllowTabletOfHome = true;
        @Config.Name(value="allowTabletOfCupidity")
        @Config.LangKey(value="tombstone.item.tablet_of_cupidity.name")
        @Config.Comment(value={"Tablet of Cupidity"})
        public boolean allowTabletOfCupidity = true;
        static boolean serverAllowTabletOfCupidity = true;
        @Config.Name(value="allowVoodooPoppet")
        @Config.LangKey(value="tombstone.item.voodoo_poppet.name")
        @Config.Comment(value={"Voodoo Poppet"})
        public boolean allowVoodooPoppet = true;
        static boolean serverAllowVoodooPoppet = true;
        @Config.Name(value="allowFamiliarReceptacle")
        @Config.LangKey(value="tombstone.item.familiar_receptacle.name")
        @Config.Comment(value={"Familiar Receptacle"})
        public boolean allowFamiliarReceptacle = true;
        static boolean serverAllowFamiliarReceptacle = true;
        @Config.Name(value="allowScrollOfPreservation")
        @Config.LangKey(value="tombstone.item.scroll_of_preservation.name")
        @Config.Comment(value={"Scroll of Preservation"})
        public boolean allowScrollOfPreservation = true;
        static boolean serverAllowScrollOfPreservation = true;
        @Config.Name(value="allowScrollOfUnstableIntangibleness")
        @Config.LangKey(value="tombstone.item.scroll_of_unstable_intangibleness.name")
        @Config.Comment(value={"Scroll of Unstable Intangibility"})
        public boolean allowScrollOfUnstableIntangibleness = true;
        static boolean serverAllowScrollOfUnstableIntangibleness = true;
        @Config.Name(value="allowScrollOfFeatherFall")
        @Config.LangKey(value="tombstone.item.scroll_of_feather_fall.name")
        @Config.Comment(value={"Scroll of Feather Falling"})
        public boolean allowScrollOfFeatherFall = true;
        static boolean serverAllowScrollOfFeatherFall = true;
        @Config.Name(value="allowScrollOfPurification")
        @Config.LangKey(value="tombstone.item.scroll_of_purification.name")
        @Config.Comment(value={"Scroll of Purification"})
        public boolean allowScrollOfPurification = true;
        static boolean serverAllowScrollOfPurification = true;
        @Config.Name(value="allowScrollOfTrueSight")
        @Config.LangKey(value="tombstone.item.scroll_of_true_sight.name")
        @Config.Comment(value={"Scroll of True Sight"})
        public boolean allowScrollOfTrueSight = true;
        static boolean serverAllowScrollOfTrueSight = true;
        @Config.Name(value="allowScrollOfReach")
        @Config.LangKey(value="tombstone.item.scroll_of_reach.name")
        @Config.Comment(value={"Scroll of Reach"})
        public boolean allowScrollOfReach = true;
        static boolean serverAllowScrollOfReach = true;
        @Config.Name(value="allowScrollOfLightningResistance")
        @Config.LangKey(value="tombstone.item.scroll_of_lightning_resistance.name")
        @Config.Comment(value={"Scroll of Lightning Resistance"})
        public boolean allowScrollOfLightningResistance = true;
        static boolean serverAllowScrollOfLightningResistance = true;
        @Config.Name(value="allowScrollOfFrostResistance")
        @Config.LangKey(value="tombstone.item.allow_scroll_of_frost_resistance.name")
        @Config.Comment(value={"Scroll of Frost Resistance"})
        public boolean allowScrollOfFrostResistance = true;
        static boolean serverAllowScrollOfFrostResistance = true;
        @Config.Name(value="allowScrollOfAquaticLife")
        @Config.LangKey(value="tombstone.item.allow_scroll_of_aquatic_life.name")
        @Config.Comment(value={"Scroll of Aquatic Life"})
        public boolean allowScrollOfAquaticLife = true;
        static boolean serverAllowScrollOfAquaticLife = true;
        @Config.Name(value="allowDustOfVanishing")
        @Config.LangKey(value="tombstone.item.dust_of_vanishing.name")
        @Config.Comment(value={"Dust of Vanishing"})
        public boolean allowDustOfVanishing = true;
        static boolean serverAllowDustOfVanishing = true;

        public boolean allowBookOfDisenchantment() {
            return serverAllowBookOfDisenchantment;
        }

        public boolean allowBookOfRepairing() {
            return serverAllowBookOfRepairing;
        }

        public boolean allowBookOfMagicImpregnation() {
            return serverAllowBookOfMagicImpregnation;
        }

        public boolean allowGraveKey() {
            return serverAllowGraveKey;
        }

        public boolean allowLostTablet() {
            return serverAllowLostTablet;
        }

        public boolean allowScrollOfKnowledge() {
            return serverAllowScrollOfKnowledge;
        }

        public boolean allowTabletOfAssistance() {
            return serverAllowTabletOfAssistance;
        }

        public boolean allowTabletOfRecall() {
            return serverAllowTabletOfRecall;
        }

        public boolean allowTabletOfHome() {
            return serverAllowTabletOfHome;
        }

        public boolean allowTabletOfCupidity() {
            return serverAllowTabletOfCupidity;
        }

        public boolean allowVoodooPoppet() {
            return serverAllowVoodooPoppet;
        }

        public boolean allowFamiliarReceptacle() {
            return serverAllowFamiliarReceptacle;
        }

        public boolean allowScrollOfPreservation() {
            return serverAllowScrollOfPreservation;
        }

        public boolean allowScrollOfUnstableIntangibleness() {
            return serverAllowScrollOfUnstableIntangibleness;
        }

        public boolean allowScrollOfFeatherFall() {
            return serverAllowScrollOfFeatherFall;
        }

        public boolean allowScrollOfPurification() {
            return serverAllowScrollOfPurification;
        }

        public boolean allowScrollOfTrueSight() {
            return serverAllowScrollOfTrueSight;
        }

        public boolean allowScrollOfReach() {
            return serverAllowScrollOfReach;
        }

        public boolean allowScrollOfLightningResistance() {
            return serverAllowScrollOfLightningResistance;
        }

        public boolean allowScrollOfFrostResistance() {
            return serverAllowScrollOfFrostResistance;
        }

        public boolean allowScrollOfAquaticLife() {
            return serverAllowScrollOfAquaticLife;
        }

        public boolean allowDustOfVanishing() {
            return serverAllowDustOfVanishing;
        }
    }

    public static class CatLoot {
        @Config.Name(value="chanceLootLostTablet")
        @Config.LangKey(value="tombstone.config.chance_loot_lost_tablet")
        @Config.Comment(value={"Chance to loot a Lost Tablet by fishing"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceLootLostTablet = 100;
        static int serverChanceLootLostTablet = 100;
        @Config.Name(value="chanceGraveDust")
        @Config.LangKey(value="tombstone.config.chance_grave_dust")
        @Config.Comment(value={"Chance on 1000 for undead mobs to drop Grave's Dust"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceGraveDust = 100;
        @Config.Name(value="chanceSoulReceptacleOnBoss")
        @Config.LangKey(value="tombstone.config.chance_soul_receptacle_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a Soul Receptacle on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceSoulReceptacleOnBoss = 50;
        @Config.Name(value="chanceRandomScrollOnBoss")
        @Config.LangKey(value="tombstone.config.chance_random_scroll_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a random scroll on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceRandomScrollOnBoss = 100;
        @Config.Name(value="chanceVoodooPoppetOnBoss")
        @Config.LangKey(value="tombstone.config.chance_voodoo_poppet_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a voodoo poppet on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceVoodooPoppetOnBoss = 100;
        @Config.Name(value="chanceFamiliarReceptacleOnBoss")
        @Config.LangKey(value="tombstone.config.chance_familiar_receptacle_on_boss")
        @Config.Comment(value={"Chance on 1000 to receive a familiar receptacle on undead boss"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceFamiliarReceptacleOnBoss = 100;
        @Config.Name(value="undeadBossLifeForDrop")
        @Config.LangKey(value="tombstone.config.undead_boss_life_for_drop")
        @Config.Comment(value={"Minimum life for an undead to be considered as a boss for drop"})
        @Config.RangeInt(min=200)
        public int undeadBossLifeForDrop = 200;
        @Config.Name(value="unhandledTameableEntities")
        @Config.LangKey(value="tombstone.config.unhandled_tameable_entities")
        @Config.Comment(value={"Entities that can't found as loot in a Familiar Receptacle"})
        public String[] unhandledTameableEntities = new String[0];

        public int getChanceLootLostTablet() {
            return serverChanceLootLostTablet;
        }
    }

    public static class CatDecorativeGrave {
        @Config.Name(value="chanceSoul")
        @Config.LangKey(value="tombstone.config.chance_soul")
        @Config.Comment(value={"Chance on 1000 that a soul appears on a grave"})
        @Config.RangeInt(min=0, max=1000)
        public int chanceSoul = 100;
        @Config.Name(value="timeSoul")
        @Config.LangKey(value="tombstone.config.time_soul")
        @Config.Comment(value={"Time in minutes to check if a soul appears on a grave"})
        @Config.RangeInt(min=30, max=10000)
        public int timeSoul = 30;
        @Config.Name(value="canReplaceGravePlate")
        @Config.LangKey(value="tombstone.config.can_replace_grave_plate")
        @Config.Comment(value={"Allows to replace a grave plate already set on a grave"})
        public boolean canReplaceGravePlate = true;
        @Config.Name(value="tabletMaxUse")
        @Config.LangKey(value="tombstone.config.tablet_max_use")
        @Config.Comment(value={"Maximum uses of a tablet"})
        @Config.RangeInt(min=1, max=10)
        public int tabletMaxUse = 3;
        static int serverTabletMaxUse = 3;
        @Config.Name(value="tabletCooldown")
        @Config.LangKey(value="tombstone.config.tablet_cooldown")
        @Config.Comment(value={"Cooldown in second after using a tablet"})
        @Config.RangeInt(min=60, max=1200)
        public int tabletCooldown = 300;
        static int serverTabletCooldown = 300;
        @Config.Name(value="unbreakableDecorativeGrave")
        @Config.LangKey(value="tombstone.config.unbreakable_decorative_grave")
        @Config.Comment(value={"Sets the decorative graves unbreakable"})
        public boolean unbreakableDecorativeGrave = false;
        static boolean serverUnbreakableDecorativeGrave = false;
        @Config.Name(value="chancePrayReward")
        @Config.LangKey(value="tombstone.config.chance_pray_reward")
        @Config.Comment(value={"Chance to receive a random beneficial spell effect when praying near a grave"})
        @Config.RangeInt(min=0, max=100)
        public int chancePrayReward = 40;
        @Config.Name(value="allowTabletSearchOutsideWorld")
        @Config.LangKey(value="tombstone.config.allow_tablet_search_outside_world")
        @Config.Comment(value={"Allows lost tablets to find locations outside the current world"})
        public boolean allowTabletSearchOutsideWorld = true;
        @Config.Name(value="cooldownResetperk")
        @Config.LangKey(value="tombstone.config.cooldown_reset_perk")
        @Config.Comment(value={"The cooldown in minutes to reset the perks with the Ankh of Pray"})
        @Config.RangeInt(min=20, max=1440)
        public int cooldownResetperk = 120;
        static int serverCooldownResetperk = 120;
        @Config.Name(value="cooldownToPray")
        @Config.LangKey(value="tombstone.config.cooldown_to_pray")
        @Config.Comment(value={"The cooldown in hours to pray with the Ankh of Pray"})
        @Config.RangeInt(min=1, max=10)
        public int cooldownToPray = 3;
        static int serverCooldownToPray = 3;
        @Config.Name(value="durationVoodooPoppetEffects")
        @Config.LangKey(value="tombstone.config.duration_voodoo_poppet_effects")
        @Config.Comment(value={"Duration of voodoo poppet's effects in seconds when preventing death"})
        @Config.RangeInt(min=5, max=60000)
        public int durationVoodooPoppetEffects = 60;

        public int getTabletMaxUse() {
            return serverTabletMaxUse;
        }

        public int tabletCooldown() {
            return serverTabletCooldown;
        }

        public boolean isUnbreakableDecorativeGrave() {
            return serverUnbreakableDecorativeGrave;
        }

        public int getCooldownResetperk() {
            return serverCooldownResetperk;
        }

        public int getCooldownToPray() {
            return serverCooldownToPray;
        }
    }

    public static class CatEnchantments {
        @Config.Name(value="nerfShadowStepForceSneak")
        @Config.LangKey(value="tombstone.config.nerf_shadow_step_force_sneak")
        @Config.Comment(value={"Shadow Step is only active while sneaking"})
        public boolean nerfShadowStepForceSneak = false;
        static boolean serverNerfShadowStepForceSneak = false;
        @Config.Name(value="nerfShadowStepOpenChest")
        @Config.LangKey(value="tombstone.config.nerf_shadow_step_open_chest")
        @Config.Comment(value={"Shadow Step is disabled for 10 seconds by opening a chest"})
        public boolean nerfShadowStepOpenChest = true;
        @Config.Name(value="enableEnchantmentShadowStep")
        @Config.LangKey(value="tombstone.config.enable_enchantment_shadow_step")
        @Config.Comment(value={"Enables the enchantment Shadow Step"})
        public boolean enableEnchantmentShadowStep = true;
        static boolean serverEnableEnchantmentShadowStep = true;
        @Config.Name(value="enableEnchantmentSoulbound")
        @Config.LangKey(value="tombstone.config.enable_enchantment_soulbound")
        @Config.Comment(value={"Enables the enchantment Soulbound"})
        public boolean enableEnchantmentSoulbound = true;
        static boolean serverEnableEnchantmentSoulbound = true;
        @Config.Name(value="enableEnchantmentMagicSiphon")
        @Config.LangKey(value="tombstone.config.enable_enchantment_magic_siphon")
        @Config.Comment(value={"Enables the enchantment Magic Siphon"})
        public boolean enableEnchantmentMagicSiphon = true;
        static boolean serverEnableEnchantmentMagicSiphon = true;
        @Config.Name(value="enableEnchantmentPlagueBringer")
        @Config.LangKey(value="tombstone.config.enable_enchantment_plague_bringer")
        @Config.Comment(value={"Enables the enchantment Plague Bringer"})
        public boolean enableEnchantmentPlagueBringer = true;
        static boolean serverEnableEnchantmentPlagueBringer = true;
        @Config.Name(value="enableEnchantmentBlessing")
        @Config.LangKey(value="tombstone.config.enable_enchantment_blessing")
        @Config.Comment(value={"Enables the enchantment Blessing"})
        public boolean enableEnchantmentBlessing = true;
        static boolean serverEnableEnchantmentBlessing = true;
        @Config.Name(value="enableEnchantmentCurseOfBones")
        @Config.LangKey(value="tombstone.config.enable_enchantment_curse_of_bones")
        @Config.Comment(value={"Enables the enchantment Curse of Bones"})
        public boolean enableEnchantmentCurseOfBones = true;
        static boolean serverEnableEnchantmentCurseOfBones = true;
        @Config.Name(value="soulboundEnchantingTable")
        @Config.LangKey(value="tombstone.config.soulbound_enchanting_table")
        @Config.Comment(value={"Allows Soulbound at enchanting table"})
        public boolean soulboundEnchantingTable = true;
        static boolean serverSoulboundEnchantingTable = true;
        @Config.Name(value="shadowStepEnchantingTable")
        @Config.LangKey(value="tombstone.config.shadow_step_enchanting_table")
        @Config.Comment(value={"Allows Shadow Step at enchanting table"})
        public boolean shadowStepEnchantingTable = false;
        static boolean serverShadowStepEnchantingTable = false;
        @Config.Name(value="magicSiphonEnchantingTable")
        @Config.LangKey(value="tombstone.config.magic_siphon_enchanting_table")
        @Config.Comment(value={"Allows Magic Siphon at enchanting table"})
        public boolean magicSiphonEnchantingTable = false;
        static boolean serverMagicSiphonEnchantingTable = false;
        @Config.Name(value="plagueBringerEnchantingTable")
        @Config.LangKey(value="tombstone.config.plague_bringer_enchanting_table")
        @Config.Comment(value={"Allows Plague Bringer at enchanting table"})
        public boolean plagueBringerEnchantingTable = false;
        static boolean serverPlagueBringerEnchantingTable = false;
        @Config.Name(value="blessingEnchantingTable")
        @Config.LangKey(value="tombstone.config.blessing_enchanting_table")
        @Config.Comment(value={"Allows Blessing at enchanting table"})
        public boolean blessingEnchantingTable = false;
        static boolean serverBlessingEnchantingTable = false;
        @Config.Name(value="curseOfBonesEnchantingTable")
        @Config.LangKey(value="tombstone.config.curse_of_bones_enchanting_table")
        @Config.Comment(value={"Allows Curse of Bones at enchanting table"})
        public boolean curseOfBonesEnchantingTable = false;
        static boolean serverCurseOfBonesEnchantingTable = false;
        @Config.Name(value="allowPlagueBringerCombiningMagicSiphon")
        @Config.LangKey(value="tombstone.config.plague_bringer_combining_magic_siphon")
        @Config.Comment(value={"Allows Plague Bringer to combine with Magic Siphon"})
        public boolean plagueBringerCombiningMagicSiphon = false;
        static boolean serverPlagueBringerCombiningMagicSiphon = false;
        @Config.Name(value="maxLevelShadowStep")
        @Config.LangKey(value="tombstone.config.max_level_shadow_step")
        @Config.Comment(value={"Max level for Shadow Step"})
        @Config.RangeInt(min=1, max=10)
        public int maxLevelShadowStep = 5;
        static int serverMaxLevelShadowStep = 5;
        @Config.Name(value="maxLevelMagicSiphon")
        @Config.LangKey(value="tombstone.config.max_level_magic_siphon")
        @Config.Comment(value={"Max level for Magic Siphon"})
        @Config.RangeInt(min=1, max=10)
        public int maxLevelMagicSiphon = 5;
        static int serverMaxLevelMagicSiphon = 5;
        @Config.Name(value="maxLevelPlagueBringer")
        @Config.LangKey(value="tombstone.config.max_level_plague_bringer")
        @Config.Comment(value={"Max level for Plague Bringer"})
        @Config.RangeInt(min=1, max=10)
        public int maxLevelPlagueBringer = 3;
        static int serverMaxLevelPlagueBringer = 3;
        @Config.Name(value="maxLevelCurseOfBones")
        @Config.LangKey(value="tombstone.config.max_level_curse_of_bones")
        @Config.Comment(value={"Max level for Curse of Bones"})
        @Config.RangeInt(min=1, max=10)
        public int maxLevelCurseOfBones = 3;
        static int serverMaxLevelCurseOfBones = 3;
        @Config.Name(value="nerfPlagueBringer")
        @Config.LangKey(value="tombstone.config.nerf_plague_bringer")
        @Config.Comment(value={"The wearer is also affected by the effect if his alignment is not bad"})
        public boolean nerfPlagueBringer = true;
        @Config.Name(value="maxDurationMagicSiphon")
        @Config.LangKey(value="tombstone.config.max_duration_magic_siphon")
        @Config.Comment(value={"Maximum duration of stolen effects in minutes"})
        @Config.RangeInt(min=1)
        public int maxDurationMagicSiphon = 1440;
        @Config.Name(value="durationPlagueBringer")
        @Config.LangKey(value="tombstone.config.duration_plague_bringer")
        @Config.Comment(value={"Duration of applied effects in seconds"})
        @Config.RangeInt(min=1)
        public int durationPlagueBringer = 10;
        @Config.Name(value="magicSiphonOnPlayerRule ")
        @Config.LangKey(value="tombstone.config.magic_siphon_on_player_rule")
        @Config.Comment(value={"Defines if players can steal effects to others players. If nerfed, the stolen effect duration is limited to 10% of the initial effect"})
        public MagicSiphonOnPlayerRule magicSiphonOnPlayerRule = MagicSiphonOnPlayerRule.ALLOW;

        public boolean isNerfShadowStepForceSneak() {
            return serverNerfShadowStepForceSneak;
        }

        public boolean isEnableEnchantmentShadowStep() {
            return serverEnableEnchantmentShadowStep;
        }

        public boolean isEnableEnchantmentSoulbound() {
            return serverEnableEnchantmentSoulbound;
        }

        public boolean isEnableEnchantmentMagicSiphon() {
            return serverEnableEnchantmentMagicSiphon;
        }

        public boolean isEnableEnchantmentPlagueBringer() {
            return serverEnableEnchantmentPlagueBringer;
        }

        public boolean isEnableEnchantmentBlessing() {
            return serverEnableEnchantmentBlessing;
        }

        public boolean isEnableEnchantmentCurseOfBones() {
            return serverEnableEnchantmentCurseOfBones;
        }

        public boolean allowSoulboundAtEnchantingTable() {
            return serverSoulboundEnchantingTable;
        }

        public boolean allowShadowStepAtEnchantingTable() {
            return serverShadowStepEnchantingTable;
        }

        public boolean allowMagicSiphonAtEnchantingTable() {
            return serverMagicSiphonEnchantingTable;
        }

        public boolean allowPlagueBringerAtEnchantingTable() {
            return serverPlagueBringerEnchantingTable;
        }

        public boolean allowBlessingAtEnchantingTable() {
            return serverBlessingEnchantingTable;
        }

        public boolean allowCurseOfBonesAtEnchantingTable() {
            return serverCurseOfBonesEnchantingTable;
        }

        public boolean allowPlagueBringerCombiningWithMagicSiphon() {
            return serverPlagueBringerCombiningMagicSiphon;
        }

        public int getMaxLevelShadowStep() {
            return serverMaxLevelShadowStep;
        }

        public int getMaxLevelMagicSiphon() {
            return serverMaxLevelMagicSiphon;
        }

        public int getMaxLevelPlagueBringer() {
            return serverMaxLevelPlagueBringer;
        }

        public int getMaxLevelCurseOfBones() {
            return serverMaxLevelCurseOfBones;
        }

        public static enum MagicSiphonOnPlayerRule {
            ALLOW,
            NERFED,
            DISALLOW;

        }
    }

    public static class CatVillageSiege {
        @Config.Name(value="handleVillageSiege")
        @Config.LangKey(value="tombstone.config.handle_village_siege")
        @Config.Comment(value={"Allows to handle village sieges"})
        @Config.RequiresWorldRestart
        public boolean handleVillageSiege = true;
        @Config.Name(value="logSiegeState")
        @Config.LangKey(value="tombstone.config.log_siege_state")
        @Config.Comment(value={"Logs the different states of a village siege while searching for an adequate place"})
        public boolean logSiegeState = false;
        @Config.Name(value="deniedDimensionTypeForSiege")
        @Config.LangKey(value="tombstone.config.denied_dimension_type_for_siege")
        @Config.Comment(value={"The dimensions that village sieges should not occur in"})
        @Config.RequiresWorldRestart
        public String[] deniedDimensionTypeForSiege = new String[]{"the_nether", "the_end"};
        @Config.Name(value="allowCreativePlayersForSiege")
        @Config.LangKey(value="tombstone.config.allow_creative_players_for_siege")
        @Config.Comment(value={"Allows to use the positions of creative players to define the siege location"})
        public boolean allowCreativePlayersForSiege = false;
        @Config.Name(value="siegeChance")
        @Config.LangKey(value="tombstone.config.siege_chance")
        @Config.Comment(value={"Chance for a siege to occur"})
        @Config.RangeInt(min=0, max=100)
        public int siegeChance = 10;
        @Config.Name(value="siegeMinDoor")
        @Config.LangKey(value="tombstone.config.siege_min_door")
        @Config.Comment(value={"Minimum of doors for a siege"})
        @Config.RangeInt(min=0, max=50)
        public int siegeMinDoor = 10;
        @Config.Name(value="siegeMinVillager")
        @Config.LangKey(value="tombstone.config.siege_min_villager")
        @Config.Comment(value={"Minimum of villagers for a siege"})
        @Config.RangeInt(min=0, max=50)
        public int siegeMinVillager = 20;
        @Config.Name(value="siegeMinGolem")
        @Config.LangKey(value="tombstone.config.siege_min_golem")
        @Config.Comment(value={"Minimum of golems for a siege"})
        @Config.RangeInt(min=0, max=5)
        public int siegeMinGolem = 0;
        @Config.Name(value="siegeMaxCreature")
        @Config.LangKey(value="tombstone.config.siege_max_creature")
        @Config.Comment(value={"Maximum of creatures appearing in a siege"})
        @Config.RangeInt(min=0, max=100)
        public int siegeMaxCreature = 20;
        @Config.Name(value="undeadWearHelmInSiege")
        @Config.LangKey(value="tombstone.config.undead_wear_helm_in_siege")
        @Config.Comment(value={"Undeads always wear a helm when sieging"})
        public boolean undeadWearHelmInSiege = true;
        @Config.Name(value="delaySiegeTest")
        @Config.LangKey(value="tombstone.config.delay_siege_test")
        @Config.Comment(value={"Delay in seconds for a second test of siege when the first failed"})
        @Config.RangeInt(min=0, max=2400)
        public int delaySiegeTest = 600;
        @Config.Name(value="persistentMobInSiege")
        @Config.LangKey(value="tombstone.config.persistent_mob_in_siege")
        @Config.Comment(value={"Mobs in siege are persistent"})
        public boolean persistentMobInSiege = false;
        @Config.Name(value="shufflePlayersForSiege")
        @Config.LangKey(value="tombstone.config.shuffle_players_for_siege")
        @Config.Comment(value={"Shuffles the list of players before testing the siege location"})
        public boolean shufflePlayersForSiege = true;
        @Config.Name(value="glowingCreatureTest")
        @Config.LangKey(value="tombstone.config.glowing_creature_test")
        @Config.Comment(value={"The creatures of the siege have a glowing effect (only uses this for test purposes)"})
        public boolean glowingCreatureTest = false;
    }

    public static class CatCompatibilities {
        @Config.Name(value="allowBaublesAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_baubles_autoEquip")
        @Config.Comment(value={"Allows to re-equip the Baubles slots"})
        public boolean allowBaublesAutoEquip = true;
        @Config.Name(value="allowGalacticrafAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_galacticraf_autoEquip")
        @Config.Comment(value={"Allows to re-equip Galacticraft slots"})
        public boolean allowGalacticrafAutoEquip = true;
        @Config.Name(value="allowTechgunsAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_techguns_autoEquip")
        @Config.Comment(value={"Allows to re-equip Techguns slots"})
        public boolean allowTechgunsAutoEquip = true;
        @Config.Name(value="allowAetherLegacyAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_aether_legacy_autoEquip")
        @Config.Comment(value={"Allows to re-equip Aether Legacy slots"})
        public boolean allowAetherLegacyAutoEquip = false;
        @Config.Name(value="allowRPGInventoryAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_rpg_inventory_autoEquip")
        @Config.Comment(value={"Allows to re-equip RPG Inventory slots"})
        public boolean allowRPGInventoryAutoEquip = true;
        @Config.Name(value="allowTheBetweenLandsAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_the_between_lands_autoEquip")
        @Config.Comment(value={"Allows to re-equip The BetweenLands slots"})
        public boolean allowTheBetweenLandsAutoEquip = true;
        @Config.Name(value="allowSmartBackpacksAutoEquip")
        @Config.LangKey(value="tombstone.config.allow_smart_backpacks_autoEquip")
        @Config.Comment(value={"Allows to re-equip the backpack slot"})
        public boolean allowSmartBackpacksAutoEquip = true;
        @Config.Name(value="supportWearableBackpacks")
        @Config.LangKey(value="tombstone.config.support_wearable_backpacks")
        @Config.Comment(value={"Allows to move the backpack close to the grave"})
        public boolean supportWearableBackpacks = false;
        @Config.Name(value="keepCosmeticArmor")
        @Config.LangKey(value="tombstone.config.keep_cosmetic_armor")
        @Config.Comment(value={"Keeps the cosmetic armor when you die"})
        public boolean keepCosmeticArmor = true;
        @Config.Name(value="allowThaumcraftVisValues")
        @Config.LangKey(value="tombstone.config.allow_thaumcraft_vis_values")
        @Config.Comment(value={"Allows to provide some vis values for decorative graves"})
        public boolean allowThaumcraftVisValues = false;
        @Config.Name(value="preserveEffectsOnReturnEndConquered")
        @Config.LangKey(value="tombstone.config.preserve_effects_on_return_end_conquered")
        @Config.Comment(value={"Ensure the potion effects to stay on the player after returning from end conquered"})
        public boolean preserveEffectsOnReturnEndConquered = true;
    }

    public static class CatClient {
        public static PlayerPreference lastPlayerPreference;
        @Config.Name(value="equipElytraInPriority")
        @Config.LangKey(value="tombstone.config.equip_elytra_in_priority")
        @Config.Comment(value={"Equips elytra in priority when recovering your lost items"})
        public boolean equipElytraInPriority = false;
        @Config.Name(value="favoriteGrave")
        @Config.LangKey(value="tombstone.config.favorite_grave")
        @Config.Comment(value={"Favorite grave"})
        public GraveModel favoriteGrave = GraveModel.GRAVE_SIMPLE;
        @Config.Name(value="favoriteGraveMarble")
        @Config.LangKey(value="tombstone.config.favorite_grave_marble")
        @Config.Comment(value={"Favorite grave marble"})
        public BlockGraveMarble.MarbleType favoriteGraveMarble = BlockGraveMarble.MarbleType.DARK;
        @Config.Name(value="highlight")
        @Config.LangKey(value="tombstone.config.highlight")
        @Config.Comment(value={"Highlights the tomb from far when holding the key"})
        public boolean highlight = true;
        @Config.Name(value="fogDensity")
        @Config.LangKey(value="tombstone.config.fog_density")
        @Config.Comment(value={"Fog density around the graves"})
        public FogDensity fogDensity = FogDensity.LOW;
        @Config.Name(value="showShadowStep")
        @Config.LangKey(value="tombstone.config.show_shadow_step")
        @Config.Comment(value={"Shows shadow step particles"})
        public boolean showShadowStep = true;
        @Config.Name(value="textColorRIP")
        @Config.LangKey(value="tombstone.config.text_color_rip")
        @Config.Comment(value={"Decimal value for the color of the grave text <R.I.P.>"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int textColorRIP = 2962496;
        @Config.Name(value="textColorOwner")
        @Config.LangKey(value="tombstone.config.text_color_owner")
        @Config.Comment(value={"Decimal value for the color of the grave text <Owner Name>"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int textColorOwner = 5991302;
        @Config.Name(value="textColorDeathDate")
        @Config.LangKey(value="tombstone.config.text_color_death_date")
        @Config.Comment(value={"Decimal value for the color of the grave text <Death Date>"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int textColorDeathDate = 2962496;
        @Config.Name(value="particleCastingColor")
        @Config.LangKey(value="tombstone.config.particle_casting_color")
        @Config.Comment(value={"Decimal value for the color of the particles when using magic items"})
        @Config.RangeInt(min=0, max=0xFFFFFF)
        public int particleCastingColor = 14937088;
        @Config.Name(value="showMagicCircle")
        @Config.LangKey(value="tombstone.config.show_magic_circle")
        @Config.Comment(value={"Shows the magic circles"})
        public boolean showMagicCircle = true;
        @Config.Name(value="showShieldParticle")
        @Config.LangKey(value="tombstone.config.show_shield_particle")
        @Config.Comment(value={"Shows shield particles on villager"})
        public boolean showShieldParticle = true;
        @Config.Name(value="skipRespawnScreen")
        @Config.LangKey(value="tombstone.config.skip_respawn_screen")
        @Config.Comment(value={"Skips the Respawn Screen"})
        public boolean skipRespawnScreen = false;
        @Config.Name(value="showEnhancedTooltips")
        @Config.LangKey(value="tombstone.config.show_enhanced_tooltips")
        @Config.Comment(value={"Shows all the infos in the tooltip of items"})
        public boolean showEnhancedTooltips = true;
        @Config.Name(value="dateInMCTime")
        @Config.LangKey(value="tombstone.config.date_in_mc_time")
        @Config.Comment(value={"Shows only the elapsed minecraft days since the death on graves"})
        public boolean dateInMCTime = false;
        @Config.Name(value="displayKnowledgeMessage")
        @Config.LangKey(value="tombstone.config.display_knowledge_message")
        @Config.Comment(value={"Display or not the messages of gain of points in knowledge of death"})
        public boolean displayKnowledgeMessage = false;
        @Config.Name(value="enableHalloweenEffect")
        @Config.LangKey(value="tombstone.config.enable_halloween_effect")
        @Config.Comment(value={"Enables the special rendering and particles for Halloween"})
        public boolean enableHalloweenEffect = true;
        @Config.Name(value="showInfoOnEnchantment")
        @Config.LangKey(value="tombstone.config.show_info_on_enchantment")
        @Config.Comment(value={"Shows the use of the Tombstone's enchantments in tooltip"})
        public boolean showInfoOnEnchantment = true;
        @Config.Name(value="graveSkinRule")
        @Config.LangKey(value="tombstone.config.grave_skin_rule")
        @Config.Comment(value={"Defines the rule to use for grave's skin"})
        public GraveSkinRule graveSkinRule = GraveSkinRule.DEFAULT;
        @Config.Name(value="graveSpawnRule")
        @Config.LangKey(value="tombstone.config.grave_spawn_rule")
        @Config.Comment(value={"Defines your grave placement logic (nearest or ideal placement)"})
        public GraveSpawnRule graveSpawnRule = GraveSpawnRule.getDefault();
        @Config.Name(value="autoEquipRule")
        @Config.LangKey(value="tombstone.config.auto_equip_rule")
        @Config.Comment(value={"Defines when to automatically equip your items"})
        public AutoEquipRule autoEquipRule = AutoEquipRule.getDefault();
        @Config.Name(value="priorizeToolOnHotbar")
        @Config.LangKey(value="tombstone.config.priorize_tool_on_hotbar")
        @Config.Comment(value={"Favor the tools on the hotbar when recovering a grave"})
        public boolean priorizeToolOnHotbar = false;
        @Config.Name(value="fogColor")
        @Config.LangKey(value="tombstone.config.fog_color")
        @Config.Comment(value={"Decimal value of the fog color"})
        public int fogColor = 0xFFFFFF;
        @Config.Name(value="fogPeriod")
        @Config.LangKey(value="tombstone.config.fog_period")
        @Config.Comment(value={"Period where graves produce fog"})
        public FogPeriod fogPeriod = FogPeriod.NIGHT;
        @Config.Name(value="activateGraveBySneaking")
        @Config.LangKey(value="tombstone.config.activate_grave_by_sneaking")
        @Config.Comment(value={"Allows to activate a grave by sneaking"})
        public boolean activateGraveBySneaking = true;
        @Config.Name(value="denyGraveOnDeath")
        @Config.LangKey(value="tombstone.config.deny_grave_on_death")
        @Config.Comment(value={"Denies to create a grave with your items when you die"})
        public boolean denyGraveOnDeath = false;
        @Config.Name(value="markerType")
        @Config.LangKey(value="tombstone.config.marker_type")
        @Config.Comment(value={"Defines the type of marker when holding in hand some items like the Grave's Key"})
        public MarkerType markerType = MarkerType.getDefault();

        public static enum MarkerType {
            WING,
            SPARK,
            NOTE,
            BOX;

            private final String translation = Helper.capitalizeWord(this.name());

            public static MarkerType getDefault() {
                return WING;
            }

            public String getTranslation() {
                return this.translation;
            }
        }

        public static enum FogPeriod implements Predicate<World>
        {
            DAY(Helper::isDay),
            NIGHT(Helper::isNight),
            BOTH(world -> true),
            NEVER(world -> false);

            private final Predicate<World> predic;

            private FogPeriod(Predicate<World> predic) {
                this.predic = predic;
            }

            @Override
            public boolean test(World world) {
                return this.predic.test(world);
            }
        }

        public static enum AutoEquipRule {
            NEVER,
            GRAVE_RECOVERY,
            DEATH_RESPAWN,
            ALWAYS;


            public static AutoEquipRule getDefault() {
                return ALWAYS;
            }

            public static AutoEquipRule byId(int id) {
                return id >= 0 && id < AutoEquipRule.values().length ? AutoEquipRule.values()[id] : AutoEquipRule.getDefault();
            }

            public boolean equiOnRespawn() {
                return this == DEATH_RESPAWN || this == ALWAYS;
            }

            public boolean equiOnGraveRecovery() {
                return this == GRAVE_RECOVERY || this == ALWAYS;
            }
        }

        public static enum GraveSpawnRule {
            SAFEST,
            NORMAL,
            NEAREST;


            public static GraveSpawnRule getDefault() {
                return NORMAL;
            }

            public static GraveSpawnRule byId(int id) {
                return id >= 0 && id < GraveSpawnRule.values().length ? GraveSpawnRule.values()[id] : GraveSpawnRule.getDefault();
            }
        }

        public static enum GraveSkinRule {
            DEFAULT,
            FORCE_NORMAL,
            FORCE_HALLOWEEN;

        }

        public static enum FogDensity {
            NONE,
            LOW,
            NORMAL,
            HIGH;

        }
    }

    public static class CatAlignment {
        @Config.Name(value="pointsFreeSoulReceptacle")
        @Config.LangKey(value="tombstone.config.points_free_soul_receptacle")
        @Config.Comment(value={"Points for freeing a soul in a receptacle"})
        @Config.RangeInt(min=0, max=50)
        public int pointsFreeSoulReceptacle = 10;
        @Config.Name(value="pointsPlunderPlayerGrave")
        @Config.LangKey(value="tombstone.config.points_plunder_player_grave")
        @Config.Comment(value={"Points for plundering a player's grave"})
        @Config.RangeInt(min=-50, max=0)
        public int pointsPlunderPlayerGrave = -2;
        @Config.Name(value="pointsExorcismZombieVillager")
        @Config.LangKey(value="tombstone.config.points_exorcism_zombie_villager")
        @Config.Comment(value={"Points for zombie villager exorcism"})
        @Config.RangeInt(min=0, max=50)
        public int pointsExorcismZombieVillager = 3;
        @Config.Name(value="pointsKillVillager")
        @Config.LangKey(value="tombstone.config.points_kill_villager")
        @Config.Comment(value={"Points for killing a villager"})
        @Config.RangeInt(min=-50, max=0)
        public int pointsKillVillager = -3;
        @Config.Name(value="pointsKillRaider")
        @Config.LangKey(value="tombstone.config.points_kill_raider")
        @Config.Comment(value={"Points for killing a raider"})
        @Config.RangeInt(min=0, max=20)
        public int pointsKillRaider = 1;
        @Config.Name(value="pointsTabletOfCupidity")
        @Config.LangKey(value="tombstone.config.points_tablet_of_cupidity")
        @Config.Comment(value={"Points for tablet of cupidity"})
        @Config.RangeInt(min=-20, max=0)
        public int pointsTabletOfCupidity = -2;
        @Config.Name(value="pointsPrayOfProtection")
        @Config.LangKey(value="tombstone.config.points_pray_of_protection")
        @Config.Comment(value={"Points for Pray of Protection"})
        @Config.RangeInt(min=0, max=50)
        public int pointsPrayOfProtection = 2;
    }
}

