/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.ArmorEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModEffects;

public class EnchantmentCurseOfBones
extends ArmorEnchantment {
    private static final String BONE_SHIELD_LAST_PROC_NBT_LONG = "bone_shield_last_proc";

    public EnchantmentCurseOfBones() {
        super("curse_of_bones", Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_CHEST, EntityEquipmentSlot.CHEST);
    }

    @Override
    public boolean isEnabled() {
        return ConfigTombstone.enchantments.isEnableEnchantmentCurseOfBones();
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigTombstone.enchantments.allowCurseOfBonesAtEnchantingTable() && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public int getLevelLimit() {
        return ConfigTombstone.enchantments.getMaxLevelCurseOfBones();
    }

    @Override
    protected void onWearerHit(EntityLivingBase wearer, Entity attacker, int level) {
        int delay = TimeHelper.tickFromSecond(60 - Math.min(level * 3, 30));
        if (EntityHelper.getCurseOfBonesLevel(wearer) > 0) {
            boolean valid;
            NBTTagCompound persistantData = wearer.getEntityData();
            boolean bl = valid = !persistantData.func_150297_b(BONE_SHIELD_LAST_PROC_NBT_LONG, 4);
            if (!valid) {
                long timeLeft = persistantData.func_74763_f(BONE_SHIELD_LAST_PROC_NBT_LONG) - (long)wearer.field_70173_aa;
                if (timeLeft <= 0L) {
                    persistantData.func_82580_o(BONE_SHIELD_LAST_PROC_NBT_LONG);
                    valid = true;
                } else if (timeLeft > (long)delay) {
                    persistantData.func_74772_a(BONE_SHIELD_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
                }
            }
            if (valid && wearer.func_70681_au().nextFloat() < 0.1f + (float)level * 0.1f) {
                PotionEffect effect = new PotionEffect(ModEffects.bone_shield, TimeHelper.tickFromSecond(10), level);
                EffectHelper.addPotion(wearer, effect);
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)new EffectMessage(wearer.func_145782_y(), effect), (Entity)wearer);
                persistantData.func_74772_a(BONE_SHIELD_LAST_PROC_NBT_LONG, (long)(wearer.field_70173_aa + delay));
            }
        }
    }
}

