/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.WeaponEnchantment;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;

public class EnchantmentPlagueBringer
extends WeaponEnchantment {
    public EnchantmentPlagueBringer() {
        super("plague_bringer", Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, EntityEquipmentSlot.MAINHAND);
    }

    @Override
    public boolean isEnabled() {
        return ConfigTombstone.enchantments.isEnableEnchantmentPlagueBringer();
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && (ConfigTombstone.enchantments.allowPlagueBringerCombiningWithMagicSiphon() || ench != ModEnchantments.magic_siphon);
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return ConfigTombstone.enchantments.allowPlagueBringerAtEnchantingTable() && super.canApplyAtEnchantingTable(stack);
    }

    @Override
    public int getLevelLimit() {
        return ConfigTombstone.enchantments.getMaxLevelPlagueBringer();
    }

    @Override
    protected boolean testProc(EntityLivingBase attacker, EntityLivingBase target, int level) {
        return Helper.RANDOM.nextInt(20) < level;
    }

    @Override
    public void onProc(EntityLivingBase attacker, EntityLivingBase target, int level) {
        PotionEffect effect = EffectHelper.getRandomEffect(TimeHelper.tickFromSecond(ConfigTombstone.enchantments.durationPlagueBringer), true);
        if (effect != null) {
            boolean canAffectAttacker;
            target.func_70690_d(effect);
            boolean bl = canAffectAttacker = ConfigTombstone.enchantments.nerfPlagueBringer && (!EntityHelper.isValidPlayer((Entity)attacker) || !EntityHelper.isBadAlignment((EntityPlayer)attacker));
            if (canAffectAttacker) {
                attacker.func_70690_d(effect);
            }
        }
    }
}

