/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public abstract class TombstoneEnchantment
extends Enchantment {
    final String customName;

    TombstoneEnchantment(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot ... slots) {
        super(rarity, type, slots);
        this.customName = name;
        this.setRegistryName("tombstone", name);
        this.func_77322_b(name);
    }

    public abstract boolean isEnabled();

    public boolean isInBeta() {
        return false;
    }

    public int func_77319_d() {
        return 1;
    }

    @Deprecated
    public int func_77325_b() {
        return this.getLevelLimit();
    }

    public abstract int getLevelLimit();

    public int func_77321_a(int amplifier) {
        return amplifier == 1 ? 1 : super.func_77321_a(amplifier);
    }

    public int func_77317_b(int amplifier) {
        return amplifier >= this.getLevelLimit() ? Integer.MAX_VALUE : super.func_77317_b(amplifier);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        assert (this.field_77351_y != null);
        return this.isEnabled() && this.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public boolean func_92089_a(ItemStack stack) {
        assert (this.field_77351_y != null);
        return this.isEnabled() && this.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltipInfos(boolean isEnchantedBook) {
        ArrayList<String> infos = new ArrayList<String>();
        if (isEnchantedBook) {
            infos.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_ENCHANT, "enchantment.tombstone." + this.field_77350_z + ".desc", new Object[0]));
        }
        if (this.isInBeta()) {
            infos.add(LangKey.TOOLTIP_IN_BETA.getClientTranslationWithStyle(StyleType.MESSAGE_SPELL, new Object[0]));
        }
        if (!this.isEnabled()) {
            infos.add(LangKey.MESSAGE_DISABLED.getClientTranslationWithStyle(StyleType.COLOR_OFF, new Object[0]));
        }
        return infos;
    }

    public String func_77320_a() {
        return "enchantment.tombstone." + this.customName + ".name";
    }

    public String func_77316_c(int level) {
        String fullname = TextFormatting.GRAY + I18n.func_74838_a((String)this.func_77320_a());
        int limit = this.getLevelLimit();
        if (limit == 1) {
            return fullname;
        }
        return fullname + " " + I18n.func_74838_a((String)("enchantment.level." + Math.min(level, limit)));
    }
}

