/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.UUID;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import org.apache.commons.lang3.tuple.Triple;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public abstract class WeaponEnchantment
extends TombstoneEnchantment {
    private Triple<UUID, UUID, Long> lastAttackId = null;

    WeaponEnchantment(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot ... slots) {
        super(name, rarity, type, slots);
    }

    public void func_151368_a(EntityLivingBase attacker, Entity entity, int level) {
        int lvl;
        if (attacker == null || !(entity instanceof EntityLivingBase) || attacker.field_70170_p.field_72995_K) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)entity;
        Triple attackId = Triple.of((Object)attacker.func_110124_au(), (Object)target.func_110124_au(), (Object)TimeHelper.worldTicks(attacker.field_70170_p));
        if (attackId.equals(this.lastAttackId)) {
            return;
        }
        this.lastAttackId = attackId;
        if (this.canAffectTarget(target) && target.func_70089_S() && this.isMainHand(attacker, target) && (lvl = EnchantmentHelper.func_77506_a((Enchantment)this, (ItemStack)attacker.func_184614_ca())) > 0 && this.testProc(attacker, target, lvl)) {
            this.onProc(attacker, target, lvl);
        }
    }

    private boolean isMainHand(EntityLivingBase attacker, EntityLivingBase target) {
        DamageSource lastDamage;
        boolean bl = EntityHelper.isValidPlayer((Entity)attacker) ? attacker.field_184617_aD == 0 : (lastDamage = target.func_189748_bU()) != null && !lastDamage.func_76352_a();
        return bl;
    }

    protected boolean canAffectTarget(EntityLivingBase target) {
        return true;
    }

    protected boolean testProc(EntityLivingBase attacker, EntityLivingBase target, int level) {
        return Helper.RANDOM.nextInt(10) < level;
    }

    protected abstract void onProc(EntityLivingBase var1, EntityLivingBase var2, int var3);
}

