/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.GuiKnowledge;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.MarkerHandler;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="tombstone")
@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    public static final KeyBinding KEYBIND_KNOWLEDGE = new KeyBinding(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, 0, "Corail Tombstone");
    private static boolean isFirstGuiGameOver = false;
    private static boolean requireRemovalVisibility = false;
    private static boolean requireRemovalNightVision = false;
    private static boolean hasWaterVision = false;
    private static boolean hasTrueSight = false;
    private static boolean isGhostlyRender = false;
    public static boolean delayedGui = false;
    private static long nextGhostTime = -1L;
    private static final List<Aura> AURAS = new ArrayList<Aura>();
    private static final ResourceLocation[] AURA_TEXTURES = new ResourceLocation[]{new ResourceLocation("tombstone", "textures/aura/aura1.png")};

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147113_T()) {
            return;
        }
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            requireRemovalNightVision = false;
            hasWaterVision = false;
            hasTrueSight = false;
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            MarkerHandler.instance.update(mc);
            hasTrueSight = EffectHelper.isPotionActive((EntityLivingBase)mc.field_71439_g, ModEffects.ghostly_shape, 4) || EffectHelper.isPotionActive((EntityLivingBase)mc.field_71439_g, ModEffects.true_sight);
            hasWaterVision = hasTrueSight || EffectHelper.isPotionActive((EntityLivingBase)mc.field_71439_g, ModEffects.aquatic_life) && ActiveRenderInfo.func_186703_a((World)mc.field_71441_e, (Entity)mc.field_71439_g, (float)mc.func_184121_ak()).func_185904_a() == Material.field_151586_h;
            boolean bl = requireRemovalNightVision = hasTrueSight && !EffectHelper.isPotionActive((EntityLivingBase)mc.field_71439_g, MobEffects.field_76439_r);
            if (requireRemovalNightVision) {
                mc.field_71439_g.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 1200, 0, true, false));
            }
        } else {
            ITBCapability cap;
            if (requireRemovalNightVision) {
                requireRemovalNightVision = false;
                mc.field_71439_g.func_184596_c(MobEffects.field_76439_r);
            }
            if ((KEYBIND_KNOWLEDGE.func_151468_f() || delayedGui) && (mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat) && (cap = (ITBCapability)mc.field_71439_g.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null) {
                delayedGui = false;
                mc.func_147108_a((GuiScreen)new GuiKnowledge(mc.field_71439_g, cap));
            }
            if (ConfigTombstone.client.enableHalloweenEffect && TimeHelper.isDateAroundHalloween()) {
                if (Helper.isNight((World)mc.field_71441_e)) {
                    long time = TimeHelper.worldTicks((World)mc.field_71441_e);
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((EntityPlayer)mc.field_71439_g, CooldownType.NEXT_PRAY)) {
                            BlockPos pos = mc.field_71439_g.func_180425_c().func_177982_a(Helper.getRandom(-9, 9), 0, Helper.getRandom(-9, 9));
                            mc.field_71452_i.func_78873_a((Particle)new ParticleGhost(mc.field_71439_g.field_70170_p, pos));
                            mc.field_71439_g.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(mc.field_71439_g.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true));
                            mc.field_71441_e.func_184156_a(pos, SoundHandler.getSound(Helper.getRandom(0, 3) == 0 ? "ghost_laugh" : "ghost_howl"), SoundCategory.VOICE, 1.0f, 1.0f, true);
                        }
                        nextGhostTime = time + (long)Helper.getRandom(60, 6000);
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiRender(GuiScreenEvent.DrawScreenEvent event) {
        if (requireRemovalNightVision) {
            Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).ifPresent(p -> p.func_184596_c(MobEffects.field_76439_r));
            requireRemovalNightVision = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onClientChatEvent(CommandEvent event) {
        if (event.isCanceled() && event.getCommand().func_71517_b().equals("tbgui")) {
            event.setCanceled(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLivingPre(RenderLivingEvent.Pre<?> event) {
        if (hasTrueSight && event.getEntity().func_82150_aj()) {
            if (Optional.ofNullable(Minecraft.func_71410_x().field_71439_g).map(arg_0 -> ((EntityLivingBase)event.getEntity()).func_98034_c(arg_0)).orElse(false).booleanValue()) {
                event.getEntity().func_82142_c(false);
                requireRemovalVisibility = true;
            }
        }
        if (ConfigTombstone.client.showMagicCircle) {
            Aura.addAura(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderLivingPost(RenderLivingEvent.Post<?> event) {
        if (requireRemovalVisibility) {
            event.getEntity().func_82142_c(true);
            requireRemovalVisibility = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        boolean bl = isGhostlyRender = EffectHelper.isPotionActive((EntityLivingBase)event.getEntityPlayer(), ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangiblenessActive((EntityLivingBase)event.getEntityPlayer());
        if (isGhostlyRender) {
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderPlayer(RenderPlayerEvent.Post event) {
        if (isGhostlyRender) {
            GlStateManager.func_187440_b((GlStateManager.Profile)GlStateManager.Profile.TRANSPARENT_MODEL);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(GuiOpenEvent event) {
        EntityPlayerSP player;
        if (event.getGui() instanceof GuiGameOver && ConfigTombstone.client.skipRespawnScreen && (player = Minecraft.func_71410_x().field_71439_g) != null && !player.field_70170_p.func_72912_H().func_76093_s()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.func_71004_bE();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (hasTrueSight || hasWaterVision) {
            boolean isWater;
            Material cameraMaterial = event.getState().func_185904_a();
            boolean bl = isWater = cameraMaterial == Material.field_151586_h;
            if (isWater || hasTrueSight && cameraMaterial == Material.field_151587_i) {
                event.setCanceled(true);
                event.setDensity(isWater ? 0.025f : 0.8f);
                GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRenderFog(EntityViewRenderEvent.FogColors event) {
        if (hasTrueSight || hasWaterVision) {
            Material cameraMaterial = event.getState().func_185904_a();
            if (cameraMaterial == Material.field_151586_h) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (cameraMaterial == Material.field_151587_i && hasTrueSight) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderBlockLayer(RenderBlockOverlayEvent event) {
        if ((hasTrueSight || hasWaterVision) && (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.FIRE && hasTrueSight)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        if (!SupportMods.ENCH_DESC.isLoaded() && ConfigTombstone.client.showInfoOnEnchantment && event.getItemStack().func_77942_o()) {
            boolean isEnchantedBook;
            boolean bl = isEnchantedBook = event.getItemStack().func_77973_b() == Items.field_151134_bR;
            if (!isEnchantedBook && ModEnchantments.getEnchantments().values().stream().allMatch(TombstoneEnchantment::isEnabled)) {
                return;
            }
            EnchantmentHelper.func_82781_a((ItemStack)event.getItemStack()).keySet().stream().filter(TombstoneEnchantment.class::isInstance).map(TombstoneEnchantment.class::cast).forEach(enchant -> {
                String key = LangKey.makeClientTranslation(enchant.func_77320_a(), new Object[0]);
                IntStream.range(0, event.getToolTip().size()).filter(line -> ((String)event.getToolTip().get(line)).startsWith(key)).findFirst().ifPresent(line -> {
                    List<String> infos = enchant.getTooltipInfos(isEnchantedBook);
                    for (String info : infos) {
                        event.getToolTip().add(++line, info);
                    }
                });
            });
        }
    }

    @SubscribeEvent
    public static void registerItemColor(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((stack, i) -> i == 0 ? -9865852 : -1, new Item[]{ModItems.book_of_disenchantment});
        event.getItemColors().func_186730_a((stack, i) -> i == 0 ? -11246691 : -1, new Item[]{ModItems.book_of_repairing});
        event.getItemColors().func_186730_a((stack, i) -> i == 0 ? -11806832 : -1, new Item[]{ModItems.book_of_magic_impregnation});
        event.getItemColors().func_186730_a((stack, i) -> i == 0 ? -16711904 : -16733664, new Item[]{ModItems.dust_of_vanishing});
        event.getItemColors().func_186730_a((stack, i) -> stack.func_77960_j() == ItemCraftingIngredient.IngredientType.GRAVE_DUST.ordinal() ? (i == 0 ? -16760672 : -16756550) : -1, new Item[]{ModItems.crafting_ingredient});
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFieldOfView(FOVUpdateEvent event) {
        if (!event.getEntity().func_184587_cr() && event.getEntity().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == ModItems.christmas_hat && event.getEntity().field_71075_bZ.func_75094_b() != 0.0f) {
            event.setNewfov(event.getNewfov() - 0.35f);
        }
    }

    @SubscribeEvent
    public static void render(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71441_e != null) {
            MarkerHandler.instance.render(mc);
        }
    }

    private static void createBox(double x, double y, double z, double offset) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        Vec3d location = new Vec3d(x, y, z).func_178786_a(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n);
        if (location.func_72438_d(Vec3d.field_186680_a) > 200.0) {
            location = location.func_72432_b().func_186678_a(200.0);
        }
        x = location.field_72450_a;
        y = location.field_72448_b;
        z = location.field_72449_c;
        long c = TimeHelper.systemTime() / 15L % 360L;
        float[] color = Helper.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        RenderGlobal.func_189694_a((double)x, (double)y, (double)z, (double)(x + offset), (double)(y + offset), (double)(z + offset), (float)color[0], (float)color[1], (float)color[2], (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderAuras(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74320_O == 0 && mc.field_71439_g != null && ConfigTombstone.client.showMagicCircle) {
            Aura.addAura((EntityLivingBase)mc.field_71439_g);
        }
        if (!AURAS.isEmpty()) {
            double ratio = (double)System.currentTimeMillis() * 0.03 % 360.0;
            AURAS.forEach(aura -> ClientEventHandler.renderAura(mc, aura, ratio));
            AURAS.clear();
        }
    }

    private static void renderAura(Minecraft mc, Aura aura, double ratio) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.Profile.PLAYER_SKIN.func_187373_a();
        GlStateManager.func_179129_p();
        mc.func_110434_K().func_110577_a(AURA_TEXTURES[0]);
        Vec3d vec3 = aura.position.func_178786_a(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n);
        GlStateManager.func_179137_b((double)vec3.field_72450_a, (double)vec3.field_72448_b, (double)vec3.field_72449_c);
        GlStateManager.func_179114_b((float)((float)ratio), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)(-vec3.field_72450_a), (double)(-vec3.field_72448_b), (double)(-vec3.field_72449_c));
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        Vec3d vec1 = new Vec3d(vec3.field_72450_a - aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c - aura.auraType.radius);
        Vec3d vec2 = new Vec3d(vec3.field_72450_a + aura.auraType.radius, vec3.field_72448_b + 0.014625, vec3.field_72449_c + aura.auraType.radius);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        bufferbuilder.func_181662_b(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_187315_a(0.0, 0.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec1.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_187315_a(0.0, 1.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec2.field_72450_a, vec1.field_72448_b, vec2.field_72449_c).func_187315_a(1.0, 1.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(vec2.field_72450_a, vec1.field_72448_b, vec1.field_72449_c).func_187315_a(1.0, 0.0).func_181666_a(aura.auraType.r, aura.auraType.g, aura.auraType.b, aura.auraType.a).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179089_o();
        GlStateManager.Profile.PLAYER_SKIN.func_187374_b();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static class Aura {
        private final Vec3d position;
        private final AuraType auraType;

        private Aura(EntityLivingBase entity, AuraType auraType) {
            float partialTicks = Minecraft.func_71410_x().func_184121_ak();
            this.position = new Vec3d(Helper.lerp(partialTicks, entity.field_70142_S, entity.field_70165_t), Helper.lerp(partialTicks, entity.field_70137_T, entity.field_70163_u) + 0.1111, Helper.lerp(partialTicks, entity.field_70136_U, entity.field_70161_v));
            this.auraType = auraType;
        }

        private Aura(double x, double y, double z) {
            this.position = new Vec3d(x, y, z);
            this.auraType = AuraType.MARKER;
        }

        public static void addAura(EntityLivingBase entity) {
            AuraType auraType = AuraType.getAuraType(entity);
            if (auraType != null) {
                Aura aura = new Aura(entity, auraType);
                double opaque = 1.0;
                double distanceToCamera = Minecraft.func_71410_x().func_175598_ae().func_78714_a(aura.position.field_72450_a, aura.position.field_72448_b, aura.position.field_72449_c);
                double f = (1.0 - distanceToCamera * 0.00390625) * opaque;
                if (f > 0.0) {
                    AURAS.add(aura);
                }
            }
        }
    }

    static enum AuraType {
        PRAY(3.5, 0.88f, 0.78f, 0.48f, 1.0f),
        SCROLL(0.8, 0.38f, 0.28f, 0.88f, 1.0f),
        SIMPLE_TELEPORT(0.8, 0.23f, 0.78f, 0.86f, 1.0f),
        AREA_TELEPORT(5.0, 0.23f, 0.78f, 0.86f, 1.0f),
        MARKER(1.0, 0.38f, 0.48f, 0.18f, 1.0f);

        private final double radius;
        private final float r;
        private final float g;
        private final float b;
        private final float a;

        private AuraType(double radius, float r, float g, float b, float a) {
            this.radius = radius;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        private static AuraType getAuraType(EntityLivingBase entity) {
            if (!entity.func_184587_cr()) {
                return null;
            }
            ItemStack heldStack = entity.func_184614_ca();
            Item heldItem = heldStack.func_77973_b();
            if (heldItem == ModItems.ankh_of_pray) {
                return PRAY;
            }
            if (heldItem == ModItems.grave_key || heldItem == ModItems.lost_tablet || heldItem == ModItems.tablet_of_assistance || heldItem == ModItems.tablet_of_cupidity) {
                return SIMPLE_TELEPORT;
            }
            if (heldItem == ModItems.tablet_of_recall || heldItem == ModItems.tablet_of_home) {
                return ((ItemGraveMagic)heldStack.func_77973_b()).isAncient(heldStack) ? AREA_TELEPORT : SIMPLE_TELEPORT;
            }
            if (heldItem == ModItems.scroll_buff || heldItem == ModItems.scroll_of_knowledge) {
                return SCROLL;
            }
            return null;
        }
    }
}

