/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.magic.IProtectedEntity;
import ovh.corail.tombstone.api.magic.ModDamages;
import ovh.corail.tombstone.api.magic.ProtectedEntityProvider;
import ovh.corail.tombstone.block.BlockGrave;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.capability.ProtectedEntityImpl;
import ovh.corail.tombstone.capability.TBCapabilityDefault;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.compatibility.CompatibilityTechguns;
import ovh.corail.tombstone.compatibility.CompatibilityWearableBackpacks;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.DamageType;
import ovh.corail.tombstone.helper.DeathHandler;
import ovh.corail.tombstone.helper.DummyTargetEntity;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.PlayerStatusHandler;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SpawnProtectionHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.VillageSiegeHandler;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncProtectionMessage;
import ovh.corail.tombstone.network.TombstoneActivatedMessage;
import ovh.corail.tombstone.network.UpdateClientMessage;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

@Mod.EventBusSubscriber(modid="tombstone")
public class EventHandler {
    private static final String END_CONQUERED_EFFECTS_NBT_LIST = "tb_end_conquered_effects";
    private static long LAST_BACKUP = -1L;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void fishHookJoinWorldEvent(EntityJoinWorldEvent event) {
        if (EventHandler.requireCompatForFishHook(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH, receiveCanceled=true)
    public static void fishHookJoinWorldAfterEvent(EntityJoinWorldEvent event) {
        if (event.isCanceled() && EventHandler.requireCompatForFishHook(event.getEntity())) {
            event.setCanceled(false);
        }
    }

    private static boolean requireCompatForFishHook(Entity fishHook) {
        if (SupportMods.ADVANCED_FISHING.isLoaded() && fishHook instanceof EntityFishHook && fishHook.getClass().equals(EntityFishHook.class)) {
            EntityPlayer player = ((EntityFishHook)fishHook).func_190619_l();
            Item rightHeldItem = player.func_184614_ca().func_77973_b();
            return rightHeldItem instanceof ItemFishingRod ? rightHeldItem == ModItems.fishing_rod_of_misadventure : player.func_184592_cb().func_77973_b() == ModItems.fishing_rod_of_misadventure;
        }
        return false;
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer().func_70055_a(Material.field_151586_h) && EffectHelper.isPotionActive((EntityLivingBase)event.getEntityPlayer(), ModEffects.aquatic_life)) {
            event.setNewSpeed(event.getNewSpeed() * (EnchantmentHelper.func_185287_i((EntityLivingBase)event.getEntityPlayer()) ? 2.0f : 10.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogued(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.player)) {
            MinecraftServer server = Objects.requireNonNull(event.player.func_184102_h());
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            ModTriggers.PASS_APRIL_FOOL.trigger(player);
            ModTriggers.CHRISTMAS.trigger(player);
            if (TimeHelper.isDateAroundHalloween()) {
                ModTriggers.HALLOWEEN.trigger(player);
            }
            EntityHelper.syncTBCapability(player, true);
            PacketHandler.INSTANCE.sendTo((IMessage)new UpdateClientMessage(server.func_71218_a(0).func_175694_M(), server.func_71262_S() ? server.func_82357_ak() : 0, TimeHelper.getSpecialEvent(), ConfigTombstone.player_death.decayTime, ConfigTombstone.general.ghostlyShapeDuration, ConfigTombstone.decorativeGrave.tabletMaxUse, ConfigTombstone.decorativeGrave.tabletCooldown, ConfigTombstone.decorativeGrave.unbreakableDecorativeGrave, ConfigTombstone.decorativeGrave.cooldownToPray, ConfigTombstone.decorativeGrave.cooldownResetperk, ConfigTombstone.enchantments.nerfShadowStepForceSneak, ConfigTombstone.enchantments.enableEnchantmentShadowStep, ConfigTombstone.enchantments.enableEnchantmentSoulbound, ConfigTombstone.enchantments.enableEnchantmentMagicSiphon, ConfigTombstone.enchantments.enableEnchantmentPlagueBringer, ConfigTombstone.enchantments.enableEnchantmentBlessing, ConfigTombstone.enchantments.enableEnchantmentCurseOfBones, ConfigTombstone.enchantments.soulboundEnchantingTable, ConfigTombstone.enchantments.shadowStepEnchantingTable, ConfigTombstone.enchantments.magicSiphonEnchantingTable, ConfigTombstone.enchantments.plagueBringerEnchantingTable, ConfigTombstone.enchantments.blessingEnchantingTable, ConfigTombstone.enchantments.curseOfBonesEnchantingTable, ConfigTombstone.enchantments.plagueBringerCombiningMagicSiphon, ConfigTombstone.loot.chanceLootLostTablet, ConfigTombstone.player_death.xpLoss, ConfigTombstone.general.chanceEnchantedGraveKey, ConfigTombstone.general.scrollDuration, ConfigTombstone.general.perkProgressionScale, ConfigTombstone.general.scrollOfKnowledgeLoss, ConfigTombstone.enchantments.maxLevelShadowStep, ConfigTombstone.enchantments.maxLevelMagicSiphon, ConfigTombstone.enchantments.maxLevelPlagueBringer, ConfigTombstone.enchantments.maxLevelCurseOfBones, ConfigTombstone.allowedMagicItems.allowBookOfDisenchantment, ConfigTombstone.allowedMagicItems.allowBookOfRepairing, ConfigTombstone.allowedMagicItems.allowBookOfMagicImpregnation, ConfigTombstone.allowedMagicItems.allowGraveKey, ConfigTombstone.allowedMagicItems.allowLostTablet, ConfigTombstone.allowedMagicItems.allowScrollOfKnowledge, ConfigTombstone.allowedMagicItems.allowTabletOfAssistance, ConfigTombstone.allowedMagicItems.allowTabletOfRecall, ConfigTombstone.allowedMagicItems.allowTabletOfHome, ConfigTombstone.allowedMagicItems.allowTabletOfCupidity, ConfigTombstone.allowedMagicItems.allowScrollOfPreservation, ConfigTombstone.allowedMagicItems.allowScrollOfUnstableIntangibleness, ConfigTombstone.allowedMagicItems.allowScrollOfFeatherFall, ConfigTombstone.allowedMagicItems.allowScrollOfPurification, ConfigTombstone.allowedMagicItems.allowScrollOfTrueSight, ConfigTombstone.allowedMagicItems.allowScrollOfReach, ConfigTombstone.allowedMagicItems.allowScrollOfLightningResistance, ConfigTombstone.allowedMagicItems.allowScrollOfFrostResistance, ConfigTombstone.allowedMagicItems.allowScrollOfAquaticLife, ConfigTombstone.allowedMagicItems.allowDustOfVanishing, ConfigTombstone.allowedMagicItems.allowVoodooPoppet, ConfigTombstone.allowedMagicItems.allowFamiliarReceptacle), player);
            PacketHandler.INSTANCE.sendTo((IMessage)CooldownHandler.INSTANCE.getCooldownPacket(player), player);
            if (ConfigTombstone.player_death.handlePlayerDeath) {
                Helper.checkDeathHandlingMod(player).ifPresent(modName -> player.func_145747_a((ITextComponent)new TextComponentTranslation("You loaded a conflicting mod handling the player's death (" + modName + ").", new Object[0])));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = Helper.getServer();
        if (server != null && event.phase == TickEvent.Phase.END) {
            long systemTime;
            if (LAST_BACKUP < TimeHelper.SERVER_START_TIME) {
                LAST_BACKUP = TimeHelper.SERVER_START_TIME;
            } else if (ConfigTombstone.recovery.recoveryPlayerEnable && TimeUnit.MILLISECONDS.toMinutes((systemTime = TimeHelper.systemTime()) - LAST_BACKUP) > (long)ConfigTombstone.recovery.recoveryPlayerTimer) {
                LAST_BACKUP = systemTime;
                CommandTBRecovery.saveAllPlayers(server, success -> (success != false ? LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_ALL_PLAYERS_FAILED).sendLog(new Object[0]));
            }
            CommandTBAcceptTeleport.cleanTickets();
            CallbackHandler.tick();
            PlayerStatusHandler.clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof BlockGraveBase);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBreak(BlockEvent.BreakEvent event) {
        if (ConfigTombstone.player_death.nerfGhostlyShapeBreakBlock && EntityHelper.isValidServerPlayer((Entity)event.getPlayer()) && EffectHelper.isPotionActive((EntityLivingBase)event.getPlayer(), ModEffects.ghostly_shape)) {
            EffectHelper.clearEffect((EntityLivingBase)event.getPlayer(), ModEffects.ghostly_shape);
            ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((EntityPlayerMP)event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onRightClickChest(PlayerInteractEvent.RightClickBlock event) {
        Block block;
        if (!event.isCanceled() && EntityHelper.isValidServerPlayer((Entity)event.getEntityPlayer()) && event.getHand() == EnumHand.MAIN_HAND) {
            TileEntity tile;
            boolean hasShadowStep;
            boolean requireNerfGhostlyShape = ConfigTombstone.player_death.nerfGhostlyShapeOpenChest && EffectHelper.isPotionActive((EntityLivingBase)event.getEntityPlayer(), ModEffects.ghostly_shape);
            boolean bl = hasShadowStep = ConfigTombstone.enchantments.nerfShadowStepOpenChest && EntityHelper.getShadowStepLevel(event.getEntityPlayer()) > 0;
            if ((requireNerfGhostlyShape || hasShadowStep) && (tile = event.getWorld().func_175625_s(event.getPos())) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                if (requireNerfGhostlyShape) {
                    EffectHelper.clearEffect((EntityLivingBase)event.getEntityPlayer(), ModEffects.ghostly_shape);
                    ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((EntityPlayerMP)event.getEntityPlayer());
                }
                if (hasShadowStep) {
                    EntityHelper.setShadowStepCooldown(event.getEntityPlayer());
                }
            }
        }
        if ((block = event.getWorld().func_180495_p(event.getPos()).func_177230_c()) instanceof BlockGrave) {
            if (event.isCanceled()) {
                event.setCanceled(false);
                event.setUseBlock(Event.Result.DEFAULT);
                event.setUseItem(Event.Result.DEFAULT);
            }
            if (event.getWorld().field_72995_K && SpawnProtectionHandler.getInstance().isBlockProtected(event.getWorld().field_73011_w.getDimension(), event.getPos())) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new TombstoneActivatedMessage(event.getPos()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            VillageSiegeHandler.instance.checkWorld((WorldServer)event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        boolean isPlayer;
        PotionEffect boneShieldEffect;
        EntityPlayerMP player;
        if (event.getEntityLiving() == null) {
            return;
        }
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving()) && event.getEntityLiving().func_70089_S() && (player = (EntityPlayerMP)event.getEntityLiving()).func_184587_cr() && player.func_184607_cu().func_77973_b() instanceof ItemGraveMagic && EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.concentration) == 0) {
            EntityHelper.setGlobalItemCooldown((EntityPlayer)player, player.func_184607_cu(), 40);
            player.func_184597_cx();
            LangKey.MESSAGE_SPELLCASTING_INTERRUPTED.sendMessage((ICommandSender)player, new Object[0]);
        }
        if ((boneShieldEffect = event.getEntityLiving().func_70660_b(ModEffects.bone_shield)) != null && !event.getSource().func_76352_a() && !event.getSource().func_94541_c() && event.getSource() instanceof EntityDamageSource && !(event.getSource() instanceof EntityDamageSourceIndirect)) {
            event.setCanceled(true);
            if (!((EntityDamageSource)event.getSource()).func_180139_w()) {
                Optional.ofNullable(event.getSource().func_76346_g()).filter(Entity::func_70089_S).ifPresent(s -> {
                    float reflectedDamages = event.getAmount() * ((float)MathHelper.func_76125_a((int)boneShieldEffect.func_76458_c(), (int)1, (int)10) / 10.0f);
                    if (reflectedDamages >= 1.0f) {
                        event.getEntityLiving().field_70170_p.func_184133_a(null, s.func_180425_c(), SoundEvents.field_187903_gc, SoundCategory.NEUTRAL, 0.5f, (Helper.RANDOM.nextFloat() - Helper.RANDOM.nextFloat()) * 0.2f + 1.0f);
                        s.func_70097_a(DamageSource.func_92087_a((Entity)event.getEntityLiving()), reflectedDamages);
                    }
                });
            }
            return;
        }
        if (EffectHelper.isUnstableIntangiblenessActive(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (DamageType.LIGHTNING.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.lightning_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (DamageType.COLD.is(event.getSource()) && EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.frost_resistance)) {
            event.setAmount(event.getAmount() / 4.0f);
        }
        if (isPlayer = EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            ITBCapability cap;
            if (event.getSource() == ModDamages.BEYOND_THE_GRAVE) {
                int knowledgeLevel;
                if (ConfigTombstone.general.allowBeyondTheGraveDamage && (cap = (ITBCapability)event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null && (knowledgeLevel = cap.getTotalPerkPoints()) > 0) {
                    event.setAmount(event.getAmount() * (1.0f - (float)Math.min(20, knowledgeLevel) * 0.05f));
                }
            } else {
                int alignmentLevel;
                cap = (ITBCapability)event.getEntityLiving().getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
                int n = alignmentLevel = cap == null ? 0 : cap.getAlignmentLevel();
                if (alignmentLevel != 0 && event.getSource().func_76346_g() instanceof EntityLivingBase) {
                    boolean valid;
                    boolean bl = EntityHelper.isUndead((EntityLivingBase)event.getSource().func_76346_g()) ? alignmentLevel > 0 : (valid = alignmentLevel < 0);
                    if (valid) {
                        float amount = event.getAmount() * (1.0f - 0.1f * (float)Math.abs(alignmentLevel));
                        if (amount < 0.5f) {
                            event.setCanceled(true);
                        } else {
                            event.setAmount(amount);
                        }
                    }
                }
            }
            if (EffectHelper.isPotionActive(event.getEntityLiving(), ModEffects.ghostly_shape, 5) && Helper.isValidPos(event.getEntityLiving().field_70170_p, event.getEntityLiving().func_180425_c())) {
                event.setCanceled(true);
                return;
            }
        }
        if (event.getSource() != null && EntityHelper.isValidPlayer(event.getSource().func_76346_g())) {
            EntityPlayer player2 = (EntityPlayer)event.getSource().func_76346_g();
            if (event.getEntityLiving() != player2) {
                if (EffectHelper.isPotionActive((EntityLivingBase)player2, ModEffects.ghostly_shape)) {
                    player2.func_184589_d(ModEffects.ghostly_shape);
                    if (EntityHelper.isValidServerPlayer((Entity)player2)) {
                        ModTriggers.CANCEL_GHOSTLY_SHAPE.trigger((EntityPlayerMP)player2);
                    }
                }
                if (EffectHelper.isPotionActive((EntityLivingBase)player2, ModEffects.diversion)) {
                    player2.func_184589_d(ModEffects.diversion);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreventDeath(LivingDamageEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().func_70089_S() && event.getEntityLiving().func_110143_aJ() <= event.getAmount()) {
            IProtectedEntity iProtectedEntity = (IProtectedEntity)event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY, null);
            Location location = Optional.ofNullable(iProtectedEntity).map(cap -> {
                if (cap.isActive()) {
                    cap.apply(event.getEntityLiving(), false);
                    return new Location(cap.getSafeLocation(event.getEntityLiving()));
                }
                return Location.ORIGIN;
            }).orElse(Location.ORIGIN);
            if (!location.isOrigin()) {
                Location spawn;
                WorldServer world;
                event.getEntityLiving().func_70606_j(event.getEntityLiving().func_110138_aP());
                event.getEntityLiving().field_70143_R = 0.0f;
                EffectHelper.clearBadEffects(event.getEntityLiving());
                EffectHelper.addPotion(event.getEntityLiving(), MobEffects.field_76428_l, 600, 9, new boolean[0]);
                if (ConfigTombstone.village_siege.glowingCreatureTest) {
                    EffectHelper.addPotion(event.getEntityLiving(), MobEffects.field_188423_x, 600);
                }
                EffectHelper.addPotion(event.getEntityLiving(), ModEffects.diversion, 600);
                MinecraftServer server = event.getEntityLiving().func_184102_h();
                WorldServer worldServer = world = server != null ? server.func_71218_a(location.dim) : null;
                if (world != null && !(spawn = new SpawnHelper(world, location.getPos()).findSpawnPlace()).isOrigin()) {
                    Helper.teleport(event.getEntityLiving(), spawn);
                }
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
                event.setCanceled(true);
                return;
            }
            if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
                if (ModItems.familiar_receptacle.captureSoul(event.getEntityLiving())) {
                    event.setCanceled(true);
                    event.getEntityLiving().func_184174_b(false);
                    event.getEntityLiving().func_70106_y();
                }
                return;
            }
            if (EventHandler.handlePlayerDamage((EntityPlayerMP)event.getEntityLiving(), event.getSource())) {
                event.setCanceled(true);
            }
        }
    }

    public static boolean handlePlayerDamage(EntityPlayerMP player, DamageSource source) {
        Location spawnPos;
        ItemStack soul;
        if (ModItems.voodoo_poppet.preventDeath(player, source)) {
            return true;
        }
        WorldServer targetWorld = player.func_71121_q();
        BlockPos playerPos = player.func_180425_c();
        boolean requirePrevention = ConfigTombstone.player_death.preventDeathOutsideWorldBorder && Helper.isOutsideWorldBorders((World)targetWorld, playerPos) || ConfigTombstone.player_death.preventDeathOutsideBuildHeight && Helper.isOutsideBuildHeight((World)targetWorld, playerPos);
        ItemStack itemStack = soul = !requirePrevention ? InventoryHelper.findItemInMainInventory((EntityPlayer)player, p -> p.func_77973_b() == ModItems.soul_receptacle) : ItemStack.field_190927_a;
        if (!(!requirePrevention && soul.func_190926_b() || (spawnPos = new SpawnHelper(targetWorld, Helper.getCloserValidPos((World)targetWorld, new BlockPos((Entity)player))).findSpawnPlace()).isOrigin() && (targetWorld.field_73011_w.getDimension() != 1 || (spawnPos = new SpawnHelper(targetWorld, new BlockPos(0, 70, 0)).findSpawnPlace()).isOrigin()))) {
            if (!requirePrevention) {
                soul.func_190918_g(1);
            }
            player.func_70606_j(player.func_110138_aP());
            EffectHelper.clearBadEffects((EntityLivingBase)player);
            EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76443_y, 1200, 10, new boolean[0]);
            EffectHelper.addPotion((EntityLivingBase)player, MobEffects.field_76428_l, 1200, 10, new boolean[0]);
            EffectHelper.addPotion((EntityLivingBase)player, ModEffects.diversion, 1200);
            (requirePrevention ? LangKey.MESSAGE_CONFIG_PREVENT_DEATH : LangKey.MESSAGE_SOUL_PREVENT_DEATH).sendSpecialMessage((ICommandSender)player, new Object[0]);
            Helper.teleport(player, spawnPos);
            player.field_70143_R = 0.0f;
            return true;
        }
        if (ConfigTombstone.recovery.backupOnDeath && !player.func_175149_v()) {
            CommandTBRecovery.savePlayer(player, success -> ModTombstone.LOGGER.info((success != false ? LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_SUCCESS : LangKey.MESSAGE_RECOVERY_SAVE_PLAYER_FAILED).getServerTranslation(player.func_70005_c_())));
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onCheckAttack(LivingAttackEvent event) {
        if (Helper.isAprilFoolsDaySnowball(event.getEntityLiving(), event.getSource())) {
            EffectHelper.addPotion(event.getEntityLiving(), MobEffects.field_76421_d, 200, 1, new boolean[0]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckAttackTarget(LivingSetAttackTargetEvent event) {
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && event.getTarget() != null) {
            EntityLivingBase attacker = event.getEntityLiving();
            if (EffectHelper.isPotionActive(event.getTarget(), ModEffects.ghostly_shape) || EffectHelper.isPotionActive(event.getTarget(), ModEffects.diversion)) {
                ((EntityLiving)attacker).field_70696_bz = null;
                if (event.getTarget().equals((Object)attacker.field_70755_b)) {
                    attacker.field_70755_b = new DummyTargetEntity(attacker.field_70170_p);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onCheckHidden(PlayerEvent.Visibility event) {
        PlayerStatusHandler.getPlayerStatus((Entity)event.getEntityLiving()).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorLowPriority));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onCheckDiscretion(PlayerEvent.Visibility event) {
        PlayerStatusHandler.getPlayerStatus((Entity)event.getEntityLiving()).ifPresent(playerStatus -> event.modifyVisibility(playerStatus.visibleFactorHighPriority));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.player) || event.player.func_175149_v()) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        EntityHelper.syncTBCapability(player, false);
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        deathHandler.restoreSoulbounds(player);
        if (deathHandler.isPlayerDead((EntityPlayer)player)) {
            if (PlayerPreference.get((EntityPlayer)player).getAutoEquipRule().equiOnRespawn()) {
                ListIterator it = player.field_71071_by.field_70462_a.listIterator();
                while (it.hasNext()) {
                    if (!InventoryHelper.autoequip((ItemStack)it.next(), (EntityPlayer)player)) continue;
                    it.set(ItemStack.field_190927_a);
                }
            }
            deathHandler.restorePlayerDead(player);
        }
        player.field_71069_bz.func_75142_b();
        List<PotionEffect> list = NBTStackHelper.getEffectList(EntityHelper.getPersistentTag((EntityPlayer)player), END_CONQUERED_EFFECTS_NBT_LIST, e -> true);
        if (!list.isEmpty()) {
            list.forEach(arg_0 -> ((EntityPlayerMP)player).func_70690_d(arg_0));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onClone(PlayerEvent.Clone event) {
        Map originalEffects;
        if (!EntityHelper.isValidServerPlayer((Entity)event.getOriginal()) || !EntityHelper.isValidServerPlayer((Entity)event.getEntityPlayer())) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
        EntityPlayerMP original = (EntityPlayerMP)event.getOriginal();
        ITBCapability originalCap = (ITBCapability)original.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (originalCap != null && cap != null) {
            cap.copyCapability(originalCap);
        }
        if (!event.isWasDeath() && ConfigTombstone.compatibilities.preserveEffectsOnReturnEndConquered && player.field_70170_p.field_73011_w.getDimension() == 1 && player.func_193076_bZ().isEmpty() && !(originalEffects = original.func_193076_bZ()).isEmpty()) {
            NBTStackHelper.setEffectlist(EntityHelper.getPersistentTag((EntityPlayer)player), END_CONQUERED_EFFECTS_NBT_LIST, originalEffects.values().stream());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving())) {
            if (!event.isCanceled() && event.getEntityLiving() != null) {
                EntityHelper.applyKillResult(event.getSource(), event.getEntityLiving());
            }
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        if (event.isCanceled()) {
            if (ConfigTombstone.player_death.handlePlayerDeath) {
                LangKey.MESSAGE_DEATH_CANCELED.sendLog(player.func_70005_c_());
            }
        } else {
            boolean isBeyondTheGraveDamage = ConfigTombstone.general.allowBeyondTheGraveDamage && event.getSource() == ModDamages.BEYOND_THE_GRAVE;
            int knowledgeLoss = ConfigTombstone.player_death.knowledgeLoss + (isBeyondTheGraveDamage ? 10 : 0);
            if (knowledgeLoss > 0) {
                Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.loseKnowledge(player, knowledgeLoss));
                if (isBeyondTheGraveDamage) {
                    ModTriggers.LOST_KNOWLEDGE.trigger(player);
                }
            }
            DeathHandler.INSTANCE.addPlayerDead(player, event.getSource());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (ConfigTombstone.player_death.isHandlingPlayerXp() && EntityHelper.isValidPlayer((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    private static void collectKeyAndSoulbound(Iterator<EntityItem> it, List<ItemStack> keys, List<ItemStack> soulbounds) {
        while (it.hasNext()) {
            EntityItem entityItem = it.next();
            if (entityItem == null) {
                it.remove();
                continue;
            }
            ItemStack stack = entityItem.func_92059_d();
            if (stack.func_190926_b()) {
                it.remove();
                continue;
            }
            if (stack.func_77973_b() == ModItems.grave_key) {
                keys.add(stack.func_77946_l());
                entityItem.func_92058_a(ItemStack.field_190927_a);
                it.remove();
                continue;
            }
            if (EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.soulbound, (ItemStack)stack) <= 0) continue;
            soulbounds.add(stack.func_77946_l());
            entityItem.func_92058_a(ItemStack.field_190927_a);
            it.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerDrops(PlayerDropsEvent event) {
        ItemStack key;
        IBlockState state;
        boolean hasGrave;
        TileEntity tile2;
        boolean hasDrop;
        if (!EntityHelper.isValidServerPlayer((Entity)event.getEntityPlayer()) || Helper.isRuleKeepInventory(event.getEntityPlayer().field_70170_p)) {
            return;
        }
        if (event.isCanceled()) {
            LangKey.MESSAGE_DROP_CANCELED.sendLog(event.getEntityPlayer().func_70005_c_());
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        ArrayList<ItemStack> soulbounds = new ArrayList<ItemStack>();
        EventHandler.collectKeyAndSoulbound(event.getDrops().iterator(), keys, soulbounds);
        double range = ConfigTombstone.player_death.snifferRange;
        List itemList = player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - range, player.field_70163_u - range, player.field_70161_v - range, player.field_70165_t + range, player.field_70163_u + range, player.field_70161_v + range));
        EventHandler.collectKeyAndSoulbound(itemList.iterator(), keys, soulbounds);
        if (event.getDrops().size() == 0 && itemList.size() == 1 && "cannibalism:playerflesh".equals(((EntityItem)itemList.get(0)).func_92059_d().func_77973_b().getRegistryName().toString())) {
            itemList.remove(0);
        }
        PlayerPreference playerPreference = PlayerPreference.get(player.func_110124_au());
        DeathHandler deathHandler = DeathHandler.INSTANCE;
        if (playerPreference.denyGraveOnDeath()) {
            LangKey.MESSAGE_CHOOSE_NO_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        int countDrop = event.getDrops().size() + itemList.size();
        boolean bl = hasDrop = countDrop > 0;
        if (!ConfigTombstone.player_death.handlePlayerDeath || !hasDrop) {
            if (!hasDrop) {
                ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, keys.stream().filter(p -> !ModItems.grave_key.isEnchanted((ItemStack)p)).findFirst().orElse(ItemStack.field_190927_a));
                LangKey.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            }
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        if (deathHandler.isNoGraveLocation(new Location((Entity)player))) {
            LangKey.MESSAGE_NO_GRAVE_LOCATION.sendSpecialMessage((ICommandSender)player, new Object[0]);
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            return;
        }
        MinecraftServer server = player.func_184102_h();
        assert (server != null);
        WorldServer world = player.func_71121_q();
        BlockPos initPos = Helper.getCloserValidPos((World)world, new BlockPos((Entity)player));
        Location spawnPos = Location.ORIGIN;
        if (ConfigTombstone.player_death.allowToFillExistingGrave) {
            Location lastGrave;
            TileEntityPlayerGrave tileGrave = world.func_175726_f(initPos).func_177434_r().values().stream().filter(TileEntityPlayerGrave.class::isInstance).map(TileEntityPlayerGrave.class::cast).filter(tile -> tile.getOwnerName().equals(player.func_70005_c_()) && InventoryHelper.hasEnoughSlots(tile.getInventory(), countDrop)).findFirst().orElse(null);
            if (tileGrave != null) {
                spawnPos = new Location(tileGrave.func_174877_v(), (World)world);
            }
            if (spawnPos.isOrigin() && !(lastGrave = deathHandler.getLastGrave(server, player)).isOrigin() && lastGrave.dim == world.field_73011_w.getDimension() && lastGrave.getPos().func_177951_i((Vec3i)initPos) <= 400.0 && (tile2 = world.func_175625_s(lastGrave.getPos())) instanceof TileEntityPlayerGrave && InventoryHelper.hasEnoughSlots((tileGrave = (TileEntityPlayerGrave)tile2).getInventory(), countDrop)) {
                spawnPos = lastGrave;
            }
        }
        boolean bl2 = hasGrave = !spawnPos.isOrigin();
        if (!hasGrave) {
            Pair<Location, SpawnHelper.SpawnResult> res = new SpawnHelper(world, initPos).withGraveSpawnRule(playerPreference.getGraveSpawnRule()).findGravePlaceWithResult();
            spawnPos = (Location)res.getLeft();
            if (spawnPos.isOrigin()) {
                deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
                LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
                LangKey.MESSAGE_NO_PLACE_FOR_GRAVE.sendLog(new Object[0]);
                return;
            }
            if (world.field_73011_w.getDimension() == 1 && res.getRight() == SpawnHelper.SpawnResult.MINIMAL && !((Location)(res = new SpawnHelper(world, new BlockPos(0, 70, 0)).withGraveSpawnRule(playerPreference.getGraveSpawnRule()).findGravePlaceWithResult()).getLeft()).isOrigin() && ((SpawnHelper.SpawnResult)((Object)res.getRight())).ordinal() > SpawnHelper.SpawnResult.MINIMAL.ordinal()) {
                spawnPos = (Location)res.getLeft();
            }
        }
        if (!hasGrave) {
            deathHandler.logLastGrave((EntityPlayer)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
            EnumFacing facing = player.func_174811_aO().func_176734_d();
            GraveModel favoriteGrave = playerPreference.getFavoriteGrave();
            state = favoriteGrave.getPlayerGrave().func_176223_P().func_177226_a((IProperty)BlockGraveBase.FACING, (Comparable)facing).func_177226_a((IProperty)BlockGraveBase.MODEL_TEXTURE, (Comparable)Integer.valueOf(playerPreference.getMarbleType().ordinal()));
            Helper.placeNoEvent((World)world, spawnPos.getPos(), state);
        } else {
            state = world.func_180495_p(spawnPos.getPos());
        }
        tile2 = world.func_175625_s(spawnPos.getPos());
        if (!(tile2 instanceof TileEntityPlayerGrave)) {
            deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((ICommandSender)player, new Object[0]);
            LangKey.MESSAGE_FAIL_TO_PLACE_GRAVE.sendLog(new Object[0]);
            return;
        }
        deathHandler.setLastDeathLocation((EntityPlayer)player, new Location(spawnPos.x, spawnPos.y + 1, spawnPos.z, spawnPos.dim));
        TileEntityPlayerGrave grave = (TileEntityPlayerGrave)tile2;
        if (hasGrave) {
            grave.resetDeathTime();
            grave.countTicks = 0;
        }
        boolean needAccess = ConfigTombstone.player_death.getDecayTime() != 0 && (!server.func_71219_W() || !ConfigTombstone.player_death.pvpUnlockGrave || !EntityHelper.isKilledByOtherPlayer((EntityPlayer)player, event.getSource()));
        ITextComponent locked = new TextComponentString("[").func_150257_a(needAccess ? LangKey.MESSAGE_LOCKED.getTranslation(new Object[0]).func_150258_a(ConfigTombstone.player_death.getDecayTime() > 0 ? " " + ConfigTombstone.player_death.getDecayTime() + " min" : "") : LangKey.MESSAGE_UNLOCKED.getTranslation(new Object[0])).func_150258_a("]").func_150255_a(needAccess ? StyleType.COLOR_OFF : StyleType.COLOR_ON);
        (hasGrave ? LangKey.MESSAGE_EXISTING_GRAVE : LangKey.MESSAGE_NEW_GRAVE).sendSpecialMessage((ICommandSender)player, LangKey.MESSAGE_JOURNEYMAP.getTranslationWithStyle(StyleType.TOOLTIP_DESC, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim), locked);
        Location finalSpawnPos = spawnPos;
        ItemStack itemStack = key = hasGrave ? keys.stream().filter(k -> ModItems.grave_key.getTombPos((ItemStack)k).equals(finalSpawnPos)).findFirst().orElse(ItemStack.field_190927_a) : ItemStack.field_190927_a;
        if (key.func_190926_b() && ConfigTombstone.allowedMagicItems.allowGraveKey()) {
            key = new ItemStack((Item)ModItems.grave_key);
            ModItems.grave_key.setTombPos(key, spawnPos);
            keys.add(0, key);
        }
        ModItems.grave_key.reenchantOnDeath((EntityPlayer)player, key);
        deathHandler.storeSoulboundsOnBody(player, keys, soulbounds);
        grave.setOwner(player, TimeHelper.systemTime(), needAccess);
        IItemHandler itemHandler = grave.getInventory();
        for (EntityItem entityItem : event.getDrops()) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        for (EntityItem entityItem : itemList) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        if (ConfigTombstone.compatibilities.supportWearableBackpacks && SupportMods.WEARABLE_BACKPACKS.isLoaded()) {
            CompatibilityWearableBackpacks.instance.checkWearableBackPacks((EntityPlayer)player, spawnPos.getPos());
        }
        if (SupportMods.SPONGE.isLoaded() && SupportMods.TECHGUNS.isLoaded()) {
            CompatibilityTechguns.instance.snifferDrops((World)world, player.func_180425_c(), spawnPos.getPos());
        }
        grave.func_70296_d();
        world.func_184138_a(spawnPos.getPos(), Blocks.field_150350_a.func_176223_P(), state, 2);
        ModTriggers.FIRST_GRAVE.trigger(player);
        if (event.getDrops().size() <= 120) {
            event.getDrops().clear();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilUpdate(AnvilUpdateEvent event) {
        boolean valid;
        if (event.getLeft().func_190926_b() || event.getRight().func_190926_b()) {
            return;
        }
        String newName = Optional.ofNullable(event.getName()).map(String::trim).orElse("");
        boolean bl = valid = event.getRight().func_77973_b() == Items.field_151042_j && event.getLeft().func_77973_b() == ModItems.grave_plate || ModItems.tablet_of_assistance.isEnchanted(event.getLeft()) && !ModItems.tablet_of_assistance.isAncient(event.getLeft()) && ItemCraftingIngredient.IngredientType.GRAVE_DUST.compareStack(event.getRight());
        if (valid) {
            event.setCost(1);
            event.setOutput(EngravableHelper.setEngravedName(event.getLeft().func_77946_l(), newName));
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAnvilRepair(AnvilRepairEvent event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntityPlayer()) && event.getItemInput().func_77973_b() == ModItems.grave_plate && event.getIngredientInput().func_77973_b() == Items.field_151042_j && EngravableHelper.isEngraved(event.getItemResult())) {
            ModTriggers.ENGRAVE_GRAVE_PLATE.trigger((EntityPlayerMP)event.getEntityPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() != null && event.getEntityLiving().field_70170_p.field_72995_K && TimeHelper.atInterval(event.getEntityLiving().field_70170_p, 20)) {
            if (ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() && ConfigTombstone.client.showShadowStep && EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EntityHelper.getShadowStepLevel((EntityPlayer)event.getEntityLiving()) > 0) {
                ModTombstone.PROXY.produceShadowStep(event.getEntityLiving());
            }
            if (ConfigTombstone.client.showShieldParticle && Optional.ofNullable(event.getEntityLiving().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY, null)).map(IProtectedEntity::isActive).orElse(false).booleanValue()) {
                ModTombstone.PROXY.produceShield(event.getEntityLiving());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStart(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().func_77973_b() == Items.field_151068_bn && EntityHelper.isValidServerPlayer((Entity)event.getEntityLiving()) && PotionUtils.func_185189_a((ItemStack)event.getItem()).size() > 0) {
            event.getEntityLiving().getEntityData().func_74757_a("is_drinking_potion", true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseStop(LivingEntityUseItemEvent.Stop event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        if (EventHandler.isDrinking(event.getEntityLiving())) {
            EventHandler.resetDrinking(event.getEntityLiving());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) && EventHandler.isDrinking(event.getEntityLiving()) && event.getPotionEffect().field_76460_b > 1200 && EffectHelper.isAllowedEffect(event.getPotionEffect())) {
            float bonus = 1.0f + (float)EntityHelper.getPerkLevelWithBonus((EntityPlayer)event.getEntityLiving(), ModPerks.alchemist) * 0.1f;
            event.getPotionEffect().field_76460_b = MathHelper.func_76141_d((float)((float)event.getPotionEffect().field_76460_b * bonus));
        }
    }

    private static boolean isDrinking(EntityLivingBase entityLiving) {
        return entityLiving.getEntityData().func_150297_b("is_drinking_potion", 1);
    }

    private static void resetDrinking(EntityLivingBase entityLiving) {
        entityLiving.getEntityData().func_82580_o("is_drinking_potion");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(TBCapabilityProvider.RL, (ICapabilityProvider)new TBCapabilityProvider(new TBCapabilityDefault()));
        } else if (event.getObject() instanceof EntityVillager || CompatibilityMinecolonies.instance.isCitizen((Entity)event.getObject())) {
            event.addCapability(ProtectedEntityProvider.RL, (ICapabilityProvider)new ProtectedEntityProvider(new ProtectedEntityImpl(EntityHelper::getHomeLocation)));
        }
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking event) {
        if (EntityHelper.isValidServerPlayer((Entity)event.getEntityPlayer()) && event.getTarget() != null) {
            PotionEffect effect;
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityPlayer();
            IProtectedEntity cap = (IProtectedEntity)event.getTarget().getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY, null);
            if (cap != null && cap.isActive()) {
                PacketHandler.INSTANCE.sendTo((IMessage)new SyncProtectionMessage(event.getTarget().func_145782_y(), true), player);
            }
            if (event.getTarget() instanceof EntityLivingBase && (effect = ((EntityLivingBase)event.getTarget()).func_70660_b(ModEffects.bone_shield)) != null) {
                PacketHandler.INSTANCE.sendTo((IMessage)new EffectMessage(event.getTarget().func_145782_y(), effect), player);
            }
        }
    }

    @SubscribeEvent
    public static void onSyncOnChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (EntityHelper.isValidPlayer(event.player) && !event.player.field_70170_p.field_72995_K) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            EntityHelper.syncTBCapability(player, false);
            MinecraftServer server = player.func_184102_h();
            if (server == null) {
                return;
            }
            WorldServer fromDim = server.func_71218_a(event.fromDim);
            long fromTime = fromDim.func_82737_E();
            WorldServer toDim = server.func_71218_a(event.toDim);
            long toTime = toDim.func_82737_E();
            long dif = TimeHelper.worldTicks((World)toDim) - TimeHelper.worldTicks((World)fromDim);
            if (fromTime != toTime) {
                CooldownHandler.INSTANCE.updateWorldTime(player, dif);
                IItemHandler inventPlayer = InventoryHelper.getItemHandler((Entity)player);
                IntStream.range(0, inventPlayer.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inventPlayer).getStackInSlot(arg_0)).filter(stack -> stack.func_77973_b() == ModItems.lost_tablet).forEach(stack -> ModItems.lost_tablet.setCooldown((World)toDim, (ItemStack)stack, Math.min(ModItems.lost_tablet.getCooldown((World)fromDim, (ItemStack)stack), TimeHelper.tickFromMinute(10))));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldStack;
        ItemStack itemStack = heldStack = event.getEntityPlayer() != null ? event.getEntityPlayer().func_184586_b(event.getHand()) : ItemStack.field_190927_a;
        if (event.getHand() == EnumHand.MAIN_HAND && heldStack.func_77973_b() == ModItems.bone_needle && event.getTarget() instanceof EntityLivingBase && heldStack.func_111282_a(event.getEntityPlayer(), (EntityLivingBase)event.getTarget(), event.getHand())) {
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (!EntityHelper.isValidPlayer(event.getEntityPlayer())) {
            return;
        }
        if (heldStack.func_77973_b() == ModItems.gift || heldStack.func_77973_b() == ModItems.dust_of_vanishing || heldStack.func_77973_b() instanceof ItemGraveMagic) {
            event.setCancellationResult(EnumActionResult.PASS);
            event.setCanceled(true);
            return;
        }
        if (event.getHand() == EnumHand.MAIN_HAND && heldStack.func_77973_b() == ModItems.ankh_of_pray && event.getTarget() instanceof EntityLivingBase && heldStack.func_111282_a(event.getEntityPlayer(), (EntityLivingBase)event.getTarget(), event.getHand())) {
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

