/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.api.cooldown.ICooldownHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SyncCooldownMessage;
import ovh.corail.tombstone.registry.ModItems;

public final class CooldownHandler
implements ICooldownHandler {
    public static final CooldownHandler INSTANCE = new CooldownHandler();
    private final Map<UUID, EnumMap<CooldownType, Long>> cooldowns = new ConcurrentHashMap<UUID, EnumMap<CooldownType, Long>>();
    private EnumMap<CooldownType, Long> clientCooldowns = new EnumMap(CooldownType.class);
    public static final String COOLDOWNS_NBT_LIST = "tb_cooldowns";
    private static final String ID_NBT_BYTE = "id";
    private static final String CD_NBT_LONG = "cd";
    private static final BiPredicate<NBTTagCompound, CooldownType> FIND_BY_TYPE = (nbt, type) -> nbt.func_74771_c(ID_NBT_BYTE) == (byte)type.ordinal();
    private static final Function<Byte, CooldownType> FIND_BY_ID = id -> id >= 0 && id < CooldownType.values().length ? CooldownType.values()[id] : null;

    private CooldownHandler() {
        CooldownType.NEXT_PRAY.setMaxCooldown(player -> TimeHelper.tickFromHour(ConfigTombstone.decorativeGrave.getCooldownToPray()));
        CooldownType.RESET_PERKS.setMaxCooldown(player -> TimeHelper.tickFromMinute(ConfigTombstone.decorativeGrave.getCooldownResetperk()));
        CooldownType.TELEPORT_DEATH.setMaxCooldown(player -> TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownTeleportDeath));
        CooldownType.TELEPORT_BIND.setMaxCooldown(player -> TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownTeleportBind));
        CooldownType.REQUEST_TELEPORT.setMaxCooldown(player -> TimeHelper.tickFromMinute(ConfigTombstone.general.cooldownRequestTeleport));
    }

    @Override
    public int getCooldown(EntityPlayer player, CooldownType type) {
        if (player.field_70170_p.field_72995_K) {
            return this.getCooldown(type);
        }
        if (!EntityHelper.isValidServerPlayer((Entity)player) || player.func_110124_au() == null) {
            return type.getMaxCooldown(player);
        }
        EnumMap entry = this.cooldowns.computeIfAbsent(player.func_110124_au(), aId -> this.computePlayerCd((EntityPlayerMP)player));
        long worldTimeCD = entry.getOrDefault((Object)type, -1L);
        if (worldTimeCD > 0L) {
            long cooldown = worldTimeCD - TimeHelper.worldTicks(player.field_70170_p);
            if (cooldown <= 0L && entry.remove((Object)type) != null) {
                this.removeCooldownInNBT(player, tag -> FIND_BY_TYPE.test((NBTTagCompound)tag, type));
                return 0;
            }
            if (cooldown > (long)type.getMaxCooldown(player)) {
                return this.resetCooldown((EntityPlayerMP)player, type);
            }
            return Math.max((int)cooldown, 0);
        }
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getCooldown(CooldownType type) {
        long cd = this.clientCooldowns.getOrDefault((Object)type, -1L);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return player != null && cd > 0L ? Math.max(0, (int)(cd - TimeHelper.worldTicks(player.field_70170_p))) : 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasCooldown(CooldownType type) {
        return this.getCooldown(type) > 0;
    }

    @Override
    public boolean hasCooldown(EntityPlayer player, CooldownType type) {
        return this.getCooldown(player, type) > 0;
    }

    public boolean noCooldown(EntityPlayer player, CooldownType type) {
        return this.getCooldown(player, type) <= 0;
    }

    @Override
    public int resetCooldown(EntityPlayerMP player, CooldownType type) {
        if (EntityHelper.isValidServerPlayer((Entity)player)) {
            int maxCD = type.getMaxCooldown((EntityPlayer)player);
            this.setWorldTimeCooldown(player, type, TimeHelper.worldTicks(player.field_70170_p) + (long)maxCD);
            return maxCD;
        }
        return 0;
    }

    @Override
    public int setCooldown(EntityPlayerMP player, CooldownType type, int time) {
        if (EntityHelper.isValidServerPlayer((Entity)player)) {
            int cappedTime = Math.min(time, type.getMaxCooldown((EntityPlayer)player));
            this.setWorldTimeCooldown(player, type, TimeHelper.worldTicks(player.field_70170_p) + (long)cappedTime);
            return cappedTime;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateClientCooldown(CooldownType type, long worldTime) {
        this.clientCooldowns.put(type, worldTime);
        if (type == CooldownType.NEXT_PRAY) {
            EntityHelper.removeGlobalItemCooldown((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ModItems.ankh_of_pray);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateAllClientCooldowns(NBTTagList tagList) {
        this.clientCooldowns = this.computePlayerCd(tagList);
        EntityHelper.removeGlobalItemCooldown((EntityPlayer)Minecraft.func_71410_x().field_71439_g, ModItems.ankh_of_pray);
    }

    private void setWorldTimeCooldown(EntityPlayerMP player, CooldownType type, long worldTime) {
        this.setWorldTimeCooldown(player, type, worldTime, true);
    }

    private void setWorldTimeCooldown(EntityPlayerMP player, CooldownType type, long worldTime, boolean checkSync) {
        NBTTagList tagList = this.getCooldownTagList((EntityPlayer)player);
        boolean isSet = false;
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            if (!FIND_BY_TYPE.test(tag, type)) continue;
            tag.func_74772_a(CD_NBT_LONG, worldTime);
            isSet = true;
            break;
        }
        if (!isSet) {
            this.writeCooldown(tagList, type, worldTime);
        }
        this.cooldowns.computeIfAbsent(Objects.requireNonNull(player.func_110124_au()), aId -> this.computePlayerCd(player)).put(type, worldTime);
        if (checkSync && type.isSync()) {
            PacketHandler.INSTANCE.sendTo((IMessage)new SyncCooldownMessage(type, worldTime), player);
        }
    }

    public void updateWorldTime(EntityPlayerMP player, long modifier) {
        if (!EntityHelper.isValidServerPlayer((Entity)player)) {
            return;
        }
        boolean requirePacket = false;
        for (CooldownType type : CooldownType.values()) {
            int cd = this.getCooldown((EntityPlayer)player, type);
            if (cd <= 0) continue;
            requirePacket = true;
            this.setWorldTimeCooldown(player, type, (long)cd + modifier, false);
        }
        if (requirePacket) {
            PacketHandler.INSTANCE.sendTo((IMessage)this.getCooldownPacket(player), player);
        }
    }

    private EnumMap<CooldownType, Long> computePlayerCd(EntityPlayerMP player) {
        return this.computePlayerCd(this.getCooldownTagList((EntityPlayer)player));
    }

    private EnumMap<CooldownType, Long> computePlayerCd(NBTTagList tagList) {
        EnumMap<CooldownType, Long> playerCooldowns = new EnumMap<CooldownType, Long>(CooldownType.class);
        tagList.forEach(inbt -> {
            NBTTagCompound nbt = (NBTTagCompound)inbt;
            CooldownType id = FIND_BY_ID.apply(nbt.func_74771_c(ID_NBT_BYTE));
            if (id != null) {
                playerCooldowns.put(id, nbt.func_74763_f(CD_NBT_LONG));
            }
        });
        return playerCooldowns;
    }

    private NBTTagList getCooldownTagList(EntityPlayer player) {
        return NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag(player), COOLDOWNS_NBT_LIST);
    }

    private void removeCooldownInNBT(EntityPlayer player, Predicate<NBTTagCompound> predic) {
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag(player);
        if (persistentTag.func_150297_b(COOLDOWNS_NBT_LIST, 9)) {
            NBTTagList tagList = persistentTag.func_150295_c(COOLDOWNS_NBT_LIST, 10);
            Iterator it = tagList.iterator();
            while (it.hasNext()) {
                NBTTagCompound tag = (NBTTagCompound)it.next();
                if (!predic.test(tag)) continue;
                it.remove();
            }
        }
    }

    public SyncCooldownMessage getCooldownPacket(EntityPlayerMP player) {
        NBTTagList initTagList = this.getCooldownTagList((EntityPlayer)player);
        EnumMap entry = this.cooldowns.computeIfAbsent(Objects.requireNonNull(player.func_110124_au()), aId -> this.computePlayerCd(initTagList));
        NBTTagList tagList = new NBTTagList();
        Arrays.stream(CooldownType.values()).filter(CooldownType::isSync).forEach(type -> {
            long worldTimeCD = entry.getOrDefault(type, -1L);
            if (worldTimeCD > 0L) {
                long cooldown = worldTimeCD - TimeHelper.worldTicks(player.field_70170_p);
                int maxCD = type.getMaxCooldown((EntityPlayer)player);
                if (cooldown <= 0L && entry.remove(type) != null) {
                    this.removeCooldownInNBT((EntityPlayer)player, tag -> FIND_BY_TYPE.test((NBTTagCompound)tag, (CooldownType)((Object)type)));
                    worldTimeCD = -1L;
                }
                if (cooldown > (long)maxCD) {
                    worldTimeCD = TimeHelper.worldTicks(player.field_70170_p) + (long)maxCD;
                    this.setWorldTimeCooldown(player, (CooldownType)((Object)type), worldTimeCD);
                }
            }
            this.writeCooldown(tagList, (CooldownType)((Object)type), worldTimeCD);
        });
        return new SyncCooldownMessage(tagList);
    }

    private void writeCooldown(NBTTagList tagList, CooldownType type, long worldTime) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a(ID_NBT_BYTE, (byte)type.ordinal());
        nbt.func_74772_a(CD_NBT_LONG, worldTime);
        tagList.func_74742_a((NBTBase)nbt);
    }

    public void clear() {
        this.cooldowns.clear();
    }
}

