/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetExperience;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;

public class DeathHandler {
    public static final DeathHandler INSTANCE = new DeathHandler();
    private static final String IS_PLAYER_DEAD_NBT_BOOL = "tb_is_player_dead";
    private static final String PRESERVED_EFFECTS_NBT_LIST = "tb_preserved_effects";
    private static final String LAST_DEATH_LOCATION_NBT_TAG = "tb_last_death_location";
    private static final String GRAVE_LOCATIONS_NBT_LIST = "tb_grave_locations";
    private static final String SOULBOUND_STACKS_NBT_LIST = "tb_soulbound_stacks";
    private static final String KEY_STACKS_NBT_LIST = "tb_key_stacks";

    private DeathHandler() {
    }

    public Location getLastGrave(MinecraftServer server, EntityPlayerMP player) {
        List<Location> graveLocations = this.getGraveList(player);
        List<Integer> dimIds = Helper.getDimensionIds();
        for (Location lastGrave : graveLocations) {
            if (lastGrave.isOrigin() || !dimIds.contains(lastGrave.dim)) continue;
            WorldServer currentWorld = server.func_71218_a(lastGrave.dim);
            if (currentWorld.func_175625_s(lastGrave.getPos()) instanceof TileEntityPlayerGrave) {
                return lastGrave;
            }
            INSTANCE.removeGrave(player, lastGrave);
        }
        return Location.ORIGIN;
    }

    public void removeGrave(EntityPlayerMP player, Location pos) {
        NBTTagList list = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((EntityPlayer)player), GRAVE_LOCATIONS_NBT_LIST);
        boolean removeAbsentWorld = list.func_74745_c() > 100;
        List<Integer> dimIds = Helper.getDimensionIds();
        assert (player.func_184102_h() != null);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            NBTTagCompound nbt = (NBTTagCompound)it.next();
            Location loc = NBTStackHelper.getLocation(nbt, "location");
            if (!pos.equals(loc) && (!removeAbsentWorld || dimIds.contains(loc.dim))) continue;
            it.remove();
        }
    }

    public void logLastGrave(EntityPlayer player, int x, int y, int z, int dim) {
        NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag(player), GRAVE_LOCATIONS_NBT_LIST).func_74742_a((NBTBase)NBTStackHelper.setLocation(new NBTTagCompound(), "location", new Location(x, y, z, dim)));
        if (ConfigTombstone.player_death.logPlayerGrave) {
            LangKey.MESSAGE_LAST_GRAVE_PLACE.sendLog(player.func_70005_c_(), LangKey.MESSAGE_LAST_GRAVE.getServerTranslation(new Object[0]), x, y, z, dim);
        }
    }

    public List<Location> getGraveList(EntityPlayerMP player) {
        LinkedList<Location> graveLocations = new LinkedList<Location>();
        NBTTagList nbtList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((EntityPlayer)player), GRAVE_LOCATIONS_NBT_LIST);
        for (int i = nbtList.func_74745_c() - 1; i >= 0; --i) {
            graveLocations.add(NBTStackHelper.getLocation(nbtList.func_150305_b(i), "location"));
        }
        return graveLocations;
    }

    public boolean isNoGraveLocation(Location location) {
        for (int i = 0; i < ConfigTombstone.player_death.noGraveLocation.length; ++i) {
            String[] res;
            if (ConfigTombstone.player_death.noGraveLocation[i].isEmpty() || !((res = ConfigTombstone.player_death.noGraveLocation[i].split(",")).length == 5 ? new Location(Integer.valueOf(res[0].trim()), Integer.valueOf(res[1].trim()), Integer.valueOf(res[2].trim()), (int)Integer.valueOf(res[3].trim())).isInRangeAndDimension(location, Integer.valueOf(res[4].trim())) : res.length == 1 && location.dim == Integer.valueOf(res[0].trim()))) continue;
            return true;
        }
        return false;
    }

    public void setLastDeathLocation(EntityPlayer player, Location location) {
        NBTStackHelper.setLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG, location);
    }

    public Location getLastDeathLocation(EntityPlayer player) {
        return NBTStackHelper.getLocation(EntityHelper.getPersistentTag(player), LAST_DEATH_LOCATION_NBT_TAG);
    }

    public void addPlayerDead(EntityPlayerMP player, DamageSource source) {
        int xpLoss;
        int toRemove;
        EntityPlayerMP killer;
        int timeSinceDeath = player.func_147099_x().func_77444_a(StatList.field_188098_h);
        if (timeSinceDeath < TimeHelper.tickFromMinute(1)) {
            if (player.func_147099_x().func_77444_a(StatList.field_188069_A) > 1) {
                ModTriggers.CHAIN_DEATH.trigger(player);
            }
        } else if (timeSinceDeath >= TimeHelper.tickFromHour(1)) {
            ModTriggers.STRONG_OR_CAREFUL.trigger(player);
            if (timeSinceDeath >= TimeHelper.tickFromHour(10)) {
                ModTriggers.ALMOST_UNKILLABLE.trigger(player);
            }
        }
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag((EntityPlayer)player);
        persistentTag.func_74757_a(IS_PLAYER_DEAD_NBT_BOOL, true);
        this.setLastDeathLocation((EntityPlayer)player, new Location((Entity)player));
        boolean hasPreservation = EffectHelper.isPotionActive((EntityLivingBase)player, ModEffects.preservation);
        if (hasPreservation || ConfigTombstone.player_death.restoreEffectsOnDeath) {
            NBTTagList effectsList = new NBTTagList();
            player.func_70651_bq().stream().filter(EffectHelper::isAllowedEffect).forEach(effect -> {
                NBTTagCompound effectData = new NBTTagCompound();
                effectData.func_74778_a("id", effect.func_188419_a().getRegistryName().toString());
                effectData.func_74768_a("amplifier", effect.func_76458_c());
                effectData.func_74768_a("duration", effect.func_76459_b());
                effectsList.func_74742_a((NBTBase)effectData);
            });
            persistentTag.func_74782_a(PRESERVED_EFFECTS_NBT_LIST, (NBTBase)effectsList);
        }
        int xpTotal = EntityHelper.getPlayerTotalXp((EntityPlayer)player);
        if (!hasPreservation && xpTotal > 0 && Optional.ofNullable(player.func_184102_h()).map(MinecraftServer::func_71219_W).orElse(false).booleanValue() && EntityHelper.isKilledByOtherPlayer((EntityPlayer)player, source) && (killer = (EntityPlayerMP)source.func_76346_g()) != null && (toRemove = MathHelper.func_76128_c((double)((double)(xpTotal * ConfigTombstone.player_death.pvpStolenXp) / 100.0))) > 0) {
            xpTotal -= toRemove;
            killer.func_71023_q(toRemove);
            LangKey.MESSAGE_PVP_STEAL_EXPERIENCE.sendMessage((ICommandSender)player, toRemove, player.func_70005_c_());
        }
        if ((xpLoss = ConfigTombstone.player_death.xpLoss) == -1) {
            xpTotal = 0;
        } else if (!hasPreservation && xpLoss > 0) {
            xpTotal = MathHelper.func_76128_c((double)((double)(xpTotal * MathHelper.func_76125_a((int)(100 + EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.memento_mori) * 20 - ConfigTombstone.player_death.getXpLoss()), (int)0, (int)100)) / 100.0));
        }
        persistentTag.func_74768_a("tb_experience_total", xpTotal);
        Pair<Integer, Float> pair = EntityHelper.getPlayerXpPair(xpTotal);
        persistentTag.func_74768_a("tb_experience_level", ((Integer)pair.getLeft()).intValue());
        persistentTag.func_74776_a("tb_experience_bar", ((Float)pair.getRight()).floatValue());
        persistentTag.func_74757_a("tb_has_preservation", hasPreservation);
    }

    public void restorePlayerDead(EntityPlayerMP player) {
        boolean hasPreservation;
        if (!this.isPlayerDead((EntityPlayer)player)) {
            return;
        }
        if (!(Helper.isDisabledPerk(ModPerks.ghostly_shape, (EntityPlayer)player) || SupportMods.DIM_DOORS.isLoaded() && player.field_70170_p.field_73011_w.func_186058_p().func_186065_b().equals("limbo"))) {
            EffectHelper.addPotion((EntityLivingBase)player, ModEffects.ghostly_shape, ConfigTombstone.general.getGhostlyShapeDuration() * 20, EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.ghostly_shape), new boolean[0]);
        }
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag((EntityPlayer)player);
        persistentTag.func_82580_o(IS_PLAYER_DEAD_NBT_BOOL);
        if (persistentTag.func_150297_b(PRESERVED_EFFECTS_NBT_LIST, 9)) {
            NBTTagList effectList = persistentTag.func_150295_c(PRESERVED_EFFECTS_NBT_LIST, 10);
            for (int i = 0; i < effectList.func_74745_c(); ++i) {
                Potion effect;
                NBTTagCompound effectData = (NBTTagCompound)effectList.func_179238_g(i);
                String id = effectData.func_74779_i("id");
                if (id.length() <= 0 || !EffectHelper.isAllowedEffect(effect = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(id)))) continue;
                EffectHelper.addPotion((EntityLivingBase)player, effect, effectData.func_74762_e("duration"), effectData.func_74762_e("amplifier"), new boolean[0]);
            }
            persistentTag.func_82580_o(PRESERVED_EFFECTS_NBT_LIST);
        }
        if ((hasPreservation = persistentTag.func_74767_n("tb_has_preservation")) || ConfigTombstone.player_death.isHandlingPlayerXp()) {
            player.field_71067_cb = persistentTag.func_74762_e("tb_experience_total");
            player.field_71068_ca = persistentTag.func_74762_e("tb_experience_level");
            player.field_71106_cc = persistentTag.func_74760_g("tb_experience_bar");
            persistentTag.func_82580_o("tb_has_preservation");
            player.field_71135_a.func_147359_a((Packet)new SPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
        }
    }

    public boolean isPlayerDead(EntityPlayer player) {
        return EntityHelper.getPersistentTag(player).func_74767_n(IS_PLAYER_DEAD_NBT_BOOL);
    }

    public void restoreSoulbounds(EntityPlayerMP player) {
        if (ConfigTombstone.player_death.handlePlayerDeath && Loader.instance().getModList().stream().anyMatch(modContainer -> "erebus".equals(modContainer.getModId()) || "death_compass".equals(modContainer.getModId()))) {
            player.field_71071_by.field_70462_a.stream().filter(stack -> "death_compass".equals(Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(ResourceLocation::func_110623_a).orElse(""))).forEach(stack -> stack.func_190918_g(stack.func_190916_E()));
        }
        NBTTagCompound persistentTag = EntityHelper.getPersistentTag((EntityPlayer)player);
        NBTTagList stackList = persistentTag.func_150295_c(SOULBOUND_STACKS_NBT_LIST, 10);
        for (int i = 0; i < stackList.func_74745_c(); ++i) {
            ItemStack stack2 = new ItemStack(stackList.func_150305_b(i));
            if (stack2.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack2);
        }
        persistentTag.func_82580_o(SOULBOUND_STACKS_NBT_LIST);
        NBTTagList keyList = persistentTag.func_150295_c(KEY_STACKS_NBT_LIST, 10);
        for (int i = 0; i < keyList.func_74745_c(); ++i) {
            ItemStack stack3 = new ItemStack(keyList.func_150305_b(i));
            if (stack3.func_190926_b()) continue;
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack3);
        }
        persistentTag.func_82580_o(KEY_STACKS_NBT_LIST);
    }

    public void storeSoulboundsOnBody(EntityPlayerMP player, List<ItemStack> keys, List<ItemStack> soulbounds) {
        NBTTagList keyStack = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((EntityPlayer)player), KEY_STACKS_NBT_LIST);
        keys.forEach(key -> keyStack.func_74742_a((NBTBase)key.serializeNBT()));
        keys.clear();
        NBTTagList stackList = NBTStackHelper.getListOrCreate(EntityHelper.getPersistentTag((EntityPlayer)player), SOULBOUND_STACKS_NBT_LIST);
        soulbounds.forEach(soulbound -> stackList.func_74742_a((NBTBase)soulbound.serializeNBT()));
        soulbounds.clear();
    }
}

