/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEffects;

public class EffectHelper {
    private static final Method methodOnFinishedPotionEffect = ReflectionHelper.findMethod(EntityLivingBase.class, (String)"onFinishedPotionEffect", (String)"func_70688_c", (Class[])new Class[]{PotionEffect.class});
    private static Function<Random, Integer> RANDOM_EFFECT_LEVEL = random -> {
        int roll = random.nextInt(100) + 1;
        return roll < 10 ? 4 : (roll < 25 ? 3 : (roll < 45 ? 2 : (roll < 70 ? 1 : 0)));
    };

    public static int getDuration(@Nullable EntityLivingBase entity, @Nullable Potion potion) {
        PotionEffect potionInstance;
        return entity != null && potion != null && (potionInstance = entity.func_70660_b(potion)) != null ? potionInstance.field_76460_b : 0;
    }

    public static boolean isPotionActive(EntityLivingBase entity, Potion potion) {
        return EffectHelper.getDuration(entity, potion) > 0;
    }

    public static boolean isPotionActive(@Nullable EntityLivingBase entity, @Nullable Potion potion, int amplifier) {
        PotionEffect potionInstance;
        return entity != null && potion != null && (potionInstance = entity.func_70660_b(potion)) != null && potionInstance.func_76458_c() >= amplifier && potionInstance.field_76460_b > 0;
    }

    public static boolean isUnstableIntangiblenessActive(@Nullable EntityLivingBase player) {
        return TimeHelper.inIntervalAfter(EffectHelper.getDuration(player, ModEffects.unstable_intangibleness), 100, 79);
    }

    public static void capDuration(EntityLivingBase entity, Potion potion, int maxDuration) {
        PotionEffect potionInstance = (PotionEffect)entity.func_193076_bZ().get(potion);
        if (potionInstance != null && potionInstance.field_76460_b > maxDuration) {
            EffectHelper.clearEffect(entity, potion);
            potionInstance.field_76460_b = maxDuration;
            EffectHelper.addPotion(entity, potionInstance);
        }
    }

    public static void addPotion(@Nullable EntityLivingBase entity, @Nullable Potion potion, int duration) {
        EffectHelper.addPotion(entity, potion, duration, 0, new boolean[0]);
    }

    public static void addPotion(@Nullable EntityLivingBase entity, @Nullable Potion potion, int duration, int amplifier, boolean ... params) {
        if (entity != null && potion != null) {
            entity.func_70690_d(new PotionEffect(potion, duration, amplifier, params.length == 0 || params[0], params.length <= 1 || params[1]));
        }
    }

    public static void addPotion(@Nullable EntityLivingBase entity, @Nullable PotionEffect potionInstance) {
        if (entity != null && potionInstance != null && potionInstance.func_188419_a() != null) {
            entity.func_70690_d(potionInstance);
        }
    }

    public static boolean isPotionHidden(@Nullable EntityLivingBase entity, @Nullable Potion potion) {
        PotionEffect potionInstance;
        return entity != null && potion != null && (potionInstance = entity.func_70660_b(potion)) != null && potionInstance.func_82720_e() && !potionInstance.func_188418_e();
    }

    public static boolean clearEffect(@Nullable EntityLivingBase entity, Potion potion) {
        PotionEffect potionInstance;
        if (entity != null && !entity.field_70170_p.field_72995_K && (potionInstance = entity.func_184596_c(potion)) != null) {
            try {
                methodOnFinishedPotionEffect.invoke((Object)entity, potionInstance);
                return true;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static void clearEffect(EntityLivingBase entity, Predicate<Potion> predic) {
        if (!entity.field_70170_p.field_72995_K) {
            Iterator it = entity.func_193076_bZ().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (!predic.test((Potion)entry.getKey())) continue;
                try {
                    methodOnFinishedPotionEffect.invoke((Object)entity, entry.getValue());
                    it.remove();
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void clearBadEffects(@Nullable EntityLivingBase entity) {
        if (entity != null) {
            if (!entity.field_70170_p.field_72995_K) {
                EffectHelper.clearEffect(entity, Potion::func_76398_f);
            }
            if (entity.func_70027_ad()) {
                entity.func_70066_B();
            }
            if (entity.func_184202_aL()) {
                entity.func_184195_f(false);
            }
        }
    }

    @Nullable
    public static PotionEffect getRandomEffect(int duration, boolean isBad) {
        return EffectHelper.getRandomEffect(duration, isBad, true, RANDOM_EFFECT_LEVEL);
    }

    @Nullable
    public static PotionEffect getRandomEffect(int duration, boolean isBad, boolean acceptInstantEffect, Function<Random, Integer> functionEffectLevel) {
        Potion potion;
        List potions;
        Predicate<Potion> predic;
        Predicate<Potion> predicate = predic = isBad ? EffectHelper::isBadEffect : EffectHelper::isAllowedEffect;
        if (!acceptInstantEffect) {
            predic = predic.and(effect -> !effect.func_76403_b());
        }
        if ((potions = ForgeRegistries.POTIONS.getValuesCollection().stream().filter(predic).collect(Collectors.toList())).size() > 0 && (potion = (Potion)potions.get(Helper.RANDOM.nextInt(potions.size()))) != null) {
            return new PotionEffect(potion, isBad && potion.func_76403_b() ? 1 : duration, functionEffectLevel.apply(Helper.RANDOM).intValue(), true, true);
        }
        return null;
    }

    public static void addRandomPotion(EntityPlayer player, int duration, boolean withMessage) {
        EffectHelper.addRandomPotion(player, duration, withMessage, false, true);
    }

    public static void addRandomPotion(EntityPlayer player, int duration, boolean withMessage, boolean isBad, boolean acceptInstantEffect) {
        PotionEffect effect = EffectHelper.getRandomEffect(duration, isBad, acceptInstantEffect, RANDOM_EFFECT_LEVEL);
        if (effect != null) {
            if (withMessage && !effect.func_188419_a().func_76393_a().isEmpty()) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMagicMessage((ICommandSender)player, LangKey.makeTranslationWithStyle(StyleType.MESSAGE_SPECIAL, effect.func_188419_a().func_76393_a(), new Object[0]));
            }
            EffectHelper.addPotion((EntityLivingBase)player, effect);
        }
    }

    public static boolean isAllowedEffect(@Nullable PotionEffect effectInstance) {
        return effectInstance != null && EffectHelper.isAllowedEffect(effectInstance.func_188419_a());
    }

    public static boolean isAllowedEffect(@Nullable Potion potion) {
        return potion != null && !potion.func_76398_f() && potion != ModEffects.ghostly_shape && potion != ModEffects.preservation && potion != ModEffects.exorcism && potion != ModEffects.bone_shield && !Helper.containRL(ConfigTombstone.general.unhandledBeneficialEffects, potion.getRegistryName());
    }

    public static boolean isBadEffect(@Nullable Potion potion) {
        return potion != null && potion.func_76398_f() && !Helper.containRL(ConfigTombstone.general.unhandledHarmfulEffects, potion.getRegistryName());
    }
}

