/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.compatibility.CompatibilityMinecolonies;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTriggers;

public class EntityHelper {
    private static final String SHADOW_STEP_COOLDOWN_NBT_LONG = "shadow_step_cooldown";

    public static int getShadowStepLevel(EntityPlayer player) {
        boolean enabled;
        boolean bl = enabled = ConfigTombstone.enchantments.enableEnchantmentShadowStep && (!ConfigTombstone.enchantments.isNerfShadowStepForceSneak() || player.func_70093_af());
        if (!enabled) {
            return 0;
        }
        ItemStack shadowStepStack = player.func_184582_a(EntityEquipmentSlot.FEET);
        int shadowStepLevel = Math.min(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.shadow_step, (ItemStack)shadowStepStack), ModEnchantments.shadow_step.getLevelLimit());
        if (shadowStepLevel == 0 || NBTStackHelper.hasTimer(TimeHelper.worldTicks(player.field_70170_p), shadowStepStack, SHADOW_STEP_COOLDOWN_NBT_LONG, 200)) {
            return 0;
        }
        return shadowStepLevel;
    }

    public static void setShadowStepCooldown(EntityPlayer player) {
        NBTStackHelper.setLong(player.func_184582_a(EntityEquipmentSlot.FEET), SHADOW_STEP_COOLDOWN_NBT_LONG, TimeHelper.worldTicks(player.field_70170_p) + 200L);
    }

    public static int getCurseOfBonesLevel(EntityLivingBase entity) {
        return Math.min(EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.curse_of_bones, (ItemStack)entity.func_184582_a(EntityEquipmentSlot.CHEST)), ModEnchantments.curse_of_bones.getLevelLimit());
    }

    public static boolean isValidPlayer(@Nullable ICommandSender sender) {
        return sender instanceof EntityPlayer && !(sender instanceof FakePlayer);
    }

    public static boolean isValidPlayer(@Nullable Entity entity) {
        return entity instanceof EntityPlayer && !(entity instanceof FakePlayer);
    }

    public static boolean isValidServerPlayer(@Nullable Entity entity) {
        return EntityHelper.isValidPlayer(entity) && !entity.field_70170_p.field_72995_K;
    }

    public static boolean isValidPlayer(@Nullable EntityPlayer player) {
        return player != null && !EntityHelper.isFakePlayer(player);
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        return player instanceof FakePlayer;
    }

    public static boolean isSurvivalPlayer(@Nullable EntityPlayer player) {
        return EntityHelper.isValidPlayer(player) && !player.func_184812_l_() && !player.func_175149_v();
    }

    public static boolean isKilledByOtherPlayer(EntityPlayer player, DamageSource source) {
        return EntityHelper.isValidPlayer(source.func_76346_g()) && !player.equals((Object)source.func_76346_g());
    }

    public static Optional<Location> getHomeLocation(EntityLivingBase entity) {
        return entity instanceof EntityCreature ? Optional.of(new Location(((EntityCreature)entity).func_180486_cf(), entity.field_70170_p)) : Optional.empty();
    }

    public static void setPlayerXp(EntityPlayer player, int amount) {
        if (amount <= 0) {
            return;
        }
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.field_71106_cc = 0.0f;
        player.field_71106_cc += (float)amount / (float)player.func_71050_bK();
        player.field_71067_cb += amount;
        while (player.field_71106_cc >= 1.0f) {
            player.field_71106_cc = (player.field_71106_cc - 1.0f) * (float)player.func_71050_bK();
            ++player.field_71068_ca;
            player.field_71106_cc /= (float)player.func_71050_bK();
        }
    }

    public static Pair<Integer, Float> getPlayerXpPair(int experienceTotal) {
        float aExperience;
        if (experienceTotal <= 0) {
            return Pair.of((Object)0, (Object)Float.valueOf(0.0f));
        }
        int aExperienceLevel = 0;
        for (aExperience = (float)experienceTotal / (float)EntityHelper.xpBarCap(aExperienceLevel); aExperience >= 1.0f; aExperience /= (float)EntityHelper.xpBarCap(++aExperienceLevel)) {
            aExperience = (aExperience - 1.0f) * (float)EntityHelper.xpBarCap(aExperienceLevel);
        }
        return Pair.of((Object)aExperienceLevel, (Object)Float.valueOf(aExperience));
    }

    public static int getPlayerTotalXp(EntityPlayer player) {
        return EntityHelper.getPlayerTotalXp(player.field_71068_ca, player.field_71106_cc);
    }

    public static int getPlayerTotalXp(int level, float bar) {
        int experienceTotal;
        if (level < 17) {
            experienceTotal = level * level + 6 * level;
            experienceTotal = (int)((float)experienceTotal + (float)(2 * level + 7) * bar);
        } else if (level < 32) {
            experienceTotal = (int)((double)(level * level) * 2.5 - 40.5 * (double)level + 360.0);
            experienceTotal = (int)((float)experienceTotal + (float)(5 * level - 38) * bar);
        } else {
            experienceTotal = (int)((double)(level * level) * 4.5 - 162.5 * (double)level + 2220.0);
            experienceTotal = (int)((float)experienceTotal + (float)(9 * level - 158) * bar);
        }
        return experienceTotal;
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        return level >= 15 ? 37 + (level - 15) * 5 : 7 + level * 2;
    }

    public static boolean noGlobalItemCooldown(@Nullable EntityPlayer player, Item item) {
        return EntityHelper.getGlobalItemCooldown(player, item) <= 0.0f;
    }

    public static boolean noGlobalItemCooldown(@Nullable EntityPlayer player, ItemStack stack) {
        return EntityHelper.noGlobalItemCooldown(player, stack.func_77973_b());
    }

    public static boolean hasGlobalItemCooldown(@Nullable EntityPlayer player, Item item) {
        return EntityHelper.getGlobalItemCooldown(player, item) > 0.0f;
    }

    public static boolean hasGlobalItemCooldown(@Nullable EntityPlayer player, ItemStack stack) {
        return EntityHelper.hasGlobalItemCooldown(player, stack.func_77973_b());
    }

    public static void setGlobalItemCooldown(EntityPlayer player, Item item, int ticks) {
        player.func_184811_cZ().func_185145_a(item, ticks);
    }

    public static void setGlobalItemCooldown(EntityPlayer player, ItemStack stack, int ticks) {
        EntityHelper.setGlobalItemCooldown(player, stack.func_77973_b(), ticks);
    }

    public static void removeGlobalItemCooldown(@Nullable EntityPlayer player, Item item) {
        Optional.ofNullable(player).ifPresent(p -> player.func_184811_cZ().func_185145_a(item, 0));
    }

    public static float getGlobalItemCooldown(@Nullable EntityPlayer player, Item item) {
        return player != null ? player.func_184811_cZ().func_185143_a(item, 0.0f) : 0.0f;
    }

    public static float getGlobalItemCooldown(@Nullable EntityPlayer player, ItemStack stack) {
        return EntityHelper.getGlobalItemCooldown(player, stack.func_77973_b());
    }

    public static void applyKillResult(DamageSource damageSource, EntityLivingBase killedEntity) {
        if (EntityHelper.isValidServerPlayer(damageSource.func_76346_g())) {
            EntityPlayerMP player = (EntityPlayerMP)damageSource.func_76346_g();
            assert (player != null);
            if (!CompatibilityMinecolonies.instance.applyKillResult(player, EntityList.func_191301_a((Entity)killedEntity))) {
                if (killedEntity instanceof EntityVillager) {
                    Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 0, ConfigTombstone.alignment.pointsKillVillager));
                    ModTriggers.KILL_ENOUGH_VILLAGER.trigger(player);
                } else if (killedEntity instanceof EntityZombie && killedEntity.getEntityData().func_74767_n("siege")) {
                    Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 0, ConfigTombstone.alignment.pointsKillRaider));
                    ModTriggers.KILL_ENOUGH_RAIDER.trigger(player);
                }
            }
            if (EntityHelper.isUndead(killedEntity)) {
                ModTriggers.KILL_ENOUGH_UNDEAD.trigger(player);
                if (EntityHelper.isBoss(killedEntity)) {
                    ModTriggers.KILL_UNDEAD_BOSS.trigger(player);
                }
            }
        }
    }

    public static boolean isBadAlignment(EntityPlayer player) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        return cap != null && cap.getAlignmentLevel() < 0;
    }

    public static int getPerkLevelWithBonus(@Nullable EntityPlayer player, @Nullable Perk perk) {
        ITBCapability cap;
        if (EntityHelper.isValidPlayer(player) && (cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null) {
            return cap.getPerkLevelWithBonus(player, perk);
        }
        return 0;
    }

    public static int getKnowledgeForPerkLevel(int perkLevel) {
        int perkScale = ConfigTombstone.general.getPerkProgressionScale();
        return perkLevel * perkScale - perkScale + 1;
    }

    public static int getPerkLevelMaxForKnowledge(int knowledgeLevel) {
        int perkScale = ConfigTombstone.general.getPerkProgressionScale();
        return (knowledgeLevel + perkScale - 1) / perkScale;
    }

    public static void syncTBCapability(EntityPlayerMP player, boolean checked) {
        ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
        if (cap != null) {
            if (checked) {
                int totalPerkPoints = cap.getTotalPerkPoints();
                int limit = EntityHelper.getPerkLevelMaxForKnowledge(totalPerkPoints);
                boolean valid = true;
                Iterator<Map.Entry<Perk, Integer>> it = cap.getPerks().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (!valid || Helper.isDisabledPerk(entry.getKey(), (EntityPlayer)player)) {
                        it.remove();
                        continue;
                    }
                    int maxPerkLevel = Math.min(limit, entry.getKey().getLevelMax());
                    if (entry.getValue() > maxPerkLevel) {
                        entry.setValue(maxPerkLevel);
                    }
                    for (int i = 1; i <= entry.getValue() && valid; ++i) {
                        int cost = entry.getKey().getCost(i);
                        if (cost <= totalPerkPoints) {
                            totalPerkPoints -= cost;
                            continue;
                        }
                        valid = false;
                        if (i > 1) {
                            entry.setValue(i - 1);
                            continue;
                        }
                        it.remove();
                    }
                }
            }
            cap.syncAll(player);
        }
    }

    public static NBTTagCompound getPersistentTag(EntityPlayer player) {
        NBTTagCompound persistentData = player.getEntityData();
        if (persistentData.func_74764_b("PlayerPersisted")) {
            return (NBTTagCompound)persistentData.func_74781_a("PlayerPersisted");
        }
        NBTTagCompound persistentTag = new NBTTagCompound();
        persistentData.func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        return persistentTag;
    }

    public static String getRegistryString(@Nullable Entity entity) {
        return Optional.ofNullable(entity).map(EntityList::func_191301_a).map(ResourceLocation::toString).orElse("");
    }

    public static String getRegistryString(@Nullable EntityEntry entityEntry) {
        return Optional.ofNullable(entityEntry).map(IForgeRegistryEntry.Impl::getRegistryName).map(ResourceLocation::toString).orElse("");
    }

    public static void writePlayerData(MinecraftServer server, EntityPlayerMP player) {
        server.func_184103_al().field_72412_k.func_75753_a((EntityPlayer)player);
    }

    public static void loadPlayerData(MinecraftServer server, EntityPlayerMP player) {
        server.func_184103_al().field_72412_k.func_75752_b((EntityPlayer)player);
    }

    @Nullable
    public static EntityPlayerMP getOfflinePlayer(MinecraftServer server, UUID id) {
        GameProfile profil = EntityHelper.getGameProfile(server, id);
        if (profil != null) {
            EntityPlayerMP player = server.func_184103_al().func_148545_a(profil);
            EntityHelper.loadPlayerData(server, player);
            return player;
        }
        return null;
    }

    @Nullable
    public static EntityPlayerMP getOfflinePlayer(MinecraftServer server, String playerName) {
        GameProfile profil = EntityHelper.getGameProfile(server, playerName);
        if (profil != null) {
            EntityPlayerMP player = server.func_184103_al().func_148545_a(profil);
            EntityHelper.loadPlayerData(server, player);
            return player;
        }
        return null;
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, UUID id) {
        return server.func_152358_ax().func_152652_a(id);
    }

    @Nullable
    public static GameProfile getGameProfile(MinecraftServer server, String playerName) {
        PlayerProfileCache.ProfileEntry entry = (PlayerProfileCache.ProfileEntry)server.func_152358_ax().field_152661_c.get(playerName.toLowerCase(Locale.US));
        if (entry != null) {
            return entry.func_152668_a();
        }
        return null;
    }

    public static boolean isUndead(EntityLivingBase entity) {
        return entity.func_70668_bt() == EnumCreatureAttribute.UNDEAD;
    }

    public static boolean isBoss(EntityLivingBase entity) {
        return entity.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() >= (double)ConfigTombstone.loot.undeadBossLifeForDrop && entity instanceof IMob && !entity.func_184222_aU();
    }
}

