/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import io.github.opencubicchunks.cubicchunks.api.world.ICube;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBBind;
import ovh.corail.tombstone.command.CommandTBKnowledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.CommandTBTeleportDeath;
import ovh.corail.tombstone.command.CommandTBTeleportDiscovery;
import ovh.corail.tombstone.command.CommandTBTeleportGrave;
import ovh.corail.tombstone.command.CommandTBTeleportHome;
import ovh.corail.tombstone.command.CommandTBTeleportVillage;
import ovh.corail.tombstone.compatibility.CompatibilityGraveStone;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

public class Helper {
    public static final Random RANDOM = new Random();
    public static final List<String> THANK_NAMES = Lists.newArrayList((Object[])new String[]{"Gegy1000", "Barteks2x", "Runemoro", "Goshen", "Paul Fulham", "Darkhax", "Subaraki", "Raycoms"});
    private static final Map<String, String> BIOME_NAMES = new HashMap<String, String>();
    public static Set<Location> ALLOWED_REMOVALS = new HashSet<Location>();
    public static final String APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL = "april_fools_day_slowness";

    public static boolean isDisabledPerk(@Nullable Perk perk, @Nullable EntityPlayer player) {
        return perk == null || perk.isDisabled(player);
    }

    public static int getRandom(int min, int max) {
        return RANDOM.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return RANDOM.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return RANDOM.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return RANDOM.nextBoolean();
    }

    public static <T> Optional<T> getRandomInList(List<T> list) {
        return list.isEmpty() ? Optional.empty() : list.stream().skip(RANDOM.nextInt(list.size())).findFirst();
    }

    public static boolean existClass(String className) {
        return Helper.getClass(className) != null;
    }

    @Nullable
    public static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    public static Field getField(@Nullable Class<?> aClass, String fieldName) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findField(aClass, (String)fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static Method getMethod(@Nullable Class<?> aClass, String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
        if (aClass != null) {
            try {
                return ObfuscationReflectionHelper.findMethod(aClass, (String)methodName, returnType, (Class[])parameterTypes);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !world.func_189509_E(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld() ? Math.max(Math.min(y, ((ICubicWorld)world).getMaxHeight()), ((ICubicWorld)world).getMinHeight()) : Math.max(Math.min(pos.func_177956_o(), world.field_73011_w.getActualHeight()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !Helper.isOutsideBuildHeight(world, pos);
    }

    public static boolean isOutsideWorldBorders(World world, BlockPos pos) {
        return !world.func_175723_af().func_177746_a(pos);
    }

    public static boolean isOutsideBuildHeight(World world, BlockPos pos) {
        return world.func_189509_E(pos);
    }

    public static boolean isValidDimension(int dim) {
        return Helper.getDimensionIds().contains(dim);
    }

    public static List<Integer> getDimensionIds() {
        return Arrays.asList(DimensionManager.getStaticDimensionIDs());
    }

    public static List<String> getDimensionIdsAsStringList() {
        return Helper.getDimensionIds().stream().map(Object::toString).collect(Collectors.toList());
    }

    public static Location findNearestStructure(WorldServer world, BlockPos pos, SupportStructures struct, boolean unexplored) {
        BlockPos startingPos = pos;
        for (int nbTry = 0; nbTry < 10; ++nbTry) {
            startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177963_a(RANDOM.nextGaussian() * 1000.0, 0.0, RANDOM.nextGaussian() * 1000.0));
            BlockPos foundPos = world.func_190528_a(struct.getStructureName(), startingPos, unexplored);
            if (foundPos == null || !Helper.isValidPos((World)world, foundPos) || !struct.isValidBiome(world.func_180494_b(foundPos))) continue;
            Location structureLoc = new Location(foundPos, (World)world);
            if (struct == SupportStructures.Village && unexplored && Helper.isVillageExplored((World)world, structureLoc.getPos())) continue;
            return structureLoc;
        }
        return Location.ORIGIN;
    }

    public static String getBiomeName(String biomeId) {
        return BIOME_NAMES.computeIfAbsent(biomeId, k -> {
            String[] splits = biomeId.toLowerCase(Locale.US).split(":");
            String biomeName = Helper.capitalizeWord(splits[splits.length - 1]);
            return splits.length < 2 || "minecraft".equals(splits[0]) ? biomeName : biomeName + " [" + splits[0] + "]";
        });
    }

    public static String capitalizeWord(String text) {
        StringBuilder builder = new StringBuilder();
        String[] splits = text.toLowerCase(Locale.US).split("\\s|_");
        builder.append(StringUtils.capitalize((String)splits[0]));
        if (splits.length > 1) {
            Arrays.stream(splits, 1, splits.length).forEach(word -> builder.append(" ").append(StringUtils.capitalize((String)word)));
        }
        return builder.toString();
    }

    public static boolean isVillageExplored(World world, BlockPos villagePos) {
        return world.func_175714_ae().func_75540_b().stream().anyMatch(v -> v.func_180608_a().equals((Object)villagePos));
    }

    public static Location findSpawnForVillage(WorldServer world, BlockPos villagePos) {
        return new SpawnHelper(world, world.func_175672_r(villagePos)).findSpawnPlace();
    }

    public static <T extends Entity> T teleport(T entity, double x, double y, double z, int dim) {
        if (entity.field_70170_p.field_72995_K || entity.field_70128_L) {
            return entity;
        }
        if (entity.func_184207_aI()) {
            entity.func_184226_ay();
        }
        if (entity.func_184218_aH()) {
            entity.func_184210_p();
        }
        if (entity.field_70170_p.field_73011_w.getDimension() != dim) {
            return (T)Optional.ofNullable(entity.changeDimension(dim, (ITeleporter)new CustomTeleporter(x, y, z))).orElse(entity);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
            player.func_70034_d(player.field_70759_as);
        } else {
            entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            entity.func_70034_d(entity.field_70177_z);
        }
        return entity;
    }

    public static <T extends Entity> T teleport(T entity, Location loc) {
        return Helper.teleport(entity, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5, loc.dim);
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc) {
        return Helper.teleport(entity, new Location(loc.getPos().func_177984_a(), loc.dim));
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_82766_b("keepInventory");
    }

    public static boolean isAllowedForRemoval(World world, BlockPos pos) {
        return ALLOWED_REMOVALS.contains(new Location(pos, world));
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        Helper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, IBlockState state) {
        ExtendedBlockStorage storage;
        pos = pos.func_185334_h();
        Location location = new Location(pos, world);
        if (!ConfigTombstone.player_death.gravesByPassGriefingRules) {
            ALLOWED_REMOVALS.add(location);
            world.func_180501_a(pos, state, 3);
            ALLOWED_REMOVALS.remove(location);
            return;
        }
        ALLOWED_REMOVALS.add(location);
        if (SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld()) {
            ICubicWorld cubicWorld = (ICubicWorld)world;
            ICube cube = cubicWorld.getCubeFromBlockCoords(pos);
            storage = cube.getStorage();
            if (storage == null) {
                cube.setLightFor(EnumSkyBlock.BLOCK, pos, cube.getLightFor(EnumSkyBlock.BLOCK, pos));
                storage = cube.getStorage();
            }
        } else {
            Chunk chunk = world.func_175726_f(pos);
            ExtendedBlockStorage[] storageArray = chunk.func_76587_i();
            storage = storageArray[pos.func_177956_o() >> 4];
            if (storage == null) {
                ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
                storageArray[pos.func_177956_o() >> 4] = extendedBlockStorage;
                storage = extendedBlockStorage;
            }
            chunk.func_76630_e();
        }
        IBlockState oldState = storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
        storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
        if (!world.field_72995_K) {
            world.func_175713_t(pos);
        }
        int oldLight = oldState.getLightValue((IBlockAccess)world, pos);
        int oldOpacity = oldState.getLightOpacity((IBlockAccess)world, pos);
        if (state.getLightOpacity((IBlockAccess)world, pos) != oldOpacity || state.getLightValue((IBlockAccess)world, pos) != oldLight || state.func_185895_e() || oldState.func_185895_e()) {
            world.func_175664_x(pos);
        }
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), oldState, state, 3);
        ALLOWED_REMOVALS.remove(location);
    }

    public static boolean canShowTooltip() {
        return ConfigTombstone.client.showEnhancedTooltips || GuiScreen.func_146272_n();
    }

    public static boolean isAprilFoolsDaySnowball(EntityLivingBase entity, @Nullable DamageSource source) {
        Entity immediateSource;
        return TimeHelper.isAprilFoolsDay() && EntityHelper.isValidServerPlayer((Entity)entity) && source != null && (immediateSource = source.func_76364_f()) instanceof EntitySnowball && immediateSource.getEntityData().func_74764_b(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL);
    }

    public static void handleAprilFoolsDayGrave(World world, BlockPos pos) {
        Vec3d centerVec = new Vec3d((Vec3i)pos).func_72441_c(0.5, 1.0, 0.5);
        EntityPlayer closestPlayer = world.func_184137_a(centerVec.field_72450_a, centerVec.field_72448_b, centerVec.field_72449_c, 20.0, false);
        if (closestPlayer != null) {
            EntitySnowball snowballentity = new EntitySnowball(world, centerVec.field_72450_a, centerVec.field_72448_b, centerVec.field_72449_c);
            snowballentity.getEntityData().func_74757_a(APRIL_FOOLS_DAY_SLOWNESS_NBT_BOOL, true);
            if (Helper.canSeeEntity((Entity)closestPlayer, centerVec)) {
                Vec3d vec = closestPlayer.func_174791_d().func_72441_c(0.0, (double)closestPlayer.func_70047_e(), 0.0).func_178788_d(snowballentity.func_174791_d());
                snowballentity.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.5f, 1.0f);
                world.func_72838_d((Entity)snowballentity);
            }
        }
    }

    public static boolean canSeeEntity(Entity entity, Vec3d vec3d) {
        Vec3d vec3d1 = entity.func_174791_d().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        return entity.field_70170_p.func_72933_a(vec3d, vec3d1) == null;
    }

    public static boolean isNight(World world) {
        float angle = world.func_72826_c(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static boolean isDay(World world) {
        return !Helper.isNight(world);
    }

    public static boolean containRL(String[] arrayRL, @Nullable ResourceLocation rl) {
        return rl != null && Arrays.stream(arrayRL).anyMatch(p -> p.contains(":") ? rl.toString().equals(p) : rl.func_110624_b().equals(p));
    }

    public static boolean containRL(String[] listRL, String registryName) {
        String domain = registryName.split(":")[0];
        return Arrays.stream(listRL).anyMatch(p -> p.contains(":") ? p.equals(registryName) : p.equals(domain));
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    public static void fillGradient(int left, int top, int right, int bottom, int color1, int color2, float zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor3F(color1);
        float[] argb2 = Helper.getRGBColor3F(color2);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Helper.makeVertex(bufferbuilder, right, top, (int)zLevel, isHorizontal ? argb2 : argb1);
        Helper.makeVertex(bufferbuilder, left, top, (int)zLevel, argb1);
        Helper.makeVertex(bufferbuilder, left, bottom, (int)zLevel, isHorizontal ? argb1 : argb2);
        Helper.makeVertex(bufferbuilder, right, bottom, (int)zLevel, argb2);
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private static void makeVertex(BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.func_181662_b((double)x, (double)y, (double)zLevel).func_181666_a(colorArray[0], colorArray[1], colorArray[2], 1.0f).func_181675_d();
    }

    public static EnumEnchantmentType addEnchantmentType(String name, Predicate<Item> predic, EnumEnchantmentType fallback) {
        EnumEnchantmentType enchantType = EnumHelper.addEnchantmentType((String)name, predic);
        return enchantType == null ? fallback : enchantType;
    }

    public static boolean isModPresent(String modid, @Nullable String version) {
        return Loader.instance().getActiveModList().stream().filter(mod -> mod.getModId().equals(modid)).findFirst().map(mod -> version == null || mod.getProcessedVersion().compareTo((Object)new DefaultArtifactVersion(version)) >= 0).orElse(false);
    }

    public static int getEnchantmentId(Enchantment enchantment) {
        return ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantment);
    }

    public static double lerp(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public static Optional<String> checkDeathHandlingMod(@Nullable EntityPlayerMP player) {
        Optional<String> modName = Stream.of("TombManyGraves", "opengrave", "corpse", "simpletomb", "simple_tomb", "rpgz", "vanilladeathchest", "gravekeeper", "enigmaticgraves").filter(modid -> Loader.instance().getModList().stream().anyMatch(modContainer -> modContainer.getModId().equals(modid))).findFirst();
        if (!modName.isPresent() && CompatibilityGraveStone.instance.isEuhDawson()) {
            return Optional.of("GraveStone (from EuhDawnson)");
        }
        return modName;
    }

    public static void initCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTBTeleport());
        event.registerServerCommand((ICommand)new CommandTBTeleportGrave());
        event.registerServerCommand((ICommand)new CommandTBShowLastGrave());
        event.registerServerCommand((ICommand)new CommandTBRestoreInventory());
        event.registerServerCommand((ICommand)new CommandTBTeleportVillage());
        event.registerServerCommand((ICommand)new CommandTBTeleportDiscovery());
        event.registerServerCommand((ICommand)new CommandTBRecovery());
        event.registerServerCommand((ICommand)new CommandTBAcceptTeleport());
        event.registerServerCommand((ICommand)new CommandTBKnowledge());
        event.registerServerCommand((ICommand)new CommandTBSiege());
        event.registerServerCommand((ICommand)new CommandTBReviveFamiliar());
        event.registerServerCommand((ICommand)new CommandTBTeleportHome());
        event.registerServerCommand((ICommand)new CommandTBRequestTeleport());
        event.registerServerCommand((ICommand)new CommandTBBind());
        event.registerServerCommand((ICommand)new CommandTBTeleportDeath());
    }

    public static void registerOreDicts() {
        OreDictionary.registerOre((String)"dustGrave", (ItemStack)ItemCraftingIngredient.IngredientType.GRAVE_DUST.getStack());
        OreDictionary.registerOre((String)"essenceOfUndeath", (ItemStack)ItemCraftingIngredient.IngredientType.ESSENCE_OF_UNDEATH.getStack());
        OreDictionary.registerOre((String)"ingredientEnchantedGraveKey", (Item)Items.field_151079_bi);
        for (int meta = 0; meta <= 1; ++meta) {
            OreDictionary.registerOre((String)"graveMarble", (ItemStack)new ItemStack(ModBlocks.dark_marble, 1, meta));
            OreDictionary.registerOre((String)"decorativeGrave", (ItemStack)new ItemStack((Block)ModBlocks.decorative_grave_simple, 1, meta));
            OreDictionary.registerOre((String)"decorativeGrave", (ItemStack)new ItemStack((Block)ModBlocks.decorative_grave_normal, 1, meta));
            OreDictionary.registerOre((String)"decorativeGrave", (ItemStack)new ItemStack((Block)ModBlocks.decorative_grave_cross, 1, meta));
            OreDictionary.registerOre((String)"decorativeGrave", (ItemStack)new ItemStack((Block)ModBlocks.decorative_tombstone, 1, meta));
            OreDictionary.registerOre((String)"decorativeGrave", (ItemStack)new ItemStack((Block)ModBlocks.decorative_subaraki_grave, 1, meta));
            OreDictionary.registerOre((String)"decorativeGrave", (ItemStack)new ItemStack((Block)ModBlocks.decorative_grave_original, 1, meta));
        }
        for (ItemScrollBuff.SpellBuff buff : ItemScrollBuff.SpellBuff.values()) {
            OreDictionary.registerOre((String)"magicScroll", (ItemStack)new ItemStack((Item)ModItems.scroll_buff, 1, buff.ordinal()));
        }
        OreDictionary.registerOre((String)"magicScroll", (Item)ModItems.scroll_of_knowledge);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_recall);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_assistance);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_home);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_cupidity);
        OreDictionary.registerOre((String)"voodooPoppetProtectionSuffocation", (Item)Item.func_150898_a((Block)Blocks.field_150392_bi));
        OreDictionary.registerOre((String)"voodooPoppetProtectionBurn", (Item)Items.field_151064_bs);
        OreDictionary.registerOre((String)"voodooPoppetProtectionLightning", (Item)Items.field_151055_y);
        OreDictionary.registerOre((String)"voodooPoppetProtectionFall", (Item)Items.field_151008_G);
        OreDictionary.registerOre((String)"voodooPoppetProtectionDarkness", (Item)Items.field_151073_bk);
    }

    @Nullable
    public static EntityPlayer getPlayer(InventoryCrafting inventory) {
        return inventory.field_70465_c.field_75151_b.stream().map(slot -> slot.field_75224_c).filter(InventoryPlayer.class::isInstance).map(InventoryPlayer.class::cast).map(inv -> inv.field_70458_d).findFirst().orElse(null);
    }

    public static void spawnRandomMob(WorldServer world, BlockPos pos) {
        EntityZombie mob;
        Location spawnPos = new SpawnHelper(world, new BlockPos(pos.func_177958_n() + Helper.getRandom(-9, 9), pos.func_177956_o(), pos.func_177952_p() + Helper.getRandom(-9, 9))).findSafePlace(2, true, true);
        if (spawnPos.isOrigin()) {
            return;
        }
        try {
            mob = new EntityZombie((World)world);
            mob.func_82227_f(true);
            if (TimeHelper.isDateAroundHalloween()) {
                mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(Blocks.field_150423_aK));
            }
            mob.func_180482_a(world.func_175649_E(new BlockPos((Entity)mob)), null);
            mob.func_70012_b((double)spawnPos.x, (double)spawnPos.y, (double)spawnPos.z, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        world.func_72838_d((Entity)mob);
        mob.func_175449_a(pos, 15);
    }

    @Nullable
    public static MinecraftServer getServer() {
        try {
            return FMLCommonHandler.instance().getMinecraftServerInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static class CustomTeleporter
    implements ITeleporter {
        private final Vec3d destination;

        CustomTeleporter(double destX, double destY, double destZ) {
            this.destination = new Vec3d(destX, destY, destZ);
        }

        public void placeEntity(World world, Entity entity, float yaw) {
            entity.func_70012_b(this.destination.field_72450_a, this.destination.field_72448_b, this.destination.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            entity.field_70179_y = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70159_w = 0.0;
        }
    }
}

