/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemElytra;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.tombstone.compatibility.CompatibilityAetherLegacy;
import ovh.corail.tombstone.compatibility.CompatibilityBaubles;
import ovh.corail.tombstone.compatibility.CompatibilityGalactiCraft;
import ovh.corail.tombstone.compatibility.CompatibilityRPGInventory;
import ovh.corail.tombstone.compatibility.CompatibilitySmartBackpacks;
import ovh.corail.tombstone.compatibility.CompatibilityTechguns;
import ovh.corail.tombstone.compatibility.CompatibilityTheBetweenLands;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.PlayerPreference;

public class InventoryHelper {
    private static final IItemHandler EMPTY_ITEM_HANDLER = new ItemStackHandler(NonNullList.func_191196_a());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean autoequip(ItemStack stack, EntityPlayer player) {
        boolean bl;
        if (stack.func_190926_b()) return false;
        if (InventoryHelper.isPowerSuit(stack)) {
            return false;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_190941_k, (ItemStack)stack) > 0) {
            return false;
        }
        if (ConfigTombstone.compatibilities.allowTechgunsAutoEquip && SupportMods.TECHGUNS.isLoaded() && CompatibilityTechguns.instance.autoEquip(stack, player)) {
            return true;
        }
        if (stack.func_77976_d() != 1) return false;
        if (ConfigTombstone.compatibilities.allowBaublesAutoEquip && SupportMods.BAUBLES.isLoaded() && CompatibilityBaubles.instance.autoEquip(stack, player)) {
            return true;
        }
        if (ConfigTombstone.compatibilities.allowGalacticrafAutoEquip && SupportMods.GALACTICRAFT.isLoaded() && CompatibilityGalactiCraft.instance.autoEquip(stack, player)) {
            return true;
        }
        if (ConfigTombstone.compatibilities.allowRPGInventoryAutoEquip && SupportMods.RPG_INVENTORY.isLoaded() && CompatibilityRPGInventory.instance.autoEquip(stack, player)) {
            return true;
        }
        if (ConfigTombstone.compatibilities.allowAetherLegacyAutoEquip && SupportMods.AETHER_LEGACY.isLoaded() && CompatibilityAetherLegacy.instance.autoEquip(stack, player)) {
            return true;
        }
        if (ConfigTombstone.compatibilities.allowTheBetweenLandsAutoEquip && SupportMods.THE_BETWEENLANDS.isLoaded() && CompatibilityTheBetweenLands.instance.autoEquip(stack, player)) {
            return true;
        }
        if (ConfigTombstone.compatibilities.allowSmartBackpacksAutoEquip && SupportMods.SMART_BACKPACKS.isLoaded() && CompatibilitySmartBackpacks.instance.autoEquip(stack, player)) {
            return true;
        }
        if (player.func_184592_cb().func_190926_b()) {
            if (InventoryHelper.isBattleSign(stack) && player.func_174820_d(99, stack.func_77946_l())) {
                return true;
            }
            if (stack.func_77973_b().isShield(stack, (EntityLivingBase)player) && player.func_174820_d(99, stack.func_77946_l())) {
                return true;
            }
        }
        EntityEquipmentSlot slot = stack.func_77973_b().getEquipmentSlot(stack);
        boolean isElytra = false;
        if (slot == null) {
            if (stack.func_77973_b() instanceof ItemArmor) {
                slot = ((ItemArmor)stack.func_77973_b()).field_77881_a;
            } else {
                if (!(stack.func_77973_b() instanceof ItemElytra)) return false;
                slot = EntityEquipmentSlot.CHEST;
                isElytra = true;
            }
        } else if (slot == EntityEquipmentSlot.CHEST) {
            isElytra = InventoryHelper.isElytra(stack);
        }
        int slotId = slot.func_188454_b();
        ItemStack stackInSlot = (ItemStack)player.field_71071_by.field_70460_b.get(slotId);
        if (stackInSlot.func_190926_b()) {
            player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
            return true;
        }
        if (slot != EntityEquipmentSlot.CHEST) {
            return false;
        }
        boolean equipElytraInPriority = PlayerPreference.get(player.func_110124_au()).equipElytraInPriority();
        if (InventoryHelper.isElytra(stackInSlot)) {
            if (isElytra) return false;
            if (equipElytraInPriority) return false;
            bl = true;
        } else {
            if (!isElytra) return false;
            if (!equipElytraInPriority) return false;
            bl = true;
        }
        boolean canEquip = bl;
        if (!canEquip) return false;
        ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackInSlot.func_77946_l());
        player.field_71071_by.field_70460_b.set(slotId, (Object)stack.func_77946_l());
        return true;
    }

    public static ItemStack findItemInMainInventory(EntityPlayer player, Predicate<ItemStack> predic) {
        return player.field_71071_by.field_70462_a.stream().filter(predic).findFirst().orElse(ItemStack.field_190927_a);
    }

    private static boolean isElytra(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemElytra || InventoryHelper.isWing(stack);
    }

    private static boolean isWing(ItemStack stack) {
        return SupportMods.WINGS.isLoaded() && Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(rl -> SupportMods.WINGS.func_176610_l().equals(rl.func_110624_b()) && rl.func_110623_a().endsWith("_wings")).orElse(false) != false;
    }

    public static boolean isTool(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77976_d() == 1 && (stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemFishingRod || stack.func_77973_b() instanceof ItemShears);
    }

    private static boolean isPowerSuit(ItemStack stack) {
        return SupportMods.POWERSUITS.isLoaded() && Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(rl -> "powersuits".equals(rl.func_110624_b())).orElse(false) != false;
    }

    private static boolean isBattleSign(ItemStack stack) {
        return SupportMods.TCONSTRUCT.isLoaded() && Optional.ofNullable(stack.func_77973_b().getRegistryName()).map(rl -> "tconstruct".equals(rl.func_110624_b()) && "battlesign".equals(rl.func_110623_a())).orElse(false) != false;
    }

    public static IItemHandler getItemHandler(Entity entity) {
        return (IItemHandler)Optional.ofNullable(entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).orElse(EMPTY_ITEM_HANDLER);
    }

    public static ItemStack findFirstInInventory(@Nullable EntityPlayer player, Item item) {
        return InventoryHelper.findFirstInInventory(player, (ItemStack stack) -> stack.func_77973_b() == item);
    }

    public static ItemStack findFirstInInventory(@Nullable EntityPlayer player, Predicate<ItemStack> predic) {
        if (player != null) {
            IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
            return IntStream.range(0, itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)).filter(predic).findFirst().orElse(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean removeFirstInInventory(EntityPlayer player, Predicate<ItemStack> predic) {
        IItemHandler itemHandler = InventoryHelper.getItemHandler((Entity)player);
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (!predic.test(stack)) continue;
            itemHandler.extractItem(i, 1, false);
            return true;
        }
        return false;
    }

    public static boolean hasEnoughSlots(IItemHandler itemHandler, int count) {
        int found = 0;
        for (int i = 0; i < itemHandler.getSlots() && count > found; ++i) {
            if (!itemHandler.getStackInSlot(i).func_190926_b()) continue;
            ++found;
        }
        return count <= found;
    }
}

