/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.loot.DelayedNBTFunction;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

@Mod.EventBusSubscriber(modid="tombstone")
public class LootHelper {
    private static final Field fieldPools = ObfuscationReflectionHelper.findField(LootTable.class, (String)"field_186466_c");

    private static void addEntry(List<LootEntry> entries, Item item, int weight) {
        LootHelper.addEntry(entries, item, weight, null);
    }

    private static void addEntry(List<LootEntry> entries, Item item, int weight, @Nullable Consumer<NBTTagCompound> consumer) {
        ArrayList<SetNBT> functions = new ArrayList<SetNBT>();
        if (consumer != null) {
            NBTTagCompound tag = new NBTTagCompound();
            consumer.accept(tag);
            functions.add(new SetNBT(new LootCondition[0], tag));
        }
        entries.add((LootEntry)new LootEntryItem(item, weight, 0, functions.toArray(new LootFunction[0]), new LootCondition[0], Objects.requireNonNull(item.getRegistryName()) + "_loot"));
    }

    private static void addEntryWithMeta(List<LootEntry> entries, Item item, int meta, int weight) {
        LootHelper.addEntryWithMeta(entries, item, meta, weight, null);
    }

    private static void addEntryWithMeta(List<LootEntry> entries, Item item, int meta, int weight, @Nullable Consumer<NBTTagCompound> consumer) {
        ArrayList<Object> functions = new ArrayList<Object>();
        if (consumer != null) {
            NBTTagCompound tag = new NBTTagCompound();
            consumer.accept(tag);
            functions.add(new SetNBT(new LootCondition[0], tag));
        }
        functions.add(new SetMetadata(new LootCondition[0], new RandomValueRange((float)meta)));
        entries.add((LootEntry)new LootEntryItem(item, weight, 0, functions.toArray(new LootFunction[0]), new LootCondition[0], Objects.requireNonNull(item.getRegistryName()) + "_loot"));
    }

    private static void addEnchantedEntryWithMeta(List<LootEntry> entries, Item item, int meta, int weight) {
        LootHelper.addEntryWithMeta(entries, item, meta, weight, nbt -> nbt.func_74757_a("enchant", true));
    }

    private static void addEnchantedEntry(List<LootEntry> entries, Item item, int weight) {
        LootHelper.addEntry(entries, item, weight, nbt -> nbt.func_74757_a("enchant", true));
    }

    private static void addAncientTablet(List<LootEntry> entries, ItemTablet item, int weight) {
        LootHelper.addEntry(entries, item, weight, nbt -> nbt.func_74757_a("ancient", true));
    }

    private static void addDelayedNBTEntry(List<LootEntry> entries, Item item, int weight) {
        ArrayList<DelayedNBTFunction> functions = new ArrayList<DelayedNBTFunction>();
        functions.add(new DelayedNBTFunction(new LootCondition[0]));
        entries.add((LootEntry)new LootEntryItem(item, weight, 0, functions.toArray(new LootFunction[0]), new LootCondition[0], Objects.requireNonNull(item.getRegistryName()) + "_loot"));
    }

    public static void addLostEntries(LootTable table) {
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>();
        int weight = 0;
        LootHelper.addEntryWithMeta(entries, ModItems.crafting_ingredient, ItemCraftingIngredient.IngredientType.ESSENCE_OF_UNDEATH.ordinal(), 20);
        weight += 20;
        if (ModItems.tablet_of_recall.isEnabled()) {
            LootHelper.addAncientTablet(entries, ModItems.tablet_of_recall, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addAncientTablet(entries, ModItems.tablet_of_home, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addAncientTablet(entries, ModItems.tablet_of_cupidity, 3);
            weight += 3;
        }
        if (ModItems.tablet_of_assistance.isEnabled()) {
            LootHelper.addAncientTablet(entries, ModItems.tablet_of_assistance, 3);
            weight += 3;
        }
        if (ModItems.voodoo_poppet.isEnabled()) {
            LootHelper.addDelayedNBTEntry(entries, ModItems.voodoo_poppet, 10);
            weight += 10;
        }
        if (ModItems.familiar_receptacle.isEnabled()) {
            LootHelper.addDelayedNBTEntry(entries, ModItems.familiar_receptacle, 10);
            weight += 10;
        }
        LootHelper.addDelayedNBTEntry(entries, (Item)ModItems.fishing_rod_of_misadventure, 20);
        weight += 20;
        int lostTabletChance = ConfigTombstone.loot.getChanceLootLostTablet();
        if (ModItems.lost_tablet.isEnabled() && lostTabletChance > 0) {
            entries.add((LootEntry)new LootEntryItem((Item)ModItems.lost_tablet, lostTabletChance, 0, new LootFunction[0], new LootCondition[0], Objects.requireNonNull(ModItems.lost_tablet.getRegistryName()) + "_loot"));
            weight += lostTabletChance;
        }
        if (weight > 0) {
            if (weight < 1000) {
                entries.add((LootEntry)new LootEntryEmpty(1000 - weight, 0, new LootCondition[0], "tombstone:empty"));
            }
            LootPool pool = new LootPool(entries.toArray(new LootEntry[0]), new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "tombstone:lost_treasure");
            LootHelper.addPool(pool, table);
        }
    }

    private static void addPool(LootPool pool, LootTable table) {
        try {
            List pools = (List)fieldPools.get(table);
            pools.removeIf(aPool -> aPool == pool || pool.getName().equals(aPool.getName()));
            pools.add(pool);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void addChestEntries(LootTable table) {
        ArrayList<LootEntry> entries = new ArrayList<LootEntry>();
        int weight = 0;
        LootHelper.addEntryWithMeta(entries, ModItems.crafting_ingredient, ItemCraftingIngredient.IngredientType.ESSENCE_OF_UNDEATH.ordinal(), 3);
        weight += 3;
        for (ItemScrollBuff.SpellBuff spellBuff : ItemScrollBuff.SpellBuff.values()) {
            if (!spellBuff.isEnable()) continue;
            LootHelper.addEnchantedEntryWithMeta(entries, ModItems.scroll_buff, spellBuff.ordinal(), 10);
            weight += 10;
        }
        if (ModItems.scroll_of_knowledge.isEnabled()) {
            LootHelper.addDelayedNBTEntry(entries, ModItems.scroll_of_knowledge, 10);
            weight += 10;
        }
        if (ModItems.tablet_of_cupidity.isEnabled()) {
            LootHelper.addEnchantedEntry(entries, ModItems.tablet_of_cupidity, 10);
            weight += 10;
        }
        if (ModItems.tablet_of_home.isEnabled()) {
            LootHelper.addEnchantedEntry(entries, ModItems.tablet_of_home, 10);
            weight += 10;
        }
        if (ModItems.tablet_of_assistance.isEnabled()) {
            LootHelper.addEnchantedEntry(entries, ModItems.tablet_of_assistance, 10);
            weight += 10;
        }
        if (ModItems.voodoo_poppet.isEnabled()) {
            LootHelper.addDelayedNBTEntry(entries, ModItems.voodoo_poppet, 10);
            weight += 10;
        }
        if (ModItems.familiar_receptacle.isEnabled()) {
            LootHelper.addDelayedNBTEntry(entries, ModItems.familiar_receptacle, 10);
            weight += 10;
        }
        LootHelper.addDelayedNBTEntry(entries, (Item)ModItems.fishing_rod_of_misadventure, 3);
        if ((weight += 3) > 0) {
            if (weight < 1000) {
                entries.add((LootEntry)new LootEntryEmpty(1000 - weight, 0, new LootCondition[0], "tombstone:empty"));
            }
            LootPool pool = new LootPool(entries.toArray(new LootEntry[0]), new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f), "tombstone:chest_treasure");
            LootHelper.addPool(pool, table);
        }
    }

    public static void handleMobDrops(List<EntityItem> drops, EntityLivingBase entity, EntityPlayerMP player) {
        Random rng = Helper.RANDOM;
        int boneCollectorLevel = EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.bone_collector);
        double chanceModifier = 1.0 + (double)boneCollectorLevel * 0.3;
        if (EntityHelper.isUndead(entity)) {
            boolean isBoss;
            if (ConfigTombstone.loot.chanceGraveDust > 0 && LootHelper.checkLoot(rng, (double)ConfigTombstone.loot.chanceGraveDust * chanceModifier)) {
                LootHelper.addDropToEntity(drops, entity, ItemCraftingIngredient.IngredientType.GRAVE_DUST.getStack(rng.nextInt(2) + 1));
                ModTriggers.GRAVE_DUST_FROM_UNDEAD.trigger(player);
            }
            if (LootHelper.checkLoot(rng, (double)((isBoss = EntityHelper.isBoss(entity)) ? 40 : 10) * chanceModifier)) {
                LootHelper.addDropToEntity(drops, entity, ItemCraftingIngredient.IngredientType.ESSENCE_OF_UNDEATH.getStack());
            }
            if (isBoss) {
                if (ConfigTombstone.loot.chanceSoulReceptacleOnBoss > 0 && LootHelper.checkLoot(rng, (double)ConfigTombstone.loot.chanceSoulReceptacleOnBoss * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, new ItemStack((Item)ModItems.soul_receptacle));
                }
                if (ConfigTombstone.loot.chanceRandomScrollOnBoss > 0 && LootHelper.checkLoot(rng, (double)ConfigTombstone.loot.chanceRandomScrollOnBoss * chanceModifier)) {
                    ItemScrollBuff.SpellBuff.getRandomEnchantedScroll().ifPresent(scroll -> LootHelper.addDropToEntity(drops, entity, scroll));
                }
                if (ModItems.voodoo_poppet.isEnabled() && ConfigTombstone.loot.chanceVoodooPoppetOnBoss > 0 && LootHelper.checkLoot(rng, (double)ConfigTombstone.loot.chanceVoodooPoppetOnBoss * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, ModItems.voodoo_poppet.createWithRandomProtections(Helper.RANDOM.nextInt(5) + 1));
                }
                if (ModItems.familiar_receptacle.isEnabled() && ConfigTombstone.loot.chanceFamiliarReceptacleOnBoss > 0 && LootHelper.checkLoot(rng, (double)ConfigTombstone.loot.chanceFamiliarReceptacleOnBoss * chanceModifier)) {
                    LootHelper.addDropToEntity(drops, entity, ModItems.familiar_receptacle.createWithRandomFamiliar());
                }
            }
        }
        if (TimeHelper.isDateAroundHalloween() && entity instanceof IMob && LootHelper.checkLoot(rng, 100.0 * chanceModifier)) {
            LootHelper.addDropToEntity(drops, entity, new ItemStack(ModItems.lollipop, rng.nextInt(3) + 1));
        }
    }

    private static boolean checkLoot(Random rng, double chance) {
        return chance >= 1000.0 || (double)rng.nextInt(1000) < chance;
    }

    private static void addDropToEntity(List<EntityItem> drops, EntityLivingBase entity, ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().equals((Object)LootTableList.field_186388_am)) {
            LootHelper.addLostEntries(event.getTable());
        } else if (!event.getName().equals((Object)LootTableList.field_186420_b) && Optional.ofNullable(event.getName()).map(ResourceLocation::func_110623_a).filter(name -> name.startsWith("chests") && !name.startsWith("chests/village/") && !name.contains("supply")).isPresent()) {
            LootHelper.addChestEntries(event.getTable());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMobDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().field_70170_p.field_72995_K && !(event.getEntityLiving() instanceof EntityPlayer)) {
            Optional.ofNullable(event.getSource()).filter(d -> EntityHelper.isValidServerPlayer(d.func_76346_g())).map(d -> (EntityPlayerMP)d.func_76346_g()).ifPresent(player -> LootHelper.handleMobDrops(event.getDrops(), event.getEntityLiving(), player));
        }
    }
}

