/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.particle.ParticleMarker;
import ovh.corail.tombstone.registry.ModItems;

@SideOnly(value=Side.CLIENT)
public final class MarkerHandler {
    public static final MarkerHandler instance = new MarkerHandler();
    private boolean canRender;
    private Vec3d position;

    private MarkerHandler() {
    }

    public void update(Minecraft mc) {
        assert (mc.field_71439_g != null && mc.field_71441_e != null);
        ItemStack stack = mc.field_71439_g.func_184614_ca();
        this.canRender = ConfigTombstone.client.highlight && ConfigTombstone.client.markerType == ConfigTombstone.CatClient.MarkerType.BOX || TimeHelper.atInterval(TimeHelper.worldTicks(mc.field_71439_g.field_70170_p), 5);
        this.position = null;
        if (this.canRender) {
            Location loc = stack.func_77973_b() == ModItems.grave_key ? ModItems.grave_key.getTombPos(stack) : (stack.func_77973_b() == ModItems.tablet_of_recall ? ModItems.tablet_of_recall.getTombPos(stack) : (ModItems.lost_tablet.isWakeUp(stack) ? ModItems.lost_tablet.getLocation(stack) : Location.ORIGIN));
            if (!loc.isOrigin() && loc.isSameDimension(mc.field_71439_g.field_70170_p)) {
                BlockPos pos = loc.getPos();
                this.position = new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            } else {
                this.canRender = false;
            }
        }
    }

    public void render(Minecraft mc) {
        assert (mc.field_71439_g != null && mc.field_71441_e != null);
        if (this.canRender) {
            float[] colors = Helper.getHSBtoRGBF((float)(TimeHelper.systemTime() / 15L % 360L) / 360.0f, 1.0f, 1.0f);
            if (ConfigTombstone.client.markerType == ConfigTombstone.CatClient.MarkerType.BOX) {
                MarkerHandler.createBox(mc, this.position.field_72450_a, this.position.field_72448_b, this.position.field_72449_c, colors);
            } else {
                boolean isFarAway;
                Vec3d vec = new Vec3d(this.position.field_72450_a + 0.5, this.position.field_72448_b + 0.8, this.position.field_72449_c + 0.5);
                Vec3d vecCameraToLocation = vec.func_178786_a(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n);
                boolean bl = isFarAway = vecCameraToLocation.func_72433_c() > 10.0;
                if (isFarAway) {
                    vec = new Vec3d(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n).func_178787_e(vecCameraToLocation.func_72432_b().func_186678_a(10.0));
                }
                MarkerHandler.spawnParticle(mc, vec, isFarAway ? 1.0f : 0.5f, colors);
                this.canRender = false;
            }
        }
    }

    private static void spawnParticle(Minecraft mc, Vec3d vec3, float scale, float[] colors) {
        double horizontalOffset = 0.25;
        assert (mc.field_71441_e != null);
        double yOffset = (Helper.RANDOM.nextDouble() - 0.5) * 2.0;
        ParticleMarker particle = new ParticleMarker((World)mc.field_71441_e, vec3.field_72450_a + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, vec3.field_72448_b + yOffset * 0.5, vec3.field_72449_c + (Helper.RANDOM.nextDouble() - 0.5) * 2.0 * horizontalOffset, 0.0, (double)(yOffset < 0.5 ? -1 : 1) * Helper.RANDOM.nextDouble() * 0.01, 0.0, scale, colors);
        mc.field_71452_i.func_78873_a((Particle)particle);
    }

    private static void createBox(Minecraft mc, double x, double y, double z, float[] colors) {
        double offset = 1.0;
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_179097_i();
        Vec3d location = new Vec3d(x, y, z).func_178786_a(mc.func_175598_ae().field_78730_l, mc.func_175598_ae().field_78731_m, mc.func_175598_ae().field_78728_n);
        if (location.func_72438_d(Vec3d.field_186680_a) > 200.0) {
            location = location.func_72432_b().func_186678_a(200.0);
        }
        x = location.field_72450_a;
        y = location.field_72448_b;
        z = location.field_72449_c;
        RenderGlobal.func_189694_a((double)x, (double)y, (double)z, (double)(x + offset), (double)(y + offset), (double)(z + offset), (float)colors[0], (float)colors[1], (float)colors[2], (float)1.0f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

