/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import ovh.corail.tombstone.helper.Location;

public class NBTStackHelper {
    private static boolean checkCompound(ItemStack stack, boolean addCompound) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (addCompound && !stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77942_o();
    }

    public static NBTTagCompound getOrCreateTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        return tag;
    }

    private static boolean checkCompound(ItemStack stack) {
        return NBTStackHelper.checkCompound(stack, false);
    }

    private static NBTTagCompound getCompound(ItemStack stack) {
        return Objects.requireNonNull(stack.func_77978_p());
    }

    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74778_a(keyName, keyValue);
        }
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74779_i(keyName);
        }
        return "";
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74757_a(keyName, keyValue);
        }
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74767_n(keyName);
        }
        return false;
    }

    public static ItemStack setShort(ItemStack stack, String keyName, short keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74777_a(keyName, keyValue);
        }
        return stack;
    }

    public static short getShort(ItemStack stack, String keyName) {
        return NBTStackHelper.getShort(stack, keyName, (short)Short.MIN_VALUE);
    }

    public static short getShort(ItemStack stack, String keyName, short fallback) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74765_d(keyName);
        }
        return fallback;
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74768_a(keyName, keyValue);
        }
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74762_e(keyName);
        }
        return Integer.MIN_VALUE;
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        if (NBTStackHelper.checkCompound(stack, true)) {
            NBTStackHelper.getCompound(stack).func_74772_a(keyName, keyValue);
        }
        return stack;
    }

    @Deprecated
    public static long getLong(ItemStack stack, String keyName) {
        return NBTStackHelper.getLong(stack, keyName, Long.MIN_VALUE);
    }

    public static long getLong(ItemStack stack, String keyName, long fallback) {
        NBTTagCompound compound;
        if (NBTStackHelper.checkCompound(stack) && (compound = NBTStackHelper.getCompound(stack)).func_74764_b(keyName)) {
            return compound.func_74763_f(keyName);
        }
        return fallback;
    }

    public static ItemStack setBlockPos(ItemStack stack, String keyName, BlockPos keyValue) {
        NBTStackHelper.setBlockPos(NBTStackHelper.getOrCreateTag(stack), keyName, keyValue);
        return stack;
    }

    public static void setBlockPos(NBTTagCompound tag, String keyName, BlockPos keyValue) {
        tag.func_74768_a(keyName + "X", keyValue.func_177958_n());
        tag.func_74768_a(keyName + "Y", keyValue.func_177956_o());
        tag.func_74768_a(keyName + "Z", keyValue.func_177952_p());
    }

    public static BlockPos getBlockPos(ItemStack stack, String keyName) {
        return NBTStackHelper.getBlockPos(NBTStackHelper.getOrCreateTag(stack), keyName);
    }

    public static BlockPos getBlockPos(@Nullable NBTTagCompound tag, String keyName) {
        if (tag != null && tag.func_150297_b(keyName + "X", 3) && tag.func_150297_b(keyName + "Y", 3) && tag.func_150297_b(keyName + "Z", 3)) {
            return new BlockPos(tag.func_74762_e(keyName + "X"), tag.func_74762_e(keyName + "Y"), tag.func_74762_e(keyName + "Z"));
        }
        return Location.ORIGIN_POS;
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, Location location) {
        NBTStackHelper.setLocation(NBTStackHelper.getOrCreateTag(stack), keyName, location);
        return stack;
    }

    public static NBTTagCompound setLocation(NBTTagCompound tag, String keyName, Location location) {
        NBTStackHelper.setBlockPos(tag, keyName, location.getPos());
        tag.func_74768_a(keyName + "D", location.dim);
        return tag;
    }

    public static Location getLocation(ItemStack stack, String keyName) {
        return NBTStackHelper.getLocation(NBTStackHelper.getOrCreateTag(stack), keyName);
    }

    public static Location getLocation(@Nullable NBTTagCompound tag, String keyName) {
        BlockPos pos;
        if (tag != null && tag.func_74764_b(keyName + "D") && !(pos = NBTStackHelper.getBlockPos(tag, keyName)).equals((Object)Location.ORIGIN_POS)) {
            return new Location(pos, tag.func_74762_e(keyName + "D"));
        }
        return Location.ORIGIN;
    }

    public static List<PotionEffect> getEffectList(NBTTagCompound tag, String keyName, Predicate<Potion> predic) {
        ArrayList<PotionEffect> effectInstances = new ArrayList<PotionEffect>();
        if (tag.func_150297_b(keyName, 9)) {
            NBTTagList effectList = tag.func_150295_c(keyName, 10);
            for (int i = 0; i < effectList.func_74745_c(); ++i) {
                PotionEffect effectInstance = NBTStackHelper.getEffect(effectList.func_150305_b(i), predic);
                if (effectInstance == null) continue;
                effectInstances.add(effectInstance);
            }
        }
        return effectInstances;
    }

    public static void setEffectlist(NBTTagCompound tag, String keyName, Stream<PotionEffect> effectInstances) {
        NBTTagList effectList = new NBTTagList();
        effectInstances.forEach(effectInstance -> effectList.func_74742_a((NBTBase)NBTStackHelper.setEffect(new NBTTagCompound(), effectInstance)));
        tag.func_74782_a(keyName, (NBTBase)effectList);
    }

    public static NBTTagCompound setEffect(NBTTagCompound tag, PotionEffect effectInstance) {
        effectInstance.func_82719_a(tag);
        return tag;
    }

    @Nullable
    public static PotionEffect getEffect(NBTTagCompound tag, Predicate<Potion> predic) {
        PotionEffect effectInstance;
        if (tag.func_150297_b("Id", 1) && (effectInstance = PotionEffect.func_82722_b((NBTTagCompound)tag)) != null && predic.test(effectInstance.func_188419_a())) {
            return effectInstance;
        }
        return null;
    }

    public static int getTimer(long actualTime, ItemStack stack, String keyName, int limit) {
        long endTime = NBTStackHelper.getLong(stack, keyName, 0L);
        if (endTime > 0L) {
            long leftTime = endTime - actualTime;
            if (leftTime > 0L) {
                if (leftTime > (long)limit) {
                    NBTStackHelper.setLong(stack, keyName, actualTime + (long)limit);
                    leftTime = limit;
                }
                return (int)leftTime;
            }
            NBTStackHelper.removeKeyName(stack, keyName);
        }
        return 0;
    }

    public static boolean hasTimer(long actualTime, ItemStack stack, String keyName, int limit) {
        return NBTStackHelper.getTimer(actualTime, stack, keyName, limit) > 0;
    }

    public static boolean removeLocation(ItemStack stack, String keyName) {
        return Stream.of("X", "Y", "Z", "D").filter(k -> NBTStackHelper.removeKeyName(stack, keyName + k)).count() == 4L;
    }

    public static boolean removeKeyName(ItemStack stack, String keyName) {
        if (NBTStackHelper.hasKeyName(stack, keyName)) {
            NBTStackHelper.getCompound(stack).func_82580_o(keyName);
            return true;
        }
        return false;
    }

    public static boolean hasKeyName(ItemStack stack, String keyName) {
        return NBTStackHelper.checkCompound(stack) && NBTStackHelper.getCompound(stack).func_74764_b(keyName);
    }

    public static NBTTagList getListOrCreate(NBTTagCompound tag, String keyName) {
        if (tag.func_150297_b(keyName, 9)) {
            return tag.func_150295_c(keyName, 10);
        }
        NBTTagList list = new NBTTagList();
        tag.func_74782_a(keyName, (NBTBase)list);
        return list;
    }

    public static Optional<NBTTagList> getListOrEmpty(ItemStack stack, String keyName) {
        return Optional.ofNullable(stack.func_77978_p()).flatMap(tag -> NBTStackHelper.getListOrEmpty(tag, keyName));
    }

    public static Optional<NBTTagList> getListOrEmpty(NBTTagCompound tag, String keyName) {
        return Optional.of(tag).filter(t -> t.func_150297_b(keyName, 9)).map(t -> t.func_150295_c(keyName, 10));
    }
}

