/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;

public class PlayerPreference {
    private static final Map<UUID, PlayerPreference> PLAYER_PREFERENCES = new HashMap<UUID, PlayerPreference>();
    private static final PlayerPreference DEFAULT_PREFERENCE = new PlayerPreference(GraveModel.getDefault(), BlockGraveMarble.MarbleType.getDefault(), ConfigTombstone.CatClient.GraveSpawnRule.getDefault(), ConfigTombstone.CatClient.AutoEquipRule.getDefault(), false, true, false, true, false);
    private GraveModel graveModel;
    private BlockGraveMarble.MarbleType marbleType;
    private ConfigTombstone.CatClient.GraveSpawnRule graveSpawnRule;
    private ConfigTombstone.CatClient.AutoEquipRule autoEquipRule;
    private boolean equipElytraInPriority;
    private boolean knowledgeMessage;
    private boolean priorizeToolOnHotbar;
    private boolean activateGraveBySneaking;
    private boolean denyGraveOnDeath;

    private PlayerPreference(GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, ConfigTombstone.CatClient.GraveSpawnRule graveSpawnRule, ConfigTombstone.CatClient.AutoEquipRule autoEquipRule, boolean equipElytraInPriority, boolean knowledgeMessage, boolean priorizeToolOnHotbar, boolean activateGraveBySneaking, boolean denyGraveOnDeath) {
        this.graveModel = graveModel;
        this.marbleType = marbleType;
        this.graveSpawnRule = graveSpawnRule;
        this.autoEquipRule = autoEquipRule;
        this.equipElytraInPriority = equipElytraInPriority;
        this.knowledgeMessage = knowledgeMessage;
        this.priorizeToolOnHotbar = priorizeToolOnHotbar;
        this.activateGraveBySneaking = activateGraveBySneaking;
        this.denyGraveOnDeath = denyGraveOnDeath;
    }

    public GraveModel getFavoriteGrave() {
        return this.graveModel;
    }

    public BlockGraveMarble.MarbleType getMarbleType() {
        return this.marbleType;
    }

    public boolean hasSameFavoriteGrave(PlayerPreference aPlayerPreference) {
        return this.hasSameFavoriteGrave(aPlayerPreference.getFavoriteGrave(), aPlayerPreference.getMarbleType());
    }

    private boolean hasSameFavoriteGrave(GraveModel graveModel, BlockGraveMarble.MarbleType marbleType) {
        return this.getFavoriteGrave() == graveModel && this.getMarbleType() == marbleType;
    }

    public boolean equipElytraInPriority() {
        return this.equipElytraInPriority;
    }

    public boolean displayKnowledgeMessage() {
        return this.knowledgeMessage;
    }

    public boolean priorizeToolOnHotbar() {
        return this.priorizeToolOnHotbar;
    }

    public boolean activateGraveBySneaking() {
        return this.activateGraveBySneaking;
    }

    public boolean denyGraveOnDeath() {
        return this.denyGraveOnDeath;
    }

    public ConfigTombstone.CatClient.GraveSpawnRule getGraveSpawnRule() {
        return this.graveSpawnRule;
    }

    public ConfigTombstone.CatClient.AutoEquipRule getAutoEquipRule() {
        return this.autoEquipRule;
    }

    public static void set(EntityPlayerMP player, PlayerPreference playerPreference) {
        if (playerPreference.graveModel == null) {
            playerPreference.graveModel = GraveModel.getDefault();
        }
        if (playerPreference.marbleType == null) {
            playerPreference.marbleType = BlockGraveMarble.MarbleType.getDefault();
        }
        if (playerPreference.graveSpawnRule == null) {
            playerPreference.graveSpawnRule = ConfigTombstone.CatClient.GraveSpawnRule.getDefault();
        }
        if (playerPreference.autoEquipRule == null) {
            playerPreference.autoEquipRule = ConfigTombstone.CatClient.AutoEquipRule.getDefault();
        }
        PLAYER_PREFERENCES.put(player.func_110124_au(), playerPreference);
    }

    public static PlayerPreference get(EntityPlayer player) {
        return PLAYER_PREFERENCES.getOrDefault(player.func_110124_au(), DEFAULT_PREFERENCE);
    }

    public static PlayerPreference get(UUID id) {
        return PLAYER_PREFERENCES.getOrDefault(id, DEFAULT_PREFERENCE);
    }

    public static void clear() {
        PLAYER_PREFERENCES.clear();
    }

    public static void toBytes(PlayerPreference playerPreference, ByteBuf buf) {
        buf.writeByte(playerPreference.graveModel.ordinal());
        buf.writeByte(playerPreference.marbleType.ordinal());
        buf.writeByte(playerPreference.graveSpawnRule.ordinal());
        buf.writeByte(playerPreference.autoEquipRule.ordinal());
        buf.writeBoolean(playerPreference.equipElytraInPriority);
        buf.writeBoolean(playerPreference.knowledgeMessage);
        buf.writeBoolean(playerPreference.priorizeToolOnHotbar);
        buf.writeBoolean(playerPreference.activateGraveBySneaking);
        buf.writeBoolean(playerPreference.denyGraveOnDeath);
    }

    public static PlayerPreference fromBytes(ByteBuf buf) {
        return new PlayerPreference(GraveModel.byId(buf.readByte()), BlockGraveMarble.MarbleType.byId(buf.readByte()), ConfigTombstone.CatClient.GraveSpawnRule.byId(buf.readByte()), ConfigTombstone.CatClient.AutoEquipRule.byId(buf.readByte()), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
    }

    @SideOnly(value=Side.CLIENT)
    public static PlayerPreference fromClientConfig() {
        return new PlayerPreference(ConfigTombstone.client.favoriteGrave, ConfigTombstone.client.favoriteGraveMarble, ConfigTombstone.client.graveSpawnRule, ConfigTombstone.client.autoEquipRule, ConfigTombstone.client.equipElytraInPriority, ConfigTombstone.client.displayKnowledgeMessage, ConfigTombstone.client.priorizeToolOnHotbar, ConfigTombstone.client.activateGraveBySneaking, ConfigTombstone.client.denyGraveOnDeath);
    }

    public boolean hasChangedFromConfig() {
        return !this.hasSameFavoriteGrave(ConfigTombstone.client.favoriteGrave, ConfigTombstone.client.favoriteGraveMarble) || this.graveSpawnRule != ConfigTombstone.client.graveSpawnRule || this.autoEquipRule != ConfigTombstone.client.autoEquipRule || this.equipElytraInPriority != ConfigTombstone.client.equipElytraInPriority || this.knowledgeMessage != ConfigTombstone.client.displayKnowledgeMessage || this.priorizeToolOnHotbar != ConfigTombstone.client.priorizeToolOnHotbar || this.activateGraveBySneaking != ConfigTombstone.client.activateGraveBySneaking || this.denyGraveOnDeath != ConfigTombstone.client.denyGraveOnDeath;
    }
}

