/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import ovh.corail.tombstone.api.capability.ModPerks;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;

public class PlayerStatusHandler {
    private static final Map<UUID, PlayerStatus> PLAYER_STATUS = new ConcurrentHashMap<UUID, PlayerStatus>();

    public static Optional<PlayerStatus> getPlayerStatus(@Nullable Entity entity) {
        return Optional.ofNullable(entity).filter(EntityHelper::isValidServerPlayer).map(EntityPlayerMP.class::cast).map(player -> PLAYER_STATUS.computeIfAbsent(player.func_110124_au(), uuid -> PlayerStatusHandler.createStatus(player)));
    }

    private static PlayerStatus createStatus(EntityPlayerMP player) {
        int lvl;
        double modifierHighPriority = 1.0;
        if (!player.func_184218_aH() && (lvl = EntityHelper.getShadowStepLevel((EntityPlayer)player)) > 0) {
            modifierHighPriority = MathHelper.func_151237_a((double)((double)player.func_70013_c() - (double)lvl * 0.1), (double)0.01, (double)1.0);
        }
        if ((lvl = EntityHelper.getPerkLevelWithBonus((EntityPlayer)player, ModPerks.shadow_walker)) > 0) {
            modifierHighPriority *= 1.0 - (double)lvl * 0.1;
        }
        double modifierLowPriority = 1.0;
        if (EffectHelper.isPotionActive((EntityLivingBase)player, ModEffects.diversion) || EffectHelper.isPotionActive((EntityLivingBase)player, ModEffects.ghostly_shape)) {
            modifierLowPriority = 0.0;
        } else {
            PotionEffect bait = player.func_70660_b(ModEffects.bait);
            if (bait != null) {
                modifierLowPriority *= Math.min((double)bait.func_76458_c() + 1.0, 2.0);
            }
        }
        return new PlayerStatus(modifierHighPriority, modifierLowPriority);
    }

    public static void clear() {
        PLAYER_STATUS.clear();
    }

    public static class PlayerStatus {
        public final double visibleFactorHighPriority;
        public final double visibleFactorLowPriority;

        public PlayerStatus(double visibleFactorHighPriority, double visibleFactorLowPriority) {
            this.visibleFactorHighPriority = visibleFactorHighPriority;
            this.visibleFactorLowPriority = visibleFactorLowPriority;
        }
    }
}

