/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SoundHandler {
    private static final Map<String, SoundEvent> sounds = new ConcurrentHashMap<String, SoundEvent>();

    private SoundHandler() {
    }

    public static void registerSounds() {
        SoundHandler.registerSound("magic_use01");
        SoundHandler.registerSound("ghost_laugh");
        SoundHandler.registerSound("ghost_howl");
    }

    private static void registerSound(String soundName) {
        ResourceLocation rl = new ResourceLocation("tombstone", soundName);
        SoundEvent currentSound = (SoundEvent)new SoundEvent(rl).setRegistryName(rl);
        ForgeRegistries.SOUND_EVENTS.register((IForgeRegistryEntry)currentSound);
        sounds.put(soundName, currentSound);
    }

    public static SoundEvent getSound(String soundName) {
        SoundEvent currentSound = sounds.get(soundName);
        if (currentSound != null) {
            return currentSound;
        }
        return (SoundEvent)Optional.ofNullable(SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("minecraft", soundName))).orElse(SoundEvents.field_187682_dG);
    }

    public static void playSoundAllAround(String soundName, World world, BlockPos currentPos) {
        if (!world.field_72995_K) {
            world.func_184133_a(null, currentPos, SoundHandler.getSound(soundName), soundName.equals("magic_use01") ? SoundCategory.PLAYERS : SoundCategory.VOICE, 1.0f, 1.0f);
        }
    }
}

