/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.world.biome.Biome;
import ovh.corail.tombstone.helper.Helper;

public enum SupportStructures {
    Village("Village"),
    Desert_Temple("Temple", b -> b.field_76752_A.func_185904_a() == Material.field_151595_p),
    Igloo_Temple("Temple", b -> b.field_76752_A.func_185904_a() == Material.field_151597_y),
    Jungle_Temple("Temple", b -> b.field_76752_A.func_185904_a() != Material.field_151595_p && b.field_76752_A.func_185904_a() == Material.field_151597_y),
    Mansion("Mansion"),
    Monument("Monument"),
    Stronghold("Stronghold", 35),
    EndCity("EndCity"),
    Mineshaft("Mineshaft", 37),
    Fortress("Fortress", 35);

    public static final int DEFAULT_Y = 68;
    private final String structureName;
    private final int y;
    private final Predicate<Biome> predic;

    private SupportStructures(String structureName) {
        this(structureName, 68);
    }

    private SupportStructures(String structureName, int y) {
        this(structureName, y, b -> true);
    }

    private SupportStructures(String structureName, Predicate<Biome> predic) {
        this(structureName, 68, predic);
    }

    private SupportStructures(String structureName, int y, Predicate<Biome> predic) {
        this.structureName = structureName;
        this.y = y;
        this.predic = predic;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public int getY() {
        return this.y;
    }

    public boolean isValidBiome(Biome biome) {
        return this.predic.test(biome);
    }

    @Nullable
    public static SupportStructures getStructure(String name) {
        try {
            return SupportStructures.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public static SupportStructures getRandomStructure(Predicate<SupportStructures> predic) {
        List list = Stream.of(SupportStructures.values()).filter(predic).collect(Collectors.toList());
        return !list.isEmpty() ? (SupportStructures)((Object)list.get(Helper.getRandom(0, list.size() - 1))) : null;
    }
}

