/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AbstractChestHorse;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;

public enum TameableType {
    TAMEABLE(EntityTameable.class::isAssignableFrom, (player, entity) -> ((EntityTameable)entity).func_193101_c(player), entity -> ((EntityTameable)entity).func_184753_b(), (entity, tag) -> {}),
    HORSE(AbstractHorse.class::isAssignableFrom, (player, entity) -> ((AbstractHorse)entity).func_110263_g(player), entity -> ((AbstractHorse)entity).func_184780_dh(), (entity, tag) -> {
        if (entity instanceof AbstractChestHorse) {
            ((AbstractChestHorse)entity).func_110207_m(false);
        }
    });

    final Predicate<Class<? extends Entity>> predic;
    final BiConsumer<EntityPlayer, Entity> tame;
    final Function<Entity, UUID> ownerId;
    final BiConsumer<Entity, NBTTagCompound> onCapture;
    static final Map<String, TameableType> TAMEABLE_TYPE;

    private TameableType(Predicate<Class<? extends Entity>> predic, BiConsumer<EntityPlayer, Entity> tame, Function<Entity, UUID> ownerId, BiConsumer<Entity, NBTTagCompound> onCapture) {
        this.predic = predic;
        this.tame = tame;
        this.ownerId = ownerId;
        this.onCapture = onCapture;
    }

    public static void init() {
        if (!TAMEABLE_TYPE.isEmpty()) {
            return;
        }
        for (EntityEntry entityType : ForgeRegistries.ENTITIES) {
            String registryName = EntityHelper.getRegistryString(entityType);
            if (registryName.isEmpty()) continue;
            Class entityClass = entityType.getEntityClass();
            try {
                Arrays.stream(TameableType.values()).filter(t -> t.predic.test(entityClass)).findFirst().ifPresent(tameable -> TAMEABLE_TYPE.put(registryName, (TameableType)((Object)tameable)));
            }
            catch (Throwable throwable) {}
        }
    }

    public static void setTamedBy(EntityPlayer player, Entity entity) {
        Optional.ofNullable(TameableType.getType(entity)).ifPresent(t -> t.tame.accept(player, entity));
    }

    @Nullable
    public UUID getOwnerId(Entity entity) {
        return this.ownerId.apply(entity);
    }

    public void onCapture(Entity entity, NBTTagCompound tag) {
        this.onCapture.accept(entity, tag);
    }

    public static boolean isTameable(String entityTypeString) {
        return TameableType.getType(entityTypeString) != null;
    }

    @Nullable
    public static TameableType getType(@Nullable Entity entity) {
        return TameableType.getType(EntityHelper.getRegistryString(entity));
    }

    @Nullable
    public static TameableType getType(String entityTypeString) {
        return TAMEABLE_TYPE.get(entityTypeString);
    }

    public static String getRandomTameableEntityTypeString() {
        return Helper.getRandomInList(TAMEABLE_TYPE.keySet().stream().filter(type -> !Helper.containRL(ConfigTombstone.loot.unhandledTameableEntities, type)).collect(Collectors.toList())).orElse("minecraft:cat");
    }

    static {
        TAMEABLE_TYPE = new HashMap<String, TameableType>();
    }
}

