/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TimeHelper {
    public static long SERVER_START_TIME;
    private static SpecialEvent SPECIAL_EVENT;
    private static final String[] UNITY;

    public static void init() {
        SERVER_START_TIME = TimeHelper.systemTime();
        LocalDate date = LocalDate.now();
        if (date.get(ChronoField.MONTH_OF_YEAR) == 4 && date.get(ChronoField.DAY_OF_MONTH) == 1) {
            SPECIAL_EVENT = SpecialEvent.APRIL_FOOLS;
        } else if (date.get(ChronoField.MONTH_OF_YEAR) == 10 && date.get(ChronoField.DAY_OF_MONTH) >= 20 || date.get(ChronoField.MONTH_OF_YEAR) == 11 && date.get(ChronoField.DAY_OF_MONTH) <= 3) {
            SPECIAL_EVENT = SpecialEvent.HALLOWEEN;
        } else if (date.get(ChronoField.MONTH_OF_YEAR) == 12 && date.get(ChronoField.DAY_OF_MONTH) >= 6) {
            SPECIAL_EVENT = SpecialEvent.CHRISTMAS;
        }
    }

    public static long systemTime() {
        return System.currentTimeMillis();
    }

    public static SpecialEvent getSpecialEvent() {
        return SPECIAL_EVENT;
    }

    @SideOnly(value=Side.CLIENT)
    public static void setSpecialEvent(SpecialEvent event) {
        SPECIAL_EVENT = event;
    }

    public static boolean isAprilFoolsDay() {
        return SPECIAL_EVENT == SpecialEvent.APRIL_FOOLS;
    }

    public static boolean isDateAroundHalloween() {
        return SPECIAL_EVENT == SpecialEvent.HALLOWEEN;
    }

    public static boolean isDateAroundChristmas() {
        return SPECIAL_EVENT == SpecialEvent.CHRISTMAS;
    }

    public static long worldTicks(World world) {
        return world.func_82737_E();
    }

    public static int tickFromSecond(int second) {
        return second * 20;
    }

    public static int tickFromMinute(int minute) {
        return minute * 1200;
    }

    public static int tickFromHour(int hour) {
        return hour * 72000;
    }

    public static int tickFromDay(int day) {
        return day * 1728000;
    }

    public static boolean atInterval(World world, int tick) {
        return TimeHelper.atInterval(TimeHelper.worldTicks(world), tick);
    }

    public static boolean atInterval(Entity entity, int tick) {
        return TimeHelper.atInterval(entity.field_70173_aa, tick);
    }

    public static boolean atInterval(long ticksExisted, int tick) {
        return ticksExisted > 0L && ticksExisted % (long)tick == 0L;
    }

    public static boolean inIntervalBefore(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval < (long)intervalStart);
    }

    public static boolean inIntervalAfter(long ticksExisted, int tick, int intervalStart) {
        return TimeHelper.testInterval(ticksExisted, tick, interval -> interval > (long)intervalStart);
    }

    public static boolean testInterval(long ticksExisted, int tick, Predicate<Long> intervalPredic) {
        return ticksExisted > 0L && intervalPredic.test(ticksExisted % (long)tick);
    }

    public static long minuteElapsed(World world, long oldTime) {
        return TimeHelper.minuteElapsed(TimeHelper.worldTicks(world), oldTime);
    }

    public static long minuteElapsed(long nowTime, long oldTime) {
        return (nowTime - oldTime) / 1200L;
    }

    public static boolean isMinuteElapsed(World world, long oldTime, int minute) {
        return TimeHelper.isMinuteElapsed(TimeHelper.worldTicks(world), oldTime, minute);
    }

    public static boolean isMinuteElapsed(long nowTime, long oldTime, int minute) {
        return nowTime - oldTime >= (long)TimeHelper.tickFromMinute(minute);
    }

    public static String getTimeString(int cd) {
        return TimeHelper.getTimeString(cd, i -> ":", false);
    }

    public static String getTimeStringWithUnit(int cd) {
        return TimeHelper.getTimeString(cd, i -> UNITY[i], true);
    }

    private static String getTimeString(int cd, Function<Integer, String> separator, boolean separatorAtEnd) {
        int[] timeArray = TimeHelper.getTimeArray(cd);
        StringBuilder builder = new StringBuilder();
        int start = IntStream.range(0, timeArray.length).filter(i -> timeArray[i] > 0).findFirst().orElse(timeArray.length - 1);
        IntStream.range(start, timeArray.length - 1).forEach(unit -> {
            builder.append(String.format("%02d", timeArray[unit]));
            builder.append((String)separator.apply(unit));
        });
        builder.append(String.format("%02d", timeArray[timeArray.length - 1]));
        if (separatorAtEnd) {
            builder.append(separator.apply(timeArray.length - 1));
        }
        return builder.toString();
    }

    public static int[] getTimeArray(int cd) {
        int[] timeArray = new int[]{0, 0, 0, 0};
        if (cd >= 1728000) {
            timeArray[0] = cd / 1728000;
            cd -= timeArray[0] * 1728000;
        }
        if (cd >= 72000) {
            timeArray[1] = cd / 72000;
            cd -= timeArray[1] * 72000;
        }
        if (cd >= 1200) {
            timeArray[2] = cd / 1200;
            cd -= timeArray[2] * 1200;
        }
        if (cd >= 20) {
            timeArray[3] = cd / 20;
        }
        return timeArray;
    }

    public static float flicker(int age, int maxAge) {
        return MathHelper.func_76126_a((float)((float)Math.PI * ((float)age / (float)maxAge)));
    }

    public static float rise(int age, int maxAge) {
        return MathHelper.func_76126_a((float)(1.5707964f * ((float)age / (float)maxAge)));
    }

    public static float downfall(int age, int maxAge) {
        return MathHelper.func_76134_b((float)(1.5707964f * ((float)age / (float)maxAge)));
    }

    static {
        SPECIAL_EVENT = SpecialEvent.NONE;
        UNITY = new String[]{"d", "h", "m", "s"};
    }

    public static enum SpecialEvent {
        NONE,
        APRIL_FOOLS,
        HALLOWEEN,
        CHRISTMAS;


        public static SpecialEvent byId(int id) {
            if (id > 0 && id < SpecialEvent.values().length) {
                return SpecialEvent.values()[id];
            }
            return NONE;
        }
    }
}

