/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.Village;
import net.minecraft.village.VillageSiege;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;

public class VillageSiegeHandler {
    public static final VillageSiegeHandler instance = new VillageSiegeHandler();

    public static void sendDevLog(String message) {
        if (ConfigTombstone.village_siege.logSiegeState) {
            ModTombstone.LOGGER.info(message);
        }
    }

    private VillageSiegeHandler() {
    }

    public void checkWorld(WorldServer world) {
        if (ConfigTombstone.village_siege.handleVillageSiege && !(world.field_175740_d instanceof CustomVillageSiege)) {
            try {
                world.field_175740_d = new CustomVillageSiege(world);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static enum SiegeState {
        SIEGE_START,
        SIEGE_END,
        SPAWN_MOBS;

    }

    public class CustomVillageSiege
    extends VillageSiege {
        public final boolean isRejectedDim;
        public final WorldServer field_75537_a;
        public SiegeState field_75536_c;
        public boolean hasFailedTrySiege;
        public Village field_75531_f;
        public int field_75534_e;
        public int field_75533_d;
        public int field_75532_g;
        public int field_75538_h;
        public int field_75539_i;

        public CustomVillageSiege(WorldServer world) {
            super(null);
            this.field_75536_c = SiegeState.SIEGE_END;
            this.hasFailedTrySiege = false;
            this.field_75534_e = 0;
            this.field_75533_d = 0;
            this.field_75537_a = world;
            this.isRejectedDim = Stream.of(ConfigTombstone.village_siege.deniedDimensionTypeForSiege).anyMatch(p -> p.equals(world.field_73011_w.func_186058_p().func_186065_b()));
        }

        public boolean startSiege(int chance) {
            if (this.field_75536_c == SiegeState.SIEGE_START || this.field_75536_c == SiegeState.SPAWN_MOBS) {
                VillageSiegeHandler.sendDevLog("A siege is already in progress");
                return false;
            }
            VillageSiegeHandler.sendDevLog("Launching a village siege");
            if (Helper.getRandom(1, 100) <= chance) {
                this.field_75536_c = SiegeState.SIEGE_START;
                VillageSiegeHandler.sendDevLog("Random chance: Siege started");
            } else {
                this.field_75536_c = SiegeState.SIEGE_END;
                VillageSiegeHandler.sendDevLog("Random chance: Siege aborted");
            }
            this.hasFailedTrySiege = false;
            return this.field_75536_c == SiegeState.SIEGE_START;
        }

        public boolean stopSiege() {
            if (this.field_75536_c == SiegeState.SIEGE_END) {
                VillageSiegeHandler.sendDevLog("No siege in progress");
                return false;
            }
            this.field_75536_c = SiegeState.SIEGE_END;
            this.hasFailedTrySiege = false;
            return true;
        }

        public void func_75528_a() {
            if (this.isRejectedDim) {
                return;
            }
            if (this.field_75537_a.func_72935_r()) {
                this.field_75536_c = SiegeState.SIEGE_END;
                this.hasFailedTrySiege = false;
            } else {
                float angle = this.field_75537_a.func_72826_c(0.0f);
                if ((double)angle == 0.5) {
                    this.startSiege(ConfigTombstone.village_siege.siegeChance);
                }
                if (this.field_75536_c == SiegeState.SIEGE_END) {
                    return;
                }
                if (this.field_75536_c == SiegeState.SIEGE_START) {
                    if (ConfigTombstone.village_siege.delaySiegeTest > 0 && this.hasFailedTrySiege && !TimeHelper.atInterval(TimeHelper.worldTicks((World)this.field_75537_a), ConfigTombstone.village_siege.delaySiegeTest)) {
                        return;
                    }
                    if (!this.trySetupSiege()) {
                        return;
                    }
                    if (EventFactory.onVillageSiegeStart(this.field_75531_f, new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i))) {
                        VillageSiegeHandler.sendDevLog("Try to siege: tombstone event canceled");
                        return;
                    }
                    this.field_75536_c = SiegeState.SPAWN_MOBS;
                    VillageSiegeHandler.sendDevLog("Spawning " + ConfigTombstone.village_siege.siegeMaxCreature + " zombie" + (ConfigTombstone.village_siege.siegeMaxCreature > 1 ? "s" : ""));
                }
                if (this.field_75536_c == SiegeState.SPAWN_MOBS) {
                    if (this.field_75534_e > 0) {
                        --this.field_75534_e;
                    } else {
                        this.field_75534_e = 2;
                        if (this.field_75533_d > 0) {
                            this.spawnZombie();
                            --this.field_75533_d;
                        } else {
                            this.field_75536_c = SiegeState.SIEGE_END;
                            VillageSiegeHandler.sendDevLog("Siege ended");
                        }
                    }
                }
            }
        }

        private boolean trySetupSiege() {
            List playerList = this.field_75537_a.field_73010_i;
            if (ConfigTombstone.village_siege.shufflePlayersForSiege) {
                Collections.shuffle(playerList, Helper.RANDOM);
            }
            for (EntityPlayer player : playerList) {
                if (player.func_175149_v() || player.func_184812_l_() && !ConfigTombstone.village_siege.allowCreativePlayersForSiege) continue;
                this.field_75531_f = this.field_75537_a.func_175714_ae().func_176056_a(new BlockPos((Entity)player), 1);
                if (this.field_75531_f == null || this.field_75531_f.func_75567_c() < ConfigTombstone.village_siege.siegeMinDoor || this.field_75531_f.func_75561_d() < 20 || this.field_75531_f.func_75562_e() < ConfigTombstone.village_siege.siegeMinVillager || this.field_75531_f.field_75587_j < ConfigTombstone.village_siege.siegeMinGolem) continue;
                BlockPos blockpos = this.field_75531_f.func_180608_a();
                float r = this.field_75531_f.func_75568_b();
                boolean isNearOtherVillage = false;
                for (int i = 0; i < 10; ++i) {
                    float f1 = this.field_75537_a.field_73012_v.nextFloat() * ((float)Math.PI * 2);
                    this.field_75532_g = blockpos.func_177958_n() + (int)((double)(MathHelper.func_76134_b((float)f1) * r) * 0.9);
                    this.field_75538_h = blockpos.func_177956_o();
                    this.field_75539_i = blockpos.func_177952_p() + (int)((double)(MathHelper.func_76126_a((float)f1) * r) * 0.9);
                    isNearOtherVillage = this.field_75537_a.func_175714_ae().func_75540_b().stream().anyMatch(currentVillage -> currentVillage != this.field_75531_f && currentVillage.func_179866_a(new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i)));
                    if (!isNearOtherVillage) break;
                }
                if (isNearOtherVillage) {
                    return false;
                }
                Vec3d vec3d = this.findRandomSpawnPos(new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i));
                if (vec3d == null) continue;
                this.field_75534_e = 0;
                this.field_75533_d = ConfigTombstone.village_siege.siegeMaxCreature;
                return true;
            }
            this.hasFailedTrySiege = true;
            VillageSiegeHandler.sendDevLog("Try to siege: failed");
            return false;
        }

        private void spawnZombie() {
            EntityZombie mob;
            Vec3d vec3d = this.findRandomSpawnPos(new BlockPos(this.field_75532_g, this.field_75538_h, this.field_75539_i));
            if (vec3d == null) {
                return;
            }
            try {
                mob = new EntityZombie((World)this.field_75537_a);
                mob.func_180482_a(this.field_75537_a.func_175649_E(new BlockPos((Entity)mob)), null);
                if (ConfigTombstone.village_siege.persistentMobInSiege) {
                    mob.func_110163_bv();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            if (ConfigTombstone.village_siege.undeadWearHelmInSiege && mob.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b()) {
                EnumDifficulty difficulty = this.field_75537_a.func_175659_aa();
                mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)(difficulty == EnumDifficulty.HARD ? Items.field_151161_ac : (difficulty == EnumDifficulty.NORMAL ? Items.field_151028_Y : Items.field_151024_Q))));
            }
            mob.func_70012_b(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, this.field_75537_a.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (EventFactory.onVillageSiegeZombieSpawn(this.field_75531_f, mob)) {
                return;
            }
            mob.getEntityData().func_74757_a("siege", true);
            this.field_75537_a.func_72838_d((Entity)mob);
            assert (this.field_75531_f != null);
            BlockPos villageCenter = this.field_75531_f.func_180608_a();
            mob.func_175449_a(villageCenter, this.field_75531_f.func_75568_b());
            if (ConfigTombstone.village_siege.glowingCreatureTest) {
                EffectHelper.addPotion((EntityLivingBase)mob, MobEffects.field_188423_x, 10000, 1, new boolean[0]);
            }
        }

        @Nullable
        private Vec3d findRandomSpawnPos(BlockPos initPos) {
            return IntStream.range(0, 10).mapToObj(i -> initPos.func_177982_a(this.field_75537_a.field_73012_v.nextInt(16) - 8, this.field_75537_a.field_73012_v.nextInt(6) - 3, this.field_75537_a.field_73012_v.nextInt(16) - 8)).filter(currentPos -> this.field_75531_f.func_179866_a(currentPos) && this.canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType.ON_GROUND, (World)this.field_75537_a, (BlockPos)currentPos)).findFirst().map(currentPos -> new Vec3d((double)currentPos.func_177958_n(), (double)currentPos.func_177956_o(), (double)currentPos.func_177952_p())).orElse(null);
        }

        public boolean canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType spawnPlacementTypeIn, World world, BlockPos pos) {
            if (!world.func_175723_af().func_177746_a(pos)) {
                return false;
            }
            IBlockState iblockstate = world.func_180495_p(pos);
            if (spawnPlacementTypeIn == EntityLiving.SpawnPlacementType.IN_WATER) {
                return iblockstate.func_185904_a() == Material.field_151586_h && world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h && !world.func_180495_p(pos.func_177984_a()).func_185915_l();
            }
            BlockPos blockpos = pos.func_177977_b();
            IBlockState state = world.func_180495_p(blockpos);
            if (!state.func_177230_c().canCreatureSpawn(state, (IBlockAccess)world, blockpos, spawnPlacementTypeIn) || state.func_177230_c() instanceof BlockStairs) {
                return false;
            }
            Block block = world.func_180495_p(blockpos).func_177230_c();
            boolean flag = block != Blocks.field_150357_h && block != Blocks.field_180401_cv;
            return flag && this.isValidEmptySpawnBlock(iblockstate) && this.isValidEmptySpawnBlock(world.func_180495_p(pos.func_177984_a()));
        }

        public boolean isValidEmptySpawnBlock(IBlockState state) {
            return !state.func_185898_k() && !state.func_185897_m() && !state.func_185904_a().func_76224_d() && !BlockRailBase.func_176563_d((IBlockState)state);
        }
    }
}

