/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.api.magic.IProtectedEntity;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.ProtectedEntityProvider;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TameableType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IChanneling;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.EffectMessage;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemAnkhOfPray
extends ItemGeneric
implements ISoulConsumer,
IChanneling {
    public ItemAnkhOfPray() {
        super("ankh_of_pray", true, false, false);
        this.func_77625_d(1);
        this.func_77656_e(30);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public String func_77653_i(ItemStack stack) {
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + super.func_77653_i(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                if (!this.func_77636_d(stack)) {
                    int cd = CooldownHandler.INSTANCE.getCooldown((EntityPlayer)player, CooldownType.NEXT_PRAY);
                    if (cd > 0) {
                        this.addItemUse(list, "1", StyleType.TOOLTIP_DESC.func_150218_j() + " [" + TimeHelper.getTimeString(cd) + "]");
                    }
                } else {
                    this.addItemUse(list, "2", new Object[0]);
                }
                if (CooldownHandler.INSTANCE.getCooldown((EntityPlayer)player, CooldownType.RESET_PERKS) <= 0) {
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (EntityHelper.isValidPlayer(player)) {
            IBlockState state = world.func_180495_p(pos);
            if (ModBlocks.isDecorativeGrave(state.func_177230_c()) && ((Boolean)state.func_177229_b((IProperty)BlockGraveBase.HAS_SOUL)).booleanValue()) {
                return EnumActionResult.PASS;
            }
            return this.func_77659_a(world, player, hand).func_188397_a();
        }
        return EnumActionResult.FAIL;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer playerIn, EntityLivingBase target, EnumHand hand) {
        if (!EntityHelper.isValidPlayer(playerIn) || hand != EnumHand.MAIN_HAND || playerIn.func_184614_ca().func_77973_b() != this || target == null) {
            return false;
        }
        if (EntityHelper.hasGlobalItemCooldown(playerIn, this) && CooldownHandler.INSTANCE.hasCooldown(playerIn, CooldownType.NEXT_PRAY)) {
            return true;
        }
        EntityHelper.setGlobalItemCooldown(playerIn, this, 10);
        if (target instanceof EntityZombieVillager) {
            EntityZombieVillager villager = (EntityZombieVillager)target;
            if (!playerIn.field_70170_p.field_72995_K) {
                EntityPlayerMP player = (EntityPlayerMP)playerIn;
                PotionEffect effectInstance = new PotionEffect(ModEffects.exorcism, 200, 1);
                EffectHelper.addPotion((EntityLivingBase)villager, effectInstance);
                PacketHandler.INSTANCE.sendToAllTracking((IMessage)new EffectMessage(villager.func_145782_y(), effectInstance), (Entity)villager);
                villager.field_191992_by = null;
                villager.field_82234_d = 200;
                villager.func_184212_Q().func_187227_b(EntityZombieVillager.field_184739_bx, (Object)Boolean.TRUE);
                villager.func_184589_d(MobEffects.field_76437_t);
                villager.field_70170_p.func_72960_a((Entity)villager, (byte)16);
                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 3, ConfigTombstone.alignment.pointsExorcismZombieVillager));
                stack.func_77972_a(3, (EntityLivingBase)player);
                LangKey.MESSAGE_EXORCISM.sendSpecialMessage((ICommandSender)player, new Object[0]);
                ModTriggers.EXORCISM.trigger(player);
            }
        } else {
            IProtectedEntity protCap;
            int alignment = Optional.ofNullable(playerIn.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).map(ITBCapability::getAlignmentLevel).orElse(0);
            if (alignment < 0 && target instanceof EntityVillager && target.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                if (!playerIn.field_70170_p.field_72995_K) {
                    EntityPlayerMP player = (EntityPlayerMP)playerIn;
                    EntityVillager villager = (EntityVillager)target;
                    EntityZombieVillager zombieVillager = new EntityZombieVillager(villager.field_70170_p);
                    zombieVillager.func_82149_j((Entity)villager);
                    villager.field_70170_p.func_72900_e((Entity)villager);
                    zombieVillager.func_180482_a(villager.field_70170_p.func_175649_E(new BlockPos((Entity)zombieVillager)), null);
                    zombieVillager.func_190733_a(villager.func_70946_n());
                    zombieVillager.func_82227_f(villager.func_70631_g_());
                    zombieVillager.func_94061_f(villager.func_175446_cd());
                    if (villager.func_145818_k_()) {
                        zombieVillager.func_96094_a(villager.func_95999_t());
                        zombieVillager.func_174805_g(villager.func_174833_aM());
                    }
                    villager.field_70170_p.func_72838_d((Entity)zombieVillager);
                    villager.field_70170_p.func_180498_a(null, 1026, new BlockPos((Entity)zombieVillager), 0);
                    PotionEffect effectInstance = new PotionEffect(ModEffects.exorcism, 200, 1);
                    EffectHelper.addPotion((EntityLivingBase)zombieVillager, effectInstance);
                    PacketHandler.INSTANCE.sendToAllTracking((IMessage)new EffectMessage(zombieVillager.func_145782_y(), effectInstance), (Entity)zombieVillager);
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 3, -ConfigTombstone.alignment.pointsExorcismZombieVillager));
                    stack.func_77972_a(3, (EntityLivingBase)player);
                    LangKey.MESSAGE_EXORCISM.sendMessage((ICommandSender)player, StyleType.MESSAGE_SPECIAL);
                    ModTriggers.ZOMBIFY.trigger(player);
                }
            } else if (alignment > 0 && (protCap = (IProtectedEntity)target.getCapability(ProtectedEntityProvider.PROTECTED_ENTITY_CAPABILITY, null)) != null && !playerIn.field_70170_p.field_72995_K) {
                EntityPlayerMP player = (EntityPlayerMP)playerIn;
                if (!protCap.isActive()) {
                    protCap.apply(target, true);
                    CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                    Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(c -> c.reward(player, 3, ConfigTombstone.alignment.pointsPrayOfProtection));
                    LangKey.MESSAGE_PRAY_OF_PROTECTION_SUCCESS.sendSpecialMessage((ICommandSender)player, target.func_70005_c_());
                    ModTriggers.PRAY_OF_PROTECTION.trigger(player);
                } else {
                    LangKey.MESSAGE_PRAY_OF_PROTECTION_FAILED.sendSpecialMessage((ICommandSender)player, target.func_70005_c_());
                }
            }
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (hand == EnumHand.MAIN_HAND && heldStack.func_77973_b() == this) {
            if (EntityHelper.hasGlobalItemCooldown(player, this)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)heldStack);
            }
            if (CooldownHandler.INSTANCE.noCooldown(player, CooldownType.NEXT_PRAY)) {
                ItemStack offhand = player.func_184592_cb();
                if (ModItems.familiar_receptacle.containSoul(offhand) && ModItems.familiar_receptacle.getDurabilityForDisplay(offhand) != 0.0) {
                    EntityHelper.setGlobalItemCooldown(player, this, 10);
                    if (!player.field_70170_p.field_72995_K) {
                        LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendMessageWithStyle((ICommandSender)player, StyleType.COLOR_OFF, new Object[0]);
                    }
                    return new ActionResult(EnumActionResult.FAIL, (Object)heldStack);
                }
                player.func_184598_c(hand);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldStack);
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldStack);
    }

    @Nullable
    private BlockPos findGraveAround(World world, BlockPos startPos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos currentPos = new BlockPos(startPos.func_177958_n() + x, startPos.func_177956_o() + y, startPos.func_177952_p() + z);
                    if (!ModBlocks.isDecorativeGrave(world.func_180495_p(currentPos).func_177230_c())) continue;
                    return currentPos;
                }
            }
        }
        return null;
    }

    public ItemStack func_77654_b(ItemStack stack, @Nullable World world, EntityLivingBase entity) {
        EntityPlayerMP player;
        if (EntityHelper.isValidServerPlayer((Entity)entity) && !EntityHelper.hasGlobalItemCooldown((EntityPlayer)(player = (EntityPlayerMP)entity), this)) {
            BlockPos gravePos = this.findGraveAround(player.field_70170_p, player.func_180425_c());
            if (gravePos != null) {
                ITBCapability cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null);
                if (cap != null) {
                    ItemStack offhandStack = player.func_184592_cb();
                    if (offhandStack.func_77973_b() == ModItems.familiar_receptacle) {
                        if (ModItems.familiar_receptacle.containSoul(offhandStack)) {
                            if (ModItems.familiar_receptacle.getDurabilityForDisplay(offhandStack) > 0.0) {
                                LangKey.MESSAGE_RECOVERING_RECEPTACLE.sendWarnMessage((ICommandSender)player, new Object[0]);
                            } else if (ModItems.familiar_receptacle.revive((EntityPlayer)player, gravePos, offhandStack)) {
                                CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                                cap.reward(player, 5, 0);
                                stack.func_77972_a(1, (EntityLivingBase)player);
                                ModTriggers.REVIVE_FAMILIAR.trigger(player);
                                LangKey.MESSAGE_REVIVE_FAMILIAR.sendSpecialMessage((ICommandSender)player, LangKey.MESSAGE_YOUR_FAMILIAR.getTranslation(new Object[0]));
                                offhandStack.func_190918_g(1);
                            } else {
                                NBTTagCompound tag = offhandStack.func_77978_p();
                                if (tag != null) {
                                    tag.func_82580_o("dead_pet");
                                }
                                LangKey.MESSAGE_CANT_REVIVE_FAMILIAR.sendWarnMessage((ICommandSender)player, LangKey.MESSAGE_YOUR_FAMILIAR.getTranslation(new Object[0]));
                            }
                        } else {
                            LangKey.MESSAGE_EMPTY_RECEPTACLE.sendWarnMessage((ICommandSender)player, new Object[0]);
                        }
                    } else {
                        Entity pet;
                        CooldownHandler.INSTANCE.resetCooldown(player, CooldownType.NEXT_PRAY);
                        cap.reward(player, 1, 0);
                        stack.func_77972_a(1, (EntityLivingBase)player);
                        ModTriggers.PRAY_ON_GRAVE.trigger(player);
                        int totalPerkPoints = cap.getTotalPerkPoints();
                        int res = Helper.RANDOM.nextInt(100) + totalPerkPoints;
                        if ((res >= 110 || TimeHelper.isAprilFoolsDay() && res < 30) && (pet = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(TameableType.getRandomTameableEntityTypeString()), (World)player.field_70170_p)) != null) {
                            pet.func_70107_b((double)((float)gravePos.func_177958_n() + Helper.RANDOM.nextFloat()) - 0.5, (double)gravePos.func_177956_o() + 1.0, (double)((float)gravePos.func_177952_p() + Helper.RANDOM.nextFloat()) - 0.5);
                            if (pet instanceof EntityLiving) {
                                ((EntityLiving)pet).func_180482_a(player.field_70170_p.func_175649_E(pet.func_180425_c()), null);
                            }
                            TameableType.setTamedBy((EntityPlayer)player, pet);
                            player.field_70170_p.func_72838_d(pet);
                            LangKey.MESSAGE_SUMMON_FAMILIAR.sendMessage((ICommandSender)player, new Object[0]);
                        }
                        if (TimeHelper.isDateAroundHalloween() || res < ConfigTombstone.decorativeGrave.chancePrayReward + totalPerkPoints * 3) {
                            EffectHelper.addRandomPotion((EntityPlayer)player, ConfigTombstone.decorativeGrave.getCooldownToPray() * 5000, true);
                        }
                    }
                }
            } else {
                LangKey.MESSAGE_CANT_PRAY.sendWarnMessage((ICommandSender)player, new Object[0]);
            }
            EntityHelper.setGlobalItemCooldown((EntityPlayer)player, this, 10);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int timeLeft) {
        this.onChanneling(stack, entity, timeLeft);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || EntityHelper.hasGlobalItemCooldown((EntityPlayer)player, stack)) {
            return false;
        }
        int cooldownToPray = CooldownHandler.INSTANCE.getCooldown((EntityPlayer)player, CooldownType.NEXT_PRAY);
        if (cooldownToPray > 0) {
            int maxTime = CooldownType.NEXT_PRAY.getMaxCooldown((EntityPlayer)player);
            int elapsedTime = maxTime - cooldownToPray;
            CooldownTracker cd = player.func_184811_cZ();
            cd.field_185148_b -= elapsedTime;
            cd.func_185145_a((Item)this, maxTime);
            cd.field_185148_b += elapsedTime;
            return false;
        }
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public String func_77658_a() {
        return "tombstone.item." + this.name;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        boolean hasReset;
        ITBCapability cap;
        if (!world.field_72995_K && (cap = (ITBCapability)player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)) != null && (hasReset = cap.resetPerks(player))) {
            ModTriggers.RESET_PERKS.trigger(player);
            return 1;
        }
        return 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_PERK_RESET_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        long cd;
        if (!player.field_70170_p.field_72995_K && (cd = (long)CooldownHandler.INSTANCE.getCooldown(player, CooldownType.RESET_PERKS)) > 0L) {
            int min = (int)(cd / 1200L);
            if (min > 0) {
                cd -= (long)(min * 1200);
            }
            return LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getTranslation(min, cd / 20L);
        }
        return LangKey.MESSAGE_PERK_RESET_FAILED.getTranslation(new Object[0]);
    }

    @Override
    public int getKnowledge() {
        return 0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

