/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.IDefaultImpregnable;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBoneNeedle
extends ItemGeneric
implements IDefaultImpregnable {
    private static final int IMPREGNATED_MAX_TIME = TimeHelper.tickFromMinute(30);
    private static final String IMPREGNATED_TIME_NBT_LONG = "impregnated_time";

    public ItemBoneNeedle() {
        super("bone_needle", true, false, false);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_185043_a(new ResourceLocation("filled"), (stack, worldIn, entityIn) -> ModItems.bone_needle.getEntityType(stack).isEmpty() ? 0.0f : 1.0f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            String impregnated = this.getTooltipDisplay(stack);
            if (impregnated == null) {
                this.addItemUse(list);
            } else {
                list.add(impregnated);
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
        int impregnatedTime = this.getImpregnatedTime(world, stack);
        if (impregnatedTime > 0) {
            this.addWarn(list, LangKey.MESSAGE_IMPREGNATE_DURATION, TimeHelper.getTimeStringWithUnit(impregnatedTime));
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        ItemStack mainHandstack;
        if (player != null && hand == EnumHand.MAIN_HAND && (mainHandstack = player.func_184614_ca()).func_77973_b() == this && !EntityHelper.hasGlobalItemCooldown(player, this)) {
            EntityHelper.setGlobalItemCooldown(player, this, 10);
            if (!player.field_70170_p.field_72995_K) {
                if (this.impregnate(mainHandstack, target)) {
                    NBTStackHelper.setLong(stack, IMPREGNATED_TIME_NBT_LONG, TimeHelper.worldTicks(player.field_70170_p) + (long)IMPREGNATED_MAX_TIME);
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_SUCCESS.sendSpecialMessage((ICommandSender)player, target.func_70005_c_());
                    ModTriggers.IMPREGNATED_BONE_NEEDLE.trigger((EntityPlayerMP)player);
                } else {
                    LangKey.MESSAGE_IMPREGNATE_NEEDLE_FAILED.sendSpecialMessage((ICommandSender)player, new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (!world.field_72995_K && stack.func_77973_b() == this && EntityHelper.isValidPlayer(entity) && !this.getEntityType(stack).isEmpty() && this.getImpregnatedTime(world, stack) == 1) {
            NBTStackHelper.removeKeyName(stack, IMPREGNATED_TIME_NBT_LONG);
            NBTStackHelper.removeKeyName(stack, "entity_type");
        }
    }

    private int getImpregnatedTime(@Nullable World world, ItemStack stack) {
        return world != null && stack.func_77973_b() == this ? NBTStackHelper.getTimer(TimeHelper.worldTicks(world), stack, IMPREGNATED_TIME_NBT_LONG, IMPREGNATED_MAX_TIME) : 0;
    }
}

