/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.api.capability.TBCapabilityProvider;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;

public class ItemChristmasGift
extends ItemGeneric
implements ISoulConsumer {
    public ItemChristmasGift() {
        super("christmas_gift", false, false, false);
        this.func_77625_d(1);
        this.func_77656_e(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            this.addItemDesc(list);
            if (LocalDate.now().get(ChronoField.DAY_OF_MONTH) >= 25) {
                this.addItemUse(list);
            }
        } else {
            this.addInfoShowTooltip(list);
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (stack.func_77973_b() == this && !TimeHelper.isDateAroundChristmas()) {
            stack.func_190918_g(stack.func_190916_E());
        }
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return false;
    }

    @Override
    public int setEnchant(World world, BlockPos gravePos, EntityPlayerMP player, ItemStack stack, boolean hasStrongSoul) {
        if (TimeHelper.isDateAroundChristmas() && LocalDate.now().get(ChronoField.DAY_OF_MONTH) >= 25) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)ItemCraftingIngredient.IngredientType.ESSENCE_OF_UNDEATH.getStack());
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack((Item)ModItems.soul_receptacle));
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack((Item)ModItems.christmas_hat));
            player.func_71023_q(1000);
            Optional.ofNullable(player.getCapability(TBCapabilityProvider.TB_CAPABILITY, null)).ifPresent(cap -> cap.reward(player, 10, 0));
            stack.func_190918_g(1);
            return 1;
        }
        return 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_GIFT_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_GIFT_FAILED.getTranslation(new Object[0]);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

