/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ICustomModel;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.registry.ModItems;

public class ItemCraftingIngredient
extends ItemGeneric
implements ICustomModel {
    public ItemCraftingIngredient() {
        super("crafting_ingredient", true, false, true);
        this.field_77787_bX = true;
        this.func_77656_e(0);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab) && this.isEnabled()) {
            for (IngredientType ingredientType : IngredientType.values()) {
                if (ingredientType == IngredientType.IMPREGNATED_DIAMOND) continue;
                items.add((Object)new ItemStack((Item)this, 1, ingredientType.ordinal()));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return IngredientType.values()[stack.func_77960_j()].hasEffect || super.func_77636_d(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (IngredientType ingredientType : IngredientType.values()) {
            if (ingredientType == IngredientType.IMPREGNATED_DIAMOND) continue;
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)ingredientType.ordinal(), (ModelResourceLocation)new ModelResourceLocation("tombstone:" + ingredientType.name().toLowerCase(), "inventory"));
        }
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "tombstone.item." + IngredientType.values()[stack.func_77960_j()].name().toLowerCase(Locale.US);
    }

    public String func_77653_i(ItemStack stack) {
        String displayName = super.func_77653_i(stack);
        if (stack.func_77960_j() == IngredientType.ESSENCE_OF_UNDEATH.ordinal()) {
            return StyleType.MESSAGE_SPECIAL.func_150218_j() + displayName;
        }
        return displayName;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slotId, boolean isSelected) {
        if (stack.func_77973_b() == this && stack.func_77960_j() == IngredientType.IMPREGNATED_DIAMOND.ordinal() && EntityHelper.isValidServerPlayer(entity)) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack newStack = new ItemStack((Item)ModItems.impregnated_diamond);
            String entityType = NBTStackHelper.getString(stack, "entity_type");
            if (!entityType.isEmpty()) {
                NBTStackHelper.setString(newStack, "entity_type", entityType);
            }
            player.field_71071_by.field_70462_a.set(slotId, (Object)newStack);
            player.field_71069_bz.func_75142_b();
        }
    }

    public static enum IngredientType {
        STRANGE_SCROLL(false),
        STRANGE_TABLET(false),
        IMPREGNATED_DIAMOND(false),
        GRAVE_DUST(false),
        ESSENCE_OF_UNDEATH(true);

        private boolean hasEffect;

        private IngredientType(boolean hasEffect) {
            this.hasEffect = hasEffect;
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int count) {
            return new ItemStack(ModItems.crafting_ingredient, count, this.ordinal());
        }

        public boolean compareStack(ItemStack stack) {
            return stack.func_77973_b() == ModItems.crafting_ingredient && stack.func_77960_j() == this.ordinal();
        }
    }
}

